package coremodules

import (
	"fmt"

	"github.com/heysion/deepin-system-update-tools/pkg/utils/version"
	"github.com/spf13/cobra"
)

// versionCmd represents the version command
var versionCmd = &cobra.Command{
	Use:              "version",
	Short:            "Print the version number",
	Long:             `All software has versions.`,
	PersistentPreRun: func(cmd *cobra.Command, args []string) {},
	Run: func(cmd *cobra.Command, args []string) {
		fmt.Printf("Version: %s\n", version.Version)
		fmt.Printf("Platform: %s Go: %s\n", version.OsArch, version.GoVersion)
	},
	PersistentPostRun: func(cmd *cobra.Command, args []string) {},
}

func init() {
	rootCmd.AddCommand(versionCmd)
}
