//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_30.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot30(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[30] = {2.039219377523641e-02,1.836123050370817e-01,5.104942191359663e-01,1.001927927452841e+00,1.659265178006093e+00,
    2.484340277790551e+00,3.479499028142790e+00,4.647636927026094e+00,5.992248202365616e+00,7.517487792929006e+00,9.228249121765884e+00,1.113026149035258e+01,
    1.323021227607870e+01,1.553590101922874e+01,1.805643521479969e+01,2.080248162057934e+01,2.378659287819636e+01,2.702363843538688e+01,3.053138327336318e+01,
    3.433128160556164e+01,3.844959271751057e+01,4.291899667402598e+01,4.778101844655198e+01,5.308982661003707e+01,5.891851874619501e+01,6.537027557479708e+01,
    7.260010092544880e+01,8.086322181567139e+01,9.064760682696567e+01,1.032075006758217e+02};
  constexpr double aw[30] = {2.798531175228286e-01,2.378689049586587e-01,1.717761569188846e-01,1.052987636977852e-01,5.471897093218286e-02,
    2.406127276610964e-02,8.932178360307843e-03,2.791324828953048e-03,7.317735569655050e-04,1.602773346818449e-04,2.918741904155569e-05,4.394286936267073e-06,
    5.433516134204974e-07,5.475554619276744e-08,4.456822775225963e-09,2.899359012807761e-10,1.488957349062788e-11,5.948430516056168e-13,1.816624576259683e-14,
    4.152444109693820e-16,6.923247909577666e-18,8.153640473024067e-20,6.512567257496230e-22,3.345756955752609e-24,1.029405997165105e-26,1.715573147671849e-29,
    1.332559611764192e-32,3.771626727120554e-36,2.439747588145120e-40,1.109587247968322e-45};
  constexpr double x[11520] = {  1.325962532681286e-03, -1.086146296693472e-05,  6.668316501892944e-08, -3.635943483739178e-10,  1.856555592920640e-12,
 -9.088621401280543e-15,  4.318921066382197e-17, -2.006881930254230e-19,  9.160971347007441e-22, -4.120702981761218e-24,  1.830285551684701e-26, -8.039215959518773e-29,
  1.191324433708726e-02, -9.707734025402471e-05,  5.897656897104480e-07, -3.159404124636112e-09,  1.570469356914364e-11, -7.398737939840205e-14,  3.335571408403331e-16,
 -1.444484583789420e-18,  6.007646223263538e-21, -2.390310151536357e-23,  9.017562317232521e-26, -3.168466830384452e-28,  3.297910853447907e-02, -2.659345586518591e-04,
  1.581620473916354e-06, -8.170126800466416e-09,  3.835801052466564e-11, -1.658215000387627e-13,  6.574543510942092e-16, -2.337588578297370e-18,  6.994530677698074e-21,
 -1.386056959912070e-23, -1.692926565459008e-26,  3.965946011201423e-28,  6.430711112602902e-02, -5.104263053402513e-04,  2.938639290705684e-06, -1.433342644600264e-08,
  6.114958125989818e-11, -2.248973319361360e-13,  6.591207252608578e-16, -1.044073351534923e-18, -4.075648005546970e-21,  5.163468021920876e-23, -3.266791204825821e-25,
  1.557561605594770e-27,  1.055749708352890e-01, -8.203929025382485e-04,  4.517500760869032e-06, -2.028842488683739e-08,  7.425927496139036e-11, -1.960275659425859e-13,
  1.146338699373434e-16,  2.790290529160227e-18, -2.294906466525136e-20,  1.162882943994151e-22, -4.055193729780100e-25,  6.153205163790472e-28,  1.563574240251701e-01,
 -1.182928291985895e-03,  6.148483711433214e-06, -2.461246230286385e-08,  6.959266169758694e-11, -5.457852217236141e-14, -8.916761058781624e-16,  7.249654825985119e-18,
 -3.290650051938475e-20,  8.047482907345111e-23,  1.479811275900282e-25, -2.946830345235837e-27,  2.161300194023466e-01, -1.582898812076536e-03,  7.651329802123594e-06,
 -2.607316041816345e-08,  4.330815520236542e-11,  1.780889566275786e-13, -1.949370766010997e-15,  9.023700053537212e-18, -1.760978458550656e-20, -8.586095386767343e-23,
  1.003520589977807e-24, -4.893053804137446e-27,  2.842738411556925e-01, -2.003555193989703e-03,  8.852238069095544e-06, -2.385425560722627e-08, -2.692670433442696e-12,
  4.365359565089160e-13, -2.488543773300529e-15,  5.552310157625532e-18,  2.247437346820902e-20, -2.717415537378528e-22,  1.166203816631730e-24, -5.980444706523594e-28,
  3.600811448693558e-01, -2.427214952789085e-03,  9.600454728430977e-06, -1.771727018578468e-08, -6.074592770719395e-11,  6.309585471969936e-13, -2.060905063936512e-15,
 -2.901925391527082e-18,  6.452374004122317e-20, -2.909234138557253e-22,  1.338779184176229e-26,  7.548140464863330e-27,  4.427618853100346e-01, -2.835989276081345e-03,
  9.782933826665875e-06, -8.070830999928666e-09, -1.189440272290921e-10,  6.784118959170344e-13, -5.993636926144209e-16, -1.271466831703764e-17,  7.606212098435036e-20,
 -5.181824763108839e-23, -1.740692386378963e-24,  1.020399766981635e-26,  5.314511088734292e-01, -3.212526245623383e-03,  9.335690831461778e-06,  4.066064371247598e-09,
 -1.638632896844125e-10,  5.345753154657299e-13,  1.480719758887898e-15, -1.850330028218028e-17,  3.887179112768061e-20,  3.200017595338586e-22, -2.402651667011264e-24,
  1.403498258781512e-27,  6.252171759806572e-01, -3.540740886385152e-03,  8.250743873935450e-06,  1.720346482408324e-08, -1.838478376398746e-10,  2.142469023824927e-13,
  3.407053498859559e-15, -1.613784072281848e-17, -3.347221176042332e-20,  5.418544002090502e-22, -9.246764341769977e-25, -1.217528063091972e-26,  7.230707699776711e-01,
 -3.806502228538973e-03,  6.577917011122496e-06,  2.960220896381468e-08, -1.720291155848131e-10, -2.077637046073892e-13,  4.363471340958160e-15, -5.424500665277339e-18,
 -9.954630856930723e-20,  3.961136498274024e-22,  1.781766351789850e-24, -1.600500603011102e-26,  8.239746390981516e-01, -3.998248374469190e-03,  4.421237329492267e-06,
  3.954348189788067e-08, -1.282969863740708e-10, -6.169541693416922e-13,  3.855530169616527e-15,  9.251695399633723e-18, -1.156218157875382e-19, -6.619660676027885e-23,
  3.386262645338694e-24, -3.697070170319733e-27,  9.268540068556562e-01, -4.107502539108453e-03,  1.930155201788227e-06,  4.560276996684288e-08, -5.967799099084597e-11,
 -8.946235999197294e-13,  1.958082048785527e-15,  2.092630082754245e-17, -6.614137510100659e-20, -5.301215029383555e-22,  2.268863141933878e-24,  1.392701554861412e-26,
  1.030607573961471e+00, -4.129266192898115e-03, -7.136891610909951e-07,  4.688282258937642e-08,  2.103457851103424e-11, -9.567049484187915e-13, -6.799117990835688e-16,
  2.371798663564846e-17,  2.301376983209335e-20, -6.506080033848732e-22, -8.010788710296923e-25,  1.899049299371880e-26,  1.134119021732599e+00, -4.062269750033511e-03,
 -3.312985787048492e-06,  4.316579683985233e-08,  9.811037972519069e-11, -7.823674421541647e-13, -3.088790658680028e-15,  1.609346288260195e-17,  9.950726315955560e-20,
 -3.307313138596867e-22, -3.225558073693097e-24,  5.957025694631951e-27,  1.236268913262932e+00, -3.909066622429569e-03, -5.673045220394313e-06,  3.495724915610762e-08,
  1.564981128659374e-10, -4.219830892662339e-13, -4.383055776782091e-15,  1.801342751421410e-18,  1.185357956324064e-19,  1.935477352900762e-22, -2.963248802610309e-24,
 -1.188960543477985e-26,  1.335946874777689e+00, -3.675962752529230e-03, -7.620126493105813e-06,  2.341222002956652e-08,  1.853319682003813e-10,  1.885366618712284e-14,
 -4.135255620111680e-15, -1.213658752554803e-17,  7.218073848168702e-20,  5.409798079527952e-22, -4.146035492886373e-25, -1.687967440630925e-26,  1.432063926066310e+00,
 -3.372780731807376e-03, -9.018015755599554e-06,  1.015352440325949e-08,  1.804375031678795e-10,  4.140167377037540e-13, -2.546610490147439e-15, -1.924474876852417e-17,
 -6.697695923841980e-21,  4.879289504182467e-22,  2.061174856010477e-24, -5.849877297966837e-27,  1.523564816265304e+00, -3.012465029846934e-03, -9.781189537409397e-06,
 -2.988847462096271e-09,  1.451865064367581e-10,  6.581539688214803e-13, -3.360733592027636e-16, -1.700122603871648e-17, -6.839152413567536e-20,  1.295999730696138e-22,
  2.454154763380099e-24,  7.975218134328923e-27,  1.609440210181802e+00, -2.610542368351020e-03, -9.883190008493131e-06, -1.427394956234325e-08,  8.947059377699868e-11,
  6.999743043586418e-13,  1.596797760335138e-15, -7.870761020643570e-18, -8.018681231232475e-20, -2.284488757796121e-22,  8.731393358582699e-25,  1.098138317091056e-26,
  1.688738561504582e+00, -2.184458499215956e-03, -9.359283917476732e-06, -2.233125300903680e-08,  2.705594408371929e-11,  5.557542085153306e-13,  2.572076122514391e-15,
  2.533207987550257e-18, -4.560202635234819e-20, -3.370784673264730e-22, -8.971337716999309e-25,  3.293549369924116e-27,  1.760577503385004e+00, -1.752819184902416e-03,
 -8.303032987273581e-06, -2.637825418898528e-08, -2.798516119722940e-11,  2.986240502411652e-13,  2.402342626718611e-15,  8.902163155613716e-18,  3.467558126568181e-21,
 -1.879227398559826e-22, -1.347417541442507e-24, -4.417911429008025e-27,  1.824154584848059e+00, -1.334568630593378e-03, -6.857017639569662e-06, -2.633575188682219e-08,
 -6.481736899717218e-11,  2.825540373514757e-14,  1.415172331758193e-15,  9.123205109697623e-18,  3.325739906569094e-20,  3.060001114466410e-23, -5.579806745726182e-25,
 -4.820023977590483e-27,  1.878757184709794e+00, -9.481426021592557e-04, -5.198564474436596e-06, -2.281980729794012e-08, -7.841369222248455e-11, -1.671069003055746e-13,
  2.303646709463154e-16,  4.912192890537662e-18,  3.163568997588128e-20,  1.329135920084858e-22,  3.129553381336808e-25, -6.157520780737638e-28,  1.923771447280517e+00,
 -6.106356377514712e-04, -3.521864318136690e-06, -1.701121293943040e-08, -7.047286965699639e-11, -2.416185481189093e-13, -5.801446953180691e-16,  3.908794874355178e-20,
  1.149097000119390e-20,  8.907367391007617e-23,  4.669034717617444e-25,  1.837466461938246e-27,  1.958690127392732e+00, -3.370217239990964e-04, -2.018269093956012e-06,
 -1.042541805913198e-08, -4.845681466314758e-11, -2.041884074795132e-13, -7.680967147354655e-16, -2.445391659066384e-18, -5.436123244160178e-21,  2.313273369952951e-24,
  1.237480709319103e-25,  9.664211014979186e-28,  1.983119479251153e+00, -1.394640062683856e-04, -8.567640619388933e-07, -4.624118841396377e-09, -2.304630351180406e-11,
 -1.081729683992139e-13, -4.817744193544841e-16, -2.037012805485565e-18, -8.130000999329909e-21, -3.019170697951303e-23, -1.010262146777191e-25, -2.799970047434966e-28,
  1.996788636410538e+00, -2.671768765346235e-05, -1.664477696020818e-07, -9.197635860082120e-10, -4.752025158994628e-12, -2.349304791373383e-14, -1.124849057731393e-16,
 -5.252272673535764e-19, -2.401670601315107e-21, -1.078208683814571e-23, -4.759538746130575e-26, -2.067322070970982e-28,  1.283556673436755e-03, -1.034495865043871e-05,
  6.249244103589724e-08, -3.352891722418139e-10,  1.684709970855424e-12, -8.116331156318854e-15,  3.795902025096943e-17, -1.736119460176814e-19,  7.801203836861807e-22,
 -3.454662697925272e-24,  1.510861093599401e-26, -6.535178377555712e-29,  1.153413699820300e-02, -9.250670415931285e-05,  5.533130314175853e-07, -2.919545420325320e-09,
  1.430183258928151e-11, -6.644640207313066e-14,  2.956784438052506e-16, -1.265338380105699e-18,  5.208826056380911e-21, -2.056127358585459e-23,  7.724198855602514e-26,
 -2.720498769534176e-28,  3.194006970187103e-02, -2.536635741554711e-04,  1.487154596495357e-06, -7.582094556355291e-09,  3.519419666012207e-11, -1.508031980810043e-13,
  5.950596615727600e-16, -2.121846187409381e-18,  6.487213531798545e-21, -1.422698984835211e-23, -2.273085667294346e-27,  2.754370523775785e-28,  6.231135783062714e-02,
 -4.875888991081351e-04,  2.772362857291020e-06, -1.339016740911512e-08,  5.680738644176951e-11, -2.094423500784327e-13,  6.283230005067326e-16, -1.147145189698318e-18,
 -2.436214080321536e-21,  3.985936890128465e-23, -2.639739300045601e-25,  1.298412208528851e-27,  1.023641654411181e-01, -7.852068391878116e-04,  4.281039727736167e-06,
 -1.913146629639734e-08,  7.037215128968748e-11, -1.924180416051320e-13,  1.830881789340698e-16,  2.119828072822851e-18, -1.904765601812699e-20,  1.006601391273847e-22,
 -3.748075769703414e-25,  7.642611786108680e-28,  1.517222426545728e-01, -1.134902981460545e-03,  5.859775454557447e-06, -2.350880811430807e-08,  6.830292773803910e-11,
 -7.365914283712296e-14, -7.029856024845243e-16,  6.243904258789658e-18, -2.993181784858945e-20,  8.405005727256571e-23,  3.664660108098211e-26, -2.141164132915793e-27,
  2.099188808376152e-01, -1.522927650939535e-03,  7.342718996466479e-06, -2.535419295528075e-08,  4.642221086694524e-11,  1.342697551078372e-13, -1.705008191689287e-15,
  8.418065506836379e-18, -2.002884157281585e-20, -4.988292257762893e-23,  7.991145622613304e-25, -4.381666961687451e-27,  2.763994430800146e-01, -1.933882383392762e-03,
  8.566006255269690e-06, -2.383068343472920e-08,  5.453773640743535e-12,  3.787490305033178e-13, -2.324417448325895e-15,  6.123897764203587e-18,  1.352187047271086e-20,
 -2.259574321401008e-22,  1.115428304671716e-24, -1.639192389333246e-27,  3.505245237371835e-01, -2.351277325346426e-03,  9.382423538869716e-06, -1.859096263419912e-08,
 -4.862679072803724e-11,  5.807454383935235e-13, -2.114822499656111e-15, -1.004021632366432e-18,  5.413456031253175e-20, -2.843599261167824e-22,  2.999068332017558e-25,
  5.506743597217725e-27,  4.315737974417055e-01, -2.758144532604088e-03,  9.675110129312421e-06, -9.866287224467378e-09, -1.055470610102068e-10,  6.600278968966681e-13,
 -9.216697617132835e-16, -1.032309298186608e-17,  7.305071535612551e-20, -1.125685971569902e-22, -1.300403007191410e-24,  9.716041296303276e-27,  5.187506221276657e-01,
 -3.137689294461341e-03,  9.369111327439724e-06,  1.531541152601655e-09, -1.528576069145787e-10,  5.640460264954488e-13,  9.816424687841362e-16, -1.709345943071177e-17,
  4.868439892366092e-20,  2.259510317468095e-22, -2.281016572123271e-24,  3.993774444708789e-27,  6.111874616676278e-01, -3.473958821944890e-03,  8.439691429239374e-06,
  1.430046614230300e-08, -1.787823574278435e-10,  2.904905805285716e-13,  2.943074251718012e-15, -1.690497038760965e-17, -1.475128512515045e-20,  4.951486326217468e-22,
 -1.385697194581866e-24, -8.759631737675333e-27,  7.079521910742593e-01, -3.752505057454756e-03,  6.916509874535672e-06,  2.682213294431967e-08, -1.751512620494336e-10,
 -1.052093502152827e-13,  4.169222404470448e-15, -8.369448734854188e-18, -8.417378770116450e-20,  4.532374752368962e-22,  1.075047479141773e-24, -1.592257482937348e-26,
  8.080553402413950e-01, -3.961016190182081e-03,  4.883051920087235e-06,  3.739712559529365e-08, -1.396919263853130e-10, -5.217322407589533e-13,  4.062604963392692e-15,
  5.539413783769943e-18, -1.156177935023909e-19,  6.471514468948513e-23,  3.128974622724646e-24, -7.859574528894919e-27,  9.104583203058751e-01, -4.089889939217470e-03,
  2.471077707114501e-06,  4.450753037002761e-08, -7.705437095450246e-11, -8.408545402064743e-13,  2.511649601140402e-15,  1.852307205616207e-17, -8.345505253362393e-20,
 -4.282828380030107e-22,  2.792711890926285e-24,  9.765423531715915e-27,  1.014082659411977e+00, -4.132721068122814e-03, -1.497096477470451e-07,  4.706564346223002e-08,
  1.791430674924487e-12, -9.649921923776132e-13, -9.053621332012419e-18,  2.407514665118089e-17, -7.806730626986485e-22, -6.656477789978701e-22,  5.364406680508719e-26,
  1.961473067830642e-26,  1.117820251634948e+00, -4.086676206638630e-03, -2.786106604198331e-06,  4.460651587548214e-08,  8.176003080814522e-11, -8.507430735853306e-13,
 -2.595558497165435e-15,  1.906289284750164e-17,  8.535497489423644e-20, -4.530581087182961e-22, -2.855421027871211e-24,  1.080462984361326e-26,  1.220544594003610e+00,
 -3.952731147177355e-03, -5.238831368968859e-06,  3.738801109742244e-08,  1.470128425996634e-10, -5.261369553082804e-13, -4.278635407207787e-15,  5.682129511085620e-18,
  1.232527221737554e-19,  6.554093373289448e-23, -3.410574938078529e-24, -8.252077608976088e-27,  1.321122952232856e+00, -3.735749574547375e-03, -7.321393311596533e-06,
  2.637504511855587e-08,  1.846904791366705e-10, -8.419151237195693e-14, -4.439846700431125e-15, -9.519882972624307e-18,  9.117403375978977e-20,  5.090657891197342e-22,
 -1.190891795579329e-24, -1.821951534134533e-26,  1.418429356644249e+00, -3.444387802860011e-03, -8.878589469470771e-06,  1.310326291950105e-08,  1.880629500495835e-10,
  3.464244170771462e-13, -3.085713170488591e-15, -1.916269040156627e-17,  1.227889656738058e-20,  5.640308501594852e-22,  1.713808528437528e-24, -9.979195774221850e-27,
  1.511358287026882e+00, -3.090817523369224e-03, -9.802685293103462e-06, -5.611632027170125e-10,  1.582291121394348e-10,  6.441334973333510e-13, -8.419067895043139e-16,
 -1.909550276872853e-17, -6.187901062975498e-20,  2.342599450905721e-22,  2.764059068751499e-24,  5.943769603639584e-27,  1.598838860624114e+00, -2.690267624900958e-03,
 -1.004541971582343e-05, -1.272842218997661e-08,  1.038339306172822e-10,  7.353555852208061e-13,  1.339310074439044e-15, -1.056060976368586e-17, -8.766131907726412e-20,
 -1.833653307904932e-22,  1.392619565352168e-24,  1.256747281409908e-26,  1.679849293320604e+00, -2.260396444839213e-03, -9.624283862291987e-06, -2.180606223958257e-08,
  3.879317117072995e-11,  6.181588439552340e-13,  2.620704425139864e-15,  8.731827609240887e-19, -5.834185531094988e-20, -3.693990585950325e-22, -7.015602875608958e-25,
  5.673223827182270e-27,  1.753431363248571e+00, -1.820516742282940e-03, -8.622051141724029e-06, -2.677501937491878e-08, -2.141589096515839e-11,  3.592773065052334e-13,
  2.652063282840902e-15,  8.894104199313662e-18, -4.313858998722083e-21, -2.456146503800164e-22, -1.534131957594165e-24, -3.997527869212353e-27,  1.818704571708702e+00,
 -1.390706462747290e-03, -7.179244260834437e-06, -2.736637451351281e-08, -6.389130289498935e-11,  6.540604862366337e-14,  1.685653790801872e-15,  1.020032626043106e-17,
  3.390327656287313e-20,  3.723204749632731e-24, -7.938349394954299e-25, -5.914265551047465e-27,  1.874879672521223e+00, -9.908480490394449e-04, -5.480039061103444e-06,
 -2.410081420239255e-08, -8.168879157498883e-11, -1.598087506315114e-13,  3.828150543424334e-16,  6.003445328475913e-18,  3.663770281426868e-20,  1.447029102263692e-22,
  2.714841771334701e-25, -1.306694646588465e-27,  1.921271234496267e+00, -6.396466313083637e-04, -3.732926184768120e-06, -1.817819317140814e-08, -7.544415889609556e-11,
 -2.554842401046444e-13, -5.733935779769734e-16,  4.618719597597293e-19,  1.505386945673387e-20,  1.094316162411228e-22,  5.525692197654519e-25,  2.053426564136349e-27,
  1.957308936834510e+00, -3.536817940618768e-04, -2.148164038120727e-06, -1.123442246949842e-08, -5.273057330501282e-11, -2.234639240003029e-13, -8.389832285361204e-16,
 -2.616971821081127e-18, -5.252758862113636e-21,  8.195887988621830e-24,  1.725426936588735e-25,  1.263233360816169e-27,  1.982547554496236e+00, -1.465465136658149e-04,
 -9.145394166357049e-07, -5.010815540779410e-09, -2.533016498416896e-11, -1.204504216343465e-13, -5.426221177080462e-16, -2.315367640968141e-18, -9.292664801243112e-21,
 -3.448505354957033e-23, -1.137774842348974e-25, -2.986605605210065e-28,  1.996679030720489e+00, -2.809474770113089e-05, -1.779571216459326e-07, -9.997067176678477e-10,
 -5.250120163777190e-12, -2.637821870183107e-14, -1.283282968429083e-16, -6.086772139646218e-19, -2.826405587835849e-21, -1.288103713050906e-23, -5.769732956205862e-26,
 -2.541670093814200e-28,  1.243151866973318e-03, -9.860666784546070e-06,  5.862550228958391e-08, -3.095845305967656e-10,  1.531113866689959e-12, -7.260938249677771e-15,
  3.342948318655248e-17, -1.505267375409275e-19,  6.659721708172057e-22, -2.904084721814938e-24,  1.250806480308324e-26, -5.329021622490110e-29,  1.117274666644578e-02,
 -8.821654654168535e-05,  5.196088245056910e-07, -2.700973674248082e-09,  1.304109210289508e-11, -5.975710119970468e-14,  2.624753649536966e-16, -1.109925626858685e-18,
  4.521458463179433e-21, -1.769912427904106e-23,  6.614920411789449e-26, -2.330852305974628e-28,  3.094864685819891e-02, -2.421209293788313e-04,  1.399451033928998e-06,
 -7.042359747693571e-09,  3.231625389445890e-11, -1.372117220776678e-13,  5.384772470795500e-16, -1.922445688103869e-18,  5.976063000565295e-21, -1.410401459735029e-23,
  7.766841664816403e-27,  1.853879935293573e-28,  6.040436378814074e-02, -4.660375857603575e-04,  2.616998749379934e-06, -1.251395173189306e-08,  5.276669507679529e-11,
 -1.947555924871530e-13,  5.953133278179540e-16, -1.204075329408850e-18, -1.178198661752949e-21,  3.037441676488550e-23, -2.119100632041375e-25,  1.073707145974052e-27,
  9.929040736794265e-02, -7.518579813519940e-04,  4.058091688409729e-06, -1.803604103195622e-08,  6.657219726536249e-11, -1.873772928351944e-13,  2.344345470839944e-16,
  1.565457135347902e-18, -1.568541805117875e-20,  8.636462689856101e-23, -3.394972154221519e-25,  8.293226947064762e-28,  1.472746265401464e-01, -1.089134739847491e-03,
  5.584175411610295e-06, -2.242860589598483e-08,  6.667464203272141e-11, -8.853827729763619e-14, -5.411098483927225e-16,  5.334609832567359e-18, -2.690048017049343e-20,
  8.383327245416832e-23, -4.276857504632461e-26, -1.493182156264205e-27,  2.039427448966244e-01, -1.465390083350591e-03,  7.043006845122005e-06, -2.459209893344449e-08,
  4.871711560912141e-11,  9.610415632860870e-14, -1.478503397001929e-15,  7.754212018386585e-18, -2.129421088176925e-20, -2.160703824174610e-23,  6.188867475329540e-25,
 -3.804904986757915e-27,  2.687991613433995e-01, -1.866496166430292e-03,  8.280801933551715e-06, -2.368579516602853e-08,  1.248500497404019e-11,  3.250623243479036e-13,
 -2.148052885631378e-15,  6.434902648719722e-18,  6.171102870721841e-21, -1.830002327090431e-22,  1.027691100504700e-24, -2.291356289677996e-27,  3.412681027677750e-01,
 -2.277122664946266e-03,  9.155038156427270e-06, -1.927883590098806e-08, -3.752074461612785e-11,  5.298387326467693e-13, -2.120202691034638e-15,  5.672487914833139e-19,
  4.416686926126260e-20, -2.680698313242042e-22,  5.014021140259493e-25,  3.695783646568507e-27,  4.206952320177454e-01, -2.681244947191727e-03,  9.547013632845284e-06,
 -1.145073116927006e-08, -9.258976854915859e-11,  6.346993317972216e-13, -1.178665667935398e-15, -8.059527111506107e-18,  6.816272995103358e-20, -1.562878209520673e-22,
 -8.925142320368922e-25,  8.763960388484745e-27,  5.063498295707208e-01, -3.062703602263869e-03,  9.373191471029446e-06, -8.228126043885529e-10, -1.413789207132393e-10,
  5.820449818077703e-13,  5.259356851700897e-16, -1.542264045432716e-17,  5.522408679773467e-20,  1.388104068683176e-22, -2.062934763347850e-24,  5.790490256449153e-27,
  5.974276802382913e-01, -3.405803031260131e-03,  8.594337630372961e-06,  1.149010299722649e-08, -1.723047556982940e-10,  3.554070224860417e-13,  2.465725912235396e-15,
 -1.710319678590669e-17,  1.992683616109797e-21,  4.330216859173330e-22, -1.695925125222114e-24, -5.368946914824517e-27,  6.930548060595983e-01, -3.695933282234116e-03,
  7.221508890873416e-06,  2.400823096407297e-08, -1.762753256768775e-10, -8.249180155242297e-15,  3.899672208901737e-15, -1.079500130248152e-17, -6.724970450898232e-20,
  4.824989516133316e-22,  3.965094197157633e-25, -1.476202878841083e-26,  7.922921918493213e-01, -3.920195467380016e-03,  5.318079945523806e-06,  3.508392050097457e-08,
 -1.491411310613291e-10, -4.227835541550222e-13,  4.166430008281452e-15,  1.900337107312628e-18, -1.111279462996057e-19,  1.819381572391334e-22,  2.708829475461279e-24,
 -1.106248865453547e-26,  8.941416491185211e-01, -4.068007170859084e-03,  2.997226965524393e-06,  4.314356963507080e-08, -9.322827271967742e-11, -7.746664272974135e-13,
  2.990748072669403e-15,  1.562813923439925e-17, -9.677119410448617e-20, -3.093328346595062e-22,  3.120736171144579e-24,  5.097092695926272e-27,  9.975529555293789e-01,
 -4.131660572877597e-03,  4.146137435575639e-07,  4.694012465784483e-08, -1.745609197025151e-11, -9.571451385391095e-13,  6.611109568951442e-16,  2.366884743233720e-17,
 -2.449853581513728e-20, -6.463896153677684e-22,  9.029230819699090e-25,  1.874562227740470e-26,  1.101432388862321e+00, -4.106803022178009e-03, -2.243551396007842e-06,
  4.577535969940355e-08,  6.416699830820281e-11, -9.063385360781954e-13, -2.026161804683732e-15,  2.151225589860040e-17,  6.711555165489995e-20, -5.564597866986009e-22,
 -2.283736179132082e-24,  1.504408964395133e-26,  1.204652744955098e+00, -3.992808021778819e-03, -4.776427159108736e-06,  3.965051745634722e-08,  1.354784271830041e-10,
 -6.264681050883465e-13, -4.064155308349526e-15,  9.637005422512788e-18,  1.230808808343456e-19, -7.683417132487222e-23, -3.674114930292550e-24, -3.580318700439289e-27,
  1.306064886849633e+00, -3.793004649074726e-03, -6.987237037373803e-06,  2.931074809812376e-08,  1.819212689818584e-10, -1.936002626968684e-13, -4.662877068575093e-15,
 -6.319862868232625e-18,  1.084484825631033e-19,  4.452759042570929e-22, -1.999120095307268e-24, -1.828706649526649e-26,  1.404510816725656e+00, -3.514735909351888e-03,
 -8.703081161172671e-06,  1.616349287179925e-08,  1.942077169829403e-10,  2.659922498070663e-13, -3.613626033412704e-15, -1.843258663727479e-17,  3.370080765704895e-20,
  6.225588070672129e-22,  1.181984095449267e-24, -1.417486415026402e-26,  1.498838193361030e+00, -3.169221932197508e-03, -9.793808191046599e-06,  2.072280397225876e-09,
  1.708652953452857e-10,  6.172964580680432e-13, -1.402879986887013e-15, -2.091889542478689e-17, -5.139991212228417e-20,  3.492239780244203e-22,  2.961717951763443e-24,
  2.864860257551871e-27,  1.587916137408509e+00, -2.771212575498970e-03, -1.018770202142539e-05, -1.094778226015229e-08,  1.188368626661468e-10,  7.636279909090832e-13,
  1.003431382598779e-15, -1.345953535230746e-17, -9.312315873762760e-20, -1.162408037020918e-22,  1.971382514959628e-24,  1.363038082134468e-26,  1.670652077902088e+00,
 -2.338425893153137e-03, -9.881813396812731e-06, -2.108304432919906e-08,  5.178615439115115e-11,  6.811257070492652e-13,  2.616981649445725e-15, -1.211410927715628e-18,
 -7.207795140720574e-20, -3.916685538287095e-22, -3.913625370887269e-25,  8.493452935299108e-27,  1.746009301084803e+00, -1.890783608480430e-03, -8.945158743977119e-06,
 -2.705664668842509e-08, -1.357379467510324e-11,  4.258910435475018e-13,  2.897749956917875e-15,  8.602412175212141e-18, -1.430092125449643e-20, -3.102669916271416e-22,
 -1.691764291942838e-24, -3.072398307440780e-27,  1.813024773720478e+00, -1.449471267055883e-03, -7.513723761241468e-06, -2.837587298745947e-08, -6.215485740242450e-11,
  1.094115352449021e-13,  1.986425004610539e-15,  1.128071819447349e-17,  3.339997971653548e-20, -3.357083852805349e-23, -1.079231125664086e-24, -7.061321784843341e-27,
  1.870826736353899e+00, -1.035867659333744e-03, -5.777194650252634e-06, -2.543284547820540e-08, -8.477876978637023e-11, -1.484666644933853e-13,  5.681225642198155e-16,
  7.261169045117370e-18,  4.202630834779131e-20,  1.541546665423381e-22,  1.942320103467635e-25, -2.251056345784294e-27,  1.918651510120761e+00, -6.704035080378171e-04,
 -3.958478169215388e-06, -1.942691947287217e-08, -8.069011328792631e-11, -2.690322651178962e-13, -5.530933314101621e-16,  1.011074454449227e-18,  1.941356122987114e-20,
  1.333989375455291e-22,  6.471424798780181e-25,  2.237627178681270e-27,  1.955858964512077e+00, -3.714210482594107e-04, -2.288190341733677e-06, -1.211498515566282e-08,
 -5.740723987617822e-11, -2.444974949378182e-13, -9.145571629502738e-16, -2.778892397597912e-18, -4.819141757713746e-21,  1.631357088342149e-23,  2.360770092467235e-25,
  1.639105109637123e-27,  1.981946345014832e+00, -1.541104257434100e-04, -9.771827499929832e-07, -5.436100489076665e-09, -2.787483262444078e-11, -1.342860974180471e-13,
 -6.118085710114755e-16, -2.633500617947062e-18, -1.061925022573310e-20, -3.930287187597749e-23, -1.271922003901034e-25, -3.093857871581337e-28,  1.996563726367714e+00,
 -2.956785984105560e-05, -1.904755817645872e-07, -1.088102479509457e-09, -5.809918506874538e-12, -2.967327861166649e-14, -1.467105078038851e-16, -7.070099365911185e-19,
 -3.334508555561130e-21, -1.542907108506400e-23, -7.013514538734231e-26, -3.133619592197692e-28,  1.204624253192536e-03, -9.406117121080589e-06,  5.505282002667904e-08,
 -2.862062576967782e-10,  1.393588830996572e-12, -6.506892740947177e-15,  2.949803594561438e-17, -1.307962218315892e-19,  5.698935174910462e-22, -2.447648275345311e-24,
  1.038438030116477e-26, -4.358605551188471e-29,  1.082799383823659e-02, -8.418586416334479e-05,  4.884107260863524e-07, -2.501545348626216e-09,  1.190650891877297e-11,
 -5.381484882875477e-14,  2.333308008652710e-16, -9.749424177012388e-19,  3.929540024640154e-21, -1.524799243979212e-23,  5.665268146548436e-26, -1.993971452221562e-28,
  3.000203127799252e-02, -2.312547684433719e-04,  1.317956743038041e-06, -6.546569305472954e-09,  2.969700358419279e-11, -1.249130670963741e-13,  4.872502266336206e-16,
 -1.739260958086677e-18,  5.475682202098101e-21, -1.365122965449540e-23,  1.438995813724217e-26,  1.190575843924125e-28,  5.858115424316195e-02, -4.456882039495715e-04,
  2.471770875759236e-06, -1.170008074394588e-08,  4.901170964640241e-11, -1.808759481889388e-13,  5.612246260496006e-16, -1.225829124746199e-18, -2.264488345658843e-22,
  2.278407328091174e-23, -1.690053393055917e-25,  8.816843129692207e-28,  9.634655936123777e-02, -7.202411529339792e-04,  3.847927486544657e-06, -1.700054662130786e-08,
  6.288418488298980e-11, -1.812788076749348e-13,  2.716894145193547e-16,  1.110720647449435e-18, -1.281187743193537e-20,  7.352020101606883e-23, -3.026708262338760e-25,
  8.369478293986387e-28,  1.430057552334504e-01, -1.045519913052296e-03,  5.321372320211304e-06, -2.137663428405017e-08,  6.478561808293666e-11, -9.982698306717746e-14,
 -4.033415328391362e-16,  4.521633462935103e-18, -2.392764285328208e-20,  8.096773000096966e-23, -9.680410668982201e-26, -9.842334017266439e-28,  1.981920225578517e-01,
 -1.410213064369696e-03,  6.752635882914872e-06, -2.379910395992394e-08,  5.030154407363615e-11,  6.314793433692504e-14, -1.271009986313284e-15,  7.064812346298969e-18,
 -2.166523275719010e-20, -2.640680113971405e-26,  4.644237765429526e-25, -3.217981047177978e-27,  2.614638748112978e-01, -1.801382797006559e-03,  7.997976587982103e-06,
 -2.343676458898352e-08,  1.848540363852466e-11,  2.756876883948669e-13, -1.966045970707384e-15,  6.534698754818754e-18,  2.975985630348836e-22, -1.440297554113686e-22,
  9.183420393050763e-25, -2.634538716698641e-27,  3.323046141582144e-01, -2.204817162030027e-03,  8.920430893385435e-06, -1.979715020118356e-08, -2.743074401016309e-11,
  4.792953997153082e-13, -2.085954463095376e-15,  1.830340671794621e-18,  3.491222685745253e-20, -2.452326343981178e-22,  6.293286399789056e-25,  2.167988249223832e-27,
  4.101220998959795e-01, -2.605442703247960e-03,  9.401129964789031e-06, -1.283222491415521e-08, -8.019568975495245e-11,  6.039444042900773e-13, -1.374686209391922e-15,
 -5.974497982380871e-18,  6.198355439283957e-20, -1.846236972684333e-22, -5.332553902305461e-25,  7.534077235964300e-27,  4.942488705730980e-01, -2.987795132117135e-03,
  9.350131322221411e-06, -2.991205495812874e-09, -1.296457254721966e-10,  5.896891821256676e-13,  1.194828402461791e-16, -1.359091976698363e-17,  5.880073170229198e-20,
  6.174984176381027e-23, -1.782430006933088e-24,  6.844312651648088e-27,  5.839427853357040e-01, -3.336543111865738e-03,  8.715922149470598e-06,  8.793144823231705e-09,
 -1.646435344555936e-10,  4.088589013620352e-13,  1.989976898322936e-15, -1.680350809155384e-17,  1.631209962811952e-20,  3.614032282460753e-22, -1.862311741798178e-24,
 -2.256957553605531e-27,  6.783883740331876e-01, -3.637056742937435e-03,  7.492695968052685e-06,  2.119148411994274e-08, -1.755300593688049e-10,  8.148878587759419e-14,
  3.569910204934554e-15, -1.266725098808747e-17, -4.974603159290717e-20,  4.859017948742707e-22, -2.119100149832107e-25, -1.278172038912309e-26,  7.766991075639742e-01,
 -3.876007973291688e-03,  5.724508037019867e-06,  3.263546100638266e-08, -1.565945974106954e-10, -3.225457840803274e-13,  4.170982141175159e-15, -1.531044042524928e-18,
 -1.027516174346364e-19,  2.798592925005219e-22,  2.172055182273811e-24, -1.314511174264889e-26,  8.779208176585241e-01, -4.041984973325290e-03,  3.505501631135636e-06,
  4.153201293977038e-08, -1.079702260652321e-10, -6.979967624000193e-13,  3.383482259374874e-15,  1.237773191097366e-17, -1.056189944626153e-19, -1.814224143361329e-22,
  3.240215470052976e-24,  3.573252070140345e-28,  9.810365058943918e-01, -4.126096733150991e-03,  9.755911426057784e-07,  4.650876951389066e-08, -3.638719520117789e-11,
 -9.334355424668849e-13,  1.309423964803914e-15,  2.252112536683980e-17, -4.692471890177893e-20, -5.943490603246454e-22,  1.682552796491999e-24,  1.647688932713259e-26,
  1.084972781682071e+00, -4.122538156423532e-03, -1.688693220160388e-06,  4.665458431153608e-08,  4.560391206881744e-11, -9.475147187386333e-13, -1.396880316752181e-15,
  2.332316043348153e-17,  4.560778750197264e-20, -6.335378979713815e-22, -1.546738422265044e-24,  1.825590599210121e-26,  1.188608154198259e+00, -4.029080350256774e-03,
 -4.288045386702766e-06,  4.171273744464369e-08,  1.219978101125266e-10, -7.203283140442899e-13, -3.739798307341547e-15,  1.350275642260846e-17,  1.176455053448576e-19,
 -2.254058030053298e-22, -3.715311712244118e-24,  1.788413295212886e-27,  1.290783369497293e+00, -3.847446480925543e-03, -6.618191237546090e-06,  3.218437904219785e-08,
  1.769179271868203e-10, -3.072264153590974e-13, -4.788957546288058e-15, -2.610023439490837e-18,  1.228477147819844e-19,  3.495238894605589e-22, -2.778140245443543e-24,
 -1.686595784509942e-26,  1.390313927284325e+00, -3.583531513652186e-03, -8.490315488558050e-06,  1.930848991752767e-08,  1.986192053901473e-10,  1.732147415251836e-13,
 -4.111213568558711e-15, -1.698773298926667e-17,  5.680287422339644e-20,  6.561884132797726e-22,  4.713171959870436e-25, -1.803648397974047e-26,  1.486004829027637e+00,
 -3.247425527502813e-03, -9.752136819880477e-06,  4.902860865616693e-09,  1.828261809817122e-10,  5.764251663655425e-13, -2.009582104747784e-15, -2.233949540383869e-17,
 -3.667528489986064e-20,  4.690733524597477e-22,  3.000702035973910e-24, -1.258831746379520e-27,  1.576667499016288e+00, -2.853206193037511e-03, -1.030715920155322e-05,
 -8.923037741367392e-09,  1.343179651720745e-10,  7.828479135921479e-13,  5.843314714866346e-16, -1.649002918289722e-17, -9.574248129454070e-20, -2.524842789735386e-23,
  2.580071430624386e-24,  1.387741115260779e-26,  1.661138684282452e+00, -2.418477243216187e-03, -1.012937790400963e-05, -2.014208959123841e-08,  6.603259403670630e-11,
  7.432524813047394e-13,  2.548634469524890e-15, -3.745742699312674e-18, -8.636148078352955e-20, -3.989380345263102e-22,  5.093531033800929e-26,  1.165485650433505e-26,
  1.738300983478393e+00, -1.963646617238987e-03, -9.270848039113965e-06, -2.720182534251929e-08, -4.341316315755964e-12,  4.982649470930329e-13,  3.130436988983437e-15,
  7.952767736224351e-18, -2.671752389021783e-20, -3.802294808479845e-22, -1.794891237561697e-24, -1.495368580667504e-27,  1.807104488879382e+00, -1.510959821493963e-03,
 -7.860120202501731e-06, -2.935014501409417e-08, -5.946368172186547e-11,  1.609954009990626e-13,  2.317003599862655e-15,  1.232122124046054e-17,  3.133645027036756e-20,
 -8.328860155459453e-23, -1.414804871164652e-24, -8.178009755017643e-27,  1.866588864859824e+00, -1.083329273445770e-03, -6.090622950535956e-06, -2.681224770273393e-08,
 -8.759447800320693e-11, -1.322348267770571e-13,  7.911068385983784e-16,  8.696089570534355e-18,  4.768875832202091e-20,  1.595984852133012e-22,  6.883799525487876e-26,
 -3.504246138270358e-27,  1.915905052462040e+00, -7.030261867987820e-04, -4.199527321858684e-06, -2.076171673458488e-08, -8.620082557625644e-11, -2.818919638023614e-13,
 -5.153272693702851e-16,  1.714337277680479e-18,  2.470597571712201e-20,  1.612945911803537e-22,  7.484991089151168e-25,  2.354744921609269e-27,  1.954335725990424e+00,
 -3.903240845669076e-04, -2.439246563088612e-06, -1.307383993636400e-08, -6.252307353039455e-11, -2.673973892627175e-13, -9.944229880432707e-16, -2.921737011674077e-18,
 -4.043313326437773e-21,  2.733048366275858e-23,  3.182079205177254e-25,  2.111636395855499e-27,  1.981313844264492e+00, -1.621966119467486e-04, -1.045183223100472e-06,
 -5.904407163895950e-09, -3.071356553961112e-11, -1.498941016758655e-13, -6.905238746837441e-16, -2.996963674414085e-18, -1.212901815923538e-20, -4.466319064374676e-23,
 -1.408033338741761e-25, -3.064525876803823e-28,  1.996442322331172e+00, -3.114552009265815e-05, -2.041107866921207e-07, -1.186007165132152e-09, -6.440262665434464e-12,
 -3.344447700101706e-14, -1.680881703572126e-16, -8.231709785651249e-19, -3.943960819639664e-21, -1.853083632986736e-23, -8.549219170129512e-26, -3.874400387785474e-28,
  1.167859400558794e-03, -8.979063051679090e-06,  5.174795619734659e-08, -2.649126829208270e-10,  1.270244173790438e-12, -5.840905316363797e-15,  2.607835791641241e-17,
 -1.138929107752666e-19,  4.888150672214159e-22, -2.068201827933512e-24,  8.644942906863010e-27, -3.575384012135133e-29,  1.049887930244369e-02, -8.039549382781731e-05,
  4.595006497894385e-07, -2.319356350531209e-09,  1.088407150350792e-11, -4.852877303119642e-14,  2.077133463784699e-16, -8.575592464994407e-19,  3.419369024456285e-21,
 -1.314849987835815e-23,  4.853305169380624e-26, -1.704033824299417e-28,  2.909761313126542e-02, -2.210174580614111e-04,  1.242168394840392e-06, -6.090784171878636e-09,
  2.731183807063119e-11, -1.137841031588882e-13,  4.409309916861715e-16, -1.571781841472473e-18,  4.995719166901275e-21, -1.298622853327672e-23,  1.850853550482017e-26,
  7.071837419937529e-29,  5.683707901917908e-02, -4.264625798688944e-04,  2.335957991543510e-06, -1.094411337976386e-08,  4.552610323265871e-11, -1.678185415232925e-13,
  5.269143914297998e-16, -1.221183721675695e-18,  4.809862522226837e-22,  1.674994813210198e-23, -1.338818399331031e-25,  7.194903511120352e-28,  9.352589333494719e-02,
 -6.902569279739731e-04,  3.649839339393098e-06, -1.602304021832689e-08,  5.932610395434000e-11, -1.744290235239125e-13,  2.974315194070899e-16,  7.408232644803049e-19,
 -1.037425463304309e-20,  6.214323478902468e-23, -2.663973289719709e-25,  8.069932051287007e-28,  1.389072175877318e-01, -1.003957546194738e-03,  5.071004652559390e-06,
 -2.035652114584468e-08,  6.270209568404096e-11, -1.080717687339447e-13, -2.870229641332397e-16,  3.801761776168841e-18, -2.109180772205719e-20,  7.635225581780894e-23,
 -1.311283398896184e-25, -5.938048733265166e-28,  1.926574231717761e-01, -1.357320566731411e-03,  6.471912072896698e-06, -2.298576713351971e-08,  5.127507891975384e-11,
  3.493925076760934e-14, -1.082877400336122e-15,  6.374828180753381e-18, -2.136438916905190e-20,  1.588652566482418e-23,  3.353074766936813e-25, -2.657508096342094e-27,
  2.543845376848384e-01, -1.738518518275510e-03,  7.718683830857982e-06, -2.309938965379008e-08,  2.354211320594002e-11,  2.306947767859734e-13, -1.783671353767617e-15,
  6.468120536185205e-18, -4.254656184657873e-21, -1.096612817201948e-22,  7.992911476633660e-25, -2.744133538523075e-27,  3.236265582259302e-01, -2.134410728302793e-03,
  8.680539316292285e-06, -2.016205533264861e-08, -1.834069540450280e-11,  4.299657501455733e-13, -2.020355842106648e-15,  2.811299573461086e-18,  2.655642877364557e-20,
 -2.185350350216357e-22,  6.965999796054544e-25,  9.387782544807345e-28,  3.998497423134947e-01, -2.530870517470266e-03,  9.239837130359130e-06, -1.402057036115411e-08,
 -6.845914471846782e-11,  5.691623635931067e-13, -1.515228413892867e-15, -4.100859259651419e-18,  5.502947488166325e-20, -1.997174747165691e-22, -2.312905780194026e-25,
  6.182627874316448e-27,  4.824470162124564e-01, -2.913172026327423e-03,  9.302180221911588e-06, -4.971156567227651e-09, -1.178529843137313e-10,  5.882044215662823e-13,
 -2.344806351344316e-16, -1.168688912475438e-17,  5.981451980824861e-20, -3.360866525963381e-24, -1.470128244239413e-24,  7.255123292812396e-27,  5.707366735381495e-01,
 -3.266437809224587e-03,  8.805911926366463e-06,  6.226701866717793e-09, -1.560265183591488e-10,  4.510428565739664e-13,  1.528639025382391e-15, -1.608787418729181e-17,
  2.796534489233223e-20,  2.857441290090581e-22, -1.901276890684967e-24,  4.004861713012250e-28,  6.639615735468339e-01, -3.576145574635303e-03,  7.730211416851003e-06,
  1.840057291639144e-08, -1.730730958917249e-10,  1.627466308927303e-13,  3.195552825879593e-15, -1.398193864277093e-17, -3.253526647848348e-20,  4.668878818221417e-22,
 -7.204671638122668e-25, -1.027117583251741e-26,  7.612890873601218e-01, -3.828688455629831e-03,  6.100905170110499e-06,  3.008375794780323e-08, -1.620498284128964e-10,
 -2.233183130435529e-13,  4.083707664620715e-15, -4.642282797198510e-18, -9.125558109462999e-20,  3.548179872474536e-22,  1.569122368502950e-24, -1.407419051305505e-26,
  8.618120794017405e-01, -4.011977823289931e-03,  3.993074563954326e-06,  3.969733279795789e-08, -1.210920490364653e-10, -6.130213297750441e-13,  3.681937708811712e-15,
  8.918389580347680e-18, -1.098256523018967e-19, -5.283205528298119e-23,  3.157207523020988e-24, -4.043841784185632e-27,  9.645512472585211e-01, -4.116070887067984e-03,
  1.529593247509829e-06,  4.577914329274456e-08, -5.469152541017467e-11, -8.946312208827401e-13,  1.915877138869817e-15,  2.069154213411137e-17, -6.694351325094217e-20,
 -5.134833969467458e-22,  2.335701601869240e-24,  1.304607298656483e-26,  1.068459171312794e+00, -4.133797328817075e-03, -1.125090879772446e-06,  4.723104774748849e-08,
  2.637202480937386e-11, -9.730598079124680e-13, -7.269040704679987e-16,  2.440736329588734e-17,  2.188649544082775e-20, -6.786884983147770e-22, -6.972302821682676e-25,
  2.011484559383072e-26,  1.172426439603615e+00, -4.061350444462397e-03, -3.776271591763431e-06,  4.354470927294306e-08,  1.067264795142198e-10, -8.051296588366147e-13,
 -3.310438951454383e-15,  1.710914931994712e-17,  1.068898684318827e-19, -3.707924243923378e-22, -3.513055007326036e-24,  7.404505687814454e-27,  1.275290205796180e+00,
 -3.898799546602298e-03, -6.215217614364360e-06,  3.495964813573628e-08,  1.696204717447586e-10, -4.225833223881420e-13, -4.805271907200796e-15,  1.499574126438862e-18,
  1.332582506106917e-19,  2.243234774251209e-22, -3.460076288336514e-24, -1.387359501839275e-26,  1.375845500199195e+00, -3.650472977951462e-03, -8.239449642244052e-06,
  2.250859279257179e-08,  2.010594352895052e-10,  6.906505477646941e-14, -4.557854457983704e-15, -1.479005001707605e-17,  8.056472615530827e-20,  6.581917673782161e-22,
 -3.935679525735877e-25, -2.110702517784381e-26,  1.472859536683598e+00, -3.325156697942832e-03, -9.675379810369990e-06,  7.917472442859494e-09,  1.938211024562831e-10,
  5.205729348151979e-13, -2.648815759105521e-15, -2.321994525336597e-17, -1.765434743946751e-20,  5.865692717837017e-22,  2.837349575485580e-24, -6.299444917787605e-27,
  1.565089134698226e+00, -2.936054043900408e-03, -1.040082242589560e-05, -6.648095881432193e-09,  1.500759734998031e-10,  7.909849159817249e-13,  7.973026470019368e-17,
 -1.954722741409591e-17, -9.464797056596537e-20,  9.000059741333184e-23,  3.176039497342150e-24,  1.300231323980286e-26,  1.651301201337263e+00, -2.500459974747710e-03,
 -1.036424264933669e-05, -1.896336571770273e-08,  8.149915048953339e-11,  8.028356256045557e-13,  2.402913576650131e-15, -6.737643960863089e-18, -1.005541353279235e-19,
 -3.856709418048395e-22,  6.366142220115388e-25,  1.497227147142167e-26,  1.730295995467400e+00, -2.039119485754353e-03, -9.597344429439723e-06, -2.718740811685163e-08,
  6.392769599384419e-12,  5.759578083488562e-13,  3.338987876607304e-15,  6.864846446948119e-18, -4.170827831876837e-20, -4.527047063783222e-22, -1.811592123784274e-24,
  8.788753645781736e-28,  1.800932634573173e+00, -1.575265499262923e-03, -8.217914086806586e-06, -3.027266398759476e-08, -5.565917592854128e-11,  2.208535515617470e-13,
  2.675503729254750e-15,  1.326436910095161e-17,  2.722993143633409e-20, -1.473765169611816e-22, -1.796595771912831e-24, -9.136902847405305e-27,  1.862156026175688e+00,
 -1.133365264508636e-03, -6.420862692387697e-06, -2.823379936242633e-08, -9.002867238679743e-11, -1.101486140691847e-13,  1.056827570949550e-15,  1.031426213361764e-17,
  5.344268004491774e-20,  1.588204832976334e-22, -1.195101265206728e-25, -5.121311329351355e-27,  1.913024143715803e+00, -7.376428471553065e-04, -4.457131378750900e-06,
 -2.218668664623012e-08, -9.195797003842604e-11, -2.935888872042164e-13, -4.553422467420831e-16,  2.603816067464618e-18,  3.107658202965056e-20,  1.933170615481024e-22,
  8.526222731836849e-25,  2.353305041905591e-27,  1.952734383539805e+00, -4.104830226724635e-04, -2.602315616709732e-06, -1.411831748814501e-08, -6.811638070102560e-11,
 -2.922588636067604e-13, -1.077876502162384e-15, -3.032732721480262e-18, -2.806435114891523e-21,  4.208125367647917e-23,  4.236185361044380e-25,  2.700715968706720e-27,
  1.980647874048248e+00, -1.708500771993195e-04, -1.119086538137803e-06, -6.420737051503251e-09, -3.388420353185983e-11, -1.675190381797859e-13, -7.801222760947539e-16,
 -3.411931341538986e-18, -1.384147514961200e-20, -5.055960234377762e-23, -1.538366324406755e-25, -2.814624664026051e-28,  1.996314381799743e+00, -3.283713878119109e-05,
 -2.189839432965282e-07, -1.294629772371973e-09, -7.151436727275898e-12, -3.777008076040733e-14, -1.930090471336718e-16, -9.607463488493730e-19, -4.676966324139482e-21,
 -2.231730562156061e-23, -1.045077685604342e-25, -4.804039566533189e-28,  1.132751458627816e-03, -8.577458366962349e-06,  4.868719971254890e-08, -2.454903681304497e-10,
  1.159435415729258e-12, -5.251591673669467e-15,  2.309761104136418e-17, -9.937833159209084e-20,  4.202230813280548e-22, -1.751904066972991e-24,  7.216093255849432e-27,
 -2.941298321731781e-29,  1.018447715084656e-02, -7.682792931051315e-05,  4.326820710550807e-07, -2.152712898942519e-09,  9.961464394462909e-12, -4.381985251731783e-14,
  1.851649937053336e-16, -7.553525036817723e-19,  2.979229577714063e-21, -1.134953256014655e-23,  4.159637528717756e-26, -1.455352503644530e-28,  2.823296535807922e-02,
 -2.113652090122402e-04,  1.171627646102264e-06, -5.671439889083294e-09,  2.513850619021048e-11, -1.037122402640682e-13,  3.990899514343289e-16, -1.419250604524887e-18,
  4.542188425457608e-21, -1.219474519708122e-23,  2.081281658036743e-26,  3.595342171755437e-29,  5.516778942621966e-02, -4.082881009564274e-04,  2.208890570670421e-06,
 -1.024187118591209e-08,  4.229343343470620e-11, -1.555806529092036e-13,  4.930203570741405e-16, -1.197118371120661e-18,  9.948355636968423e-22,  1.198607976138402e-23,
 -1.052995185867341e-25,  5.837915147773382e-28,  9.082206773630687e-02, -6.618114450689455e-04,  3.463144313649950e-06, -1.510133694462534e-08,  5.591040187121715e-11,
 -1.670772684366573e-13,  3.138489596347404e-16,  4.426536544163155e-19, -8.320474881741028e-21,  5.218317458514417e-23, -2.319925864268890e-25,  7.540356964793612e-28,
  1.349710002399651e-01, -9.643497335457592e-04,  4.832673355901088e-06, -1.937091852305781e-08,  6.048001367197645e-11, -1.137566934638744e-13, -1.896170311542246e-16,
  3.169745074443891e-18, -1.844298198380638e-20,  7.067703121925399e-23, -1.505073367795605e-25, -3.016686994024155e-28,  1.873299643281674e-01, -1.306634595919976e-03,
  6.201023923194842e-06, -2.216112835669574e-08,  5.172803477342335e-11,  1.101549730376575e-14, -9.138503031526345e-16,  5.702687558473187e-18, -2.057781754083414e-20,
  2.711491498358106e-23,  2.298414462643746e-25, -2.145630489994613e-27,  2.475522164832361e-01, -1.677871079028009e-03,  7.443896089689922e-06, -2.268806933053413e-08,
  2.774250310838068e-11,  1.900411349510470e-13, -1.605020925752729e-15,  6.274741201366111e-18, -7.656027939967555e-21, -8.009762299746393e-23,  6.793175146036559e-25,
 -2.686564403079728e-27,  3.152262654230075e-01, -2.065938544526514e-03,  8.437109266040825e-06, -2.038931808308319e-08, -1.021942363157778e-11,  3.825107592174126e-13,
 -1.930886166631233e-15,  3.540669478006382e-18,  1.919793168394147e-20, -1.901421576582133e-22,  7.161889106849579e-25, -2.865208402864006e-30,  3.898730069102518e-01,
 -2.457642576581894e-03,  9.065387356727215e-06, -1.502686210211398e-08, -5.744785300657607e-11,  5.316112850201446e-13, -1.606489906040843e-15, -2.456230852563074e-18,
  4.773501928879734e-20, -2.039296181798740e-22,  1.082795572311610e-26,  4.830843996073613e-27,  4.709427411028568e-01, -2.839024364531471e-03,  9.231599386439909e-06,
 -6.763104744728841e-09, -1.061705611879335e-10,  5.788658787983656e-13, -5.350121094505085e-16, -9.785484566092269e-18,  5.871204686468281e-20, -5.577965700991061e-23,
 -1.151595901403625e-24,  7.149558679324095e-27,  5.578122311265176e-01, -3.195733373553856e-03,  8.865957534418274e-06,  3.804286554650260e-09, -1.466747141155876e-10,
  4.824347719742360e-13,  1.092149222771051e-15, -1.504299753573980e-17,  3.689355707935272e-20,  2.107068773195746e-22, -1.835254581421617e-24,  2.504994713675744e-27,
  6.497820069738671e-01, -3.513467457903742e-03,  7.934523817069958e-06,  1.566147481605576e-08, -1.690834845397015e-10,  2.346396305028405e-13,  2.791965001948583e-15,
 -1.476053791989960e-17, -1.634766706958224e-20,  4.298330762736062e-22, -1.112170656732781e-24, -7.515151279669098e-27,  7.460741717545499e-01, -3.778481576530432e-03,
  6.446223206742656e-06,  2.746050494181555e-08, -1.655482873508208e-10, -1.271869106028992e-13,  3.914840851748499e-15, -7.347187162961782e-18, -7.750201994844514e-20,
  4.051669274687161e-22,  9.493964488811087e-25, -1.392975064403877e-26,  8.458310266108282e-01, -3.978161592047929e-03,  4.457428894003128e-06,  3.766665559160586e-08,
 -1.324506404115806e-10, -5.220562713363624e-13,  3.882336208368370e-15,  5.397492873935625e-18, -1.095079102020068e-19,  6.874316539563198e-23,  2.894413730849888e-24,
 -7.766300030630892e-27,  9.481148936443297e-01, -4.101652960953372e-03,  2.073110743922933e-06,  4.476362861083057e-08, -7.207873198495498e-11, -8.419562884787917e-13,
  2.462605364656278e-15,  1.827266659991231e-17, -8.361974225204086e-20, -4.097784819510888e-22,  2.818583896188191e-24,  8.801907318590269e-27,  1.051909578273579e+00,
 -4.140525276423504e-03, -5.564312446591092e-07,  4.749659618354203e-08,  6.792040226141920e-12, -9.822482151494681e-13, -3.739408408121624e-17,  2.471316980808916e-17,
 -2.832895614303326e-21, -6.886680100828253e-22,  2.005781668327004e-25,  2.043346360700624e-26,  1.156123966213380e+00, -4.089442692555783e-03, -3.244034245904391e-06,
  4.511936505295257e-08,  8.987012628283240e-11, -8.784582918302557e-13, -2.785692027783224e-15,  2.028966222291467e-17,  9.110519078437504e-20, -5.031870615860528e-22,
 -3.067663797135746e-24,  1.275259787886965e-26,  1.259598285297451e+00, -3.946797770568908e-03, -5.779717413843907e-06,  3.759971930865767e-08,  1.600214594986065e-10,
 -5.369176508067765e-13, -4.702567109473495e-15,  5.865213506203268e-18,  1.387064222258212e-19,  7.492860905722867e-23, -3.977019004307761e-24, -9.395290538510339e-27,
  1.361113565041928e+00, -3.715253408781012e-03, -7.950018863879092e-06,  2.573051544265923e-08,  2.013149054402484e-10, -4.497984724713618e-14, -4.932353111118071e-15,
 -1.183775549972258e-17,  1.037464305851103e-19,  6.232345984460471e-22, -1.367552468778557e-24, -2.292122890966985e-26,  1.459404780983687e+00, -3.402126210679813e-03,
 -9.561431531882062e-06,  1.109822575102946e-08,  2.035439382115407e-10,  4.491558964282222e-13, -3.303556310653073e-15, -2.342575561167042e-17,  5.423388222012547e-21,
  6.928813996194966e-22,  2.436827114503264e-24, -1.198084577837605e-26,  1.553178059322526e+00, -3.019537709221270e-03, -1.046567041937528e-05, -4.120410950473880e-09,
  1.658687211742352e-10,  7.859922243982844e-13, -5.093261719040829e-16, -2.249851554958142e-17, -8.898823609766882e-20,  2.279236633648341e-22,  3.703538730965639e-24,
  1.072315860848791e-26,  1.641132125269868e+00, -2.584260749405867e-03, -1.058343928944404e-05, -1.752786305680063e-08,  9.811534843390044e-11,  8.578654790473210e-13,
  2.167166828825900e-15, -1.017126175654798e-17, -1.138123929168635e-19, -3.460712644439086e-22,  1.366629544633188e-24,  1.815958192175288e-26,  1.721983897415553e+00,
 -2.117200593889621e-03, -9.922585213316313e-06, -2.698855407151024e-08,  1.872800717000104e-11,  6.582337327069737e-13,  3.509969214923832e-15,  5.255566281918176e-18,
 -5.929260810534914e-20, -5.234955980526816e-22, -1.703974791112370e-24,  4.172146471663379e-27,  1.794497764327062e+00, -1.642476680126478e-03, -8.586371921725021e-06,
 -3.112425739688113e-08, -5.056941421269005e-11,  2.896155145838080e-13,  3.058203965926483e-15,  1.403616855743566e-17,  2.053193532103812e-20, -2.274952020271375e-22,
 -2.213878748072610e-24, -9.756413349587597e-27,  1.857517650765965e+00, -1.186112034186626e-03, -6.768378994520603e-06, -2.969040205992797e-08, -9.195359230642767e-11,
 -8.112067306253811e-14,  1.370419474365310e-15,  1.211451184074218e-17,  5.901476667886858e-20,  1.489675315541375e-22, -3.879040044355868e-25, -7.149208964739068e-27,
  1.910000536132024e+00, -7.743903216933799e-04, -4.732395202878786e-06, -2.370555526033727e-08, -9.793251554674947e-11, -3.035231751984479e-13, -3.674187646075796e-16,
  3.716400017382736e-18,  3.867450414410342e-20,  2.294530071600714e-22,  9.527828411042381e-25,  2.160583537779890e-27,  1.951049714653064e+00, -4.319982080103801e-04,
 -2.778472122200522e-06, -1.525637558356668e-08, -7.422717263313012e-11, -3.191555232351041e-13, -1.163797836813699e-15, -3.094785110302997e-18, -9.560342893028062e-22,
  6.160587743974374e-23,  5.579059341883065e-25,  3.427830303188637e-27,  1.979946067023056e+00, -1.801204427893836e-04, -1.199502215063292e-06, -6.990738037587096e-09,
 -3.742981786480679e-11, -1.874401573710008e-13, -8.821395666520503e-16, -3.885191909842305e-18, -1.577524141481972e-20, -5.694631747377103e-23, -1.650697218702690e-25,
 -2.222307597715543e-28,  1.996179428285703e+00, -3.465315683980081e-05, -2.352318077590474e-07, -1.415357117096188e-09, -7.955430148334476e-12, -4.274279284157073e-14,
 -2.221320079827960e-16, -1.124114093219496e-18, -5.561021596956430e-21, -2.695286022967106e-23, -1.281212914660426e-25, -5.973958718894534e-28,  1.099202398027300e-03,
 -8.199436731824044e-06,  4.584925008788886e-08, -2.277504563326964e-10,  1.059729231743863e-12, -4.729176945944047e-15,  2.049417938281837e-17, -8.688701599021652e-20,
  3.620528752726538e-22, -1.487550545837041e-24,  6.039056646417204e-27, -2.426409788672887e-29,  9.883928479881881e-03, -7.346715851529471e-05,  4.077776586919239e-07,
 -2.000106191745759e-09,  9.127847917750075e-12, -3.961928456821149e-14,  1.652906136450437e-16, -6.662454951199958e-19,  2.599112214904399e-21, -9.807243037444124e-24,
  3.567299774906653e-26, -1.242602194333176e-28,  2.740582898446208e-02, -2.022577336118266e-04,  1.105916863487479e-06, -5.285310556092668e-09,  2.315690729709955e-11,
 -9.459492491335380e-14,  3.613209980231086e-16, -1.280761463205271e-18,  4.118471175801571e-21, -1.133847024736690e-23,  2.182219285797291e-26,  1.137180294256305e-29,
  5.356921682340222e-02, -3.910973147561183e-04,  2.089947654363218e-06, -9.589437583893187e-09,  3.929745037919486e-11, -1.441464279403940e-13,  4.600060825976875e-16,
 -1.159144428159817e-18,  1.356390437838915e-21,  8.253125142616328e-24, -8.216816129327580e-26,  4.711601783028519e-28,  8.822910570158556e-02, -6.348161983835001e-04,
  3.287186733853445e-06, -1.423308992421241e-08,  5.264503583613714e-11, -1.594245752387913e-13,  3.227857061462912e-16,  2.047287762220034e-19, -6.601088100138898e-21,
  4.354836659499875e-23, -2.002258150549551e-25,  6.885205912416181e-28,  1.311894748841790e-01, -9.266018745955029e-04,  4.605952614204846e-06, -1.842165763002656e-08,
  5.816622585795635e-11, -1.173068487950969e-13, -1.087525346339110e-16,  2.619095898854448e-18, -1.600954678704378e-20,  6.445900788715218e-23, -1.588478440095593e-25,
 -8.914244350107878e-29,  1.822009779577136e-01, -1.258076059404527e-03,  5.940059829519339e-06, -2.133285601853405e-08,  5.174157382805953e-11, -9.074255369867072e-15,
 -7.632355459163811e-16,  5.061413623607560e-18, -1.945768637622571e-20,  3.455798739454948e-23,  1.456037679179321e-25, -1.693751737649769e-27,  2.409581212284839e-01,
 -1.619401116118289e-03,  7.174421347511329e-06, -2.221581644135522e-08,  3.117219818068895e-11,  1.535987790285525e-13, -1.433155498598447e-15,  5.988627653482523e-18,
 -1.007853945351948e-20, -5.524573858670861e-23,  5.645144778170539e-25, -2.517321097220840e-27,  3.070959522268801e-01, -1.999422572119374e-03,  8.191700780346694e-06,
 -2.049411013822241e-08, -3.024258238443381e-12,  3.374224484121744e-13, -1.824136446009407e-15,  4.050996722680076e-18,  1.286641920777428e-20, -1.617155097231705e-22,
  7.001810206839791e-25, -6.848078352308365e-28,  3.801863197482143e-01, -2.385855598589805e-03,  8.879894038642790e-06, -1.586308517208768e-08, -4.720589228623447e-11,
  4.923960728816803e-13, -1.654979857367208e-15, -1.045697301245126e-18,  4.044909166043636e-20, -1.996264114698097e-22,  1.951070060172807e-25,  3.565066097430113e-27,
  4.597337956232498e-01, -2.765524201963909e-03,  9.140629301814801e-06, -8.370002203923687e-09, -9.474275176897713e-11,  5.629478099302966e-13, -7.830644121860758e-16,
 -7.947109876318789e-18,  5.594959227620627e-20, -9.567215000171740e-23, -8.465938449776256e-25,  6.662126423894842e-27,  5.451713867331405e-01, -3.124662261193531e-03,
  8.897850835372119e-06,  1.535964130547962e-09, -1.367973029976673e-10,  5.037318215612681e-13,  6.885143364343737e-16, -1.375495898357219e-17,  4.318872071789935e-20,
  1.399910630509401e-22, -1.689455843151198e-24,  4.026736524742533e-27,  6.358562153665119e-01, -3.449285127679376e-03,  8.106395769645131e-06,  1.299718072280294e-08,
 -1.637543432277729e-10,  2.966421125350720e-13,  2.373607723072760e-15, -1.504526312132334e-17, -1.746676775543704e-21,  3.795502599491714e-22, -1.381920640228911e-24,
 -4.765564811688700e-27,  7.310654082340189e-01, -3.725638876298144e-03,  6.759789020514488e-06,  2.479641257872357e-08, -1.671705174855464e-10, -3.596592227750010e-14,
  3.676636847143489e-15, -9.587731339882537e-18, -6.237798308477260e-20,  4.311351098700337e-22,  3.566904423533628e-25, -1.287919385899406e-26,  8.299925099052279e-01,
 -3.940730948409781e-03,  4.896385464801197e-06,  3.546902320499787e-08, -1.419497975616379e-10, -4.274595573580175e-13,  3.984933667685643e-15,  1.954457181061692e-18,
 -1.050398338560144e-19,  1.767874968310732e-22,  2.487361061341491e-24, -1.057099321485191e-26,  9.317448242699868e-01, -4.082940284313173e-03,  2.602809901724799e-06,
  4.347903547934124e-08, -8.828700769825048e-11, -7.770293483846588e-13,  2.934719790636452e-15,  1.538323884840852e-17, -9.626133411857789e-20, -2.906419477773903e-22,
  3.104369468712370e-24,  4.157970029131922e-27,  1.035342184650021e+00, -4.142696534496837e-03,  1.353214538730686e-08,  4.744829514344504e-08, -1.280599899740929e-11,
 -9.748751010346559e-13,  6.495996256432356e-16,  2.422913826397417e-17, -2.726598243710919e-20, -6.629193428281201e-22,  1.077761924615258e-24,  1.918723561677689e-26,
  1.139717752688133e+00, -4.113206150200842e-03, -2.694565340823209e-06,  4.641330006646005e-08,  7.168003986802039e-11, -9.381856935583393e-13, -2.179651671004578e-15,
  2.289269384291850e-17,  7.092998504949570e-20, -6.132551960297620e-22, -2.402478334685091e-24,  1.731241114627789e-26,  1.243721536637674e+00, -3.991188053156897e-03,
 -5.313532776985051e-06,  4.006808857050855e-08,  1.481703913454884e-10, -6.473056108311019e-13, -4.476018257634285e-15,  1.031556100446177e-17,  1.384552079780876e-19,
 -9.081891388969199e-23, -4.268815564868673e-24, -3.698686935726355e-27,  1.346127383785653e+00, -3.777563847983958e-03, -7.621977259708610e-06,  2.893781968098546e-08,
  1.992067209729543e-10, -1.669383559552891e-13, -5.214045681612551e-15, -8.171429816488511e-18,  1.249533481868943e-19,  5.481857943562195e-22, -2.385989166747924e-24,
 -2.306774379160920e-26,  1.445644215725993e+00, -3.478028930523110e-03, -9.408430723975931e-06,  1.442226350959980e-08,  2.116812745301303e-10,  3.620427952016927e-13,
 -3.953170275225517e-15, -2.283543017939362e-17,  3.197878376967327e-20,  7.780749478455500e-22,  1.779878899763033e-24, -1.787166071580514e-26,  1.540932209869656e+00,
 -3.103414546703080e-03, -1.049867594900906e-05, -1.341636684891892e-09,  1.814136737016342e-10,  7.658957392277125e-13, -1.177708912825368e-15, -2.518539982155275e-17,
 -7.801183319404480e-20,  3.844780705102338e-22,  4.095854072059100e-24,  6.832502827010526e-27,  1.630624454543983e+00, -2.669741591968912e-03, -1.078377951005961e-05,
 -1.581803739766688e-08,  1.157675353572506e-10,  9.060372985106730e-13,  1.829595133457910e-15, -1.400043105167500e-17, -1.250867077622613e-19, -2.745880677697238e-22,
  2.226990220107108e-24,  2.082356024414986e-26,  1.713354291094869e+00, -2.197870601689957e-03, -1.024420058618634e-05, -2.657896561159743e-08,  3.274581042475592e-11,
  7.440065883623358e-13,  3.627637457789868e-15,  3.043943428748849e-18, -7.931038609907051e-20, -5.867956292306943e-22, -1.429852864311685e-24,  8.451975118179971e-27,
  1.787788091407433e+00, -1.712674907942834e-03, -8.964513242058476e-06, -3.188290678700648e-08, -4.401095164306277e-11,  3.677946065456038e-13,  3.459057049060232e-15,
  1.454421774407759e-17,  1.064400048256623e-20, -3.246986927995334e-22, -2.646598667080634e-24, -9.793093463571756e-27,  1.852662616637347e+00, -1.241709327923613e-03,
 -7.133538790592514e-06, -3.117273258582553e-08, -9.321850592653891e-11, -4.394190009654278e-14,  1.736845519510322e-15,  1.408513886270155e-17,  6.401623771366411e-20,
  1.264664210365137e-22, -7.551088389778011e-25, -9.614602146344525e-27,  1.906825416681764e+00, -8.134144518949147e-04, -5.026465161821479e-06, -2.532148033468480e-08,
 -1.040819746489507e-10, -3.109447681488312e-13, -2.447381000782862e-16,  5.093683953044998e-18,  4.764270174779833e-20,  2.693483853786310e-22,  1.038477298451497e-24,
  1.676720447023776e-27,  1.949276077627102e+00, -4.549789759294708e-04, -2.968890076894334e-06, -1.649662231852801e-08, -8.089662213650584e-11, -3.481277653179393e-13,
 -1.250514224704180e-15, -3.085276521164340e-18,  1.702061416554412e-21,  8.718731648274017e-23,  7.276221452154198e-25,  4.314563506103722e-27,  1.979205847162044e+00,
 -1.900624894165626e-04, -1.287111874276747e-06, -7.620793896609365e-09, -4.139944913687076e-11, -2.099759149927888e-13, -9.983096301811508e-16, -4.424092572991617e-18,
 -1.794626656474290e-20, -6.371649149312814e-23, -1.726335293504271e-25, -1.112508056027269e-28,  1.996036941239300e+00, -3.660517922608212e-05, -2.530089931244536e-07,
 -1.549783581646070e-09, -8.866255039791597e-12, -4.847270526211416e-14, -2.562517704970846e-16, -1.318634548667616e-18, -6.630275459943531e-21, -3.264439050103997e-23,
 -1.575295529810141e-25, -7.450361199907168e-28,  1.067121327739301e-03, -7.843293525409256e-06,  4.321494172401791e-08, -2.115255367546426e-10,  9.698737981001969e-13,
 -4.265249360226257e-15,  1.821581268341823e-17, -7.611354099971506e-20,  3.126037997848855e-22, -1.266044070825305e-24,  5.066786104113678e-27, -2.007088825263913e-29,
  9.596435707712141e-03, -7.029851842011686e-05,  3.846271903185533e-07, -1.860190349285023e-09,  8.373668151759234e-12, -3.586708657796842e-14,  1.477489684162102e-16,
 -5.884578382739023e-19,  2.270469349063494e-21, -8.484114852373878e-24,  3.061567763136739e-26, -1.060932169154270e-28,  2.661409974269597e-02, -1.936579357144711e-04,
  1.044655260803738e-06, -4.929475994432563e-09,  2.134889645885098e-11, -8.633903554251733e-14,  3.272445934301342e-16, -1.155332235811276e-18,  3.726068060687046e-21,
 -1.046105279716657e-23,  2.192515885180345e-26, -5.618725511973041e-30,  5.203755273578551e-02, -3.748275528785511e-04,  1.978553735084149e-06, -8.983152901877532e-09,
  3.652232077439479e-11, -1.334905969535316e-13,  4.281980711715824e-16, -1.111581663779417e-18,  1.599074700802518e-21,  5.352361377619480e-24, -6.354595929131041e-26,
  3.783066254231383e-28,  8.574137408062045e-02, -6.091878129620062e-04,  3.121339725761365e-06, -1.341585483271353e-08,  4.953435981507369e-11, -1.516314041835445e-13,
  3.257858249095311e-16,  1.709009852588312e-20, -5.170396001826192e-21,  3.612458474504264e-23, -1.714794415528495e-25,  6.177283102272341e-28,  1.275553846813776e-01,
 -8.906228511427807e-04,  4.390398864115737e-06, -1.750988500610780e-08,  5.579963813548202e-11, -1.190926837389915e-13, -4.225004705628770e-17,  2.142687769676722e-18,
 -1.380389329102076e-20,  5.807469511932312e-23, -1.592811919504019e-25,  6.027182035687237e-29,  1.772621132230303e-01, -1.211565504174047e-03,  5.689023664112068e-06,
 -2.050739104338915e-08,  5.138803286368766e-11, -2.576044623920927e-14, -6.300387748646378e-16,  4.459658554143840e-18, -1.812563412371409e-20,  3.901049945084825e-23,
  7.984810503745365e-26, -1.305682181295828e-27,  2.345936313665047e-01, -1.563063404080721e-03,  6.910919556935194e-06, -2.169429796657101e-08,  3.391360305347502e-11,
  1.211770947778270e-13, -1.270258264912323e-15,  5.638438123335065e-18, -1.168703489962279e-20, -3.481435722310364e-23,  4.587821879608522e-25, -2.280656985996524e-27,
  2.992277710941670e-01, -1.934873008138806e-03,  7.945696230803708e-06, -2.049085001669677e-08,  3.295803962465075e-12,  2.950456458965101e-13, -1.705781435648317e-15,
  4.374911195347777e-18,  7.540137094856502e-21, -1.344608621199839e-22,  6.592118108216944e-25, -1.143972047488877e-27,  3.707837529059895e-01, -2.315589979989614e-03,
  8.685323220641001e-06, -1.654176157877708e-08, -3.775680968221275e-11,  4.524648866180653e-13, -1.667206153206421e-15,  1.354811477149685e-19,  3.343768243352875e-20,
 -1.890274729751739e-22,  3.266438058074891e-25,  2.440188192881309e-27,  4.488172775021890e-01, -2.692825848998088e-03,  9.031462011036938e-06, -9.796907758200676e-09,
 -8.368872379910054e-11,  5.416829467199557e-13, -9.810791827509861e-16, -6.217804316941754e-18,  5.196466412937112e-20, -1.238770323131423e-22, -5.690611498500448e-25,
  5.921011931611552e-27,  5.328151685208894e-01, -3.053442166231751e-03,  8.903484884228456e-06, -5.714258856656820e-10, -1.265877941707740e-10,  5.157948691484354e-13,
  3.233907825580268e-16, -1.230496105636927e-17,  4.705769561038944e-20,  7.627875428968413e-23, -1.489148489976702e-24,  4.990390357344699e-27,  6.221897027111108e-01,
 -3.383854167734673e-03,  8.246846939996437e-06,  1.042752596696728e-08, -1.572859382657105e-10,  3.485594081395598e-13,  1.953533762526284e-15, -1.489356800749401e-17,
  1.087865143353097e-20,  3.208486839411128e-22, -1.534625037637173e-24, -2.223217278093342e-27,  7.162728296536218e-01, -3.670415830699735e-03,  7.041289135623310e-06,
  2.212062893699057e-08, -1.670302926533410e-10,  4.884073831427119e-14,  3.382581681361403e-15, -1.133382053290913e-17, -4.673267998492513e-20,  4.345380415414440e-22,
 -1.738859915754944e-25, -1.114522225965340e-26,  8.143105686020451e-01, -3.899896577835734e-03,  5.308121306314088e-06,  3.313464112316650e-08, -1.495401075237922e-10,
 -3.315377317949204e-13,  3.993688847406590e-15, -1.286732437641317e-18, -9.700224611273322e-20,  2.663830701077154e-22,  1.979572083898766e-24, -1.233455767102513e-26,
  9.154579770706555e-01, -4.060055980982889e-03,  3.115582716444719e-06,  4.194608560575000e-08, -1.030902095435348e-10, -7.017841898879515e-13,  3.320924977789032e-15,
  1.215970745325568e-17, -1.044577487587951e-19, -1.641831714711959e-22,  3.184892372201681e-24, -4.596181320737024e-28,  1.018775214233957e+00, -4.140315717568336e-03,
  5.810422629154886e-07,  4.708849482964953e-08, -3.209324733105258e-11, -9.512640270570049e-13,  1.312281310475290e-15,  2.298471749094712e-17, -5.015774302005660e-20,
 -6.036146915476171e-22,  1.867988736457050e-24,  1.651698751539652e-26,  1.123225368075772e+00, -4.132516780961841e-03, -2.131352259594523e-06,  4.740745101301026e-08,
  5.244636690788129e-11, -9.825699299926878e-13, -1.510321820464073e-15,  2.479222771631389e-17,  4.731659679873317e-20, -6.930404955377346e-22, -1.562620622416028e-24,
  2.062496491110536e-26,  1.227674868628446e+00, -4.031733766076335e-03, -4.818937195070357e-06,  4.232951636767278e-08,  1.341760007602136e-10, -7.507675715541286e-13,
 -4.125882383652854e-15,  1.466065330895475e-17,  1.320898858495939e-19, -2.629588180249999e-22, -4.290944588128495e-24,  2.777483150042105e-27,  1.330897452136619e+00,
 -3.837096764760939e-03, -7.255731974257943e-06,  3.209154852765851e-08,  1.946004600395518e-10, -2.943516939337617e-13, -5.384042563027109e-15, -3.877552606800002e-18,
  1.427287540642031e-19,  4.328311122973136e-22, -3.368572170900588e-24, -2.125739826563951e-26,  1.431582743171994e+00, -3.552546014615672e-03, -9.214820497706810e-06,
  1.786172083836050e-08,  2.179222879229007e-10,  2.596359725272333e-13, -4.573936325259920e-15, -2.135183644151576e-17,  6.106615347432127e-20,  8.318675134731694e-22,
  8.693958951409267e-25, -2.340147722041538e-26,  1.528350542086933e+00, -3.187417855363178e-03, -1.049686002696681e-05,  1.681745015035561e-09,  1.963904184059324e-10,
  7.289002729017314e-13, -1.915540204638286e-15, -2.742819972541501e-17, -6.116278039017625e-20,  5.528047029325946e-22,  4.279847781411517e-24,  1.255826441745947e-27,
  1.619771791822215e+00, -2.756738213092991e-03, -1.096187694662168e-05, -1.381854660446320e-08,  1.342932571852530e-10,  9.447826491719997e-13,  1.380191282008354e-15,
 -1.814234768862921e-17, -1.331422205118412e-19, -1.666062775017550e-22,  3.184177290411647e-24,  2.247287994571712e-26,  1.704396895581588e+00, -2.281089928122977e-03,
 -1.055949814203045e-05, -2.593123758638970e-08,  4.850191248872699e-11,  8.317859717717522e-13,  3.674087022956726e-15,  1.577927854547099e-19, -1.013615777080893e-19,
 -6.350759146887964e-22, -9.459790796349925e-25,  1.369182588045125e-26,  1.780791520337484e+00, -1.785932775341264e-03, -9.351075439688522e-06, -3.252358525810497e-08,
 -3.579174917977027e-11,  4.557257696180646e-13,  3.869155881198772e-15,  1.467653381856313e-17, -3.053085652899375e-21, -4.390055926527673e-22, -3.062570231022542e-24,
 -8.939282473265046e-27,  1.847579237712728e+00, -1.300299336240403e-03, -7.516581846888742e-06, -3.266885623128560e-08, -9.364734254954095e-11,  2.710458727019224e-15,
  2.160546526520328e-15,  1.619979761860291e-17,  6.791596953374783e-20,  8.697961201206842e-23, -1.240297907098292e-24, -1.250586423665073e-26,  1.903489370406175e+00,
 -8.548703889983809e-04, -5.340520912510431e-06, -2.703681052155626e-08, -1.103471252590892e-10, -3.149254791650428e-13, -7.925537588326193e-17,  6.781543247334104e-18,
  5.810268294212262e-20,  3.121317549091013e-22,  1.094095755454342e-24,  7.684331615041715e-28,  1.947407373963384e+00, -4.795444781909332e-04, -3.174850746841447e-06,
 -1.784832860762665e-08, -8.816625338683594e-11, -3.791674944203910e-13, -1.335625300327955e-15, -2.974584386781382e-18,  5.413152793845456e-21,  1.203890740796038e-22,
  9.402228392085347e-25,  5.379806714971527e-27,  1.978424407904958e+00, -2.007367710029870e-04, -1.382678667067181e-06, -8.318126337442087e-09, -4.584894013786882e-11,
 -2.354889022217027e-13, -1.130578526940610e-15, -5.036413316574999e-18, -2.036510441036560e-20, -7.067109864641674e-23, -1.737339738219269e-25,  7.642337873760940e-29,
  1.995886351090360e+00, -3.870612831797009e-05, -2.724906663508895e-07, -1.699746446519840e-09, -9.900328911274404e-12, -5.509091504423309e-14, -2.963296293905562e-16,
 -1.550889823328981e-18, -7.927261434561250e-21, -3.965301334133997e-23, -1.942610567853964e-25, -9.318649982341417e-28,  1.036423880838543e-03, -7.507469744079581e-06,
  4.076700311453572e-08, -1.966669472530298e-10,  8.887736486176282e-13, -3.852554387051448e-15,  1.621809739579538e-17, -6.680200824728813e-20,  2.704711948795205e-22,
 -1.079976753622341e-24,  4.261505436454356e-27, -1.664624805751137e-29,  9.321257439764719e-03, -6.730856569006445e-05,  3.630857151250878e-07, -1.731763185998529e-09,
  7.690492813252094e-12, -3.251089713864917e-14,  1.322450368018951e-16, -5.204621597617608e-19,  1.986002978659158e-21, -7.348109410551662e-24,  2.629738672427481e-26,
 -9.060079375460252e-29,  2.585581587221511e-02, -1.855316300924914e-04,  9.874954119697251e-07, -4.601291930584838e-09,  1.969810233502068e-11, -7.886022541051213e-14,
  2.965091569286558e-16, -1.041955074055094e-18,  3.365162368060772e-21, -9.592689612029332e-24,  2.141033901015770e-26, -1.699172942469189e-29,  5.056923042597431e-02,
 -3.594205795960386e-04,  1.874175719311230e-06, -8.419606370828887e-09,  3.395278588286107e-11, -1.235813911489799e-13,  3.978158209826379e-16, -1.057787759134621e-18,
  1.749802011771808e-21,  3.119914566062771e-24, -4.863033027011201e-26,  3.022065947152911e-28,  8.335356338021836e-02, -5.848478105621990e-04,  2.965006065371102e-06,
 -1.264714143435891e-08,  4.657986739636795e-11, -1.438243426529690e-13,  3.241343800077154e-16, -1.288267308161983e-19, -3.987017516121000e-21,  2.978796172445529e-23,
 -1.458703917415673e-25,  5.465626902589231e-28,  1.240618300954395e-01, -8.563251384896875e-04,  4.185558283294899e-06, -1.663618119472873e-08,  5.341225413611907e-11,
 -1.194347686558546e-13,  1.186663976088315e-17,  1.733191763512891e-18, -1.182694432474745e-20,  5.178916372614606e-23, -1.542655536859195e-25,  1.606624687309810e-28,
  1.725053366981489e-01, -1.167023736373810e-03,  5.447848672770693e-06, -1.969008446594911e-08,  5.073139598488153e-11, -3.944715684013451e-14, -5.130737206043020e-16,
  3.902618450100096e-18, -1.667669040172414e-20,  4.115565552171676e-23,  2.978003708939060e-26, -9.801629598447785e-28,  2.284503169488748e-01, -1.508807975736689e-03,
  6.653918443347957e-06, -2.113389549533486e-08,  3.604484806731114e-11,  9.254211509919340e-14, -1.117782067124110e-15,  5.247750091906313e-18, -1.263350487191979e-20,
 -1.839197729556432e-23,  3.643085027200182e-25, -2.010332091673979e-27,  2.916138547356138e-01, -1.872289668407924e-03,  7.700310067548845e-06, -2.039309210477428e-08,
  8.797374219020509e-12,  2.555998334326548e-13, -1.580597959086725e-15,  4.543730966996474e-18,  3.161176857155441e-21, -1.091923587932732e-22,  6.022040869425183e-25,
 -1.420472461588661e-27,  3.616590873740316e-01, -2.246910994995482e-03,  8.483489021099426e-06, -1.707564680315654e-08, -2.910673561020250e-11,  4.126121784814749e-13,
 -1.649436509179501e-15,  1.099321022562921e-18,  2.689105320847758e-20, -1.741083463324828e-22,  4.123541801244775e-25,  1.484933800867576e-27,  4.381897018716341e-01,
 -2.621066353049019e-03,  8.906218213402645e-06, -1.105059326186480e-08, -7.310367275126615e-11,  5.162315029403278e-13, -1.132596399671805e-15, -4.630186785764930e-18,
  4.715586467802570e-20, -1.416818413525816e-22, -3.276158892865397e-25,  5.038733345883346e-27,  5.207437646124398e-01, -2.982275361301529e-03,  8.884816823332276e-06,
 -2.513995765052551e-09, -1.162213019322712e-10,  5.195940788032157e-13,  2.671205322566360e-19, -1.076623406816068e-17,  4.878608068647194e-20,  2.127551165597088e-23,
 -1.257610377731137e-24,  5.459046146148138e-27,  6.087869684038921e-01, -3.317421107083450e-03,  8.357115717044552e-06,  7.969126921489220e-09, -1.498794335778507e-10,
  3.904895619571918e-13,  1.543038555021191e-15, -1.437264005238268e-17,  2.130689084212146e-20,  2.581818076688651e-22, -1.582730761866602e-24, -2.935541562571478e-29,
  7.017054441184684e-01, -3.613069057317609e-03,  7.290747995953425e-06,  1.946025890542540e-08, -1.652681756405376e-10,  1.260599329929461e-13,  3.046635237412881e-15,
 -1.258123761773965e-17, -3.132712989313659e-20,  4.183907099197998e-22, -6.176319908871726e-25, -8.973048226270281e-27,  7.987983724190421e-01, -3.855882289709412e-03,
  5.691179155504781e-06,  3.069414269431748e-08, -1.552170684177439e-10, -2.364629209721357e-13,  3.915747712593490e-15, -4.223165389001781e-18, -8.612068081863848e-20,
  3.344273005987003e-22,  1.417456989758322e-24, -1.304756670370633e-26,  8.992707494157857e-01, -4.033146985709444e-03,  3.608590233423456e-06,  4.018879617232515e-08,
 -1.163032652178495e-10, -6.183786326818108e-13,  3.613885842298575e-15,  8.746960512598524e-18, -1.080918078774954e-19, -3.847081355259328e-23,  3.070080568284246e-24,
 -4.662175518483934e-27,  1.002226812550670e+00, -4.133417294807917e-03,  1.142401547418817e-06,  4.642472714249435e-08, -5.075247158230478e-11, -9.122473099108822e-13,
  1.930226715990616e-15,  2.104776859351133e-17, -7.037720843557433e-20, -5.154107797533664e-22,  2.514421228582732e-24,  1.270833174191526e-26,  1.106664820437707e+00,
 -4.147279281096670e-03, -1.558082220315020e-06,  4.808765103620380e-08,  3.248950484239988e-11, -1.010339808239159e-12, -7.987678694084290e-16,  2.589691927457645e-17,
  2.146672838745634e-20, -7.367634415238767e-22, -6.109167941870619e-25,  2.235357342803350e-26,  1.211474097588164e+00, -4.068218126372829e-03, -4.298614635138296e-06,
  4.435097745683168e-08,  1.182061150084917e-10, -8.443950555209227e-13, -3.657865163904372e-15,  1.870329644724347e-17,  1.195813122270220e-19, -4.301787067997347e-22,
 -4.021287284496692e-24,  9.462255643908963e-27,  1.315435486402734e+00, -3.893549788073671e-03, -6.852168840203146e-06,  3.515101137172635e-08,  1.874151865390144e-10,
 -4.243420422886156e-13, -5.426524801201332e-15,  9.112998012619988e-19,  1.556686453811673e-19,  2.803725487444523e-22, -4.226149920888561e-24, -1.738672042137350e-26,
  1.417226563628798e+00, -3.625347586230281e-03, -8.979407813634203e-06,  2.138385584732534e-08,  2.219700960262262e-10,  1.429359586005518e-13, -5.139892284974337e-15,
 -1.891395308235592e-17,  9.137807478377988e-20,  8.446264282253525e-22, -2.643313519233163e-25, -2.790495108238759e-26,  1.515433125570266e+00, -3.271257503236100e-03,
 -1.045735334618467e-05,  4.937853040399997e-09,  2.104454263840111e-10,  6.735098385614909e-13, -2.707703329363066e-15, -2.903396218120278e-17, -3.818500403381211e-20,
  7.231057614438753e-22,  4.183122509412481e-24, -5.889464438464466e-27,  1.608568452204753e+00, -2.845058544267295e-03, -1.111417845961567e-05, -1.151707093501482e-08,
  1.534765009082570e-10,  9.713253538426875e-13,  8.118426792445667e-16, -2.247233620679102e-17, -1.366074867869289e-19, -1.930689577705551e-23,  4.181410761297039e-24,
  2.254866182824447e-26,  1.695101633455586e+00, -2.366796124721900e-03, -1.086545232374792e-05, -2.501733558646221e-08,  6.601778594234499e-11,  9.196292000297255e-13,
  3.629613463525932e-15, -3.457603619282925e-18, -1.247445904033350e-19, -6.591388964406057e-22, -2.131909834627669e-25,  1.972454958664914e-26,  1.773495687447983e+00,
 -1.862311520132091e-03, -9.744476967521962e-06, -3.301815241605581e-08, -2.571547215992825e-11,  5.534903192656388e-13,  4.276182267529257e-15,  1.430158444487603e-17,
 -2.115260687354336e-20, -5.688586502779733e-22, -3.414770358331877e-24, -6.830494076048142e-27,  1.842255256294007e+00, -1.362025544984010e-03, -7.917586919398648e-06,
 -3.416380401212229e-08, -9.303658091187510e-11,  6.025481479759702e-14,  2.644963176251879e-15,  1.841250208451925e-17,  7.001315280314314e-20,  2.542941810160907e-23,
 -1.860845378037532e-24, -1.574810325638509e-26,  1.899982342713139e+00, -8.989228166434032e-04, -5.675763962587895e-06, -2.885278747521520e-08, -1.166481446064345e-10,
 -3.143282243959167e-13,  1.384075862329183e-16,  8.829106941883403e-18,  7.013183045388137e-20,  3.561788157793320e-22,  1.097318979662913e-24, -7.368243526764635e-28,
  1.945437007335580e+00, -5.058245729487352e-04, -3.397750619095591e-06, -1.932142502827325e-08, -9.607678056690395e-11, -4.121981120404676e-13, -1.415782490556139e-15,
 -2.724276851091146e-18,  1.048437978511635e-20,  1.630877373670506e-22,  1.203852437954454e-24,  6.634976133361453e-27,  1.977598687694396e+00, -2.122103090803599e-04,
 -1.487058013872057e-06, -9.090911180504438e-09, -5.084187034676592e-11, -2.643910604705209e-13, -1.281113640747753e-15, -5.730133328815998e-18, -2.303284247620125e-20,
 -7.747459627592961e-23, -1.642641089702846e-25,  3.760767050170054e-28,  1.995727033630313e+00, -4.097042069182571e-05, -2.938757086060707e-07, -1.867367966965866e-09,
 -1.107693768512846e-11, -6.275396479941439e-14, -3.435317351701299e-16, -1.828986076703555e-18, -9.505110514048726e-21, -4.830918876334088e-23, -2.402726120646607e-25,
 -1.168918567022344e-27,  1.007031660961941e-03, -7.190537707769394e-06,  3.848984614083744e-08, -1.830424479862132e-10,  8.154683035896149e-13, -3.484822283114342e-15,
  1.446319394129938e-17, -5.873747779720838e-20,  2.344917591388685e-22, -9.232991119600019e-25,  3.592790546272950e-27, -1.384155158180243e-29,  9.057703823823666e-03,
 -6.448496110821520e-05,  3.430219323801732e-07, -1.613749425659574e-09,  7.070869374152541e-12, -2.950494751206029e-14,  1.185234611479667e-16, -4.609471122891085e-19,
  1.739481488415078e-21, -6.371903072011464e-24,  2.260903048936092e-26, -7.740095333944694e-29,  2.512914698939068e-02, -1.778472883294554e-04,  9.341201047476512e-07,
 -4.298362985866630e-09,  1.818975842585087e-11, -7.208224734277767e-14,  2.687912611793370e-16, -9.396315903095010e-19,  3.035038562862444e-21, -8.753619639871744e-24,
  2.049047178055577e-26, -2.424357783018466e-29,  4.916090782341271e-02, -3.448222643125361e-04,  1.776319999723410e-06, -7.895626022558469e-09,  3.157426788810244e-11,
 -1.143828098676211e-13,  3.689960282726909e-16, -1.000347608488769e-18,  1.830133201147079e-21,  1.421445757802382e-24, -3.674473951015172e-26,  2.401604845862892e-28,
  8.106066865416212e-02, -5.617223709781813e-04,  2.817618476557790e-06, -1.192445425311638e-08,  4.378081016790849e-11, -1.361018686222679e-13,  3.188944978542455e-16,
 -2.403337319352381e-19, -3.014068113913516e-21,  2.441371305772951e-23, -1.233403277423868e-25,  4.781775681136330e-28,  1.207022543954238e-01, -8.236248621489964e-04,
  3.990972951811496e-06, -1.580066346521859e-08,  5.103012376998660e-11, -1.186087025967433e-13,  5.536941679633558e-17,  1.383384300124442e-18, -1.007170711768966e-20,
  4.578084753952737e-23, -1.456919192973966e-25,  2.237429538607508e-28,  1.679229302815467e-01, -1.124372336232633e-03,  5.216409769788545e-06, -1.888532663781114e-08,
  4.982786047263477e-11, -5.050857402184557e-14, -4.110476515636843e-16,  3.392820589784172e-18, -1.518327837253771e-20,  4.156703517961130e-23, -7.264490989562656e-27,
 -7.128015086565434e-28,  2.225199555800094e-01, -1.456581119536175e-03,  6.403828493613712e-06, -2.054377964584309e-08,  3.763908623198213e-11,  6.743239133355498e-14,
 -9.765853385054729e-16,  4.835528520962272e-18, -1.305388288067764e-20, -5.506483113391478e-24,  2.820031449849061e-25, -1.730927797178157e-27,  2.842463550218712e-01,
 -1.811663288066421e-03,  7.456599648249193e-06, -2.021345582659552e-08,  1.354037681765455e-11,  2.192001377881574e-13, -1.452515811935399e-15,  4.586517517985419e-18,
 -3.516804010586044e-22, -8.640251249095170e-23,  5.363232111591283e-25, -1.553540560712390e-27,  3.528058711015873e-01, -2.179870017650029e-03,  8.276052402308274e-06,
 -1.747747534763973e-08, -2.124738515523815e-11,  3.734866373368797e-13, -1.607527239528851e-15,  1.862844780980297e-18,  2.093357103102031e-20, -1.565490563274419e-22,
  4.599508470440881e-25,  7.077852241848251e-28,  4.278470690561428e-01, -2.550366145147422e-03,  8.766928957192105e-06, -1.213917296388719e-08, -6.306050613805680e-11,
  4.876591693020005e-13, -1.241898184895898e-15, -3.204919722790343e-18,  4.187038015772509e-20, -1.506256718323182e-22, -1.263687454116470e-25,  4.107147344138002e-27,
  5.089565855844131e-01, -2.911348321416399e-03,  8.843834289988563e-06, -4.290500510008148e-09, -1.058528605751876e-10,  5.161598178111710e-13, -2.792826075759380e-16,
 -9.202060553070415e-18,  4.870485674372683e-20, -2.418092606921110e-23, -1.014789477958738e-24,  5.518519162430114e-27,  5.956515467251619e-01, -3.250221824517348e-03,
  8.438620685091797e-06,  5.635411100740549e-09, -1.417314771953858e-10,  4.227784778148327e-13,  1.151460438712084e-15, -1.355429437202077e-17,  2.946664178326880e-20,
  1.953986786905690e-22, -1.543577471211880e-24,  1.734263822769704e-27,  6.873712356582341e-01, -3.553853717046406e-03,  7.508501094716147e-06,  1.683998886181966e-08,
 -1.620448458338995e-10,  1.948523324641034e-13,  2.682552095348691e-15, -1.334821190363930e-17, -1.679863149018398e-20,  3.864803635692644e-22, -9.605870122163924e-25,
 -6.601355439628282e-27,  7.834681748458303e-01, -3.808922083129934e-03,  6.044468380837069e-06,  2.817789600618026e-08, -1.590176864069636e-10, -1.442038840334231e-13,
  3.760798444547747e-15, -6.776578005247865e-18, -7.319912964397920e-20,  3.796518235516322e-22,  8.455984895091504e-25, -1.279903710059393e-26,  8.831989074045445e-01,
 -4.002381745047781e-03,  4.079298019765426e-06,  3.823379208563607e-08, -1.277856895625333e-10, -5.290976972019026e-13,  3.810333729873362e-15,  5.289097204493479e-18,
 -1.073257166778060e-19,  7.914518524443273e-23,  2.785372856950174e-24, -8.138941450756733e-27,  9.857149287801562e-01, -4.122064869485563e-03,  1.694032641917841e-06,
  4.546944062698055e-08, -6.848781238148027e-11, -8.591207274226567e-13,  2.485390195110275e-15,  1.851924932240207e-17, -8.699862777931546e-20, -4.049521710686109e-22,
  2.975270933909532e-24,  8.151877208311456e-27,  1.090054439103496e+00, -4.157428435719236e-03, -9.785809373796891e-07,  4.844503477113541e-08,  1.215003531349210e-11,
 -1.020755877018705e-12, -6.804682995105969e-17,  2.615669617921997e-17, -5.258239110233140e-21, -7.414070517939533e-22,  3.785571414615047e-25,  2.232931973358548e-26,
  1.195135861583855e+00, -4.100447358027725e-03, -3.755627365358660e-06,  4.610258787279535e-08,  1.004849153772714e-10, -9.254825029146844e-13, -3.083144614964845e-15,
  2.225199978099375e-17,  1.013172189149807e-19, -5.808094470137487e-22, -3.464629412734954e-24,  1.571575856281378e-26,  1.299754395085101e+00, -3.946629604207556e-03,
 -6.412667784902656e-06,  3.807470235170125e-08,  1.776309909181759e-10, -5.537014184794763e-13, -5.329992303747765e-15,  6.020160612717818e-18,  1.625489837662361e-19,
  9.760346824070811e-23, -4.869997966846523e-24, -1.158413436435942e-26,  1.402583213398951e+00, -3.696095874943632e-03, -8.701420264316429e-06,  2.495137096005582e-08,
  2.235541706411721e-10,  1.358184073259203e-14, -5.624003235742491e-15, -1.550785274214524e-17,  1.212893403677424e-19,  8.085289182437458e-22, -1.560932015496088e-24,
 -3.069423055528918e-26,  1.502181235310790e+00, -3.354621072489615e-03, -1.037746403012899e-05,  8.408932023350737e-09,  2.231993179562072e-10,  5.986566632041268e-13,
 -3.533621094123102e-15, -2.980772808762799e-17, -9.225420256146759e-21,  8.828586948249606e-22,  3.743589821892095e-24, -1.424583101413059e-26,  1.597009576763777e+00,
 -2.934481563546606e-03, -1.123700566873024e-05, -8.905199041307183e-09,  1.730443316804533e-10,  9.827654600431137e-13,  1.215538995916641e-16, -2.682069820549467e-17,
 -1.340564693025174e-19,  1.673578827316677e-22,  5.136831823044066e-24,  2.048161522054945e-26,  1.685458727634276e+00, -2.454901190193145e-03, -1.115870046666421e-05,
 -2.380921863621803e-08,  8.527121098802424e-11,  1.005105151570104e-12,  3.473346377294419e-15, -7.828930108781582e-18, -1.484007637498635e-19, -6.484197532275006e-22,
  7.963376596373039e-25,  2.619439860678240e-26,  1.765888011637295e+00, -1.941858323594073e-03, -1.014277974748497e-05, -3.333533085457122e-08, -1.358742511111570e-11,
  6.608276596687528e-13,  4.663880518250550e-15,  1.327014434809632e-17, -4.415394823240512e-20, -7.104866056856104e-22, -3.639270738821140e-24, -3.068129738718652e-27,
  1.836677840698270e+00, -1.427031293997574e-03, -8.336432648885860e-06, -3.563911965705018e-08, -9.115362388543334e-11,  1.301739969015927e-13,  3.191906186151748e-15,
  2.065178939016011e-17,  6.941269470953313e-20, -6.386531851533053e-23, -2.628853392889995e-24, -1.917057861760395e-26,  1.896293600990523e+00, -9.457460666081958e-04,
 -6.033402265184107e-06, -3.076918105104562e-08, -1.228801048625962e-10, -3.077741171106497e-13,  4.190291363234724e-16,  1.128685682895554e-17,  8.373103904583682e-20,
  3.988081378338260e-22,  1.017295304430458e-24, -3.054692573248672e-27,  1.943357838870786e+00, -5.339607778485490e-04, -3.639109190452007e-06, -2.092647657582909e-08,
 -1.046664890554763e-10, -4.470485655082305e-13, -1.486412922586191e-15, -2.284949023000192e-18,  1.729639110487341e-20,  2.174919209937066e-22,  1.526857384793872e-24,
  8.076246493312881e-27,  1.976725342553475e+00, -2.245573789217724e-04, -1.601209829847597e-06, -9.948410330651508e-09, -5.645059630827486e-11, -2.971490209290142e-13,
 -1.452304199206729e-15, -6.513038357838358e-18, -2.593512286254720e-20, -8.359223802447700e-23, -1.382668632462261e-25,  8.372718030106813e-28,  1.995558303633165e+00,
 -4.341417133559660e-05, -3.173904280326781e-07, -2.055105621241547e-09, -1.241879743842441e-11, -7.164931209956677e-14, -3.992769154031940e-16, -2.162936113789081e-18,
 -1.143038421542031e-20, -5.903225477799678e-23, -2.980749180655583e-25, -1.470477854646269e-27,  9.788717427503528e-04, -6.891188345880695e-06,  3.636938133997668e-08,
 -1.705342109986890e-10,  7.491140632451697e-13, -3.156623248538086e-15,  1.291879103694976e-17, -5.173897351446562e-20,  2.036995564347258e-22, -7.910572573661793e-25,
  3.036066080509160e-27, -1.153837547367591e-29,  8.805132342677317e-03, -6.181636620986101e-05,  3.243167583863766e-07, -1.505186030388974e-09,  6.508202256740382e-12,
 -2.680917858495705e-14,  1.063629518179613e-16, -4.087858320463135e-19,  1.525582283279800e-21, -5.532214429721475e-24,  1.945723639859465e-26, -6.616047796679829e-29,
  2.443238392539164e-02, -1.705758086319420e-04,  8.842395028427617e-07, -4.018518258342491e-09,  1.681054780083189e-11, -6.593628416759821e-14,  2.437950146014534e-16,
 -8.473964311194647e-19,  2.734390872474289e-21, -7.956774067214450e-24,  1.932087443250778e-26, -2.850398311701433e-29,  4.780945171775700e-02, -3.309822769454977e-04,
  1.684529657421376e-06, -7.408267218844966e-09,  2.937293631599575e-11, -1.058563665886074e-13,  3.418119803740296e-16, -9.412285422696989e-19,  1.857252287015913e-21,
  1.474019082659630e-25, -2.732394280585296e-26,  1.898092921332954e-28,  7.885797134982253e-02, -5.397420927747894e-04,  2.678639496372031e-06, -1.124532422497061e-08,
  4.113470939652029e-11, -1.285392726254994e-13,  3.109404218949803e-16, -3.236337988159359e-19, -2.219083784924576e-21,  1.988176041500985e-23, -1.037214621881598e-25,
  4.144642569118065e-28,  1.174704290221767e-01, -7.924418099405180e-04,  3.806185868696550e-06, -1.500307414188950e-08,  4.867419399098285e-11, -1.168499556286106e-13,
  8.983191478950871e-17,  1.086354715579508e-18, -8.526008636626457e-21,  4.016218709228015e-23, -1.349849289343562e-25,  2.590358305732795e-28,  1.635074872365917e-01,
 -1.083534080673911e-03,  4.994534338730859e-06, -1.809666691866512e-08,  4.872645458327582e-11, -5.928725343815570e-14, -3.226265579975223e-16,  2.930784940840241e-18,
 -1.369903832866456e-20,  4.071611250675443e-23, -3.371428629725002e-26, -4.974943412010757e-28,  2.167945456089055e-01, -1.406326260730115e-03,  6.160956994157470e-06,
 -1.993199336741153e-08,  3.876407609970896e-11,  4.557176902070757e-14, -8.470537979949014e-16,  4.416665489591032e-18, -1.306669022987280e-20,  4.331359376323566e-24,
  2.118678915167650e-25, -1.459394133721274e-27,  2.771174768648793e-01, -1.752976732682553e-03,  7.215476710340664e-06, -1.996358825069837e-08,  1.758615976023666e-11,
  1.858768271178165e-13, -1.324689744835576e-15,  4.529501626127842e-18, -3.092633307860042e-21, -6.633087245418455e-23,  4.670772212904106e-25, -1.578963375618734e-27,
  3.442174721537271e-01, -2.114505742362945e-03,  8.064522711738952e-06, -1.775975283296629e-08, -1.415886443871775e-11,  3.356025160215904e-13, -1.546810978223674e-15,
  2.446146917132915e-18,  1.563472198056378e-20, -1.377183175206563e-22,  4.771811833524667e-25,  1.027398862978037e-28,  4.177849295103322e-01, -2.480829815669883e-03,
  8.615521605360276e-06, -1.307176288159881e-08, -5.361188596208324e-11,  4.569231262919559e-13, -1.313698181212441e-15, -1.952466345057547e-18,  3.639794450912600e-20,
 -1.523377248849652e-22,  3.412392361232486e-26,  3.195946419744958e-27,  4.974523279527389e-01, -2.840831601324308e-03,  8.782525663278984e-06, -5.902009340913028e-09,
 -9.561665651736023e-11,  5.065401869106216e-13, -5.153045114110407e-16, -7.664795502922167e-18,  4.716174484231043e-20, -5.997164257385244e-23, -7.766128268947504e-25,
  5.263750923152485e-27,  5.827860520831752e-01, -3.182480258519684e-03,  8.492922946267864e-06,  3.436726485665789e-09, -1.330297215574356e-10,  4.459719146877464e-13,
  7.861147822219373e-16, -1.251055373471641e-17,  3.541186784849427e-20,  1.355990662381621e-22, -1.436902357226021e-24,  3.038965609594279e-27,  6.732771748398351e-01,
 -3.493021146754015e-03,  7.695164240006774e-06,  1.428181774370610e-08, -1.575345208137698e-10,  2.547004171653552e-13,  2.303312052677115e-15, -1.367109716955379e-17,
 -3.640559455504845e-21,  3.429497699300607e-22, -1.198724531696112e-24, -4.239970780820429e-27,  7.683312782154467e-01, -3.759257237553124e-03,  6.367257958686595e-06,
  2.561537537213860e-08, -1.610158553321958e-10, -5.647350451538954e-14,  3.540355956870023e-15, -8.894829867619879e-18, -5.905630883870014e-20,  4.024695741852269e-22,
  3.029425726693350e-25, -1.175155019273066e-26,  8.672575048717867e-01, -3.967947668302694e-03,  4.525503109825051e-06,  3.610957750741045e-08, -1.374431595288984e-10,
 -4.362572576335103e-13,  3.910923864028647e-15,  1.921013984664238e-18, -1.025649308554284e-19,  1.825766337321659e-22,  2.367658344491469e-24, -1.068317920030838e-26,
  9.692572015085377e-01, -4.106349987840640e-03,  2.232535045799132e-06,  4.423958774045451e-08, -8.503341157528267e-11, -7.935761153316836e-13,  2.962929594717402e-15,
  1.552562644882811e-17, -9.936121454660287e-20, -2.801916268847060e-22,  3.227302575449579e-24,  3.291194000061238e-27,  1.073412752509061e+00, -4.162929967631293e-03,
 -3.967474241666186e-07,  4.847627401799074e-08, -8.222292466406491e-12, -1.013643875282967e-12,  6.580043417118904e-16,  2.556620494720915e-17, -3.144293843173915e-20,
 -7.070108492805433e-22,  1.328438000402485e-24,  2.057315339401709e-26,  1.178677522610527e+00, -4.128253552611922e-03, -3.193373006535971e-06,  4.755846707158274e-08,
  8.128758620896831e-11, -9.916551796615431e-13, -2.418024218050761e-15,  2.513430920074085e-17,  7.809515781190156e-20, -7.039393934200788e-22, -2.653983127998230e-24,
  2.090868566470230e-26,  1.283868234705290e+00, -3.996055931598626e-03, -5.939106556261129e-06,  4.082132358438850e-08,  1.652944646443236e-10, -6.790088026057387e-13,
 -5.088350854148148e-15,  1.123947630788630e-17,  1.624521456401191e-19, -1.053200360638938e-22, -5.222522229385895e-24, -4.227059055004705e-27,  1.387661589290287e+00,
 -3.764448792219557e-03, -8.380557787842208e-06,  2.852293768013568e-08,  2.224432538720132e-10, -1.261398949751927e-13, -5.999611060129797e-15, -1.117559604360515e-17,
  1.489437703014285e-19,  7.187584301399272e-22, -2.930993984654109e-24, -3.115414949701504e-26,  1.488597437544000e+00, -3.437175567167684e-03, -1.025475029990540e-05,
  1.207101435109816e-08,  2.342567341034197e-10,  5.038313686245822e-13, -4.367394258261307e-15, -2.956689660820076e-17,  2.507803046614430e-20,  1.017449089584045e-21,
  2.920670145428122e-24, -2.319203736223048e-26,  1.585091250041958e+00, -3.024756496861692e-03, -1.132660738120729e-05, -5.979352723200283e-09,  1.926655081506515e-10,
  9.761932780896553e-13, -6.882845895855462e-16, -3.097275473695319e-17, -1.241262609158496e-19,  3.896754905138702e-22,  5.944823960862478e-24,  1.577744469597095e-26,
  1.675458808960365e+00, -2.545288885875777e-03, -1.143554724071334e-05, -2.227961765186969e-08,  1.061862972811399e-10,  1.085277035637342e-12,  3.184200993130293e-15,
 -1.294272817062379e-17, -1.708754279103008e-19, -5.916186119788530e-22,  2.089864439051831e-24,  3.251683478485610e-26,  1.757955756539064e+00, -2.024603308649713e-03,
 -1.054365192647619e-05, -3.344079238388139e-08,  7.776269810561597e-13,  7.770352569283408e-13,  5.011617039492189e-15,  1.141970814600401e-17, -7.237045773330813e-20,
 -8.572092247704480e-22, -3.654622100328031e-24,  2.736203793904568e-27,  1.830833589319956e+00, -1.495458000817282e-03, -8.772752887223228e-06, -3.707238646796025e-08,
 -8.773596281228554e-11,  2.139668509487277e-13,  3.800752994761603e-15,  2.281420475838977e-17,  6.500840735599356e-20, -1.868828016038429e-22, -3.546086432536135e-24,
 -2.246714636196018e-26,  1.892411696032497e+00, -9.955240925191000e-04, -6.414629981718789e-06, -3.278384710291661e-08, -1.289077995621628e-10, -2.936087232436022e-13,
  7.747851942413869e-16,  1.420350132949035e-17,  9.878005579645792e-20,  4.359017239278165e-22,  8.127390507167671e-25, -6.443101375329902e-27,  1.941162138496319e+00,
 -5.641072837426285e-04, -3.900576279489227e-06, -2.267462698420100e-08, -1.139690262044900e-10, -4.834200009816435e-13, -1.541377447474554e-15, -1.593679384465780e-18,
  2.631525259846542e-20,  2.861337401840390e-22,  1.916867724053290e-24,  9.672435861302984e-27,  1.975800715312927e+00, -2.378604001038631e-04, -1.726212437505004e-06,
 -1.090112124693839e-08, -6.275739791345783e-11, -3.342893007993704e-13, -1.646747750383954e-15, -7.392096120359191e-18, -2.903347442425389e-20, -8.820205618458632e-23,
 -8.719587906115232e-26,  1.529144997520167e-27,  1.995379407596154e+00, -4.605543013754844e-05, -3.432929332422864e-07, -2.265812288037884e-09, -1.395273793304811e-11,
 -8.200208604065140e-14, -4.652965908543256e-16, -2.565144926581582e-18, -1.378670980712953e-20, -7.235570657386771e-23, -3.708958145593724e-25, -1.855040744786271e-27,
  9.518762203371116e-04, -6.608219869275672e-06,  3.439285564104085e-08, -1.590370792351234e-10,  6.889684621807432e-13, -2.863245480833932e-15,  1.155723750677729e-17,
 -4.565375576199736e-20,  1.772904838844860e-22, -6.791835152456532e-25,  2.571423650488826e-27, -9.642078301243741e-30,  8.562943998369838e-03, -5.929235070898514e-05,
  3.068620582581408e-07, -1.405209360263484e-09,  5.996646415500731e-12, -2.438848206627734e-14,  9.557150786134508e-17, -3.630090611468017e-19,  1.339757080600716e-21,
 -4.809217246353258e-24,  1.676229218844679e-26, -5.659094337893153e-29,  2.376392944118955e-02, -1.636903072136596e-04,  8.375885865525816e-07, -3.759789282960165e-09,
  1.554846102225171e-11, -6.036030086368957e-14,  2.212509085534495e-16, -7.643323689100905e-19,  2.461548663160176e-21, -7.209777397931970e-24,  1.801360613409411e-26,
 -3.062194281373192e-29,  4.651192312685067e-02, -3.178538051237949e-04,  1.598381807101046e-06, -6.954800373299260e-09,  2.733574385611232e-11, -9.796241827380837e-14,
  3.162890148702755e-16, -8.819069382943620e-19,  1.844782238931626e-21, -7.911375639372307e-25, -1.989915279051583e-26,  1.491244640071844e-28,  7.674102210745896e-02,
 -5.188417564869170e-04,  2.547561006518900e-06, -1.060733290909926e-08,  3.863777687852898e-11, -1.211928340808117e-13,  3.009866186477074e-16, -3.839587017075171e-19,
 -1.573785120495003e-21,  1.608011568007153e-23, -8.678354615727030e-26,  3.564236619897733e-28,  1.143604389804209e-01, -7.626994079707164e-04,  3.630744987055930e-06,
 -1.424285608594086e-08,  4.636106459165135e-11, -1.143585052794142e-13,  1.166402540957339e-16,  8.356364344487574e-19, -7.174558151149060e-21,  3.499642815702078e-23,
 -1.231937613705985e-25,  2.741307076316398e-28,  1.592519067054984e-01, -1.044433285095470e-03,  4.782011657112875e-06, -1.732692328380074e-08,  4.746967586340538e-11,
 -6.609373873708016e-14, -2.464834808520686e-16,  2.515568342859958e-18, -1.226231895195378e-20,  3.898284957388465e-23, -5.171100865344099e-26, -3.274278604015184e-28,
  2.112663160143374e-01, -1.357984734331638e-03,  5.925521037311508e-06, -1.930554002594140e-08,  3.948199219022254e-11,  2.667942785186813e-14, -7.292066439055820e-16,
  4.002540864647326e-18, -1.277299677587826e-20,  1.159783744346774e-23,  1.532978614737520e-25, -1.206605560186723e-27,  2.702195074405128e-01, -1.696206116277230e-03,
  6.977719123163583e-06, -1.965415390497974e-08,  2.099597697407988e-11,  1.555929219572357e-13, -1.199583258363602e-15,  4.395801254324470e-18, -5.160905784213007e-21,
 -4.902680705876034e-23,  3.985023121555617e-25, -1.527710191099351e-27,  3.358871270256295e-01, -2.050845382885356e-03,  7.850261456640512e-06, -1.793459105586109e-08,
 -7.812227670043463e-12,  2.993530437623700e-13, -1.472033568648738e-15,  2.870816200576096e-18,  1.102020395913673e-20, -1.186833393621235e-22,  4.713046646469617e-25,
 -3.456115474520075e-28,  4.079984454539481e-01, -2.412546986567688e-03,  8.453809684702278e-06, -1.385817470353998e-08, -4.479248043658734e-11,  4.248649048013537e-13,
 -1.352882015687584e-15, -8.749554837536736e-19,  3.096992069548089e-20, -1.484144919455339e-22,  1.558996926111443e-25,  2.353666909811478e-27,  4.862290376977284e-01,
 -2.770879934971491e-03,  8.702854299988875e-06, -7.351571300631059e-09, -8.562603746965537e-11,  4.917658460530923e-13, -7.091550469276734e-16, -6.195713098858012e-18,
  4.449828956981184e-20, -8.653103246096583e-23, -5.548301597510972e-25,  4.788193880995989e-27,  5.701922288254442e-01, -3.114407412206971e-03,  8.521690153078443e-06,
  1.380514797980812e-09, -1.239493101567532e-10,  4.607672934975859e-13,  4.523401717169746e-16, -1.131008262698583e-17,  3.929373310037085e-20,  8.108143590741278e-23,
 -1.282721821918174e-24,  3.898830494068824e-27,  6.594292383397639e-01, -3.430816748960245e-03,  7.851600214528002e-06,  1.180489075344525e-08, -1.519187444834732e-10,
  3.053843222439239e-13,  1.920678510333843e-15, -1.359963522538732e-17,  7.803632500662510e-21,  2.919300506341087e-22, -1.336338195745140e-24, -2.055576607156218e-27,
  7.533980102550923e-01, -3.707133488459661e-03,  6.659162382745407e-06,  2.303461420159883e-08, -1.613168600750845e-10,  2.530627479540555e-14,  3.267032602621549e-15,
 -1.055145590814427e-17, -4.446989423128379e-20,  4.046930455999712e-22, -1.798014791810536e-25, -1.011199011189428e-26,  8.514608129656071e-01, -3.930048398156831e-03,
  4.945352120640833e-06,  3.384579733804338e-08, -1.452272147513049e-10, -3.421137956482272e-13,  3.919876099261454e-15, -1.238573484144488e-18, -9.440563159192188e-20,
  2.673594977356890e-22,  1.860425224740617e-24, -1.220193692558608e-26,  9.528708501159030e-01, -4.086390516777248e-03,  2.754736034400924e-06,  4.275608586633788e-08,
 -1.001605118094093e-10, -7.176169088159060e-13,  3.351795766960132e-15,  1.220979018919442e-17, -1.071024712012277e-19, -1.496177817708930e-22,  3.266938032292287e-24,
 -1.432774140801526e-27,  1.056758363696356e+00, -4.163780856300372e-03,  1.835129578796593e-07,  4.818363340361851e-08, -2.827995070771596e-11, -9.893983322954196e-13,
  1.356028431371769e-15,  2.416476899534582e-17, -5.572839544087435e-20, -6.366347458380627e-22,  2.166419027401322e-24,  1.729089078592117e-26,  1.162117058078295e+00,
 -4.151497146615180e-03, -2.615531834198095e-06,  4.869749457107460e-08,  6.093251897351323e-11, -1.040984343336721e-12, -1.683221937373160e-15,  2.720926953764055e-17,
  5.107524555086822e-20, -7.905094278350635e-22, -1.648277498142716e-24,  2.450563608798513e-26,  1.267792149753324e+00, -4.041565475050223e-03, -5.433851725970357e-06,
  4.335087590999588e-08,  1.505215912875594e-10, -7.967702833140012e-13, -4.701725803304533e-15,  1.633674161996561e-17,  1.548773490333517e-19, -3.155404165380527e-22,
 -5.227915841996295e-24,  4.078186477765426e-27,  1.372471958040868e+00, -3.830063891997750e-03, -8.017036844719278e-06,  3.205392746180622e-08,  2.184580848255383e-10,
 -2.733239461927434e-13, -6.242087758303261e-15, -6.020675031491236e-18,  1.723822941379321e-19,  5.745713988582499e-22, -4.261581002262384e-24, -2.884806799270860e-26,
  1.474685667583582e+00, -3.518569715612576e-03, -1.008709616459392e-05,  1.589376062917749e-08,  2.432187441778797e-10,  3.892047095564661e-13, -5.178377549505242e-15,
 -2.815795413141959e-17,  6.353935356802250e-20,  1.111261884428021e-21,  1.706727615838025e-24, -3.185817425716391e-26,  1.572810619836283e+00, -3.115602483337278e-03,
 -1.137922316956099e-05, -2.741713944820031e-09,  2.119516806145418e-10,  9.488333962611295e-13, -1.608686867480023e-15, -3.467320758838277e-17, -1.056684908125297e-19,
  6.393194606626804e-22,  6.481651348445058e-24,  8.126406237971399e-27,  1.665093034393684e+00, -2.637812126836000e-03, -1.169197939905251e-05, -2.040297494862308e-08,
  1.286234176237556e-10,  1.156712185671678e-12,  2.742182312060652e-15, -1.873247974183271e-17, -1.903087505163623e-19, -4.777322980067557e-22,  3.643487552435970e-24,
  3.785950411648066e-26,  1.749686105283326e+00, -2.110556246510080e-03, -1.094433248565380e-05, -3.329738592998002e-08,  1.754554299985799e-11,  9.008598815205273e-13,
  5.294108532217376e-15,  8.582252392908558e-18, -1.058123852813677e-19, -9.987644026063864e-22, -3.363773301739360e-24,  1.088896596187631e-26,  1.824708542549196e+00,
 -1.567443004122662e-03, -9.225886301336390e-06, -3.843674966409076e-08, -8.249151768230829e-11,  3.130783219526127e-13,  4.467456450308842e-15,  2.475746758074719e-17,
  5.548130837269454e-20, -3.493529168198953e-22, -4.597060217146103e-24, -2.515267019479521e-26,  1.888324423930466e+00, -1.048450258978484e-03, -6.820601419435732e-06,
 -3.489219714039028e-08, -1.345599037388202e-10, -2.698696043960232e-13,  1.219136951509959e-15,  1.762118721972082e-17,  1.149778196229007e-19,  4.614524335457230e-22,
  4.302385484057959e-25, -1.119272678957827e-26,  1.938841532119814e+00, -5.964320235737932e-04, -4.183938434851048e-06, -2.457750189242985e-08, -1.240104371126102e-10,
 -5.208433118644111e-13, -1.572552211360080e-15, -5.711182723589046e-19,  3.810324400232635e-20,  3.718112219071444e-22,  2.379217689440441e-24,  1.134674061069235e-26,
  1.974820801041531e+00, -2.522109458641554e-04, -1.863278386381487e-06, -1.196094556008753e-08, -6.985572376767581e-11, -3.764029306226711e-13, -1.867214747930140e-15,
 -8.372497451583392e-18, -3.225288363157313e-20, -9.007213628662346e-23,  1.093319612301087e-27,  2.547433497054126e-27,  1.995189515459637e+00, -4.891445644818594e-05,
 -3.718782992829176e-07, -2.502808524436402e-09, -1.571053682981875e-11, -9.408345896862162e-14, -5.437100616692443e-16, -3.051027472216415e-18, -1.667945413997573e-20,
 -8.895993947626107e-23, -4.628922787190553e-25, -2.346576644024421e-27,  9.259817986789516e-04, -6.340527660861051e-06,  3.254870957794453e-08, -1.484570558519246e-10,
  6.343769667015454e-13, -2.600592262847069e-15,  1.035481961047163e-17, -4.035261911855181e-20,  1.545934905666933e-22, -5.843291129558006e-25,  2.182689847188033e-27,
 -8.076804829003051e-30,  8.330579847391785e-03, -5.690330948200882e-05,  2.905595220495963e-07, -1.313043920191092e-09,  5.531015006510800e-12, -2.221204782561230e-14,
  8.598233297016168e-17, -3.227822581276893e-19,  1.178116896345167e-21, -4.186032146759973e-24,  1.445627383083696e-26, -4.844417814200621e-29,  2.312228973769915e-02,
 -1.571659291341281e-04,  7.939248446775427e-07, -3.520390162886288e-09,  1.439266671883215e-11, -5.529842869413605e-14,  2.009143328229989e-16, -6.895792319584985e-19,
  2.214639119473399e-21, -6.516451587066323e-24,  1.664829327997547e-26, -3.123228456733992e-29,  4.526556375437488e-02, -3.053932920270476e-04,  1.517485092188284e-06,
 -6.532698293778286e-09,  2.545043903387321e-11, -9.066116341806050e-14,  2.924167774365557e-16, -8.234710076041775e-19,  1.803461743866983e-21, -1.466034773210952e-24,
 -1.408400596173313e-26,  1.163831774234476e-28,  7.470562449753992e-02, -4.989600926207810e-04,  2.423903512067517e-06, -1.000813059699515e-08,  3.628525894112198e-11,
 -1.141033444861053e-13,  2.896131412701758e-16, -4.256979234430741e-19, -1.053749721463437e-21,  1.290668403853146e-23, -7.226660756447324e-26,  3.044453548914197e-28,
  1.113666683860335e-01, -7.343246677559264e-04,  3.464206412945240e-06, -1.351921681133772e-08,  4.410365411034521e-11, -1.113031778368182e-13,  1.370066293766706e-16,
  6.252811370674743e-19, -6.000467658871273e-21,  3.031102184136268e-23, -1.110709902167451e-25,  2.749668576226551e-28,  1.551493869988751e-01, -1.006996074839333e-03,
  4.578601067126899e-06, -1.657828171570866e-08,  4.609412665261692e-11, -7.120717005753383e-14, -1.813331078802324e-16,  2.145203392420809e-18, -1.089925949454025e-20,
  3.666758914712516e-23, -6.309369311755676e-26, -1.957473863848930e-28,  2.059277333995610e-01, -1.311496458291804e-03,  5.697659458629315e-06, -1.867047304934001e-08,
  3.984941199678054e-11,  1.047756058016472e-14, -6.227871781780760e-16,  3.601569103075678e-18, -1.225726334404929e-20,  1.673693863594728e-23,  1.053167595417103e-25,
 -9.787912842337034e-28,  2.635448411273907e-01, -1.641321825228921e-03,  6.743982627874041e-06, -1.929484617000133e-08,  2.382980213119513e-11,  1.282597270775649e-13,
 -1.079057062463596e-15,  4.205359350502195e-18, -6.654907240357927e-21, -3.440393654060568e-23,  3.333885275032980e-25, -1.425427993872598e-27,  3.278079842329413e-01,
 -1.988905833844855e-03,  7.634487821546692e-06, -1.801358174554128e-08, -2.171754176380730e-12,  2.650248627639626e-13, -1.387330240405407e-15,  3.158703624128687e-18,
  7.082341741984394e-21, -1.002363264827711e-22,  4.487739127837083e-25, -6.579313328089919e-28,  3.984824488779929e-01, -2.345593250730868e-03,  8.283486188355160e-06,
 -1.450864654146672e-08, -3.662130043495334e-11,  3.922088495466919e-13, -1.364299777621900e-15,  3.198762831554892e-20,  2.576212753151891e-20, -1.403339391336091e-22,
  2.427119118572860e-25,  1.610275191920647e-27,  4.752841730044124e-01, -2.701632525081287e-03,  8.606736760494261e-06, -8.643886229552294e-09, -7.597415079288820e-11,
  4.728222496518152e-13, -8.631962868291007e-16, -4.825491093395016e-18,  4.103290940067615e-20, -1.046834246442836e-22, -3.572534227872646e-25,  4.176429120651963e-27,
  5.578710044692208e-01, -3.046200636809959e-03,  8.526662926002095e-06, -5.284666305452998e-10, -1.146503094086282e-10,  4.679677075486970e-13,  1.536316568834545e-16,
 -1.001553707189553e-17,  4.133197595531019e-20,  3.336592943817412e-23, -1.099711586349455e-24,  4.358707260158498e-27,  6.458324364139616e-01, -3.367478154570487e-03,
  7.978884018430082e-06,  9.425428057902584e-09, -1.453807534823355e-10,  3.469486851858078e-13,  1.544890273725077e-15, -1.319222551200791e-17,  1.733448237929185e-20,
  2.372482601870780e-22, -1.383976382248269e-24, -1.653531029844416e-28,  7.386777116693408e-01, -3.652798340467981e-03,  6.920121555630595e-06,  2.046175048373023e-08,
 -1.600513516334335e-10,  1.000223560905496e-13,  2.953844752155440e-15, -1.174361384879643e-17, -3.013245804468712e-20,  3.891745198866568e-22, -5.814648190329514e-25,
 -8.102591203786129e-27,  8.358222608763936e-01, -3.888900971608743e-03,  5.337350591788638e-06,  3.147251739900845e-08, -1.511332542126553e-10, -2.487849200651644e-13,
  3.844445510319759e-15, -4.092256863748409e-18, -8.357270725774109e-20,  3.308183664630021e-22,  1.308827647039610e-24, -1.271037102686258e-26,  9.365725734245696e-01,
 -4.062328641872366e-03,  3.257734487195438e-06,  4.104317892828290e-08, -1.136827465780610e-10, -6.334626831235833e-13,  3.645056968107873e-15,  8.721350883760504e-18,
 -1.101634974672433e-19, -2.148667031425404e-23,  3.108997013409692e-24, -5.632215704298985e-27,  1.040109825608210e+00, -4.160009121651271e-03,  7.583550276868838e-07,
  4.757484487828400e-08, -4.768879385855248e-11, -9.489563449907206e-13,  2.004357678046537e-15,  2.203289885636258e-17, -7.691522599073605e-20, -5.360014602304367e-22,
  2.832790362874216e-24,  1.284231050281710e-26,  1.145472943287649e+00, -4.170068943162319e-03, -2.026005822096654e-06,  4.950392447250331e-08,  3.977141088783124e-11,
 -1.072081364628210e-12, -9.028372195126958e-16,  2.837776896521656e-17,  2.169601724718360e-20, -8.342442417620254e-22, -5.265539227081661e-25,  2.613834587448203e-26,
  1.251542297046453e+00, -4.082915755052776e-03, -4.899736421879012e-06,  4.562577252780061e-08,  1.334976677469458e-10, -9.035744485292210e-13, -4.176904662436688e-15,
  2.107120743107630e-17,  1.398199204879308e-19, -5.185569251545724e-22, -4.861065996134782e-24,  1.255552549945438e-26,  1.357025949255104e+00, -3.892602646211831e-03,
 -7.611624628520916e-06,  3.549733943560452e-08,  2.114831480553635e-10, -4.245157886314031e-13, -6.330578383029509e-15, -2.087952166085365e-19,  1.897043454187975e-19,
  3.800508443375532e-22, -5.426322827923893e-24, -2.361662737406056e-26,  1.460451297227406e+00, -3.598436882513178e-03, -9.872787757413683e-06,  1.984051723258805e-08,
  2.496975112911826e-10,  2.557296996820151e-13, -5.932243116812795e-15, -2.547431347818657e-17,  1.044147028100765e-19,  1.149202869059905e-21,  1.367909992403909e-25,
 -3.918977721249870e-26,  1.560166017233671e+00, -3.206708793173737e-03, -1.139115785844959e-05,  7.988918874644007e-10,  2.304617469298949e-10,  8.982156859455217e-13,
 -2.623056198025087e-15, -3.763578393157146e-17, -7.792619115172988e-20,  9.028225894919558e-22,  6.616244417398085e-24, -2.474991579478699e-27,  1.654353215327427e+00,
 -2.732290538758401e-03, -1.192369275481961e-05, -1.815654141812611e-08,  1.523696798296930e-10,  1.215527487920721e-12,  2.130048843492033e-15, -2.506607471467145e-17,
 -2.044714661744110e-19, -2.975166051930627e-22,  5.391485912016906e-24,  4.116103383748056e-26,  1.741066248975955e+00, -2.199702993997379e-03, -1.134159960912541e-05,
 -3.286554175848473e-08,  3.685066952567247e-11,  1.030385380555366e-12,  5.481423469427886e-15,  4.596109644841543e-18, -1.440478208374846e-19, -1.120784090020345e-21,
 -2.659817594715266e-24,  2.151225951328521e-26,  1.818288204158696e+00, -1.643116981298459e-03, -9.694820328445128e-06, -3.970045671351124e-08, -7.510062903281104e-11,
  4.288034623354447e-13,  5.183364741744768e-15,  2.629395435128410e-17,  3.932299278324330e-20, -5.558971865129268e-22, -5.740236879063801e-24, -2.652200514244936e-26,
  1.884018789267099e+00, -1.104726895099882e-03, -7.252398023384007e-06, -3.708656955108744e-08, -1.396225239133032e-10, -2.342583960822024e-13,  1.766555237001130e-15,
  2.156852951775823e-17,  1.317654250408401e-19,  4.670559558178606e-22, -1.967173305937841e-25, -1.760270967677341e-26,  1.936386944439837e+00, -6.311177870031840e-04,
 -4.491123867098990e-06, -2.664705721738085e-08, -1.348052441489944e-10, -5.586256300149332e-13, -1.569324275591770e-15,  8.817220657524211e-19,  5.332623105452876e-20,
  4.774491707538566e-22,  2.914386688255231e-24,  1.295006687903288e-26,  1.973781208172701e+00, -2.677108874548272e-04, -2.013772418553651e-06, -1.314137830004260e-08,
 -7.785151818016174e-11, -4.241488601544902e-13, -2.116579996753400e-15, -9.456220604548705e-18, -3.546414103891984e-20, -8.739075550140652e-23,  1.437068498573225e-25,
  4.023636458928033e-27,  1.994987711140235e+00, -5.201403867955576e-05, -4.034846868868141e-07, -2.769969635141144e-09, -1.772994089911916e-11, -1.082210506982600e-13,
 -6.371193747499343e-16, -3.639796624035766e-18, -2.024174305451020e-20, -1.097146744232590e-22, -5.794251252367692e-25, -2.976134279499987e-27,  9.011294231499069e-04,
 -6.087095239424878e-06,  3.082645141841602e-08, -1.387099908048262e-10,  5.847615671124514e-13, -2.365094913602750e-15,  9.291157998495680e-18, -3.572602151193642e-20,
  1.350471982447447e-22, -5.037300946261742e-25,  1.856688911350613e-27, -6.781586832972776e-30,  8.107517850774792e-03, -5.464038802652059e-05,  2.753196674702139e-07,
 -1.227992484765227e-09,  5.106699179720790e-12, -2.025280195733408e-14,  7.745034346569376e-17, -2.873861101638230e-19,  1.037334031204468e-21, -3.648289143773300e-24,
  1.248137651004562e-26, -4.150763578054763e-29,  2.250606668709617e-02, -1.509796766826608e-04,  7.530261928306458e-07, -3.298699675136182e-09,  1.333339410298903e-11,
 -5.070038742797010e-14,  1.825639063819382e-16, -6.223384168718092e-19,  1.991702907155597e-21, -5.877940975020219e-24,  1.528037469885649e-26, -3.080701864281119e-29,
  4.406778345702878e-02, -2.935601936542853e-04,  1.441477332471681e-06, -6.139623466684205e-09,  2.370556164261980e-11, -8.391337811517531e-14,  2.701588862842239e-16,
 -7.667038763638336e-19,  1.741703126235784e-21, -1.935130308398348e-24, -9.561793906913566e-27,  9.013657682355902e-29,  7.274781967326675e-02, -4.800395562063258e-04,
  2.307215233653804e-06, -9.445449449408271e-09,  3.407171578119758e-11, -1.072990639419813e-13,  2.772875405610556e-16, -4.525162043524704e-19, -6.380405183367819e-22,
  1.026998019164875e-23, -5.990309064174868e-26,  2.585132586788755e-28,  1.084837862713871e-01, -7.072481106574890e-04,  3.306136895975084e-06, -1.283118262245523e-08,
  4.191178231435479e-11, -1.078256437674020e-13,  1.519843581457563e-16,  4.498914072347769e-19, -4.986343683466863e-21,  2.610811915591186e-23, -9.913904657698929e-26,
  2.661101982683199e-28,  1.511934179228120e-01, -9.711505958948098e-04,  4.384039014141620e-06, -1.585238556612825e-08,  4.463113005269700e-11, -7.487658611405005e-14,
 -1.259553968870082e-16,  1.817045615291463e-18, -9.626439041421234e-21,  3.400305699615652e-23, -6.940692368711004e-26, -9.597558129252090e-29,  2.007715064785087e-01,
 -1.266800515472424e-03,  5.477443701906403e-06, -1.803198466525046e-08,  3.991743604247286e-11, -3.302942953353480e-15, -5.273385900585008e-16,  3.219709645738021e-18,
 -1.158872615967152e-20,  2.014920268254821e-23,  6.675328951570434e-26, -7.787720632795682e-28,  2.570860005366132e-01, -1.588289449105940e-03,  6.514812336638847e-06,
 -1.889441528167634e-08,  2.614543183498711e-11,  1.037502387838641e-13, -9.644569432248822e-16,  3.975038941931850e-18, -7.668186282719492e-21, -2.228528589972723e-23,
  2.735137784034377e-25, -1.292525534972487e-27,  3.199731433530286e-01, -1.928694782678054e-03,  7.418285491708345e-06, -1.800770442284352e-08,  2.803066413229632e-12,
  2.328126592847000e-13, -1.296231776618851e-15,  3.331006247042514e-18,  3.789359780681317e-21, -8.293037155489368e-23,  4.150768524898683e-25, -8.569629900557266e-28,
  3.892314957058031e-01, -2.280031152644519e-03,  8.106119884791769e-06, -1.503361105800415e-08, -2.910402095465449e-11,  3.595649607152550e-13, -1.352608074658246e-15,
  7.775439188051664e-19,  2.090015370665771e-20, -1.294022578232023e-22,  2.992853108123935e-25,  9.805472069493379e-28,  4.646146655208862e-01, -2.633213491345935e-03,
  8.496024904613431e-06, -9.784990004984620e-09, -6.673506540723861e-11,  4.506289766511812e-13, -9.805114795385940e-16, -3.575145905182343e-18,  3.704958626122251e-20,
 -1.154948673543242e-22, -1.882533448740598e-25,  3.499799808788980e-27,  5.458225452784969e-01, -2.978043172534298e-03,  8.509624150333338e-06, -2.287889059906867e-09,
 -1.052760228515934e-10,  4.684399190026829e-13, -1.081644149936509e-16, -8.681805779209779e-18,  4.178814872768626e-20, -6.728475512133737e-24, -9.041163598074658e-25,
  4.482384534129004e-27,  6.324908471573154e-01, -3.303233665609500e-03,  8.078267774310898e-06,  7.156737963775373e-09, -1.381005700352912e-10,  3.796636554983270e-13,
  1.184481682298756e-15, -1.251153650767207e-17,  2.488159867071717e-20,  1.822210746148778e-22, -1.356251488406967e-24,  1.362613447795920e-27,  7.241787341169594e-01,
 -3.596498561470848e-03,  7.150375813638319e-06,  1.792067065270605e-08, -1.573691251064621e-10,  1.668725853623226e-13,  2.613594578312567e-15, -1.248883647101028e-17,
 -1.662099730379366e-20,  3.594186773689087e-22, -8.905256138639692e-25, -5.935973886731661e-27,  8.203543880177813e-01, -3.844732940082361e-03,  5.700363929841290e-06,
  2.901954865041041e-08, -1.551970808113561e-10, -1.581840865003764e-13,  3.694277845366226e-15, -6.567019710544733e-18, -7.085526999257082e-20,  3.720424882059423e-22,
  7.552867990539036e-25, -1.231380472336238e-26,  9.203784570062079e-01, -4.034328546692579e-03,  3.738936611617237e-06,  3.912772996765276e-08, -1.254594652298241e-10,
 -5.434491630327275e-13,  3.839953251647263e-15,  5.207194560064465e-18, -1.087680482177883e-19,  9.685505157993840e-23,  2.783459724768537e-24, -9.010911426092596e-27,
  1.023485518298688e+00, -4.151673084640003e-03,  1.324057757826797e-06,  4.666280937270682e-08, -6.613841442161054e-11, -8.937438540890056e-13,  2.584081871965418e-15,
  1.928576121775119e-17, -9.404891829701300e-20, -4.128709888394704e-22,  3.286149030859134e-24,  7.690131351917682e-27,  1.128764026835882e+00, -4.183891619407421e-03,
 -1.428851319483796e-06,  4.996782794007771e-08,  1.817775078963917e-11, -1.084163914565405e-12, -1.030707328147607e-16,  2.858970507903049e-17, -8.438342381250581e-21,
 -8.322929039643858e-22,  6.205978138019811e-25,  2.565602389674899e-26,  1.235135755211227e+00, -4.119888705768699e-03, -4.340024808330108e-06,  4.761192607647869e-08,
  1.144740461206890e-10, -9.962532074554364e-13, -3.527338548190259e-15,  2.521045262212238e-17,  1.178067754215040e-19, -6.995776306405383e-22, -4.133092528759318e-24,
  2.035146977737043e-26,  1.341336530765285e+00, -3.951734946386704e-03, -7.165661069262966e-06,  3.880490270458696e-08,  2.014766131544830e-10, -5.758227578393491e-13,
 -6.249690091520163e-15,  6.036855048645264e-18,  1.992481312420954e-19,  1.443760891761548e-22, -6.299317464230892e-24, -1.564885328884948e-26,  1.445901189304128e+00,
 -3.676398584745800e-03, -9.610587510949586e-06,  2.386862328676675e-08,  2.533327045754671e-10,  1.052122385124847e-13, -6.592539137458044e-15, -2.147352164615613e-17,
  1.454535351059233e-19,  1.118537146776539e-21, -1.705699657272251e-24, -4.406402386886617e-26,  1.547157074518174e+00, -3.297735682368276e-03, -1.135886607584187e-05,
  4.626210923045266e-09,  2.477098469794956e-10,  8.223667810298706e-13, -3.706521151479087e-15, -3.955875043669172e-17, -4.072057749825303e-20,  1.161587868633712e-21,
  6.226240552534773e-24, -1.561095270552227e-26,  1.643231955158265e+00, -2.828508285823701e-03, -1.212613320139153e-05, -1.552161660165272e-08,  1.771307339975633e-10,
  1.257478769913372e-12,  1.335302757570338e-15, -3.173534385408961e-17, -2.108605886815799e-19, -4.534337293104226e-23,  7.217641350501583e-24,  4.120505592018941e-26,
  1.732083489899310e+00, -2.292001700690791e-03, -1.173174514212970e-05, -3.210388770946438e-08,  5.878149006056405e-11,  1.162924993640649e-12,  5.539380813231290e-15,
 -6.774593386855859e-19, -1.860500700085305e-19, -1.204598996342297e-21, -1.436893216737002e-24,  3.441299184436969e-26,  1.811557573951061e+00, -1.722600896272361e-03,
 -1.017812987500903e-05, -4.082644649261253e-08, -6.522026711202767e-11,  5.621610444792156e-13,  5.933874481339739e-15,  2.718549621870018e-17,  1.489671380322487e-20,
 -8.087836102063449e-22, -6.897678256532858e-24, -2.562339200801685e-26,  1.879480970674675e+00, -1.164564552003497e-03, -7.710987186796163e-06, -3.935549358639272e-08,
 -1.438322731188814e-10, -1.841221388300629e-13,  2.432012417995118e-15,  2.605087851286536e-17,  1.482304077201556e-19,  4.413912887374766e-22, -1.147173692300158e-24,
 -2.593345192972738e-26,  1.933788537232223e+00, -6.683633660625961e-04, -4.824205147140503e-06, -2.889535554872460e-08, -1.463513278545477e-10, -5.957836120340786e-13,
 -1.517994963720511e-15,  2.886810952899811e-18,  7.275387613020143e-20,  6.058311629273713e-22,  3.514034606136152e-24,  1.422336158466784e-26,  1.972677114751312e+00,
 -2.844736916689739e-04, -2.179231834190570e-06, -1.445771879600811e-08, -8.686459620657584e-11, -4.782551666591415e-13, -2.397704991179734e-15, -1.063992143921877e-17,
 -3.845898741746106e-20, -7.753320665972362e-23,  3.645328478129688e-25,  6.136669456880187e-27,  1.994772981680646e+00, -5.537986733228112e-05, -4.385006118742002e-07,
 -3.071830877374562e-09, -2.005591998991276e-11, -1.248118975573715e-13, -7.487291960166790e-16, -4.355470446953026e-18, -2.464222402947862e-20, -1.357339071976731e-22,
 -7.274136248383213e-25, -3.783879310259123e-27,  8.772639433615305e-04, -5.846986170373108e-06,  2.921654601379513e-08, -1.297204367829374e-10,  5.396109746216364e-13,
 -2.153638991893199e-15,  8.348703264503183e-18, -3.168088962884019e-20,  1.181808571828691e-22, -4.350995630697873e-25,  1.582657546352322e-27, -5.707290951831445e-30,
  7.893270007115569e-03, -5.249541544526463e-05,  2.610609537588859e-07, -1.149427420906991e-09,  4.719598314295743e-12, -1.848692244546454e-14,  6.984918031095096e-17,
 -2.561999422300444e-19,  9.145586528036651e-22, -3.183752893249904e-24,  1.078844578099263e-26, -3.559995753670204e-29,  2.191395071860834e-02, -1.451102535880302e-04,
  7.146890955754041e-07, -3.093245165695530e-09,  1.236182663481830e-11, -4.652094875683809e-14,  1.659997279499872e-16, -5.618742883552297e-19,  1.790774764505763e-21,
 -5.293548903118956e-24,  1.394735845985315e-26, -2.969486034923221e-29,  4.291614864596047e-02, -2.823167543034747e-04,  1.370023323438157e-06, -5.773415520274469e-09,
  2.209042559541143e-11, -7.768094617291885e-14,  2.494605045113042e-16, -7.121504678185564e-19,  1.666049785604852e-21, -2.244798320157296e-24, -6.074155850355235e-27,
  6.917571877723743e-29,  7.086387190946625e-02, -4.620261091709132e-04,  2.197071066994725e-06, -8.917112609432604e-09,  3.199124667282945e-11, -1.007981899436330e-13,
  2.643836539706436e-16, -4.674589351845591e-19, -3.088222313612088e-22,  8.089122173226451e-24, -4.943224979882136e-26,  2.183545114610610e-28,  1.057067327289017e-01,
 -6.814036748381597e-04,  3.156115723610255e-06, -1.217764405139281e-08,  3.979267644136012e-11, -1.040440446177623e-13,  1.624834075986952e-16,  3.046239976654146e-19,
 -4.115046235275220e-21,  2.237264502809586e-23, -8.774495038653033e-26,  2.510075813684856e-28,  1.473777723692148e-01, -9.368271734175946e-04,  4.198045071039351e-06,
 -1.515041529858846e-08,  4.310731492511280e-11, -7.732268577309842e-14, -7.921060070709857e-17,  1.528042680019542e-18, -8.453103474625184e-21,  3.116572715286951e-23,
 -7.192318725588087e-26, -2.224876049252594e-29,  1.957905884012454e-01, -1.223835652917443e-03,  5.264887634318196e-06, -1.739449190249351e-08,  3.973190455926109e-11,
 -1.491846444046350e-14, -4.422661201963145e-16,  2.860927847385300e-18, -1.082306813321710e-20,  2.218660479678148e-23,  3.636789191031277e-26, -6.069803576454643e-28,
  2.508356539997095e-01, -1.537070621073587e-03,  6.290653818184909e-06, -1.846070865122977e-08,  2.799783615004266e-11,  8.191048855619765e-14, -8.566973858456839e-16,
  3.718823494704562e-18, -8.286843452251020e-21, -1.243927207168932e-23,  2.198654832861477e-25, -1.144619132555257e-27,  3.123756897339413e-01, -1.870211763070735e-03,
  7.202610401246717e-06, -1.792726369750127e-08,  7.155838215359785e-12,  2.028333711674371e-13, -1.201692380862127e-15,  3.407626131236787e-18,  1.093280306102597e-21,
 -6.711914867789059e-23,  3.746978323233235e-25, -9.652779871117902e-28,  3.802399159891816e-01, -2.215911188069141e-03,  7.923154188921602e-06, -1.544350009289404e-08,
 -2.223521158544552e-11,  3.274349767134982e-13, -1.322156987537487e-15,  1.374198308858352e-18,  1.646608959035868e-20, -1.167273222463256e-22,  3.307264629279971e-25,
  4.676460477738148e-28,  4.542169795608726e-01, -2.565732447077264e-03,  8.372491644415890e-06, -1.078196067695003e-08, -5.796524114620025e-11,  4.260255368752552e-13,
 -1.064651085031967e-15, -2.457248437513270e-18,  3.279149420425438e-20, -1.201478353427725e-22, -4.939062338250641e-26,  2.814562582874060e-27,  5.340463132063159e-01,
 -2.910103922371727e-03,  8.472371477582925e-06, -3.897576022351020e-09, -9.595209515758128e-11,  4.630775284213178e-13, -3.326178340437018e-16, -7.355055767545474e-18,
  4.094229754658010e-20, -3.897325565587847e-23, -7.091522758009331e-25,  4.342181043342632e-27,  6.194076564335066e-01, -3.238300976808628e-03,  8.151146235024682e-06,
  5.009302175050696e-09, -1.302509081301892e-10,  4.039830018538745e-13,  8.462179383542453e-16, -1.162069667082772e-17,  3.048286998872748e-20,  1.295341375890202e-22,
 -1.269784232584631e-24,  2.503918537506727e-27,  7.099084477869004e-01, -3.538477891977877e-03,  7.350437274056913e-06,  1.543275256757560e-08, -1.534329961944810e-10,
  2.253542026294366e-13,  2.258354338869719e-15, -1.282103070682127e-17, -4.380235884701554e-21,  3.192111769786183e-22, -1.104249901940568e-24, -3.796472498723832e-27,
  8.050688076923721e-01, -3.797779513384830e-03,  6.033610615452663e-06,  2.651583627464166e-08, -1.574903008109201e-10, -7.197159135380016e-14,  3.480707137701962e-15,
 -8.615304630739068e-18, -5.704598736920113e-20,  3.917042717830136e-22,  2.360696288207672e-25, -1.118203171948359e-26,  9.043038902884403e-01, -4.002573841028840e-03,
  4.196082924602509e-06,  3.703847650205327e-08, -1.353970660449861e-10, -4.499300029384324e-13,  3.937699265911981e-15,  1.803070436061419e-18, -1.033799247147777e-19,
  1.994881302039267e-22,  2.330885108921401e-24, -1.138645318313845e-26,  1.006903530098210e+00, -4.138860133088449e-03,  1.877083713299691e-06,  4.546514268320828e-08,
 -8.335118426211901e-11, -8.255987663724614e-13,  3.079899052088801e-15,  1.606431866721752e-17, -1.064790636584629e-19, -2.762355610792751e-22,  3.506584030484699e-24,
  2.337933328956343e-27,  1.112009401100200e+00, -4.192920677328509e-03, -8.282075620971253e-07,  5.008534259472778e-08, -3.465697407034146e-12, -1.077089444309124e-12,
  6.892030501382337e-16,  2.784724332957981e-17, -3.768720846633748e-20, -7.854914548057016e-22,  1.701142444649032e-24,  2.314395597243844e-26,  1.218590420422988e+00,
 -4.152293937810006e-03, -3.758363940028272e-06,  4.927975801043538e-08,  9.376169684174162e-11, -1.072036997117573e-12, -2.772671294466775e-15,  2.854727816564017e-17,
  8.988028350909718e-20, -8.450046666227178e-22, -3.092325120453428e-24,  2.664739272874503e-26,  1.325417965722021e+00, -4.007143725832043e-03, -6.681066735322375e-06,
  4.192831775526198e-08,  1.884776614610506e-10, -7.230634219003321e-13, -5.990967316407426e-15,  1.244614645841926e-17,  1.997699598409007e-19, -1.185136585019872e-22,
 -6.771194498687702e-24, -5.506519663895115e-27,  1.431043736999398e+00, -3.752068581324229e-03, -9.299803033437940e-06,  2.792998935292452e-08,  2.538089121097617e-10,
 -5.966120265051435e-14, -7.122697119673311e-15, -1.619173813393375e-17,  1.840187267229983e-19,  1.010841247554719e-21, -3.689279034629176e-24, -4.544991749805641e-26,
  1.533784838250276e+00, -3.388315959055159e-03, -1.127904532799112e-05,  8.715935119092127e-09,  2.631773073945500e-10,  7.200116072553034e-13, -4.825788802720855e-15,
 -4.014626497586243e-17,  5.375237410967082e-21,  1.392631869142795e-21,  5.218296927730519e-24, -3.037035884580119e-26,  1.631722794791431e+00, -2.926212288347310e-03,
 -1.229455333236420e-05, -1.248490285699725e-08,  2.025248668702241e-10,  1.278101059444661e-12,  3.524197511932182e-16, -3.844978365189838e-17, -2.068672647998924e-19,
  2.786799864117489e-22,  8.951296231333226e-24,  3.676304052371498e-26,  1.722725360240418e+00, -2.387378845379934e-03, -1.211055789064272e-05, -3.097011158646002e-08,
  8.336425671590970e-11,  1.294929361306499e-12,  5.430481519103529e-15, -7.332792724916665e-18, -2.300472930519710e-19, -1.227600635057855e-21,  3.927264265423902e-25,
  4.893527444714411e-26,  1.804501193624922e+00, -1.806002438572586e-03, -1.067391157889635e-05, -4.177202781557974e-08, -5.249110252311350e-11,  7.137333644281804e-13,
  6.696972802284193e-15,  2.714093004703041e-17, -1.944904982919305e-20, -1.106252312473386e-21, -7.944171411800042e-24, -2.126470538533605e-26,  1.874696290081089e+00,
 -1.228180893558866e-03, -8.197171554590722e-06, -4.168284032220833e-08, -1.468691184281054e-10, -1.164504370530906e-13,  3.230156143538137e-15,  3.103723363785121e-17,
  1.629933151836478e-19,  3.697743380819626e-22, -2.509377715349851e-24, -3.632624929786144e-26,  1.931035643029727e+00, -7.083847101621865e-04, -5.185398683325421e-06,
 -3.133424915439054e-08, -1.586233228273454e-10, -6.309612918030273e-13, -1.401091185195117e-15,  5.592261058147029e-18,  9.724691214850677e-20,  7.591359808537266e-22,
  4.155089567366310e-24,  1.474636776671520e-26,  1.971503219148019e+00, -3.026258917892435e-04, -2.361389520152881e-06, -1.592730359525933e-08, -9.703000933425791e-11,
 -5.395166322672288e-13, -2.713248675694792e-15, -1.191187887542892e-17, -4.091542418900087e-20, -5.674476982660798e-23,  6.966331027930622e-25,  9.127173593796994e-27,
  1.994544204782534e+00, -5.904097158951922e-05, -4.773736064901996e-07, -3.413714970756855e-09, -2.274221158668354e-11, -1.443386668097313e-13, -8.824986820074304e-16,
 -5.228162449811890e-18, -3.009508522858769e-20, -1.684469785541997e-22, -9.157905900539433e-25, -4.821633975986135e-27,  8.543338076450930e-04, -5.619336813311055e-06,
  2.771031648318023e-08, -1.214206508134907e-10,  4.984721800091293e-13, -1.963501598658755e-15,  7.512312966924433e-18, -2.813797593738845e-20,  1.035987903906878e-22,
 -3.765408487346233e-25,  1.351778974275313e-27, -4.814223410157715e-30,  7.687379740119574e-03, -5.046084412088746e-05,  2.477089932963502e-07, -1.076783052991964e-09,
  4.366059259663576e-12, -1.689342125529206e-14,  6.306865024490444e-17, -2.286875907426513e-19,  8.073478573792074e-22, -2.782002891651911e-24,  9.335696756627381e-27,
 -3.056688097986638e-29,  2.134471429860600e-02, -1.395379235061190e-04,  6.787268719608014e-07, -2.902688062454622e-09,  1.147000599610351e-11, -4.271944190322391e-14,
  1.510416192676712e-16, -5.075134368706291e-19,  1.609938087836281e-21, -4.761355967301195e-24,  1.267354981591620e-26, -2.815159172469453e-29,  4.180837155201458e-02,
 -2.716277990600117e-04,  1.302812784083060e-06, -5.432079037895203e-09,  2.059509284839840e-11, -7.192722839176752e-14,  2.302542314674616e-16, -6.601711336150314e-19,
  1.581549431290184e-21, -2.432079269557154e-24, -3.411264909803289e-27,  5.249808142866177e-29,  6.905025499472982e-02, -4.448690114166676e-04,  2.093071453112668e-06,
 -8.421040083757716e-09,  3.003767007637803e-11, -9.461090926549742e-14,  2.511976146800208e-16, -4.730453794551069e-19, -5.098696390669021e-23,  6.293366784778206e-24,
 -4.060898989716746e-26,  1.835450297184722e-28,  1.030307054538127e-01, -6.567286091127979e-04,  3.013736116492136e-06, -1.155739375549720e-08,  3.775140862360955e-11,
 -1.000562486648921e-13,  1.692857136706364e-16,  1.851730581790774e-19, -3.370193896231916e-21,  1.907839810701296e-23, -7.710451532070806e-26,  2.322101676894932e-28,
  1.436964973626127e-01, -9.039584257254735e-04,  4.020327060583117e-06, -1.447315917001101e-08,  4.154516262151786e-11, -7.873986745437476e-14, -4.004769170891818e-17,
  1.274938704666079e-18, -7.383001509428869e-21,  2.828612600379375e-23, -7.167265411666790e-26,  3.057384042829067e-29,  1.909781772329366e-01, -1.182540706666729e-03,
  5.059956352751623e-06, -1.676171855740883e-08,  3.933368088877390e-11, -2.460996897308461e-14, -3.668870886444088e-16,  2.527600372705574e-18, -1.000419333531106e-20,
  2.315167405016834e-23,  1.293930184901061e-26, -4.622690114404754e-28,  2.447866298690353e-01, -1.487623771712372e-03,  6.071863644299098e-06, -1.800071986868280e-08,
  2.943871643313536e-11,  6.256895527899176e-14, -7.563386112449244e-16,  3.448081005462291e-18, -8.588085273618780e-21, -4.607284410378535e-24,  1.728378836251962e-25,
 -9.931685752943540e-28,  3.050087251177294e-01, -1.813449143843010e-03,  6.988299080171735e-06, -1.778185146940199e-08,  1.093183929027996e-11,  1.751395383998629e-13,
 -1.106132171425485e-15,  3.406759032496218e-18, -1.063613857124971e-21, -5.299642162182091e-23,  3.311600228404249e-25, -1.003809847870172e-27,  3.715018601017532e-01,
 -2.153272803970797e-03,  7.735908168005853e-06, -1.574858386993562e-08, -1.600042146966111e-11,  2.962206903431835e-13, -1.276915956705925e-15,  1.836464007248027e-18,
  1.250582773711233e-20, -1.032126178055452e-22,  3.420882592069611e-25,  6.649266436699028e-29,  4.440871687934719e-01, -2.499285176148584e-03,  8.237820074016189e-06,
 -1.164265006539649e-08, -4.970522389166207e-11,  3.997628449528574e-13, -1.119415065335984e-15, -1.477276605337346e-18,  2.845867016101439e-20, -1.198422060306656e-22,
  5.991564677579280e-26,  2.161938146845430e-27,  5.225411233231346e-01, -2.842537432446989e-03,  8.416693205422819e-06, -5.359218249020824e-09, -8.678629519074407e-11,
  4.527699660407112e-13, -5.204650606099575e-16, -6.072456708461681e-18,  3.907395299926780e-20, -6.360429913416421e-23, -5.248222770920877e-25,  4.010658875271281e-27,
  6.065852023746020e-01, -3.172886167988724e-03,  8.199023679760454e-06,  2.990919799302104e-09, -1.219939248379037e-10,  4.205018683315567e-13,  5.351272325153497e-16,
 -1.058020483211072e-17,  3.426074414305740e-20,  8.119783003827700e-23, -1.141460499753184e-24,  3.269359922906896e-27,  6.958732576612697e-01, -3.478974994372644e-03,
  7.521058676399601e-06,  1.301670398670153e-08, -1.484130231315962e-10,  2.752413075464195e-13,  1.899068210977462e-15, -1.278614821843873e-17,  6.281499896512089e-21,
  2.722959393645901e-22, -1.227168061255345e-24, -1.828646927229811e-27,  7.899761820283626e-01, -3.748280786011800e-03,  6.336648550457115e-06,  2.398892928759417e-08,
 -1.581149130579083e-10,  8.477430772322661e-15,  3.216049459185313e-15, -1.021426771413275e-17, -4.288912728750153e-20,  3.917647508187873e-22, -2.209205628871684e-25,
 -9.520703860706194e-27,  8.883634943232945e-01, -3.967264809237083e-03,  4.627266234235774e-06,  3.480527993555445e-08, -1.434484304580573e-10, -3.551859563975242e-13,
  3.943073132316363e-15, -1.373196692267510e-18, -9.464520491676306e-20,  2.822410274278102e-22,  1.797233175797521e-24, -1.269519940047349e-26,  9.903815446285191e-01,
 -4.121685036141848e-03,  2.414132227068816e-06,  4.400359001782440e-08, -9.908957527947695e-11, -7.466768239208584e-13,  3.480696082029907e-15,  1.252505693514339e-17,
 -1.138879806340664e-19, -1.354427755920729e-22,  3.496077292762535e-24, -2.732609131443174e-27,  1.095228270075561e+00, -4.197144814082395e-03, -2.282234080108948e-07,
  4.985871817025397e-08, -2.477973332327819e-11, -1.051353785226938e-12,  1.447895761520884e-15,  2.620386848364319e-17, -6.450480039838296e-20, -6.982152293947112e-22,
  2.631756475630891e-24,  1.890742238951425e-26,  1.201924889938528e+00, -4.179971569378766e-03, -3.158724221341755e-06,  5.060508092644562e-08,  7.172181850015272e-11,
 -1.128693118947706e-12, -1.937810793225530e-15,  3.091523166573226e-17,  5.752917161022843e-20, -9.438579039183121e-22, -1.820236994159151e-24,  3.077319236860694e-26,
  1.309285751166324e+00, -4.058529583709523e-03, -6.160335239575980e-06,  4.482058938439851e-08,  1.726104984656797e-10, -8.619481833707288e-13, -5.553994137179316e-15,
  1.871797023838334e-17,  1.905997856125738e-19, -3.909028190228066e-22, -6.764972868253568e-24,  5.910864532960881e-27,  1.415888885770932e+00, -3.825057481822417e-03,
 -8.940347359749225e-06,  3.197195640324397e-08,  2.508730954948490e-10, -2.353484359172389e-13, -7.488380325358429e-15, -9.753262454330406e-18,  2.172749061204341e-19,
  8.237900884998047e-22, -5.642498090081239e-24, -4.259161521266422e-26,  1.520051874549055e+00, -3.478057320926149e-03, -1.114873530364386e-05,  1.303529983007203e-08,
  2.763286005513950e-10,  5.907706629694635e-13, -5.939668426891458e-15, -3.913469664712676e-17,  5.890456419522633e-20,  1.570189634470144e-21,  3.550353307884087e-24,
 -4.533929496203329e-26,  1.619820364264451e+00, -3.025110959751721e-03, -1.242408577635201e-05, -9.039928618526084e-09,  2.280804473348604e-10,  1.272903790570699e-12,
 -8.148321907293398e-16, -4.483689020429423e-17, -1.900220590945514e-19,  6.665804472965690e-22,  1.037129761035601e-23,  2.680926184792150e-26,  1.712979756868537e+00,
 -2.485725184892904e-03, -1.247331889720850e-05, -2.942209872847384e-08,  1.105450570706588e-10,  1.421924631046176e-12,  5.115505668384620e-15, -1.539389640111694e-17,
 -2.733990508490383e-19, -1.164416797949229e-21,  2.875108731979212e-24,  6.382093208232764e-26,  1.797103207958020e+00, -1.893411923231378e-03, -1.117971500462047e-05,
 -4.248869864186450e-08, -3.654813387532909e-11,  8.834707024177368e-13,  7.441771416962558e-15,  2.581833060593554e-17, -6.519912036710765e-20, -1.440426807782247e-21,
 -8.697808173388688e-24, -1.207803697945112e-26,  1.869649187271320e+00, -1.295799138859517e-03, -8.711527453739797e-06, -4.404685993513265e-08, -1.483494018167631e-10,
 -2.789726892596832e-14,  4.174063670936544e-15,  3.644330383426112e-17,  1.740815684931632e-19,  2.339277834443834e-22, -4.372973365529612e-24, -4.867848271720300e-26,
  1.928116694216808e+00, -7.514160597720509e-04, -5.577059703406787e-06, -3.397494324950172e-08, -1.715641985151631e-10, -6.623304056167432e-13, -1.196596791698415e-15,
  9.174765607023042e-18,  1.277228877117456e-19,  9.381880301652173e-22,  4.791247645869847e-24,  1.387108846227366e-26,  1.970253684503096e+00, -3.223087543113934e-04,
 -2.562199902239900e-06, -1.756976056704751e-08, -1.084993096739620e-10, -6.087866165886490e-13, -3.065375282696232e-15, -1.324762793182711e-17, -4.234973038602872e-20,
 -1.971469445089590e-23,  1.185317855617264e-24,  1.331413710640960e-26,  1.994300134444142e+00, -6.303023176820407e-05, -5.206205705159958e-07, -3.801887125411133e-09,
 -2.585322922805442e-11, -1.673899882453538e-13, -1.043334378068157e-15, -6.295737124957550e-18, -3.687298910998595e-20, -2.096902418707446e-22, -1.156081148092006e-24,
 -6.155962367093955e-27,  8.322907850431596e-04, -5.403349810432900e-06,  2.629985710761062e-08, -1.137497214236521e-10,  4.609431704482946e-13, -1.792297996295469e-15,
  6.768896130371909e-18, -2.502966687988042e-20,  9.096765223288323e-23, -3.264773684275533e-25,  1.156810668141553e-27, -4.070246461516470e-30,  7.489419515389216e-03,
 -4.852969534722376e-05,  2.351958492686037e-07, -1.009548936461657e-09,  4.042823351359762e-12, -1.545378333753022e-14,  5.701253233667097e-17, -2.043853725638991e-19,
  7.136053644484034e-22, -2.434161426835103e-24,  8.087604162510561e-27, -2.627757323272333e-29,  2.079720595069586e-02, -1.342443813932953e-04,  6.449681660014469e-07,
 -2.725810847736210e-09,  1.065074553316528e-11, -3.925930096263744e-14,  1.375274105088572e-16, -4.586425116528717e-19,  1.447360362348774e-21, -4.278673660577926e-24,
  1.147360511837597e-26, -2.636337326328307e-29,  4.074230028910619e-02, -2.614605421253728e-04,  1.239558448237933e-06, -5.113771840330045e-09,  1.921034123759517e-11,
 -6.661730718971805e-14,  2.124646486322567e-16, -6.109844971674923e-19,  1.492057253613396e-21, -2.526449048851040e-24, -1.403444744257078e-27,  3.927621684163872e-29,
  6.730363944078516e-02, -4.285206211723242e-04,  1.994841193986309e-06, -7.955252050463662e-09,  2.820466634758272e-11, -8.874109561454291e-14,  2.379614152373503e-16,
 -4.713502421628119e-19,  1.481981393953192e-22,  4.821374041687819e-24, -3.320881221812159e-26,  1.535825218988809e-28,  1.004511467311444e-01, -6.331633573413994e-04,
  2.878606208899017e-06, -1.096915791721669e-08,  3.579127182900509e-11, -9.594274617973540e-14,  1.730598348921806e-16,  8.774039203641536e-20, -2.736478859903701e-21,
  1.619256912836876e-23, -6.733746032357191e-26,  2.115632918767379e-28,  1.401439047277748e-01, -8.724793405622695e-04,  3.850585380714055e-06, -1.382107550008521e-08,
  3.996351133483082e-11, -7.929840837789677e-14, -7.507834173649637e-18,  1.054425507932313e-18, -6.415872127989885e-21,  2.545787656495647e-23, -6.947577447997623e-26,
  6.688525212324586e-29,  1.863277148683455e-01, -1.142854959972835e-03,  4.862574035320239e-06, -1.613677225717484e-08,  3.875897752527029e-11, -3.260138779312001e-14,
 -3.004703671277197e-16,  2.220863903484656e-18, -9.165978933463134e-21,  2.329942031706829e-23, -4.680193337131017e-27, -3.425296241979514e-28,  2.389319279677642e-01,
 -1.439904800922999e-03,  5.858719311731826e-06, -1.752064337294316e-08,  3.051623354231320e-11,  4.554422169072068e-14, -6.636557090509197e-16,  3.171859943952358e-18,
 -8.639636141357100e-21,  1.476040385930116e-24,  1.323995109603296e-25, -8.461816735261548e-28,  2.978653944441256e-01, -1.758393049610273e-03,  6.776077327306383e-06,
 -1.758032976950961e-08,  1.417685783502904e-11,  1.497315176825259e-13, -1.011488507704934e-15,  3.344667586434999e-18, -2.743694517475875e-21, -4.063276327445373e-23,
  2.871178699296619e-25, -9.910182663918178e-28,  3.630113409601308e-01, -2.092145383239776e-03,  7.545579282702694e-06, -1.595884214772755e-08, -1.037808290820434e-11,
  2.662336415492151e-13, -1.220432107524988e-15,  2.179840838957008e-18,  9.036303078629967e-21, -8.956574301160506e-23,  3.380734923306346e-25, -2.333090957908152e-28,
  4.342209300709529e-01, -2.433954384487132e-03,  8.093595652725179e-06, -1.237544357283711e-08, -4.198146207796056e-11,  3.724994595090786e-13, -1.148673590005558e-15,
 -6.349904904306555e-19,  2.420877271755833e-20, -1.157225087487658e-22,  1.417520485890655e-25,  1.569440123697216e-27,  5.113052009595680e-01, -2.775484051627666e-03,
  8.344347579930102e-06, -6.676089760188797e-09, -7.786885908079921e-11,  4.383774983675827e-13, -6.733598674983708e-16, -4.862440216012733e-18,  3.644770964325456e-20,
 -8.119508013152091e-23, -3.580444060385868e-25,  3.554693094066995e-27,  5.940250233935587e-01, -3.107182953542291e-03,  8.223482822400742e-06,  1.106896643610403e-09,
 -1.134788022381146e-10,  4.299162529947619e-13,  2.546086034324759e-16, -9.445612437461168e-18,  3.639807533010904e-20,  3.856480703939294e-23, -9.870954335569213e-25,
  3.695175162497299e-27,  6.820786274726197e-01, -3.418221657658956e-03,  7.663200823583326e-06,  1.068848940791447e-08, -1.424812650137072e-10,  3.165542283464523e-13,
  1.545275539526752e-15, -1.243789725661102e-17,  1.518598762431991e-20,  2.221214006137273e-22, -1.269200002752628e-24, -1.326722053629122e-28,  7.750862077543310e-01,
 -3.696479096620146e-03,  6.609355577904319e-06,  2.146454093219872e-08, -1.571974250291402e-10,  8.208848777071784e-14,  2.912939124018886e-15, -1.136355465330720e-17,
 -2.904049417682424e-20,  3.751157221161148e-22, -5.971112530274101e-25, -7.544106811049121e-27,  8.725710607933512e-01, -3.928615550465791e-03,  5.030940726678174e-06,
  3.245839795738451e-08, -1.496106536151226e-10, -2.613459751175461e-13,  3.863842598772026e-15, -4.226501042588791e-18, -8.332667935992635e-20,  3.428035176418562e-22,
  1.228819227534535e-24, -1.298183475541012e-26,  9.739367353635207e-01, -4.100287863267512e-03,  2.932184911671446e-06,  4.230333913038070e-08, -1.131614818351696e-10,
 -6.593470655297560e-13,  3.779833502008087e-15,  8.829299036799945e-18, -1.162881320625458e-19,  6.440557573359886e-25,  3.276307403277248e-24, -7.115601256449459e-27,
  1.078439816901894e+00, -4.196585707532509e-03,  3.670152489254709e-07,  4.929615886192204e-08, -4.540118492389432e-11, -1.008055496915388e-12,  2.149081020143418e-15,
  2.375939649150118e-17, -8.755909569616558e-20, -5.778486840677636e-22,  3.346568035346160e-24,  1.342443903933589e-26,  1.185158335320016e+00, -4.202794541486105e-03,
 -2.545330266129620e-06,  5.156980986727456e-08,  4.875393753416825e-11, -1.164636867156416e-12, -1.051604029130194e-15,  3.220114171401080e-17,  2.257227290112259e-20,
 -9.889400300540652e-22, -4.227180705742428e-25,  3.230225968637626e-26,  1.292956538329399e+00, -4.105615283560361e-03, -5.606509388641644e-06,  4.743739365216025e-08,
  1.540845285638617e-10, -9.882804496188111e-13, -4.946986218591081e-15,  2.454049225874547e-17,  1.717504684864645e-19, -6.528681291521408e-22, -6.249014005738370e-24,
  1.746233852504188e-26,  1.400448135937794e+00, -3.894977790884659e-03, -8.532787245570186e-06,  3.593842695238581e-08,  2.443509658566938e-10, -4.175352375600301e-13,
 -7.660005453313790e-15, -2.373083614778596e-18,  2.424333789818016e-19,  5.624609543275501e-22, -7.369966927406813e-24, -3.518278748522581e-26,  1.505962363411744e+00,
 -3.566545501765316e-03, -1.096542034782102e-05,  1.754296736484910e-08,  2.866310615905504e-10,  4.353354710198764e-13, -7.000381240961973e-15, -3.632206416749906e-17,
  1.174691031210808e-19,  1.668190083950155e-21,  1.252194606875615e-24, -5.868948841783036e-26,  1.607520538140900e+00, -3.124873598912353e-03, -1.250983371755850e-05,
 -5.188478292632947e-09,  2.532378269093836e-10,  1.237620591455672e-12, -2.151204468013316e-15, -5.045151900211286e-17, -1.583116268318579e-19,  1.100755086255956e-21,
  1.122076559504971e-23,  1.079370194742267e-26,  1.702835092299563e+00, -2.586891724691525e-03, -1.281481212262622e-05, -2.741936407826875e-08,  1.401710873907943e-10,
  1.538498007951227e-12,  4.555883258795243e-15, -2.478543233830690e-17, -3.125334917327742e-19, -9.891399149912436e-22,  5.985893783311396e-24,  7.711859938590731e-26,
  1.789347443500799e+00, -1.984897634772565e-03, -1.169247282448017e-05, -4.292216849000919e-08, -1.703556929288617e-11,  1.070462078942912e-12,  8.127196260467328e-15,
  2.283431880556591e-17, -1.234090687389037e-19, -1.794929184040605e-21, -8.915250727687180e-24,  3.326579297911896e-27,  1.864323201739891e+00, -1.367645964076036e-03,
 -9.254331121070597e-06, -4.641911259594666e-08, -1.478196369870885e-10,  8.516115452397846e-14,  5.273464623289163e-15,  4.211047084057906e-17,  1.788021212336170e-19,
  1.218835653481812e-23, -6.814541118568980e-24, -6.246468502293032e-26,  1.925019147706617e+00, -7.977110165482488e-04, -6.001671118395519e-06, -3.682740758706961e-08,
 -1.850746572635814e-10, -6.874716022594472e-13, -8.771355968631195e-16,  1.384043605831907e-17,  1.650880606232369e-19,  1.141304732399595e-21,  5.341215713962005e-24,
  1.064074903710107e-26,  1.968922076068378e+00, -3.436801658116232e-04, -2.783868061326319e-06, -1.940728150732630e-08, -1.214415706205954e-10, -6.869602615703848e-13,
 -3.455315915663691e-15, -1.460378672549019e-17, -4.205074878099460e-20,  4.098785849114380e-23,  1.891979796270870e-24,  1.911241822872510e-26,  1.994039384369920e+00,
 -6.738498257223761e-05, -5.688401802042708e-07, -4.243744126002979e-09, -2.946642786278667e-11, -1.946860215722874e-13, -1.237335795453974e-15, -7.605936907039769e-18,
 -4.532375694423006e-20, -2.618247539230968e-22, -1.463128865930381e-24, -7.871766809243025e-27,  8.110897120175572e-04, -5.198288231764295e-06,  2.497795603290677e-08,
 -1.066528042357817e-10,  4.266666333639468e-13, -1.637936067320303e-15,  6.107113769522576e-18, -2.229816110806957e-20,  8.000596291353843e-23, -2.835958422876424e-25,
  9.917857896031382e-28, -3.449295839928624e-30,  7.298988663941112e-03, -4.669551027028908e-05,  2.234594091897925e-07, -9.472639241716476e-10,  3.746980146558470e-12,
 -1.415165444207491e-14,  5.159669580381077e-17, -1.828918353378992e-19,  6.315302437587461e-22, -2.132662833505502e-24,  7.013943702330175e-27, -2.262142334922467e-29,
  2.027034476680663e-02, -1.292126365134963e-04,  6.132555654694861e-07, -2.561505345525584e-09,  9.897552346882271e-12, -3.610765255383443e-14,  1.253112999712517e-16,
 -4.147051557028448e-19,  1.301314589105017e-21, -3.842374681397351e-24,  1.035518374815443e-26, -2.446467625675030e-29,  3.971590965461927e-02, -2.517844098617821e-04,
  1.179994293279096e-06, -4.816793816361629e-09,  1.792762842242360e-11, -6.171813548172315e-14,  1.960117925714190e-16, -5.647015524875664e-19,  1.400481117762897e-21,
 -2.551279540000206e-24,  8.589616638688708e-29,  2.882927226789397e-29,  6.562088047131094e-02, -4.129362049422975e-04,  1.902028241142778e-06, -7.517870138161872e-09,
  2.648588957033947e-11, -8.318770791499089e-14,  2.248543409003144e-16, -4.640744196126420e-19,  2.994138970275234e-22,  3.620330376510125e-24, -2.703010670086978e-26,
  1.279352962399253e-28,  9.796373089854975e-02, -6.106514363876601e-04,  2.750349686648706e-06, -1.041162207333341e-08,  3.391410134109981e-11, -9.176920399025217e-14,
  1.743746548974661e-16,  8.997978264404081e-21, -2.199842666573543e-21,  1.367901212355249e-23, -5.849489474818798e-26,  1.903635566131554e-28,  1.367145615169321e-01,
 -8.423273196144868e-04,  3.688516629584786e-06, -1.319434722288630e-08,  3.837801634848533e-11, -7.914668141455887e-14,  1.927575913350561e-17,  8.632512192173992e-19,
 -5.548629988976617e-21,  2.274543452803298e-23, -6.597571138111610e-26,  9.035854592816319e-29,  1.818328846333605e-01, -1.104718442313845e-03,  4.672630900329064e-06,
 -1.552221609594640e-08,  3.803970578871261e-11, -3.909883746805465e-14, -2.422668592023288e-16,  1.940909270102765e-18, -8.333924073289632e-21,  2.284097714798371e-23,
 -1.753303740860567e-26, -2.451492277831816e-28,  2.332647285067654e-01, -1.393867673143161e-03,  5.651428486736626e-06, -1.702593233282015e-08,  3.127487326255265e-11,
  3.065107257547489e-14, -5.786993215862355e-16,  2.897193568903573e-18, -8.499767018779616e-21,  6.068620705583866e-24,  9.822967137993613e-26, -7.089078434355747e-28,
  2.909389091112315e-01, -1.705024211535552e-03,  6.566568985234216e-06, -1.733083033614054e-08,  1.693625992503739e-11,  1.265684061462501e-13, -9.192715826713342e-16,
  3.235596833272017e-18, -4.010151201192028e-21, -3.000799163249954e-23,  2.444753692842635e-25, -9.425264981066724e-28,  3.547622723591439e-01, -2.032549201798877e-03,
  7.353247498104724e-06, -1.608386423237199e-08, -5.341213338313326e-12,  2.377054861828183e-13, -1.155814559589816e-15,  2.419998316795650e-18,  6.052243206778615e-21,
 -7.631635285383732e-23,  3.228551553866057e-25, -4.451014277109201e-28,  4.246136541430560e-01, -2.369810503070681e-03,  7.941301094304832e-06, -1.298904944199629e-08,
 -3.480815847644807e-11,  3.448016683645306e-13, -1.156225546547250e-15,  7.425390950442193e-20,  2.016001849822502e-20, -1.088291902776897e-22,  1.991512601671195e-25,
  1.052934461092935e-27,  5.003362379009261e-01, -2.709070243217602e-03,  8.257045456361796e-06, -7.852773121799043e-09, -6.927327415841286e-11,  4.207120842672212e-13,
 -7.936370261497218e-16, -3.745349000457738e-18,  3.330322217203449e-20, -9.253950647947435e-23, -2.129908058067053e-25,  3.031783862372626e-27,  5.817279087165693e-01,
 -3.041372170965423e-03,  8.226156197334459e-06, -6.397331226019157e-10, -1.048401090781532e-10,  4.329857674625012e-13,  6.594037765755936e-18, -8.265959111444254e-18,
  3.711546039800295e-20,  2.392333845334549e-24, -8.205282727449091e-25,  3.833425003090898e-27,  6.685291103177047e-01, -3.356441264812326e-03,  7.777999627114803e-06,
  8.461335553877296e-09, -1.358072095940590e-10,  3.495236588873644e-13,  1.204950065596080e-15, -1.183378731271648e-17,  2.227106252851161e-20,  1.716640248673649e-22,
 -1.243708830779865e-24,  1.234539962814273e-27,  7.604076121933254e-01, -3.642616562823062e-03,  6.851905299153183e-06,  1.896620485015315e-08, -1.548828128348774e-10,
  1.480881595978780e-13,  2.583743133056109e-15, -1.208200613842649e-17, -1.604066608236934e-20,  3.452059951624575e-22, -8.831215149181985e-25, -5.452513890819467e-27,
  8.569395025480970e-01, -3.886851080380863e-03,  5.405922589282937e-06,  3.002780508622772e-08, -1.539213442719779e-10, -1.703234517541695e-13,  3.710086660662639e-15,
 -6.687124781181646e-18, -7.023768549847924e-20,  3.806513444386529e-22,  6.679960348492151e-25, -1.237749360544337e-26,  9.575856691882814e-01, -4.074831573417122e-03,
  3.428542487407650e-06,  4.039226529213007e-08, -1.254234081158764e-10, -5.660840055761503e-13,  3.975136731650167e-15,  5.133064368572802e-18, -1.139914287274280e-19,
  1.243545987317004e-22,  2.884414238046048e-24, -1.051884824939782e-26,  1.061663073393898e+00, -4.191297231976372e-03,  9.535550064045549e-07,  4.841147368161236e-08,
 -6.499434352685721e-11, -9.488292801235081e-13,  2.772180696737830e-15,  2.065154944194857e-17, -1.058259340570360e-19, -4.339545321564161e-22,  3.803290158827538e-24,
  7.276393982362506e-27,  1.168310367553582e+00, -4.220670349301278e-03, -1.922584431796388e-06,  5.216246727886434e-08,  2.528212944595005e-11, -1.179007102909262e-12,
 -1.452190130243318e-16,  3.235333612906278e-17, -1.299246109545889e-20, -9.775784958167920e-22,  9.820922011763861e-25,  3.111049701700934e-26,  1.276448035423474e+00,
 -4.148149995675327e-03, -5.023141046635889e-06,  4.973841487136213e-08,  1.331904120808120e-10, -1.098164864754597e-12, -4.186775835555060e-15,  2.961390915154399e-17,
  1.439624031657193e-19, -8.842647010348560e-22, -5.244570041922151e-24,  2.791199221397068e-26,  1.384734524410998e+00, -3.961449280489255e-03, -8.078376381819252e-06,
  3.977124152002710e-08,  2.341610799926007e-10, -6.012794815507902e-13, -7.615219891369340e-15,  5.649020846250905e-18,  2.570306924013649e-19,  2.398533809772019e-22,
 -8.675173335795091e-24, -2.349386043176469e-26,  1.491522178806616e+00, -3.653348237746143e-03, -1.072713133058671e-05,  2.218925209756842e-08,  2.935777326542309e-10,
  2.556025834935572e-13, -7.955705944166047e-15, -3.159775628048869e-17,  1.777736024648603e-19,  1.663444173855165e-21, -1.560274106549915e-24, -6.837625821425156e-26,
  1.594820591779024e+00, -3.225130574388300e-03, -1.254697821883688e-05, -9.419490361909775e-10,  2.773567338060427e-10,  1.168507248077261e-12, -3.628192077733965e-15,
 -5.479625634575815e-17, -1.105452808673251e-19,  1.553047266015607e-21,  1.123449950462395e-23, -1.106471083822980e-26,  1.692280461491105e+00, -2.690685848753555e-03,
 -1.312935410898806e-05, -2.492478282029572e-08,  1.719722724794526e-10,  1.638350097129748e-12,  3.716891779634585e-15, -3.530320890370114e-17, -3.429862064653305e-19,
 -6.787600638922699e-22,  9.599581894587833e-24,  8.619617485054448e-26,  1.781217507003267e+00, -2.080500618130906e-03, -1.220843285384116e-05, -4.301265723662557e-08,
  6.373419069905180e-12,  1.272678719499349e-12,  8.701068469190421e-15,  1.778316663164940e-17, -1.943553289188101e-19, -2.142474412355685e-21, -8.296295971437531e-24,
  2.608765808519211e-26,  1.858700964199776e+00, -1.443948761231208e-03, -9.825471552544740e-06, -4.876331189567359e-08, -1.447519399569250e-10,  2.265183589919391e-13,
  6.532319682181268e-15,  4.778092500866537e-17,  1.736340437980041e-19, -3.195330503753209e-22, -9.873999701487919e-24, -7.650058960469129e-26,  1.921729405564682e+00,
 -8.475434930547869e-04, -6.461824225853776e-06, -3.989959834270886e-08, -1.989999600383387e-10, -7.032360521287970e-13, -4.091683791628356e-16,  1.982269853117547e-17,
  2.101184432061248e-19,  1.362599161445471e-21,  5.673169355537426e-24,  3.700484530005051e-27,  1.967501290514794e+00, -3.669167660760951e-04, -3.028882205630968e-06,
 -2.146490775183859e-08, -1.360439510790554e-10, -7.749448427428032e-13, -3.882724576147323e-15, -1.590942464213936e-17, -3.899092278561188e-20,  1.356462469327596e-22,
  2.898660306425053e-24,  2.704768484438097e-26,  1.993760408753277e+00, -7.214772537762308e-05, -6.227278112671451e-07, -4.748045693877474e-09, -3.367524464523011e-11,
 -2.271106967712930e-13, -1.472108696677609e-15, -9.219116748644254e-18, -5.589185221288857e-20, -3.278862885380313e-22, -1.855988010416036e-24, -1.007618656567144e-26,
  7.906882613953827e-04, -5.003470303736610e-06,  2.373802656977592e-08, -1.000804513881815e-10,  3.953245031868003e-13, -1.498577384384032e-15,  5.517126025447533e-18,
 -1.989395209123818e-20,  7.047548699772759e-23, -2.468002472357628e-25,  8.517726206918850e-28, -2.930215263945542e-30,  7.115711392369511e-03, -4.495230556839909e-05,
  2.124428253858889e-07, -8.895109253814395e-10,  3.475926973924621e-12, -1.297257083822093e-14,  4.674748304847786e-17, -1.638590227881559e-19,  5.595732915775239e-22,
 -1.871058409883138e-24,  6.088964185513350e-27, -1.950530788714482e-29,  1.976311536500808e-02, -1.244269059533443e-04,  5.834443540256947e-07, -2.408762191392879e-09,
  9.204557243341237e-12, -3.323494173943431e-14,  1.142623075361567e-16, -3.751984263672364e-19,  1.170190551927792e-21, -3.449131667277212e-24,  9.320904352652988e-27,
 -2.255217038006959e-29,  3.872729261012046e-02, -2.425708774810816e-04,  1.123873899323642e-06, -4.539576349837639e-09,  1.673905361222371e-11, -5.719861282545599e-14,
  1.808137754431556e-16, -5.213527059423972e-19,  1.308978971019068e-21, -2.525040711686998e-24,  1.166143942375181e-27,  2.059753477973107e-29,  6.399900675151596e-02,
 -3.980737571800237e-04,  1.814302478759709e-06, -7.107117125280983e-09,  2.487505401323601e-11, -7.794593682647719e-14,  2.120125618406838e-16, -4.526059319764905e-19,
  4.115793451253079e-22,  2.645017439536149e-24, -2.189471002204465e-26,  1.060731675166130e-28,  9.556435230567813e-02, -5.891393101304499e-04,  2.628606144283305e-06,
 -9.883452191744559e-09,  3.212054834858762e-11, -8.758870431069325e-14,  1.737119730946458e-16, -5.395344454012636e-20, -1.747552381769291e-21,  1.150054533644066e-23,
 -5.058056852269741e-26,  1.694856352692085e-28,  1.334032803129607e-01, -8.134421965243440e-04,  3.533816618697397e-06, -1.259292942805469e-08,  3.680156620832628e-11,
 -7.841333603940790e-14,  4.108052050954514e-17,  6.982951641713697e-19, -4.776295302228452e-21,  2.019056151769020e-23, -6.166883377283235e-26,  1.040040192575461e-28,
  1.774876077965038e-01, -1.068072176076995e-03,  4.489989339568387e-06, -1.492013458834301e-08,  3.720383443590839e-11, -4.429047759553935e-14, -1.915324621859022e-16,
  1.687225125161244e-18, -7.526649247446002e-21,  2.194815223444596e-23, -2.654178755932259e-26, -1.673358504924540e-28,  2.277783987640878e-01, -1.349464941414130e-03,
  5.450137545894779e-06, -1.652135778176092e-08,  3.175541981886813e-11,  1.770523824919110e-14, -5.013478895320445e-16,  2.629396142524250e-18, -8.217744207493456e-21,
  9.411596044681737e-24,  6.982556510357004e-26, -5.844737814256762e-28,  2.842225669732891e-01, -1.653318748099379e-03,  6.360304637807956e-06, -1.704076743263959e-08,
  1.925426226356239e-11,  1.055776152952462e-13, -8.306208305935025e-16,  3.091794778433134e-18, -4.924233925731195e-21, -2.103866321339840e-23,  2.045124958843703e-25,
 -8.710921072735217e-28,  3.467485035513787e-01, -1.974496348471075e-03,  7.159880438123588e-06, -1.613277454970651e-08, -8.589078996427387e-13,  2.107984906205577e-13,
 -1.085738691783922e-15,  2.572163193337407e-18,  3.532166913505570e-21, -6.383937262324685e-23,  2.999884648308940e-25, -5.833711646098435e-28,  4.152604730928455e-01,
 -2.306912522196894e-03,  7.782313607980204e-06, -1.349231745617125e-08, -2.818908923695440e-11,  3.171465401538809e-13, -1.145692286302728e-15,  6.583088317029155e-19,
  1.639549301754326e-20, -1.000703373564387e-22,  2.356309148404544e-25,  6.189926416929996e-28,  4.896314470780948e-01, -2.643409022416810e-03,  8.156436169938247e-06,
 -8.894900006630020e-09, -6.105739069656523e-11,  4.005236520900001e-13, -8.840980371242333e-16, -2.734341563433874e-18,  2.984914131486137e-20, -9.855098119700687e-23,
 -9.154548476410537e-26,  2.488279715258431e-27,  5.696939505208549e-01, -2.975621487272949e-03,  8.208700338647782e-06, -2.247964824920094e-09, -9.619686520217817e-11,
  4.305007328821623e-13, -2.082553964947510e-16, -7.082891378900582e-18,  3.665137136829394e-20, -2.706735701527292e-23, -6.531181598273661e-25,  3.743509507760101e-27,
  6.552283848766528e-01, -3.293847522318716e-03,  7.866733632784433e-06,  6.345804101672902e-09, -1.285539482377820e-10,  3.745522100485909e-13,  8.844427629262448e-16,
 -1.103171006117984e-17,  2.757159472225674e-20,  1.233273418762290e-22, -1.165701109320568e-24,  2.254078129136084e-27,  7.459481587070298e-01, -3.586932824313425e-03,
  7.064739342765903e-06,  1.651502723171336e-08, -1.513286052441560e-10,  2.059916659205633e-13,  2.240077852532738e-15, -1.240371920139743e-17, -4.301362632936664e-21,
  3.056913376433004e-22, -1.077763215366066e-24, -3.415946505453057e-27,  8.414808156932516e-01, -3.842204459421945e-03,  5.751382874607336e-06,  2.754258171155103e-08,
 -1.564538171906388e-10, -8.376940496098498e-14,  3.493471460061913e-15, -8.711364362250427e-18, -5.618150991840710e-20,  3.968196862914587e-22,  1.499590011092487e-25,
 -1.107144491855294e-26,  9.413442201322355e-01, -4.045499346508478e-03,  3.900852315068301e-06,  3.830014241123610e-08, -1.357815235156002e-10, -4.693632980324137e-13,
  4.068620664491328e-15,  1.578282664681984e-18, -1.075564209477730e-19,  2.297230111100720e-22,  2.367517882995731e-24, -1.278228694206584e-26,  1.044916793789554e+00,
 -4.181364137436946e-03,  1.527639236204183e-06,  4.722355596768100e-08, -8.326080311123976e-11, -8.757540612266331e-13,  3.300877917776495e-15,  1.704503889930965e-17,
 -1.186495660977479e-19, -2.772623805851673e-22,  3.986042538344797e-24,  1.069094385157826e-27,  1.151400896498898e+00, -4.233542141383870e-03, -1.294985659478479e-06,
  5.237845759319560e-08,  1.740132594898627e-12, -1.171700800761113e-12,  7.496324325574331e-16,  3.138469945004550e-17, -4.715639162571078e-20, -9.118420462068599e-22,
  2.277568807470537e-24,  2.738885104996229e-26,  1.259778894205022e+00, -4.185913155587103e-03, -4.414235470358838e-06,  5.168858643022080e-08,  1.102920134097602e-10,
 -1.188207442545696e-12, -3.298150820649017e-15,  3.367344356606781e-17,  1.086728635940943e-19, -1.066875081387293e-21, -3.826186928610236e-24,  3.610262023008200e-26,
  1.368762584513315e+00, -4.024104558262854e-03, -7.579070843676038e-06,  4.341175441449243e-08,  2.203254779449443e-10, -7.812117263904125e-13, -7.341087444326326e-15,
  1.394341349417728e-17,  2.592083329587089e-19, -1.235936018824124e-22, -9.387191657844226e-24, -8.416438639298136e-27,  1.476738951296913e+00, -3.738020031475703e-03,
 -1.043254254282220e-05,  2.691672945067410e-08,  2.967123061805538e-10,  5.474637844812974e-14, -8.751918490839936e-15, -2.496889543347676e-17,  2.357931843143534e-19,
  1.539198791812762e-21, -4.681748076462376e-24, -7.243651659977962e-26,  1.581719355046607e+00, -3.325474429884870e-03, -1.253090091269304e-05,  3.677460541735030e-09,
  2.997299993045094e-10,  1.062674093984159e-12, -5.202995794903489e-15, -5.735381653188117e-17, -4.673202938857493e-20,  1.985170033805526e-21,  1.017862836554609e-23,
 -3.752691882869836e-26,  1.681305823504982e+00, -2.796867774721181e-03, -1.341084612605583e-05, -2.190660227973486e-08,  2.055447654800645e-10,  1.714433640085227e-12,
  2.571642399977367e-15, -4.658812542167047e-17, -3.595842589896044e-19, -2.177714324712774e-22,  1.346277432498731e-23,  8.791802213160294e-26,  1.772696905734790e+00,
 -2.180228945965990e-03, -1.272309574108003e-05, -4.269555202601249e-08,  3.395163944481043e-11,  1.486703225391379e-12,  9.099889666668998e-15,  1.026842293058128e-17,
 -2.771052591123986e-19, -2.442928199125728e-21, -6.503506057736408e-24,  5.667945580303579e-26,  1.852764200540025e+00, -1.524932143196872e-03, -1.042434911717708e-05,
 -5.103411584653593e-08, -1.385422596095776e-10,  3.999627612846925e-13,  7.945661578071324e-15,  5.307012023456880e-17,  1.541753011365965e-19, -7.856249642675237e-22,
 -1.351956238400015e-23, -8.866281284877537e-26,  1.918232732206950e+00, -9.012084669619881e-04, -6.960188716419424e-06, -4.319644604979267e-08, -2.131137988606191e-10,
 -7.055889823111931e-13,  2.476878374090531e-16,  2.737527834479032e-17,  2.632676091780524e-19,  1.589583138376940e-21,  5.585375590927458e-24, -8.783774472955792e-27,
  1.965983476165978e+00, -3.922163548205473e-04, -3.300049601980821e-06, -2.377081914498821e-08, -1.525114908138631e-10, -8.736114174746781e-13, -4.344748421936550e-15,
 -1.705412538916585e-17, -3.170753858235211e-20,  2.783223792724674e-22,  4.313092215644884e-24,  3.776149542222393e-26,  1.993461479952630e+00, -7.736697185857553e-05,
 -6.830935432027147e-07, -5.325198496401434e-09, -3.859276635194881e-11, -2.657524750449061e-13, -1.757165436466099e-15, -1.121175979621460e-17, -6.914594819216544e-20,
 -4.117744529608815e-22, -2.358984590681493e-24, -1.290223429555091e-26,  7.710467313504614e-04, -4.818264656598706e-06,  2.257404604202098e-08, -9.398802229480484e-11,
  3.666332293069733e-13, -1.372603868876133e-15,  4.990378163013612e-18, -1.777456185044255e-20,  6.217410803398265e-23, -2.151744463200454e-25,  7.326794856577506e-28,
 -2.495845453658835e-30,  6.939234961720306e-03, -4.329453336745588e-05,  2.020940146590495e-07, -8.359122707300569e-10,  3.227333520012087e-12, -1.190372505862784e-14,
  4.240031873336350e-17, -1.469850297701428e-19,  4.963998616195731e-22, -1.643852184840320e-24,  5.290669333694543e-27, -1.685134313718365e-29,  1.927456325407788e-02,
 -1.198725176332658e-04,  5.554013832272233e-07, -2.266661365334253e-09,  8.566451803201961e-12, -3.061459382750738e-14,  1.042628322085722e-16, -3.396689789233369e-19,
  1.052498759823311e-21, -3.095588958448701e-24,  8.369758579869690e-27, -2.069566092997708e-29,  3.777465238985330e-02, -2.337933183630384e-04,  1.070968931586516e-06,
 -4.280672368123953e-09,  1.563731834096516e-11, -5.302960708554655e-14,  1.667887305790878e-16, -4.809091501399509e-19,  1.219116945493286e-21, -2.462289094078887e-24,
  1.924301231713587e-27,  1.411974913132682e-29,  6.243520981960823e-02, -3.838938296602010e-04,  1.731354517957977e-06, -6.721315427544375e-09,  2.336599982495038e-11,
 -7.300814050415208e-14,  1.995371442149890e-16, -4.380721059849374e-19,  4.921083559916142e-22,  1.856881574094199e-24, -1.764741063507206e-26,  8.748504173175840e-29,
  9.324911378171130e-02, -5.685762615583742e-04,  2.513031214171668e-06, -9.383311713004525e-09,  3.041031168491701e-11, -8.344369551515461e-14,  1.714779128985952e-16,
 -1.036270604269283e-19, -1.368207972630912e-21,  9.620505490660014e-24, -4.356715239825978e-26,  1.494818948374386e-28,  1.302051095052642e-01, -7.857662329697679e-04,
  3.386182854073558e-06, -1.201659058800989e-08,  3.524465607523779e-11, -7.720939263365251e-14,  5.859893445649503e-17,  5.566164926782720e-19, -4.092711969141518e-21,
  1.781763375507671e-23, -5.693235981113250e-26,  1.102392679998844e-28,  1.732860391869654e-01, -1.032858377244122e-03,  4.314489294595406e-06, -1.433219389010965e-08,
  3.627574613198379e-11, -4.834684298694119e-14, -1.475448526648167e-16,  1.458796345155064e-18, -6.757224480402157e-21,  2.075830807620082e-23, -3.250648146227330e-26,
 -1.063423675952449e-28,  2.224664978003352e-01, -1.306648205959644e-03,  5.254939407698020e-06, -1.601106748276047e-08,  3.199501238240044e-11,  6.526981773008681e-15,
 -4.313518495652281e-16,  2.372340181598093e-18, -7.834543549566407e-21,  1.172374117495338e-23,  4.658316371043542e-26, -4.744384742426571e-28,  2.777097693532981e-01,
 -1.603248877088591e-03,  6.157730090111412e-06, -1.671686084242593e-08,  2.117338296653730e-11,  8.666310716369474e-14, -7.463596656700404e-16,  2.923606322314060e-18,
 -5.543395062663497e-21, -1.360055519439218e-23,  1.680077526583335e-25, -7.867958384607777e-28,  3.389638502348203e-01, -1.917991600429681e-03,  6.966339296614865e-06,
 -1.611418043046607e-08,  3.102375588137044e-12,  1.856157391374079e-13, -1.012464998158710e-15,  2.650685061193774e-18,  1.443501331548780e-21, -5.238030513604467e-23,
  2.723903262695739e-25, -6.624753022845408e-28,  4.061563044044264e-01, -2.245308839611485e-03,  7.617904142851553e-06, -1.389408612853579e-08, -2.211933902397007e-11,
  2.899271406442984e-13, -1.120442794010665e-15,  1.127189777946438e-18,  1.296817260188604e-20, -9.020976168767583e-23,  2.548364363008344e-25,  2.672219580034198e-28,
  4.791876153017740e-01, -2.578600494683514e-03,  8.044096404988963e-06, -9.808911468536952e-09, -5.326475883609923e-11,  3.784911965889149e-13, -9.478243884285262e-16,
 -1.836436462020459e-18,  2.626033940591139e-20, -1.001808705831538e-22,  6.193871379970274e-27,  1.959076725467762e-27,  5.579225968523628e-01, -2.910085300151050e-03,
  8.172772933973350e-06, -3.718571173902874e-09, -8.765221534823981e-11,  4.232542104978935e-13, -3.903371288766392e-16, -5.930361910501088e-18,  3.524581808865969e-20,
 -4.996353745909522e-23, -4.935774658512344e-25,  3.485368083801735e-27,  6.421792962013126e-01, -3.230643445035067e-03,  7.930792760787990e-06,  4.349919418075344e-09,
 -1.208751261812953e-10,  3.921756663466829e-13,  5.885114355726920e-16, -1.008717379643989e-17,  3.119806390001066e-20,  7.890749927647965e-23, -1.050318757792420e-24,
  2.937307690038892e-27,  7.317146607071433e-01, -3.529663018146473e-03,  7.248537216990415e-06,  1.412953103988810e-08, -1.466993232149691e-10,  2.555801953974716e-13,
  1.892440250287601e-15, -1.237386497992882e-17,  5.896457808623583e-21,  2.601366237244985e-22, -1.186480216611343e-24, -1.564856411650913e-27,  8.262060530083912e-01,
 -3.794914006100003e-03,  6.066833522282732e-06,  2.503038660062605e-08, -1.573115233441094e-10, -3.043042542342920e-15,  3.226534407794199e-15, -1.028037039633062e-17,
 -4.190093819881834e-20,  3.935745141372779e-22, -2.991540039513150e-25, -9.281335322639141e-27,  9.252274941568347e-01, -4.012491732642912e-03,  4.347126428258822e-06,
  3.605785352076658e-08, -1.441907162686716e-10, -3.715667558981560e-13,  4.065994370604058e-15, -1.714051094771024e-18, -9.772116430600361e-20,  3.127698146609294e-22,
  1.776858845754936e-24, -1.387707336544044e-26,  1.028219334766851e+00, -4.166900242206556e-03,  2.085765240503711e-06,  4.575572125550658e-08, -9.994726793917122e-11,
 -7.912430172993457e-13,  3.723702866271373e-15,  1.311930920531602e-17, -1.257655989496948e-19, -1.186138331735652e-22,  3.904733063539659e-24, -4.642563238493659e-27,
  1.134449987255502e+00, -4.241389160543912e-03, -6.670464635528231e-07,  5.222010043999538e-08, -2.144379863616770e-11, -1.143364527064712e-12,  1.602481628279665e-15,
  2.937032238892027e-17, -7.806650673643108e-20, -7.982099987250577e-22,  3.361849441667680e-24,  2.160788681131479e-26,  1.242968582085457e+00, -4.218717820172277e-03,
 -3.784181656288964e-06,  5.325917184207046e-08,  8.581455642231223e-11, -1.255692289742807e-12, -2.312574943824586e-15,  3.651013254469674e-17,  6.790954837564213e-20,
 -1.186420333220572e-21, -2.114429230131705e-24,  4.112567930125096e-26,  1.352548283402077e+00, -4.082594681178633e-03, -7.037524750188473e-06,  4.680254493352075e-08,
  2.029758232535461e-10, -9.517822554915607e-13, -6.835734851549572e-15,  2.209398966856661e-17,  2.479556165446775e-19, -5.015615027152532e-22, -9.387061806721900e-24,
  8.598455023065108e-27,  1.461622110114238e+00, -3.820107655104716e-03, -1.008105885467544e-05,  3.166125154606873e-08,  2.956547624238795e-10, -1.627868325899061e-13,
 -9.337375825514921e-15, -1.657930169816115e-17,  2.870676053979898e-19,  1.288537602558049e-21, -7.828908965614476e-24, -6.934867513356415e-26,  1.568217359566541e+00,
 -3.425462024055854e-03, -1.245731941611731e-05,  8.635835503165432e-09,  3.196041005751105e-10,  9.184310844272918e-13, -6.818555796346159e-15, -5.763093432353296e-17,
  3.158857904821043e-20,  2.350906655916870e-21,  7.898923597236550e-24, -6.620529293854556e-26,  1.669902196355869e+00, -2.905147527033916e-03, -1.365285193539674e-05,
 -1.834069019483215e-08,  2.403382340710873e-10,  1.759195848612344e-12,  1.105686966190257e-15, -5.810884679804497e-17, -3.568128898812502e-19,  3.963675632685575e-22,
  1.717983135650273e-23,  7.903878818256511e-26,  1.763769191671512e+00, -2.284051526254341e-03, -1.323116312454226e-05, -4.190250835195834e-08,  6.588743676403257e-11,
  1.707465830583235e-12,  9.249714596599182e-15, -5.077361053048801e-20, -3.690361678619353e-19, -2.642553747059780e-21, -3.202978183011648e-24,  9.436886934199724e-26,
  1.846493751477758e+00, -1.610813579382731e-03, -1.104975962256323e-05, -5.317592193104225e-08, -1.285129264476943e-10,  6.090176408947216e-13,  9.495654553886879e-15,
  5.743904564449361e-17,  1.151943401109115e-19, -1.406995246800203e-21, -1.760006829090031e-23, -9.560523870460589e-26,  1.914513169144347e+00, -9.590224420880392e-04,
 -7.499468881378868e-06, -4.671855965189229e-08, -2.270988964323260e-10, -6.894400118015519e-13,  1.141043890586576e-15,  3.675749767884245e-17,  3.243734783127405e-19,
  1.799933021530825e-21,  4.784009015917874e-24, -2.916423012869664e-26,  1.964359943008321e+00, -4.198005995928921e-04, -3.600535918885641e-06, -2.635661066386929e-08,
 -1.710656861977127e-10, -9.837196869811081e-13, -4.834705296947597e-15, -1.787167735220796e-17, -1.814699501968367e-20,  4.879832476884299e-22,  6.273510338633241e-24,
  5.199261962056279e-26,  1.993140662481808e+00, -8.309824634375244e-05, -7.508839524949095e-07, -5.987605914114286e-09, -4.435631661567910e-11, -3.119560054920252e-13,
 -2.104437175549589e-15, -1.368099264677227e-17, -8.581410350676924e-20, -5.184871240300532e-22, -3.002910394661886e-24, -1.651091445850567e-26,  7.521278524597585e-04,
 -4.642086033997696e-06,  2.148050127248963e-08, -8.833516505053913e-11,  3.403396622385859e-13, -1.258589184700975e-15,  4.519419023504632e-18, -1.590348261085742e-20,
  5.492991713187985e-23, -1.879518840218192e-25,  6.310950021319068e-28, -2.132323347788582e-30,  6.769228019037637e-03, -4.171704494572600e-05,  1.923652103214833e-07,
 -7.861256080935335e-10,  2.999110783173792e-12, -1.093376265309477e-14,  3.849851151479889e-17, -1.320076574959559e-19,  4.408581137379809e-22, -1.446363584310749e-24,
  4.600187223772344e-27, -1.459515806620380e-29,  1.880379056867197e-02, -1.155358219047420e-04,  5.290040523171241e-07, -2.134363679235929e-09,  7.978431877546440e-12,
 -2.822270950097415e-14,  9.520731742610541e-17, -3.077092129289874e-19,  9.468691139022359e-22, -2.778486782191810e-24,  7.498090864155601e-27, -1.894702725639174e-29,
  3.685629518841810e-02, -2.254268650478073e-04,  1.021067738383919e-06, -4.038747019285255e-09,  1.461568722995727e-11, -4.918393604539868e-14,  1.538562253311032e-16,
 -4.432997125722626e-19,  1.131995113481869e-21, -2.374482639413660e-24,  2.428861946402836e-27,  9.012620367869812e-30,  6.092683418162226e-02, -3.703593704075742e-04,
  1.652894514966374e-06, -6.358884674076972e-09,  2.195274182341905e-11, -6.836460472931852e-14,  1.875007100839636e-16, -4.213840766689369e-19,  5.471332711664272e-22,
  1.223135372774436e-24, -1.415491420982204e-26,  7.168624574435353e-29,  9.101431561537651e-02, -5.489142645893485e-04,  2.403296512119920e-06, -8.909875181686852e-09,
  2.878233319367230e-11, -7.936768343403223e-14,  1.680131391200551e-16, -1.421921166466637e-19, -1.051704463118610e-21,  8.003731186391041e-24, -3.740867771516505e-26,
  1.306577727409395e-28,  1.271153236180421e-01, -7.592440967755256e-04,  3.245316557177437e-06, -1.146494814044549e-08,  3.371572034703515e-11, -7.563021710392968e-14,
  7.244401192520613e-17,  4.354826768394613e-19, -3.491093760339434e-21,  1.563790770754594e-23, -5.204885668688085e-26,  1.109603438116050e-28,  1.692225620914736e-01,
 -9.990206158611435e-04,  4.145952944304025e-06, -1.375969638846721e-08,  3.527658367550822e-11, -5.142151668019137e-14, -1.096152853264764e-16,  1.254262744024024e-18,
 -6.034322066287040e-21,  1.937917487307749e-23, -3.611011377571397e-26, -5.961545029418371e-29,  2.173227794605868e-01, -1.265368512917190e-03,  5.065880665364863e-06,
 -1.549864337026300e-08,  3.202726332808695e-11, -3.056284167490156e-15, -3.683704149755911e-16,  2.128708214798672e-18, -7.383713141825900e-21,  1.319865243111917e-23,
  2.785556817861781e-26, -3.792619968811185e-28,  2.713940353414150e-01, -1.554783560986508e-03,  5.959214524963546e-06, -1.636516640406976e-08,  2.273404417798604e-11,
  6.971235431011493e-14, -6.670468732183520e-16,  2.739614627810581e-18, -5.920154733736542e-21, -7.546455551052370e-24,  1.353492780567175e-25, -6.973604942735678e-28,
  3.314021221367690e-01, -1.863033249187357e-03,  6.773385258369865e-06, -1.603613885030847e-08,  6.577730376617081e-12,  1.622107604390602e-13, -9.378679520255678e-16,
  2.668751067537676e-18, -2.532145347583942e-22, -4.208037721367236e-23,  2.423645997042188e-25, -6.958203228754301e-28,  3.972958916370196e-01, -2.185038107809624e-03,
  7.449238303194199e-06, -1.420305673105043e-08, -1.658691614196012e-11,  2.634592123363015e-13, -1.083545820746450e-15,  1.492195548835857e-18,  9.906142315216436e-21,
 -7.986737684122309e-23,  2.602819255240038e-25, -7.633865250150006e-30,  4.690011536828641e-01, -2.514732472011852e-03,  7.921521807347935e-06, -1.060184079857358e-08,
 -4.592610116415295e-11,  3.552179993055244e-13, -9.880208825984840e-16, -1.053602271523358e-18,  2.267770969888326e-20, -9.835697632562795e-23,  8.142495629314927e-26,
  1.468340571251003e-27,  5.464127045925473e-01, -2.844904809729780e-03,  8.120013017418144e-06, -5.053849132068380e-09, -7.929361096136446e-11,  4.120191757801719e-13,
 -5.408929970405508e-16, -4.834791197019030e-18,  3.312779077030163e-20, -6.674222600096935e-23, -3.480633703903636e-25,  3.114544704660638e-27,  6.293839000748015e-01,
 -3.167020584226544e-03,  7.971648846069596e-06,  2.479338955247878e-09, -1.129126546874629e-10,  4.030258039032073e-13,  3.204180453883223e-16, -9.051232368333475e-18,
  3.331489421247356e-20,  3.961196259043897e-23, -9.116966630495008e-25,  3.317195483726078e-27,  7.177130032735162e-01, -3.471036001204803e-03,  7.404184810326788e-06,
  1.182558513378422e-08, -1.411614518616692e-10,  2.968707872829149e-13,  1.549955565064097e-15, -1.204460441936364e-17,  1.439498308267204e-20,  2.117866675503560e-22,
 -1.219521479433938e-24,  1.280952230501758e-29,  8.111253082498349e-01, -3.745220645885869e-03,  6.352107602111436e-06,  2.251702231284733e-08, -1.566220596690196e-10,
  7.080105516171307e-14,  2.922021522350853e-15, -1.139757454770879e-17, -2.804069292668771e-20,  3.740335861131656e-22, -6.629007065362156e-25, -7.226168699032320e-27,
  9.092497655753913e-01, -3.976023694563390e-03,  4.765750242857798e-06,  3.369663089888857e-08, -1.506518805789022e-10, -2.749013071958258e-13,  3.976005417754127e-15,
 -4.648455971098797e-18, -8.533010072608458e-20,  3.715552416355902e-22,  1.162349231133452e-24, -1.388854721947765e-26,  1.011588543551742e+00, -4.148046201874620e-03,
  2.624732787851601e-06,  4.403493846822834e-08, -1.148510481662840e-10, -6.979237084285479e-13,  4.034270753901361e-15,  9.056143090399623e-18, -1.272871775111158e-19,
  3.200505256064732e-23,  3.591417419137909e-24, -9.415046920411057e-27,  1.117477716090590e+00, -4.244226523115922e-03, -4.321096361547488e-08,  5.169642516972688e-08,
 -4.386144975323503e-11, -1.095344408069611e-12,  2.385752166442919e-15,  2.644011818334027e-17, -1.041707830777821e-19, -6.467554477660399e-22,  4.158596179449547e-24,
  1.444214725105845e-26,  1.226037242009153e+00, -4.246413418117451e-03, -3.137670962771875e-06,  5.442862986468302e-08,  6.022959740436691e-11, -1.298721083098119e-12,
 -1.266384310238266e-15,  3.798712130818663e-17,  2.411869614634778e-20, -1.234138837041177e-21, -2.618016078857681e-25,  4.245560912694777e-26,  1.336108937238518e+00,
 -4.136594651111835e-03, -6.457064969363123e-06,  4.988918537331514e-08,  1.823542645836781e-10, -1.107538954762703e-12, -6.109244349512127e-15,  2.966824768010173e-17,
  2.232783770492915e-19, -8.643805627600924e-22, -8.629023406889474e-24,  2.571088382332425e-26,  1.446182901911954e+00, -3.899156295020677e-03, -9.672888244465678e-06,
  3.635336728062621e-08,  2.901259919837810e-10, -3.913759053908203e-13, -9.666481181605670e-15, -6.717200704048857e-18,  3.271058835324145e-19,  9.170052374614925e-22,
 -1.066784861774220e-23, -5.838912364541600e-26,  1.554316975175594e+00, -3.524617791428819e-03, -1.232243152541030e-05,  1.388701311936009e-08,  3.362064915438976e-10,
  7.356162060617979e-13, -8.404947875302204e-15, -5.521119609672880e-17,  1.211304877168549e-19,  2.600301843625218e-21,  4.370523286925174e-24, -9.364044272554620e-26,
  1.658061862547962e+00, -3.015182643141706e-03, -1.384870357452423e-05, -1.421294149044882e-08,  2.756491306768363e-10,  1.764935617291683e-12, -6.780842960068065e-16,
 -6.915943035554610e-17, -3.293843019892036e-19,  1.147616498874945e-21,  2.022104566218940e-23,  5.683162044051101e-26,  1.754418131186994e+00, -2.391891556660972e-03,
 -1.372650209417963e-05, -4.056307882711320e-08,  1.022492976313173e-10,  1.928018914718030e-12,  9.068537548726860e-15, -1.339791968079797e-17, -4.653625954908369e-19,
 -2.675394493819969e-21,  1.869106255586608e-24,  1.366021160530669e-25,  1.839869611612388e+00, -1.701798047234919e-03, -1.169976435464948e-05, -5.512174993301704e-08,
 -1.139214089847482e-10,  8.565775480149954e-13,  1.114692376597277e-14,  6.017071699218755e-17,  5.085495505583611e-20, -2.195150832141890e-21, -2.178623454155130e-23,
 -9.255769860496628e-26,  1.910553448690145e+00, -1.021323491358368e-03, -8.082342293263437e-06, -5.046059266246021e-08, -2.405241595835488e-10, -6.484703821657364e-13,
  2.325560823844388e-15,  4.820815421669385e-17,  3.922325014625848e-19,  1.957358752801368e-21,  2.861248447670846e-24, -6.024655264120229e-26,  1.962621061219608e+00,
 -4.499180711847409e-04, -3.933907696745956e-06, -2.925753234180112e-08, -1.919412057431085e-10, -1.105805037139756e-12, -5.340228475037696e-15, -1.811809685524404e-17,
  4.534641376505863e-21,  7.897914028021255e-22,  8.951684719355389e-24,  7.050957268330516e-26,  1.992795782613883e+00, -8.940528063771480e-05, -8.272085797738001e-07,
 -6.750100181993758e-09, -5.113321015635603e-11, -3.673877273659180e-13, -2.528929615577528e-15, -1.675037060524274e-17, -1.068282512958106e-19, -6.544035585652083e-22,
 -3.826233240387931e-24, -2.108926512171767e-26,  7.338966110871330e-04, -4.474391414856540e-06,  2.045233991537184e-08, -8.308535930789371e-11,  3.162174706314461e-13,
 -1.155274153996600e-15,  4.097746618209082e-18, -1.424929134042173e-20,  4.859628441439184e-23, -1.644911101222479e-25,  5.441550686613897e-28, -1.828564691899747e-30,
  6.605379067224327e-03, -4.021505783349427e-05,  1.832125606278459e-07, -7.398402641645939e-10,  2.789383818627610e-12, -1.005260567931130e-14,  3.499221991433653e-17,
 -1.186990104259718e-19,  3.919517694077454e-22, -1.274613969620214e-24,  4.001202850809561e-27, -1.268477267063743e-29,  1.834995214240860e-02, -1.114041109155571e-04,
  5.041393849355881e-07, -2.011103121329242e-09,  7.436146869512793e-12, -2.603779069346384e-14,  8.700102305036943e-17, -2.789535259422114e-19,  8.520457179538566e-22,
 -2.494753726560434e-24,  6.700211994147162e-27, -1.734808929954782e-29,  3.597062338274359e-02, -2.174482810075045e-04,  9.739740572614513e-07, -3.812568972430365e-09,
  1.366794942143205e-11, -4.563632034317478e-14,  1.419382542877589e-16, -4.084241212700969e-19,  1.048346484474813e-21, -2.270658187643143e-24,  2.732815158541903e-27,
  4.951527271791549e-30,  5.947136803182328e-02, -3.574355719518862e-04,  1.578651022582081e-06, -6.018338616231238e-09,  2.062950458389654e-11, -6.400415737551934e-14,
  1.759529466682760e-16, -4.032746418870738e-19,  5.816969892190085e-22,  7.159044559547105e-25, -1.130467987588547e-26,  5.821720871126197e-29,  8.885644504584686e-02,
 -5.301078569289398e-04,  2.299089437086538e-06, -8.461839009582376e-09,  2.723496162545834e-11, -7.538669142608554e-14,  1.636019170467873e-16, -1.715143766826771e-19,
 -7.891669049174257e-22,  6.617108400571558e-24, -3.205015299395333e-26,  1.131249486486042e-28,  1.241294137558670e-01, -7.338228254774145e-04,  3.110924289500924e-06,
 -1.093749905743694e-08,  3.222142715679436e-11, -7.375735638409549e-14,  8.315533958734705e-17,  3.323828051794194e-19, -2.964433829916589e-21,  1.365286663875195e-23,
 -4.722775326076973e-26,  1.076050317551077e-28,  1.652917825802724e-01, -9.665039415342486e-04,  3.984188770157970e-06, -1.320362987449076e-08,  3.422458027073518e-11,
 -5.365203680686931e-14, -7.709643856196375e-17,  1.072043617247681e-18, -5.363201410918196e-21,  1.789332989108547e-23, -3.792946675444516e-26, -2.489380344853801e-29,
  2.123411938912012e-01, -1.225576698728125e-03,  4.882968043285040e-06, -1.498715672686228e-08,  3.188242055708998e-11, -1.120818172543044e-14, -3.120017058165289e-16,
  1.900215724090479e-18, -6.892300075073885e-21,  1.400388002491302e-23,  1.299253291454676e-26, -2.986947214340945e-28,  2.652690136398355e-01, -1.507889088674710e-03,
  5.765058259233062e-06, -1.599111185652498e-08,  2.397430189086313e-11,  5.460211746360247e-14, -5.930236246015187e-16,  2.546809376866280e-18, -6.101530258825522e-21,
 -2.719813247833996e-24,  1.066302401990748e-25, -6.085382693302792e-28,  3.240571473986644e-01, -1.809613873901803e-03,  6.581686221172058e-06, -1.590613904966600e-08,
  9.602899571200227e-12,  1.405963799721864e-13, -8.634711091871861e-16,  2.638220915902542e-18, -1.601005718961183e-21, -3.300006865658796e-23,  2.116550036058621e-25,
 -6.954131674331732e-28,  3.886738417334425e-01, -2.126130068397120e-03,  7.277378624948101e-06, -1.442769204226144e-08, -1.157422447911563e-11,  2.379887259939069e-13,
 -1.037744333553272e-15,  1.765193209398860e-18,  7.217635165952444e-21, -6.952818730442725e-23,  2.551761304492311e-25, -2.139412409563899e-28,  4.590681454694697e-01,
 -2.451881146294021e-03,  7.790121058586885e-06, -1.128112051317022e-08, -3.906084575096196e-11,  3.312302440656701e-13, -1.007889266255418e-15, -3.838222451206778e-19,
  1.920983679925574e-20, -9.394080289940132e-23,  1.361964416367468e-25,  1.030836526323256e-27,  5.351625918402719e-01, -2.780208236744114e-03,  8.052024168466660e-06,
 -6.257373065167841e-09, -7.119339772928386e-11,  3.975307344197304e-13, -6.618047504104792e-16, -3.815571821314122e-18,  3.050636043808091e-20, -7.804890042099804e-23,
 -2.204468927412194e-25,  2.679023449607370e-27,  6.168435100013058e-01, -3.103158482535351e-03,  7.990828418967646e-06,  7.375544480664395e-10, -1.047951391867715e-10,
  4.077961627276637e-13,  8.207448308547575e-17, -7.969088559522069e-18,  3.412019267621058e-20,  6.116270246016553e-24, -7.622006337241151e-25,  3.439859006754121e-27,
  7.039481713749158e-01, -3.411272826741023e-03,  7.532742503425746e-06,  9.616408730785233e-09, -1.348790662592832e-10,  3.300814947675042e-13,  1.220234785889688e-15,
 -1.147136539915491e-17,  2.114501372300208e-20,  1.634110941844739e-22, -1.190103657980624e-24,  1.269391047200344e-27,  7.962477107111541e-01, -3.693365437370777e-03,
  6.607334922931479e-06,  2.002609767133357e-08, -1.545310750408260e-10,  1.370108356837920e-13,  2.592311570203859e-15, -1.208513544168444e-17, -1.512370206621863e-20,
  3.417842049612840e-22, -9.340992992085657e-25, -5.104900880055999e-27,  8.934244253858853e-01, -3.936321616055860e-03,  5.155482458965358e-06,  3.124735166820267e-08,
 -1.552077492487675e-10, -1.813349611899521e-13,  3.809688728206826e-15, -7.157214194677815e-18, -7.126272777518877e-20,  4.060332527880716e-22,  5.681347730299170e-25,
 -1.298827422049752e-26,  9.950416556662667e-01, -4.124966928281655e-03,  3.141682975641763e-06,  4.209099255016837e-08, -1.278231287048213e-10, -5.985165821841549e-13,
  4.231183948658050e-15,  5.028233843808172e-18, -1.236595408966108e-19,  1.662386581616558e-22,  3.094469353491934e-24, -1.295442545060349e-26,  1.100504028540106e+00,
 -4.242104356221221e-03,  5.722232602210245e-07,  5.082274255817814e-08, -6.513782497153914e-11, -1.029599495503561e-12,  3.076142147624042e-15,  2.276733387210866e-17,
 -1.243272781489656e-19, -4.699732668582290e-22,  4.623809352872340e-24,  6.669231058512082e-27,  1.209005542691356e+00, -4.268887812120513e-03, -2.479606877416308e-06,
  5.518321936543955e-08,  3.403767485047581e-11, -1.316304455117239e-12, -1.986122437070646e-16,  3.804966663192568e-17, -2.005222263292763e-20, -1.207700275498266e-21,
  1.565965864312547e-24,  4.002289636308307e-26,  1.319463104913759e+00, -4.185808623365698e-03, -5.841644710793865e-06,  5.262197749543644e-08,  1.588085965620878e-10,
 -1.243415987692093e-12, -5.183643454145904e-15,  3.625115326487613e-17,  1.862634175558719e-19, -1.182229365599260e-21, -7.152219860730825e-24,  4.094898163807600e-26,
  1.430434383896494e+00, -3.974716202092704e-03, -9.209095003889822e-06,  4.092011560927757e-08,  2.799695150675375e-10, -6.244181787122891e-13, -9.703671409739902e-15,
  4.191286631521984e-18,  3.518620312180635e-19,  4.438397714162171e-22, -1.285561008571869e-23, -3.990350374224289e-26,  1.540022531003100e+00, -3.622438174480372e-03,
 -1.212306295533891e-05,  1.937253891261817e-08,  3.487790436440425e-10,  5.158719981903194e-13, -9.882330321871575e-15, -4.981199496580515e-17,  2.168303592093075e-19,
  2.685699482313649e-21, -2.613966228348632e-25, -1.156421247224708e-25,  1.645778581909523e+00, -3.126576842762402e-03, -1.399163641196539e-05, -9.521729204405114e-09,
  3.106222763493294e-10,  1.724276838283862e-12, -2.754763068511184e-15, -7.887826869692805e-17, -2.729955689447728e-19,  1.996676607328701e-21,  2.196292968319362e-23,
  1.990560583627996e-26,  1.744627901356189e+00, -2.503619782731892e-03, -1.420213273340481e-05, -3.860694062077156e-08,  1.429466669687372e-10,  2.139391190365804e-12,
  8.470608805014778e-15, -2.980360842890201e-17, -5.587677585049102e-19, -2.467852446923048e-21,  8.813701890719453e-24,  1.784547118290700e-25,  1.832870992033979e+00,
 -1.798071593403622e-03, -1.237154781235844e-05, -5.679232934256176e-08, -9.397751113925889e-11,  1.144425744921672e-12,  1.284136254372081e-14,  6.035774167148239e-17,
 -4.480175617403277e-20, -3.143804623839930e-21, -2.550741359634807e-23, -7.335249333717487e-26,  1.906334908609889e+00, -1.088470724311443e-03, -8.711376574565708e-06,
 -5.440921664643711e-08, -2.528184877761147e-10, -5.749749117369497e-13,  3.861826551330032e-15,  6.190323365564789e-17,  4.640104977897242e-19,  2.006704865402223e-21,
 -7.197420342682681e-25, -1.050212798334563e-25,  1.960756146859775e+00, -4.828476292390375e-04, -4.304177298840712e-06, -3.251265592489555e-08, -2.153798474336918e-10,
 -1.240012904184834e-12, -5.840699592741178e-15, -1.744250957016863e-17,  4.021880319715830e-20,  1.216434292698497e-21,  1.255116563231106e-23,  9.395141644146747e-26,
  1.992424392747056e+00, -9.636144299315858e-05, -9.133721813023106e-07, -7.630478007951364e-09, -5.912799042721626e-11, -4.341193244345571e-13, -3.049562249624162e-15,
 -2.057725871874365e-17, -1.333797118405198e-19, -8.276120047620344e-22, -4.876046416841249e-24, -2.683935896454995e-26,  7.163200875343098e-04, -4.314676503589815e-06,
  1.948492694560580e-08, -7.820551274124251e-11,  2.940640148302673e-13, -1.061545598135513e-15,  3.719676432322904e-18, -1.278490888917603e-20,  4.304772085799269e-23,
 -1.442562204610403e-25,  4.694287471292579e-28, -1.575923575170629e-30,  6.447395060345001e-03, -3.878412595776777e-05,  1.745957683644682e-07, -6.967740151685923e-10,
  2.596467777276982e-12, -9.251299292142353e-15,  3.183755785514246e-17, -1.068609039277210e-19,  3.488165532431050e-22, -1.125235101073214e-24,  3.479423541062097e-27,
 -1.108027053571687e-29,  1.791225188928145e-02, -1.074655450072799e-04,  4.807031930045889e-07, -1.896179969845713e-09,  6.935654212077047e-12, -2.404049470031741e-14,
  7.955889945878641e-17, -2.530747825008358e-19,  7.668787192543211e-22, -2.241581507693500e-24,  5.968670849151084e-27, -1.593848350273724e-29,  3.511612924691680e-02,
 -2.098358423615830e-04,  9.295058218506592e-07, -3.601002326414994e-09,  1.278838116345031e-11, -4.236331669162063e-14,  1.309599018923159e-16, -3.761634712387014e-19,
  9.686135722480475e-22, -2.158005713334012e-24,  2.875799585810478e-27,  1.650867653816783e-30,  5.806643456196236e-02, -3.450897286141133e-04,  1.508369881710463e-06,
 -5.698281566482934e-09,  1.939074647753093e-11, -5.991466270508463e-14,  1.649251371778617e-16, -3.843304527767289e-19,  5.999151388597707e-22,  3.114171445419368e-25,
 -9.004002602543078e-27,  4.663341013722861e-29,  8.677216625824594e-02, -5.121140150051864e-04,  2.200112856546708e-06, -8.037929838726382e-09,  2.576608941705896e-11,
 -7.152051637402922e-14,  1.584800704204516e-16, -1.931942481894672e-19, -5.728721285857582e-22,  5.429771722010550e-24, -2.743532007541323e-26,  9.683256973617482e-29,
  1.212430782187850e-01, -7.094517782797208e-04,  2.982719237405800e-06, -1.043364598826682e-08,  3.076693763592050e-11, -7.166022566292609e-14,  9.120533484065623e-17,
  2.450295391422356e-19, -2.505808608386694e-21,  1.185675822119132e-23, -4.262439135871515e-26,  1.012000252417396e-28,  1.614885233925450e-01, -9.352549786761056e-04,
  3.828995062432928e-06, -1.266471158533775e-08,  3.313537004423879e-11, -5.516095332230852e-14, -4.938719044292033e-17,  9.104332596650222e-19, -4.746541363692189e-21,
  1.636216701579724e-23, -3.844956722313556e-26, -2.785474963558039e-31,  2.075158877782360e-01, -1.187223685478046e-03,  4.706174208003133e-06, -1.447922050958511e-08,
  3.158755938695286e-11, -1.808220394094902e-14, -2.618070545840644e-16,  1.687804203549693e-18, -6.381783893846566e-21,  1.428131897565287e-23,  1.364335939069613e-27,
 -2.321030538693708e-28,  2.593284922021539e-01, -1.462529596869965e-03,  5.575500047692113e-06, -1.559953614247914e-08,  2.492968042767073e-11,  4.120315298056916e-14,
 -5.244555941854980e-16,  2.350766124569892e-18, -6.128892540382377e-21,  1.035075219650673e-24,  8.172639343956463e-26, -5.245302988748782e-28,  3.169227939762332e-01,
 -1.757721060302734e-03,  6.391823645588845e-06, -1.573109820384573e-08,  1.221354321972063e-11,  1.207526855704523e-13, -7.904854661568417e-16,  2.569555127636045e-18,
 -2.643942241265514e-21, -2.514022212078254e-23,  1.815110083089750e-25, -6.717087429028539e-28,  3.802846590347143e-01, -2.068606363768293e-03,  7.103287931001353e-06,
 -1.457613741112090e-08, -7.059379817371121e-12,  2.136998230104141e-13, -9.854477858585910e-16,  1.958057932137668e-18,  4.895639949727290e-21, -5.955681155516568e-23,
  2.423168458805366e-25, -3.618249311096499e-28,  4.493843911097202e-01, -2.390111801242072e-03,  7.651212118811441e-06, -1.185441393764411e-08, -3.267865892567701e-11,
  3.069783149822454e-13, -1.010530714274752e-15,  1.779157843661853e-19,  1.593590054735519e-20, -8.770133167044652e-23,  1.730289154939388e-25,  6.535176270456464e-28,
  5.241700891707516e-01, -2.716111163440180e-03,  7.970360605777288e-06, -7.333759878147658e-09, -6.340971101571858e-11,  3.804730477738919e-13, -7.554071501444478e-16,
 -2.885803799438157e-18,  2.756505873538053e-20, -8.464429210290662e-23, -1.126870463497019e-25,  2.217558747877059e-27,  6.045587459563234e-01, -3.039224336670091e-03,
  7.989888029185721e-06, -8.738870131611844e-10, -9.663695419018308e-11,  4.072117155856393e-13, -1.257812875051674e-16, -6.879307973002963e-18,  3.382799204483184e-20,
 -2.135591335862807e-23, -6.120171766000210e-25,  3.357120825862458e-27,  6.904242836753601e-01, -3.350585474675224e-03,  7.635413730956340e-06,  7.512640130583601e-09,
 -1.280101800341580e-10,  3.555943214971106e-13,  9.093291210077348e-16, -1.070966036489514e-17,  2.618713327409829e-20,  1.172195760620581e-22, -1.112756544024561e-24,
  2.191682850258192e-27,  7.815814292654624e-01, -3.639587308107668e-03,  6.832914172444644e-06,  1.757878668728748e-08, -1.511963479963683e-10,  1.951221216423672e-13,
  2.248948317823687e-15, -1.237984024951554e-17, -3.540606059581302e-21,  3.005351967331347e-22, -1.113604094335333e-24, -3.082096941826801e-27,  8.777639415167839e-01,
 -3.893620343721819e-03,  5.515446949153128e-06,  2.873990932207974e-08, -1.579376297002023e-10, -9.255130583707614e-14,  3.579583396339002e-15, -9.200453528732921e-18,
 -5.637040411375713e-20,  4.177545403780042e-22,  2.951841710802982e-26, -1.140108855404307e-26,  9.785952035580819e-01, -4.097848738418482e-03,  3.634126829064274e-06,
  3.995561720458038e-08, -1.387688566313107e-10, -4.957194783597617e-13,  4.317638337886248e-15,  1.189610153049517e-18, -1.155912195317640e-19,  2.778771295457719e-22,
  2.471612975794570e-24, -1.512983592862185e-26,  1.083548602173677e+00, -4.235106333872641e-03,  1.175176970021072e-06,  4.962002119791330e-08, -8.494228953441009e-11,
 -9.485861725170323e-13,  3.655642526126490e-15,  1.855428937856958e-17, -1.378672279480970e-19, -2.814277368883645e-22,  4.747983208379588e-24, -9.378903481814359e-28,
  1.191894522090165e+00, -4.286068615036850e-03, -1.815009242629266e-06,  5.551731487860058e-08,  7.749672087968263e-12, -1.308398626771188e-12,  8.513646840455188e-16,
  3.672780939658153e-17, -6.199066244946179e-20, -1.111328208711407e-21,  3.210228969940294e-24,  3.421262764625880e-26,  1.302630461812734e+00, -4.229974662341350e-03,
 -5.195776934842027e-06,  5.495756571757612e-08,  1.327817271110378e-10, -1.355010722790834e-12, -4.091935491518091e-15,  4.147915630224003e-17,  1.390222275359187e-19,
 -1.428560294072991e-21, -5.079980113239315e-24,  5.250780609365072e-26,  1.414391389650602e+00, -4.046349675899999e-03, -8.691629482968692e-06,  4.528713029964537e-08,
  2.651684012663005e-10, -8.546145491682954e-13, -9.427004629306363e-15,  1.560424619149153e-17,  3.582227558377459e-19, -9.865198567322813e-23, -1.409030668501184e-23,
 -1.541375425311550e-26,  1.525340416467549e+00, -3.718397230246125e-03, -1.185681222690268e-05,  2.502219760922829e-08,  3.566161808820302e-10,  2.628323119277428e-13,
 -1.116546461233324e-14, -4.133871315071727e-17,  3.120590858360665e-19,  2.569025772971372e-21, -5.662000010757828e-24, -1.279003754345806e-25,  1.633047807404841e+00,
 -3.238879894035423e-03, -1.407495312985258e-05, -4.280248470513108e-09,  3.442629763370637e-10,  1.630744781184008e-12, -5.073635844286941e-15, -8.629359583568770e-17,
 -1.852169253234615e-19,  2.878674967618438e-21,  2.176638377300146e-23, -3.091933871852811e-26,  1.734383313241401e+00, -2.619047774177755e-03, -1.465024622778711e-05,
 -3.596676679080444e-08,  1.876890618222259e-10,  2.330572019740641e-12,  7.373001146428788e-15, -4.902159398367750e-17, -6.392718949857826e-19, -1.947397515535498e-21,
  1.745716991837307e-23,  2.123627802226106e-25,  1.825476411024903e+00, -1.899793718438766e-03, -1.306126648268677e-05, -5.809554598331704e-08, -6.787148500701178e-11,
  1.472624882657402e-12,  1.449285624609779e-14,  5.691062032924893e-17, -1.770290193986513e-19, -4.218087871707478e-21, -2.789830200011073e-23, -3.089000034669750e-26,
  1.901837410397366e+00, -1.160842984128787e-03, -9.388919235483055e-06, -5.854065225844398e-08, -2.632417979142850e-10, -4.597474153012308e-13,  5.813757347480811e-15,
  7.789185959189774e-17,  5.344699724905111e-19,  1.868778366140474e-21, -6.620888147798766e-24, -1.660426323595469e-25,  1.958753333290017e+00, -5.189021735465475e-04,
 -4.715849161138241e-06, -3.616491470313348e-08, -2.416204964286251e-10, -1.385860809832554e-12, -6.303748523813655e-15, -1.534938650790923e-17,  9.411612645866293e-20,
  1.809201853441184e-21,  1.729527441164999e-23,  1.225063643828460e-25,  1.992023729494956e+00, -1.040514529076923e-04, -1.010914161524773e-06, -8.650166514766651e-09,
 -6.859155559294481e-11, -5.147340132459613e-13, -3.690240969883544e-15, -2.536218404685748e-17, -1.669870264124822e-19, -1.048261087117879e-21, -6.208174909598119e-24,
 -3.394892107824090e-26,  6.993673075643290e-04, -4.162472549853826e-06,  1.857400570400205e-08, -7.366560431361949e-11,  2.736976136123926e-13, -9.764181048464026e-16,
  3.380228718782336e-18, -1.148698113857966e-20,  3.817636520618719e-23, -1.268016187545131e-25,  4.048148714563886e-28, -1.368052677756294e-30,  6.295000112820351e-03,
 -3.742011252155198e-05,  1.664777669873094e-07, -6.566702175367615e-10,  2.418846808062119e-12, -8.521878339302875e-15,  2.899581869578706e-17, -9.632097719804896e-20,
  3.106995456194257e-22, -9.953990087722350e-25,  3.022034519704191e-27, -9.754666717370831e-30,  1.748993946661147e-02, -1.037090854831410e-04,  4.585993190361550e-07,
 -1.788954597120510e-09,  6.473378501242408e-12, -2.221341415689724e-14,  7.280455645595415e-17, -2.297810858590642e-19,  6.903135671810759e-22, -2.016496120930739e-24,
  5.294152147094125e-27, -1.476511078401740e-29,  3.429138912166178e-02, -2.025692287590445e-04,  8.874940622759175e-07, -3.402999105731999e-09,  1.197170986705356e-11,
 -3.934323845346277e-14,  1.208497433034265e-16, -3.463885566065466e-19,  8.930056263219349e-22, -2.042374345550462e-24,  2.885338124444969e-27, -1.158698435243309e-30,
  5.670978382393001e-02, -3.332911024836266e-04,  1.441813157637895e-06, -5.397404526185175e-09,  1.823117484131682e-11, -5.608341718207467e-14,  1.544338586213213e-16,
 -3.650194753714396e-19,  6.051096072769005e-22, -1.078103434604308e-26, -7.179770996642868e-27,  3.648402659655774e-29,  8.475831087379340e-02, -4.948920317865666e-04,
  2.106084703834856e-06, -7.636910906899129e-09,  2.437326617560695e-11, -6.778380621210724e-14,  1.528419075624294e-16, -2.086023486579891e-19, -3.961685665018952e-22,
  4.413015840843863e-24, -2.351356678673603e-26,  8.157345487727295e-29,  1.184522133282531e-01, -6.860825789207894e-04,  2.860422207054115e-06, -9.952719515841033e-09,
  2.935613293296099e-11, -6.939764585394021e-14,  9.700543215861986e-17,  1.713526632664579e-19, -2.108603619492853e-21,  1.023840472093837e-23, -3.835753818404151e-26,
  9.238158752999072e-29,  1.578078174937225e-01, -9.052219957333432e-04,  3.680162927046282e-06, -1.214342745265807e-08,  3.202227648233888e-11, -5.605697014696520e-14,
 -2.593507243066009e-17,  7.676720176807038e-19, -4.185140771174111e-21,  1.482922898883092e-23, -3.808107116907860e-26,  1.569961171996505e-29,  2.028412034935805e-01,
 -1.150260732207200e-03,  4.535442970378661e-06, -1.397703844961716e-08,  3.116679230791687e-11, -2.382107261450874e-14, -2.173303211675477e-16,  1.491804729729727e-18,
 -5.868982125300980e-21,  1.414828149901347e-23, -7.627744772847629e-27, -1.787578394185816e-28,  2.535664059007953e-01, -1.418667535055097e-03,  5.390723902273645e-06,
 -1.519473066002834e-08,  2.563309137023690e-11,  2.938396995846049e-14, -4.613700411136652e-16,  2.155824943755589e-18, -6.038137828406428e-21,  3.865606118189224e-24,
  6.035470841057762e-26, -4.484280000260290e-28,  3.099929882735884e-01, -1.707338064800250e-03,  6.204299391456460e-06, -1.551736759575544e-08,  1.444465538947115e-11,
  1.026340568242362e-13, -7.198488090881173e-16,  2.471812271019792e-18, -3.425331634069367e-21, -1.846045726776970e-23,  1.527549702081382e-25, -6.336994700927429e-28,
  3.721227761071441e-01, -2.012481318498556e-03,  6.927833512602817e-06, -1.465616160594860e-08, -3.017366626478195e-12,  1.907227712239199e-13, -9.287380917451062e-16,
  2.082251219505209e-18,  2.921923443403251e-21, -5.021516280933267e-23,  2.240355559189115e-25, -4.622382890578980e-28,  4.399454504190039e-01, -2.329479546697502e-03,
  7.506020344552063e-06, -1.232947098850657e-08, -2.678093087582443e-11,  2.828401135025233e-13, -9.988746083963864e-16,  6.387347444501135e-19,  1.290926808737336e-20,
 -8.030254851112885e-23,  1.946060862421796e-25,  3.370886047624777e-28,  5.134325893258520e-01, -2.652716974719523e-03,  7.876516005525876e-06, -8.288450333586210e-09,
 -5.598758969001184e-11,  3.614704792109700e-13, -8.243237420994293e-16, -2.053164275695207e-18,  2.445900534991258e-20, -8.733625762571003e-23, -2.525241083243393e-26,
  1.759121893606064e-27,  5.925295841084307e-01, -2.975372846684830e-03,  7.970392292187738e-06, -2.355151725507143e-09, -8.853788108728280e-11,  4.020029670138645e-13,
 -3.033945769915328e-16, -5.813552487799295e-18,  3.265359555823370e-20, -4.294249333766636e-23, -4.690409566650489e-25,  3.120456558068877e-27,  6.771446309228020e-01,
 -3.289175829162167e-03,  7.713514694122856e-06,  5.522457901272630e-09, -1.207038392963050e-10,  3.739180641575142e-13,  6.217647666095949e-16, -9.812543107848721e-18,
  2.963094982057404e-20,  7.483740023095843e-23, -1.001976278180355e-24,  2.793012212664441e-27,  7.671336850024929e-01, -3.584121023320682e-03,  7.029482721136756e-06,
  1.519367932596037e-08, -1.467822603281848e-10,  2.449341358027239e-13,  1.902290430548423e-15, -1.232886040374272e-17,  6.449220279001201e-21,  2.538283301946692e-22,
 -1.208610674607421e-24, -1.280828634009463e-27,  8.622798307303231e-01, -3.848160322317293e-03,  5.845117637103217e-06,  2.620267573699578e-08, -1.589514169587780e-10,
 -9.922611433490828e-15,  3.298973751087074e-15, -1.076439937113841e-17, -4.142570975311604e-20,  4.094756911546191e-22, -4.286592398299862e-25, -9.372662173432250e-27,
  9.622649370260283e-01, -4.066896316177612e-03,  4.099963501244254e-06,  3.766163451233560e-08, -1.476464335269298e-10, -3.921045342652004e-13,  4.300794811337837e-15,
 -2.331495063544703e-18, -1.039717760916837e-19,  3.630881230622274e-22,  1.782877629923489e-24, -1.596419748197411e-26,  1.066630716312551e+00, -4.223347671437960e-03,
  1.761852599968226e-06,  4.811410529630512e-08, -1.029971890786994e-10, -8.551230938135436e-13,  4.112135266490474e-15,  1.401688391073018e-17, -1.446090321797219e-19,
 -9.440661619689104e-23,  4.553710179250012e-24, -7.707363341452527e-27,  1.174725427163091e+00, -4.297923729788148e-03, -1.148916497853894e-06,  5.543342118298825e-08,
 -1.813198614910253e-11, -1.275885499375102e-12,  1.846150104628221e-15,  3.413157487026201e-17, -9.934516473947233e-20, -9.551334744583049e-22,  4.538047321812889e-24,
  2.579057385187359e-26,  1.285631655738910e+00, -4.268868890323995e-03, -4.524449592467407e-06,  5.686033905619614e-08,  1.047959145234806e-10, -1.438826280780991e-12,
 -2.876221224744586e-15,  4.507046474988619e-17,  8.451507461415641e-20, -1.583233587371125e-21, -2.606083299697624e-24,  5.903221412287462e-26,  1.398070466709602e+00,
 -4.113638181752013e-03, -8.123331156292348e-06,  4.938096535455653e-08,  2.458556859000837e-10, -1.074331494685033e-12, -8.830916706973331e-15,  2.690092680910449e-17,
  3.444360036648847e-19, -6.677567310939820e-22, -1.416129258920216e-23,  1.249198487986059e-26,  1.510279157583844e+00, -3.811953359931235e-03, -1.152218541990222e-05,
  3.075517774105407e-08,  3.591055472321687e-10, -1.781662132906755e-14, -1.216961827687730e-14, -2.992784617680655e-17,  3.991025183543407e-19,  2.229252492268702e-21,
 -1.131887987371885e-23, -1.267975531864663e-25,  1.619866898685562e+00, -3.351588899846118e-03, -1.409221427613395e-05,  1.481430014874476e-09,  3.754614521034075e-10,
  1.479414807459104e-12, -7.556076757723670e-15, -9.039807519416030e-17, -6.639810575760106e-20,  3.704715616076560e-21,  1.909067988748392e-23, -9.190258951336243e-26,
  1.723670061549491e+00, -2.737921494936255e-03, -1.506226133522489e-05, -3.258174493768923e-08,  2.359466389460137e-10,  2.488681684995467e-12,  5.704532155954762e-15,
 -7.044653703241068e-17, -6.944961607852571e-19, -1.055837666919126e-21,  2.723909438270808e-23,  2.284213143035190e-25,  1.817663817672304e+00, -2.007088533741512e-03,
 -1.376389409823989e-05, -5.892644267824936e-08, -3.481556049281147e-11,  1.838787207370195e-12,  1.598267070571079e-14,  4.859913067086390e-17, -3.491258812176609e-19,
 -5.342226352338011e-21, -2.778049516391578e-23,  4.169935886157345e-26,  1.897039264724032e+00, -1.238836536826604e-03, -1.011695503964628e-05, -6.281772239575847e-08,
 -2.708545416186217e-10, -2.920529723748086e-13,  8.243832347026339e-15,  9.600463063399094e-17,  5.950219523925463e-19,  1.436026110227808e-21, -1.558666793504834e-23,
 -2.442594452502753e-25,  1.956599426848074e+00, -5.584327641279981e-04, -5.173965383149511e-06, -4.026093964725711e-08, -2.708833922016152e-10, -1.541902618113740e-12,
 -6.680560186941255e-15, -1.115094919913675e-17,  1.730842673656030e-19,  2.618230363867425e-21,  2.339544869026134e-23,  1.553180906121939e-25,  1.991590664232503e+00,
 -1.125734459995878e-04, -1.121656947947767e-06, -9.835053696070717e-09, -7.983269022708231e-11, -6.124619732743655e-13, -4.481224818962253e-15, -3.136055880236204e-17,
 -2.095761278958717e-19, -1.328880726245900e-21, -7.885288172656161e-24, -4.252634236678606e-26,  6.830091060488153e-04, -4.017343463529200e-06,  1.771566297234597e-08,
 -6.943836849974940e-11,  2.549551498735536e-13, -8.990183045748244e-16,  3.075031622880371e-18, -1.033536458282586e-20,  3.388894583999787e-23, -1.117608647675231e-25,
  3.484391036551666e-28, -1.201042141546382e-30,  6.147934312132727e-03, -3.611916534183784e-05,  1.588244292513240e-07, -6.192952557733232e-10,  2.255155450605207e-12,
 -7.857251346644197e-15,  2.643279920118783e-17, -8.692943081413730e-20,  2.769406541852627e-22, -8.827709207516547e-25,  2.617075723512959e-27, -8.696815344272216e-30,
  1.708230719525971e-02, -1.001244331508314e-04,  4.377389490091279e-07, -1.688841893675943e-09,  6.046074789311837e-12, -2.054088071958449e-14,  6.666931736857282e-17,
 -2.088129360894791e-19,  6.213775278686369e-22, -1.817442398820470e-24,  4.664877447646655e-27, -1.389586560415556e-29,  3.349505800325274e-02, -1.956294227068507e-04,
  8.477818922140168e-07, -3.217592318332371e-09,  1.121307983021639e-11, -3.655606920534440e-14,  1.115400349128612e-16, -3.189666553695803e-19,  8.215382775062679e-22,
 -1.928750959950076e-24,  2.776915287497785e-27, -3.761239790871722e-30,  5.539928511178096e-02, -3.220107977157464e-04,  1.378758123981548e-06, -5.114481129364443e-09,
  1.714575405936523e-11, -5.249746530817455e-14,  1.444839662610236e-16, -3.457146319908640e-19,  5.999136973404556e-22, -2.686266064742504e-25, -5.779530149868920e-27,
  2.727226658070485e-29,  8.281186892179403e-02, -4.784033980974856e-04,  2.016737509312811e-06, -7.257586761085821e-09,  2.305379219528872e-11, -6.418698289163896e-14,
  1.468461867213488e-16, -2.189126097604586e-19, -2.534042553492831e-22,  3.539926826949331e-24, -2.024727547034043e-26,  6.695568638978022e-29,  1.157529044959263e-01,
 -6.636690515879943e-04,  2.743762373066582e-06, -9.493997018807559e-09,  2.799181194913594e-11, -6.701923552111184e-14,  1.009119965191010e-16,  1.094863178224334e-19,
 -1.766686620566556e-21,  8.782319544981888e-24, -3.452687600376989e-26,  8.137198671031681e-29,  1.542449014011176e-01, -8.763549521666148e-04,  3.537478848333484e-06,
 -1.164006692131518e-08,  3.089657758531540e-11, -5.643612475056894e-14, -6.237030429189543e-18,  6.419967028348996e-19, -3.678512347991784e-21,  1.332277928211756e-23,
 -3.718111162959241e-26,  2.398345632320984e-29,  1.983116773154312e-01, -1.114639646902518e-03,  4.370693919032414e-06, -1.348245071687551e-08,  3.064148730039865e-11,
 -2.855650801582573e-14, -1.781130272692989e-16,  1.312073229068704e-18, -5.366912688758420e-21,  1.369873710631151e-23, -1.455355239945409e-26, -1.381273956523051e-28,
  2.479768424406723e-01, -1.376264077852525e-03,  5.210865410853575e-06, -1.478048125700557e-08,  2.611481913310119e-11,  1.901375655746026e-14, -4.036880033507902e-16,
  1.965259690432574e-18, -5.860090586163976e-21,  5.905355782609381e-24,  4.211178392436854e-26, -3.826975412346351e-28,  3.032617312295988e-01, -1.658444424345825e-03,
  6.019542428804918e-06, -1.527074704192545e-08,  1.633011241284310e-11,  8.617525508658334e-14, -6.522644265669951e-16,  2.352693929659471e-18, -3.986527587507380e-21,
 -1.289504395938788e-23,  1.258404186889819e-25, -5.892291464237967e-28,  3.641825815148184e-01, -1.957762684749083e-03,  6.751791914750240e-06, -1.467511491072033e-08,
  5.789619404360923e-13,  1.691416495757654e-13, -8.693857063585053e-16,  2.148517297518701e-18,  1.270384932801583e-21, -4.168165377540290e-23,  2.021733742260940e-25,
 -5.264758893828343e-28,  4.307466817902464e-01, -2.270030061473742e-03,  7.355678197117351e-06, -1.271400710994505e-08, -2.136217975050606e-11,  2.591258008449142e-13,
 -9.756304258005755e-16,  1.007103540651522e-18,  1.016132867219980e-20, -7.230200740470407e-23,  2.035298768127517e-25,  7.730860171280161e-29,  5.029470949770815e-01,
 -2.590117378554974e-03,  7.771914831827678e-06, -9.127509402276128e-09, -4.896022963234800e-11,  3.410823814477044e-13, -8.713279228668514e-16, -1.320833185676813e-18,
  2.131418084591764e-20, -8.692876674371526e-23,  4.244958407464421e-26,  1.323028218060307e-27,  5.807554068103401e-01, -2.911746229725869e-03,  7.933894729166106e-06,
 -3.707886214929700e-09, -8.058321786407342e-11,  3.928846675819342e-13, -4.518019282565642e-16, -4.796730293559728e-18,  3.080219342155256e-20, -5.905303528119852e-23,
 -3.389966864063242e-25,  2.776369035698140e-27,  6.641117179531967e-01, -3.227234891907012e-03,  7.768445782083160e-06,  3.651742685526938e-09, -1.130979459976180e-10,
  3.856527685097808e-13,  3.606395237878265e-16, -8.828734194410111e-18,  3.163434052078946e-20,  3.732761142026617e-23, -8.712493912556601e-25,  3.104479540947887e-27,
  7.529107714984303e-01, -3.527195401883301e-03,  7.197885148402205e-06,  1.288671636280636e-08, -1.414548346339278e-10,  2.864780369765971e-13,  1.561278288048282e-15,
 -1.198569266150107e-17,  1.470753432782058e-20,  2.048217901753606e-22, -1.230795497983631e-24,  2.179199995356208e-28,  8.469826417039485e-01, -3.800184875223080e-03,
  6.144297509747601e-06,  2.366206231064592e-08, -1.583832460018349e-10,  6.549960826302436e-14,  2.981199857653785e-15, -1.185824128321751e-17, -2.708670881301874e-20,
  3.847309329839334e-22, -7.923070542570596e-25, -7.141971954740054e-27,  9.460657560252844e-01, -4.032329569240659e-03,  4.537488358755505e-06,  3.524213428627245e-08,
 -1.544635113783067e-10, -2.900322672588300e-13,  4.190988796364431e-15, -5.437063295689312e-18, -8.978612610010933e-20,  4.203804830907304e-22,  1.084365439933526e-24,
 -1.560767867933588e-26,  1.049769130720460e+00, -4.206972653144332e-03,  2.328787463686898e-06,  4.633481680545220e-08, -1.190836594591561e-10, -7.522469825328894e-13,
  4.439558519867455e-15,  9.369403665985953e-18, -1.448264760401647e-19,  7.925059145745109e-23,  4.089549077637532e-24, -1.314001231376424e-26,  1.157519553022061e+00,
 -4.304461111574233e-03, -4.862895292099996e-07,  5.494189317985794e-08, -4.313119635532444e-11, -1.220499387009998e-12,  2.752420181564259e-15,  3.043945602437164e-17,
 -1.302150687967719e-19, -7.537860343971962e-22,  5.456234007762245e-24,  1.577312811797582e-26,  1.268488147700052e+00, -4.302308895533401e-03, -3.833025706378187e-06,
  5.830354477969085e-08,  7.543266935123240e-11, -1.492459564746575e-12, -1.585067686872645e-15,  4.684801369421486e-17,  2.627500462162374e-20, -1.634870823029522e-21,
  2.999783951323293e-26,  5.982627016010566e-26,  1.381489785800497e+00, -4.176189378356818e-03, -7.507903033779331e-06,  5.313152595630814e-08,  2.223169757387203e-10,
 -1.276015388654772e-12, -7.927768069994690e-15,  3.743050257114065e-17,  3.104093213058825e-19, -1.214859638549025e-21, -1.298949341962887e-23,  4.049305539500392e-26,
  1.494849464300265e+00, -3.902557049538162e-03, -1.111871303188683e-05,  3.648188862291204e-08,  3.557683909260563e-10, -3.184292985204059e-13, -1.281742056735403e-14,
 -1.597061008074616e-17,  4.698932751199920e-19,  1.668633612080053e-21, -1.659168433224258e-23, -1.102720449145689e-25,  1.606235327302523e+00, -3.464151199488558e-03,
 -1.403745067793655e-05,  7.714803212609244e-09,  4.030305675892863e-10,  1.267583402525437e-12, -1.009591992666553e-14, -9.025056216538355e-17,  7.956978383981613e-20,
  4.368504230366865e-21,  1.362989404937536e-23, -1.561207447516657e-25,  1.712474998823194e+00, -2.859915504278726e-03, -1.542892671332675e-05, -2.840168713931449e-08,
  2.869164887838538e-10,  2.599382005526952e-12,  3.416793642085300e-15, -9.304866550836155e-17, -7.104797734717993e-19,  2.334191955405598e-22,  3.713113438722648e-23,
  2.155394465439202e-25,  1.809410753311126e+00, -2.120034693050096e-03, -1.447307138946049e-05, -5.916800668952557e-08,  5.898941350943096e-12,  2.237252921129767e-12,
  1.715662580652558e-14,  3.414078898487694e-17, -5.607464333568652e-19, -6.387761698831811e-21, -2.371500219156022e-23,  1.489601807079033e-25,  1.891917168649470e+00,
 -1.322861469636095e-03, -1.089692508570537e-05, -6.718642034082891e-08, -2.744880377548559e-10, -5.974892410652148e-14,  1.120531629613937e-14,  1.157295676454267e-16,
  6.326671071373367e-19,  5.711514827439248e-22, -2.833414117521621e-23, -3.370860175128697e-25,  1.954279745332945e+00, -6.018330933458536e-04, -5.684147599367033e-06,
 -4.485058350727100e-08, -3.033464405678499e-10, -1.705263016516669e-12, -6.899707067081227e-15, -3.909566326683650e-18,  2.859243953095958e-19,  3.700843560870065e-21,
  3.098460462360227e-23,  1.894578458745280e-25,  1.991121644540431e+00, -1.220414690990948e-04, -1.247765534010545e-06, -1.121652694750558e-08, -9.323266176188472e-11,
 -7.313528179682289e-13, -5.460858501492808e-15, -3.889713268805544e-17, -2.635698688673075e-19, -1.684553628740100e-21, -9.970831628345055e-24, -5.246882680124390e-26,
  6.672180016196265e-04, -3.878883194573509e-06,  1.690629761795113e-08, -6.549901542394574e-11,  2.376899686477177e-13, -8.285713096521412e-16,  2.800237404110178e-18,
 -9.312703520248409e-21,  3.010406748079562e-23, -9.883988010478445e-26,  2.985356437986476e-28, -1.074022051636786e-30,  6.005952625704886e-03, -3.487769440094192e-05,
  1.516043047529134e-07, -5.844362703295884e-10,  2.104162192961872e-12, -7.251099697567251e-15,  2.411820678010462e-17, -7.855633519762443e-20,  2.469552920982168e-22,
 -7.854906239762446e-25,  2.252615764484264e-27, -7.918132852251633e-30,  1.668868721508506e-02, -9.670197210433619e-05,  4.180399887587181e-07, -1.595306249408877e-09,
  5.650795583704226e-12, -1.900879054539304e-14,  6.109134617402213e-17, -1.899408743555862e-19,  5.591625578842009e-22, -1.642906901013088e-24,  4.065218833624270e-27,
 -1.344287992271579e-29,  3.272586451942109e-02, -1.889986166778241e-04,  8.102235760270817e-07, -3.043889547846995e-09,  1.050801972152981e-11, -3.398337388162049e-14,
  1.029667300490786e-16, -2.937673234641785e-19,  7.540556425644641e-22, -1.821767371908477e-24,  2.552336601249595e-27, -6.504979218115994e-30,  5.413291983062268e-02,
 -3.112216427612603e-04,  1.318996295892985e-06, -4.848363504076870e-09,  1.612970799195717e-11, -4.914385142189794e-14,  1.350709588135370e-16, -3.267145500710878e-19,
  5.863472512030775e-22, -4.784232813898234e-25, -4.774958914247999e-27,  1.838158971521123e-29,  8.092998027853919e-02, -4.626116878865798e-04,  1.931817883369256e-06,
 -6.898806614875649e-09,  2.180479487262670e-11, -6.073703305531069e-14,  1.406211843356526e-16, -2.251333501668764e-19, -1.398738337950214e-22,  2.784679889315213e-24,
 -1.762156568136048e-26,  5.231678183584925e-29,  1.131414175594019e-01, -6.421671516971051e-04,  2.632477818924097e-06, -9.056718585036065e-09,  2.667586262252507e-11,
 -6.456666576596197e-14,  1.032318068428300e-16,  5.775119591085836e-20, -1.474553565026344e-21,  7.469083593397357e-24, -3.123309503444386e-26,  6.787673037155433e-29,
  1.507952083600956e-01, -8.486055265294259e-04,  3.400726858674057e-06, -1.115475371492343e-08,  2.976774735086818e-11, -5.638297113045307e-14,  1.016097240552267e-17,
  5.316733125261833e-19, -3.225400169679488e-21,  1.185743504731125e-23, -3.608000657628514e-26,  2.480791953005149e-29,  1.939220368715482e-01, -1.080312963554373e-03,
  4.211826526867828e-06, -1.299697607315799e-08,  3.003048741686909e-11, -3.240931944746574e-14, -1.437060832516784e-16,  1.148098820056633e-18, -4.885616430688157e-21,
  1.300419398337297e-23, -1.997042595735586e-26, -1.102483677523198e-28,  2.425540467212577e-01, -1.335279488863016e-03,  5.036017552515794e-06, -1.436011002832146e-08,
  2.640255771238605e-11,  9.964588907731559e-15, -3.512519607477260e-16,  1.781431455609631e-18, -5.621082519242475e-21,  7.269651991073284e-24,  2.648881921571555e-26,
 -3.297781551277680e-28,  2.967231120709329e-01, -1.611016513412292e-03,  5.837915336159498e-06, -1.499650562218182e-08,  1.790233376408293e-11,  7.129660327680178e-14,
 -5.882381124372371e-16,  2.218619069935170e-18, -4.366272049272606e-21, -8.366793449244887e-24,  1.008909108862633e-25, -5.455774763820382e-28,  3.564584446898522e-01,
 -1.904452347637453e-03,  6.575854133419896e-06, -1.463990201538902e-08,  3.758033256559868e-12,  1.490015563128403e-13, -8.088728095241093e-16,  2.166675640138179e-18,
 -9.029406897431430e-23, -3.407107716213519e-23,  1.780676171160344e-25, -5.661958819805768e-28,  4.217832784368253e-01, -2.211800333095117e-03,  7.201226272229618e-06,
 -1.301560386146042e-08, -1.641135103101855e-11,  2.360834519925245e-13, -9.432593286885627e-16,  1.292194029375326e-18,  7.705216519813629e-21, -6.415817276119881e-23,
  2.021227375660527e-25, -1.342097177122431e-28,  4.927102642828888e-01, -2.528392986527717e-03,  7.657905939738183e-06, -9.857447331585244e-09, -4.235031025429356e-11,
  3.198009062283986e-13, -8.992299975995856e-16, -6.884161025470962e-19,  1.822822911219658e-20, -8.418785622631483e-23,  9.165501932360943e-26,  9.192504744316787e-28,
  5.692350522460478e-01, -2.848474375927751e-03,  7.881921381135911e-06, -4.934988990690280e-09, -7.284426898589201e-11,  3.805390485391705e-13, -5.726478973968711e-16,
 -3.847459726900249e-18,  2.846058257636109e-20, -7.028743709118227e-23, -2.257380043856701e-25,  2.362893263835355e-27,  6.513273083971129e-01, -3.164942215804081e-03,
  7.801665120993472e-06,  1.904268288513162e-09, -1.053177651136199e-10,  3.914570600236430e-13,  1.277627741838563e-16, -7.801391039460975e-18,  3.238410255480168e-20,
  5.244434424304284e-24, -7.324650139149382e-25,  3.166159320571841e-27,  7.389180817151368e-01, -3.469031785914236e-03,  7.339141441690102e-06,  1.067119833841194e-08,
 -1.353774481244761e-10,  3.199811799635072e-13,  1.233308840589348e-15, -1.140653484481716e-17,  2.120062777249682e-20,  1.561469293779452e-22, -1.194551241841418e-24,
  1.370508486427266e-27,  8.318819486231667e-01, -3.749937672148033e-03,  6.413092975843393e-06,  2.114218330557573e-08, -1.563851130946274e-10,  1.329786547563629e-13,
  2.639069446300884e-15, -1.251010257210004e-17, -1.387656330586607e-20,  3.474144890489756e-22, -1.057322923936588e-24, -4.921581643854092e-27,  9.300116561134401e-01,
 -3.994380459623029e-03,  4.945391599444889e-06,  3.272972057063886e-08, -1.592722682720147e-10, -1.915858061489382e-13,  4.000853930290586e-15, -8.061033874624504e-18,
 -7.403433975174607e-20,  4.503454159472147e-22,  4.234294888948536e-25, -1.430143800410616e-26,  1.032981974965625e+00, -4.186151778382301e-03,  2.872895724862511e-06,
  4.431498774071313e-08, -1.330445465716215e-10, -6.430694154610444e-13,  4.637666623671552e-15,  4.810968402533418e-18, -1.391798604321049e-19,  2.300252992521320e-22,
  3.421438029926757e-24, -1.694880730050821e-26,  1.140298084550004e+00, -4.305727779058039e-03,  1.680794614535212e-07,  5.406038429843390e-08, -6.681410084335614e-11,
 -1.144708040891897e-12,  3.542616374190661e-15,  2.588168769147354e-17, -1.532837759791994e-19, -5.247502456035260e-22,  5.918914705260580e-24,  5.267086718700438e-27,
  1.251222040737065e+00, -4.330156293097420e-03, -3.127132130195286e-06,  5.927005403775508e-08,  4.530957380016954e-11, -1.514719493729409e-12, -2.703688074519518e-16,
  4.675245408139444e-17, -3.193312424514016e-20, -1.582065758347429e-21,  2.574621236975999e-24,  5.494619644422799e-26,  1.364669022564733e+00, -4.233643824021963e-03,
 -6.849856928625835e-06,  5.647447327676461e-08,  1.949845126992685e-10, -1.452626634808844e-12, -6.747917926196733e-15,  4.656750867829886e-17,  2.578210635607341e-19,
 -1.691212230903491e-21, -1.064894824290132e-23,  6.504386638173723e-26,  1.479064245156510e+00, -3.989659447367096e-03, -1.064704124738578e-05,  4.210639946678698e-08,
  3.462964021689032e-10, -6.296636834265825e-13, -1.304602067888101e-14, -1.099944171269312e-19,  5.169224204626913e-19,  9.162263173431360e-22, -2.079714551160818e-23,
 -7.852735652931080e-26,  1.592154866809829e+00, -3.575969033087327e-03, -1.390539047602242e-05,  1.435208844514451e-08,  4.257566427934520e-10,  9.953935828435339e-13,
 -1.256297902675135e-14, -8.509736619828143e-17,  2.448301574391588e-19,  4.758466462332505e-21,  5.445910875283397e-24, -2.139238800366721e-25,  1.700786430866415e+00,
 -2.984628182260267e-03, -1.574047548263716e-05, -2.339159853962989e-08,  3.394999192674474e-10,  2.647570066850867e-12,  4.965472574636126e-16, -1.153450360739521e-16,
 -6.731620590078856e-19,  1.896172282986738e-21,  4.562916837421849e-23,  1.636279324708947e-25,  1.800694555561709e+00, -2.238654176543635e-03, -1.518097132066006e-05,
 -5.869300516274205e-08,  5.482761768310604e-11,  2.658236918040027e-12,  1.782556317455120e-14,  1.234959723451408e-17, -8.058477781374819e-19, -7.166018658241441e-21,
 -1.416945674246100e-23,  2.900027734139944e-25,  1.886446160404918e+00, -1.413336469493690e-03, -1.172950197465053e-05, -7.157203397541260e-08, -2.727193926511598e-10,
  2.503619539483665e-13,  1.473053405237206e-14,  1.360544105446467e-16,  6.289890685414043e-19, -8.879116115855552e-22, -4.533844567760021e-23, -4.355692563396774e-25,
  1.951777937977482e+00, -6.495442629385642e-04, -6.252630531003637e-06, -4.998598281119810e-08, -3.391105992623492e-10, -1.871003626739984e-12, -6.859249220919657e-15,
  7.627768880450979e-18,  4.435575292127420e-19,  5.116149260546394e-21,  3.999180331656160e-23,  2.182442085736747e-25,  1.990612624631863e+00, -1.325885057799904e-04,
 -1.391821007127664e-06, -1.283277513910890e-08, -1.092637166300407e-10, -8.764948295124248e-13, -6.677750189590626e-15, -4.838334895320043e-17, -3.319776825919384e-19,
 -2.132697055701116e-21, -1.251471878418694e-23, -6.320763171809855e-26,  6.519680813198953e-04, -3.746713350835902e-06,  1.614259240337459e-08, -6.182498256535368e-11,
  2.217700271458582e-13, -7.643890316959797e-16,  2.552449310992444e-18, -8.404091133965468e-21,  2.674964904050552e-23, -8.781562993786524e-26,  2.532854987156921e-28,
 -9.906255928534746e-31,  5.868823893540637e-03, -3.369235139276882e-05,  1.447883832235373e-07, -5.518991331712028e-10,  1.964754909303830e-12, -6.697790196639554e-15,
  2.202513437704334e-17, -7.108948969881947e-20,  2.202170450285627e-22, -7.021946258292838e-25,  1.915483871172918e-27, -7.466799299264319e-30,  1.630844885566598e-02,
 -9.343271826246708e-05,  3.994264975352552e-07, -1.507857035990795e-09,  5.284861131692977e-12, -1.760444999542690e-14,  5.601483216242388e-17, -1.729637589873376e-19,
  5.028024666495857e-22, -1.492121569628708e-24,  3.472902747350466e-27, -1.360571734862231e-29,  3.198260626237965e-02, -1.826601273826221e-04,  7.746836697258260e-07,
 -2.881067051885942e-09,  9.852411831976075e-12, -3.160821142558429e-14,  9.506933948720719e-17, -2.706677910852650e-19,  6.902323816245114e-22, -1.726326114748990e-24,
  2.195158471936828e-27, -9.890663076739957e-30,  5.290877482143205e-02, -3.008980801313589e-04,  1.262332513001940e-06, -4.597978132296332e-09,  1.517851789047782e-11,
 -4.600982146351732e-14,  1.261827913151671e-16, -3.082624510043365e-19,  5.658564776589172e-22, -6.559476636123499e-25, -4.169908667515959e-27,  8.934559256673485e-30,
  7.910992655663596e-02, -4.474824477725557e-04,  1.851085965965007e-06, -6.559466603407850e-09,  2.062329045506658e-11, -5.743818734823376e-14,  1.342689126155156e-16,
 -2.281371408812054e-19, -5.179897925571660e-23,  2.121345386206594e-24, -1.565990968774813e-26,  3.653129113116811e-29,  1.106141904023480e-01, -6.215348930675622e-04,
  2.526315902045246e-06, -8.640100378360959e-09,  2.540940938746522e-11, -6.207479001498594e-14,  1.042269764289057e-16,  1.463212046659275e-20, -1.227476901180317e-21,
  6.274790160445745e-24, -2.860546067420047e-26,  5.083142582371580e-29,  1.474543614403959e-01, -8.219271286028086e-04,  3.269690361335251e-06, -1.068747292613018e-08,
  2.864367375807776e-11, -5.597174408788346e-14,  2.366504446464046e-17,  4.350139072222740e-19, -2.824259926570711e-21,  1.043452708312085e-23, -3.511954754525442e-26,
  1.733235074530636e-29,  1.896671979368689e-01, -1.047234088325016e-03,  4.058723772727818e-06, -1.252185054078629e-08,  2.935032596847067e-11, -3.548974380012947e-14,
 -1.136788462285673e-16,  9.990861808592418e-19, -4.432964086849369e-21,  1.211354898022163e-23, -2.445994262650648e-26, -9.631089706964688e-29,  2.372924238331872e-01,
 -1.295673439975460e-03,  4.866236016121904e-06, -1.393651620654938e-08,  2.652148531027109e-11,  2.113025424628698e-15, -3.038494843192213e-16,  1.605920997803708e-18,
 -5.343687161777514e-21,  8.051153182380544e-24,  1.285506567589410e-26, -2.929530988967913e-28,  2.903713199394584e-01, -1.565028050067117e-03,  5.659720520794726e-06,
 -1.469940705402946e-08,  1.919203783047690e-11,  5.790830452996738e-14, -5.281128649603925e-16,  2.074811703286698e-18, -4.600516605029206e-21, -4.800019817235666e-24,
  7.770453971666226e-26, -5.104768003223513e-28,  3.489447380660603e-01, -1.852546987949858e-03,  6.400631061090982e-06, -1.455696739758108e-08,  6.548842607207942e-12,
  1.303151999874052e-13, -7.484212200031135e-16,  2.145486717104353e-18, -1.194727364669023e-21, -2.745522856957901e-23,  1.525230526325304e-25, -5.941405673691742e-28,
  4.130503017000698e-01, -2.154819384871540e-03,  7.043615401704728e-06, -1.324162935963113e-08, -1.191299839314401e-11,  2.139051886441921e-13, -9.039621410626519e-16,
  1.503351423160877e-18,  5.539133553720579e-21, -5.624518369436214e-23,  1.922481172631890e-25, -3.100448494862159e-28,  4.827184540345477e-01, -2.467613937314860e-03,
  7.535758197095215e-06, -1.048506215004085e-08, -3.617133979326504e-11,  2.980512184593570e-13, -9.107895566275433e-16, -1.528249952148196e-19,  1.527218748993413e-20,
 -7.982408955255199e-23,  1.238326977926854e-25,  5.482975342968981e-28,  5.579668632093484e-01, -2.785675124597932e-03,  7.815957104642825e-06, -6.040392586356637e-09,
 -6.537912781038018e-11,  3.656032705442508e-13, -6.680181095996259e-16, -2.978753824980982e-18,  2.579156397703335e-20, -7.736942898903402e-23, -1.316864444469666e-25,
  1.906583003376850e-27,  6.387924712436047e-01, -3.102465540653424e-03,  7.814664538477093e-06,  2.819116167966445e-10, -9.747504918243666e-11,  3.920191791361913e-13,
 -7.617845769013068e-17, -6.767462594440418e-18,  3.207885766650316e-20, -2.129748272978407e-23, -5.957105341513129e-25,  3.018438391431414e-27,  7.251601405144343e-01,
 -3.409842763239671e-03,  7.454415690558501e-06,  8.557857244265678e-09, -1.287072833765609e-10,  3.458295254861840e-13,  9.242038278229910e-16, -1.064726208955151e-17,
  2.597877991213614e-20,  1.098301141565567e-22, -1.115527705226805e-24,  2.161636777499546e-27,  8.169863544701645e-01, -3.697660416402068e-03,  6.651884790725789e-06,
  1.866461957350542e-08, -1.531207476251916e-10,  1.920740041195571e-13,  2.284389616461312e-15, -1.276259067039973e-17, -2.177449977077475e-21,  3.014080033137942e-22,
 -1.228169573906969e-24, -2.887377383664841e-27,  9.141156864970236e-01, -3.953289880012129e-03,  5.322748340655954e-06,  3.015584629816425e-08, -1.621633815322176e-10,
 -9.852646011693267e-14,  3.744431197729799e-15, -1.016866417790357e-17, -5.766383801177927e-20,  4.552377569023854e-22, -1.644881163054476e-25, -1.233976704897871e-26,
  1.016286649794672e+00, -4.161078619272735e-03,  3.391498568548051e-06,  4.208946825927490e-08, -1.447845488183324e-10, -5.306436465825089e-13,  4.711445692296714e-15,
  5.146153895438640e-19, -1.286222293501483e-19,  3.512239325859685e-22,  2.623086279465664e-24, -1.906643749624236e-26,  1.123081943383002e+00, -4.301808127116648e-03,
  8.096500248319739e-07,  5.281306118434908e-08, -8.880226672646554e-11, -1.051559088730575e-12,  4.196120061547564e-15,  2.072031713398066e-17, -1.678847659080332e-19,
 -2.863611923958469e-22,  5.927906135961676e-24, -4.691936424701825e-27,  1.233855900337874e+00, -4.352318365806340e-03, -2.412541409892301e-06,  5.975274187848480e-08,
  1.505551285088780e-11, -1.505666791502986e-12,  1.016000109552924e-15,  4.484378212596882e-17, -8.647387093116447e-20, -1.433291680413684e-21,  4.792641566256257e-24,
  4.515864731374321e-26,  1.347629213511493e+00, -4.285681131840576e-03, -6.154430722807344e-06,  5.935346528072800e-08,  1.644226640077171e-10, -1.598056751482362e-12,
 -5.338228597201212e-15,  5.376739302187278e-17,  1.900141217052826e-19, -2.054084840823805e-21, -7.363952813754130e-24,  8.295572753388041e-26,  1.462938586370346e+00,
 -4.072721545032507e-03, -1.010899060476979e-05,  4.752941661565085e-08,  3.305816022407876e-10, -9.409113634312909e-13, -1.281374097563832e-14,  1.679267442460398e-17,
  5.342099870484638e-19,  2.748061415077118e-23, -2.331794177758953e-23, -3.437432034187261e-26,  1.577629760535014e+00, -3.686406048228883e-03, -1.369169105399488e-05,
  2.130628341733463e-08,  4.424616496889943e-10,  6.663339941588152e-13, -1.481007960048607e-14, -7.449913160156592e-17,  4.176617463455901e-19,  4.774533355733559e-21,
 -4.937594085727099e-24, -2.542623603495265e-25,  1.688594428440307e+00, -3.111578415986315e-03, -1.598683628296361e-05, -1.753648206699824e-08,  3.922966239222119e-10,
  2.618373105777652e-12, -3.021842286753178e-15, -1.354291307095268e-16, -5.705351972294976e-19,  3.840139910331619e-21,  5.086322507650266e-23,  6.671714225500967e-26,
  1.791492609217604e+00, -2.362900106346378e-03, -1.587819401146497e-05, -5.736713878149489e-08,  1.122824167804691e-10,  3.087044341603108e-12,  1.777092803422446e-14,
 -1.764678014309691e-17, -1.070522545531149e-18, -7.430250743332832e-21,  2.159753925825522e-24,  4.546592891952772e-25,  1.880599598963485e+00, -1.510681610654304e-03,
 -1.261431634692023e-05, -7.587494207996144e-08, -2.638566734365866e-10,  6.518404696085301e-13,  1.881431861712236e-14,  1.552814818025551e-16,  5.595136649661439e-19,
 -3.111694678489261e-21, -6.647489788770268e-23, -5.207543356143457e-25,  1.949075785861963e+00, -7.020597739959668e-04, -6.886280505269128e-06, -5.571995367664140e-08,
 -3.781505387350493e-10, -2.031277080524863e-12, -6.416957700415223e-15,  2.509636499798115e-17,  6.588960692258885e-19,  6.912895968241748e-21,  4.992398740804039e-23,
  2.286577520442536e-25,  1.990058982393794e+00, -1.443701579984246e-04, -1.556911631589039e-06, -1.473042471431265e-08, -1.285125247669600e-10, -1.054292604961526e-12,
 -8.193473354930233e-15, -6.033730831761342e-17, -4.184638881065540e-19, -2.691991900942378e-21, -1.552339467982558e-23, -7.323111676134945e-26,  6.372348943509492e-04,
 -3.620481029961907e-06,  1.542148860548302e-08, -5.839571428565192e-11,  2.070762616174735e-13, -7.058601494069782e-16,  2.328656795192704e-18, -7.596813199675469e-21,
  2.376027336289470e-23, -7.854297081705881e-26,  2.105580212080507e-28, -9.620936290571926e-31,  5.736329899041554e-03, -3.256001106938438e-05,  1.383498807740792e-07,
 -5.215066430181481e-10,  1.835927924830417e-12, -6.192299580256030e-15,  2.012958734681625e-17, -6.443286031839194e-20,  1.962384448842308e-22, -6.321051566147068e-25,
  1.589090304359796e-27, -7.456540431857913e-30,  1.594099620413727e-02, -9.030827222993539e-05,  3.818281730199032e-07, -1.426044541072968e-09,  4.945832598845508e-12,
 -1.631644041743840e-14,  5.138921135704116e-17, -1.577079155262493e-19,  4.514401891988362e-22, -1.365427115231575e-24,  2.853530471399586e-27, -1.475449863891961e-29,
  3.126414545145131e-02, -1.765983166389546e-04,  7.410362298583056e-07, -2.728364338566983e-09,  9.242463027907347e-12, -2.941505261646282e-14,  8.779063809625120e-17,
 -2.495586975947949e-19,  6.295488299782538e-22, -1.648506132192705e-24,  1.660695577999532e-27, -1.473823931694335e-29,  5.172503611245281e-02, -2.910160633011566e-04,
  1.208584071715277e-06, -4.362321773259754e-09,  1.428791666987904e-11, -4.308298747318897e-14,  1.178011704367408e-16, -2.905644774546480e-19,  5.393064007382100e-22,
 -8.180335187805612e-25, -4.017249884331127e-27, -2.480543703252676e-30,  7.734912342719648e-02, -4.329830910861073e-04,  1.774314854615508e-06, -6.238511153814030e-09,
  1.950623314800845e-11, -5.429250851553759e-14,  1.278685022285018e-16, -2.286908722767668e-19,  1.363444158621860e-23,  1.521850182017157e-24, -1.445222345772976e-26,
  1.761488716913823e-29,  1.081678248708098e-01, -6.017322727803016e-04,  2.425033471893506e-06, -8.243345820547240e-09,  2.419293916536920e-11, -5.957266381369004e-14,
  1.041191744411502e-16, -2.124968271180801e-20, -1.021697020014664e-21,  5.169092539940252e-24, -2.684619938173243e-26,  2.786029366760716e-29,  1.442181666111037e-01,
 -7.962748981900499e-04,  3.144153648395303e-06, -1.023809480388947e-08,  2.753085375646360e-11, -5.526749343853663e-14,  3.463471152569630e-17,  3.503779943908318e-19,
 -2.473758504857333e-21,  9.040511497963297e-24, -3.471485790700964e-26, -1.104447911754185e-30,  1.855422607015382e-01, -1.015357418541919e-03,  3.911255319426119e-06,
 -1.205806269351226e-08,  2.861543293825398e-11, -3.789797676107984e-14, -8.762623653919163e-17,  8.640116673334368e-19, -4.015502302803369e-21,  1.105083902691486e-23,
 -2.869948760100030e-26, -9.971117892381857e-29,  2.321865408596447e-01, -1.257405290068307e-03,  4.701544036313555e-06, -1.351221563305593e-08,  2.649436545592673e-11,
 -4.658824771319464e-15, -2.612335318151326e-16,  1.439634911684113e-18, -5.047636012508939e-21,  8.313856535594437e-24,  3.915805670347445e-28, -2.778061260250810e-28,
  2.842006535928594e-01, -1.520450553561771e-03,  5.485206113755817e-06, -1.438373832811955e-08,  2.022807592905085e-11,  4.591395773473038e-14, -4.721011218707627e-16,
  1.925386734580990e-18, -4.722719754440523e-21, -2.134414093340844e-24,  5.569805428847302e-26, -4.939212279451168e-28,  3.416358566497594e-01, -1.802038700771497e-03,
  6.226659043507646e-06, -1.443229108912200e-08,  8.980365424705455e-12,  1.130687816618715e-13, -6.890233211817939e-16,  2.092567081098051e-18, -2.079674940107989e-21,
 -2.188560187033867e-23,  1.257289148942777e-25, -6.259764709080084e-28,  4.045427114876954e-01, -2.099108982652771e-03,  6.883709600553234e-06, -1.339917662155597e-08,
 -7.848340166138535e-12,  1.927334342528506e-13, -8.596807554810161e-16,  1.649661108665755e-18,  3.649007655144643e-21, -4.887520431512074e-23,  1.751003623398188e-25,
 -4.684357189926614e-28,  4.729677602494944e-01, -2.407840548007386e-03,  7.406657867646611e-06, -1.101730355636897e-08, -3.042897725786165e-11,  2.761935240954591e-13,
 -9.086516660302551e-16,  2.909032817581294e-19,  1.249254858066038e-20, -7.449186757851717e-23,  1.402427774079064e-25,  1.997668440126991e-28,  5.469487345745855e-01,
 -2.723454639804266e-03,  7.737434400270042e-06, -7.028859916776037e-09, -5.823367160761844e-11,  3.486606308687687e-13, -7.402936583190238e-16, -2.198849513790942e-18,
  2.293038523808908e-20, -8.110037014282699e-23, -5.841182493964845e-26,  1.418865807213762e-27,  6.265076284928841e-01, -3.039960610889028e-03,  7.808948113003171e-06,
 -1.215127788127690e-09, -8.966770112963230e-11,  3.880321593551278e-13, -2.514426504991298e-16, -5.757550376729961e-18,  3.091450423835871e-20, -4.255334235281518e-23,
 -4.694552669326739e-25,  2.692859026242413e-27,  7.116406417883786e-01, -3.349831135954038e-03,  7.544985956817312e-06,  6.554978968052887e-09, -1.215925320499137e-10,
  3.645302268430114e-13,  6.382531102043134e-16, -9.761095183460457e-18,  2.915384224501073e-20,  6.726388758958010e-23, -1.009652750567787e-24,  2.591519290913603e-27,
  8.023035030824880e-01, -3.643590774477602e-03,  6.861296719892197e-06,  1.624827677972893e-08, -1.487599589897551e-10,  2.426129322884356e-13,  1.927623921732879e-15,
 -1.266835575773461e-17,  7.763217248836710e-21,  2.502709682069543e-22, -1.316224365416194e-24, -1.178699251224827e-27,  8.983899203659158e-01, -3.909304639636920e-03,
  5.669001327504571e-06,  2.755025033453225e-08, -1.632593233876756e-10, -1.227022291676479e-14,  3.436323936657737e-15, -1.175398251775019e-17, -4.151854896245516e-20,
  4.384627912255801e-22, -6.574619129454598e-25, -1.003844251897740e-26,  9.996997414838590e-01, -4.131966484317281e-03,  3.882342540895819e-06,  3.969415290780694e-08,
 -1.542678592462049e-10, -4.178487710570391e-13,  4.670267766567138e-15, -3.380399893203229e-18, -1.142943736334191e-19,  4.390990760370714e-22,  1.766617093962471e-24,
 -1.962796316965331e-26,  1.105891642906109e+00, -4.292821616083388e-03,  1.434205949301795e-06,  5.122963343257122e-08, -1.087825579413481e-10, -9.445051543644430e-13,
  4.699849919471379e-15,  1.522825942787683e-17, -1.739997562896758e-19, -5.602279436941438e-23,  5.526417304958593e-24, -1.327812769947034e-26,  1.216412570197831e+00,
 -4.368748748287218e-03, -1.695051474985692e-06,  5.975446895190405e-08, -1.471409048047149e-11, -1.466574229574832e-12,  2.225413967583191e-15,  4.129170900889864e-17,
 -1.341763805335261e-19, -1.205577225525341e-21,  6.495407279289706e-24,  3.177394536071639e-26,  1.330392588837910e+00, -4.332025360008315e-03, -5.427480403419534e-06,
  6.172210110809699e-08,  1.313055527787985e-10, -1.707491481453957e-12, -3.759094867738180e-15,  5.861519519401389e-17,  1.116763509022423e-19, -2.272298935672247e-21,
 -3.481299650623343e-24,  9.192517780884669e-26,  1.446489693498338e+00, -4.151223677485906e-03, -9.507576377938886e-06,  5.265166188299404e-08,  3.087361264907182e-10,
 -1.240872683841604e-12, -1.210536753736860e-14,  3.372112886706744e-17,  5.181800182192411e-19, -9.206818541150419e-22, -2.371559384340666e-23,  1.694382152238317e-26,
  1.562666859641174e+00, -3.794795641535173e-03, -1.339316398001539e-05,  2.847229086351926e-08,  4.520734189224329e-10,  2.875275480393599e-13, -1.668350359215856e-14,
 -5.844422821695873e-17,  5.832349788607420e-19,  4.347269248687441e-21, -1.651784643245500e-23, -2.668099080047242e-25,  1.675891148472094e+00, -3.240204204927020e-03,
 -1.615790183816600e-05, -1.084606149713677e-08,  4.436216219846745e-10,  2.498423526085329e-12, -7.045853042152259e-15, -1.510781707466860e-16, -3.953054609146378e-19,
  5.894985135985817e-21,  5.085619226756924e-23, -7.352702324508702e-26,  1.781782647276658e+00, -2.492643898547419e-03, -1.655370868472784e-05, -5.505376052084562e-08,
  1.782272541468176e-10,  3.503500747093174e-12,  1.675737176610596e-14, -5.612453783700880e-17, -1.331181911369949e-18, -6.894099849839420e-21,  2.585487084192687e-23,
  6.197828369870063e-25,  1.874349177158950e+00, -1.615308749990381e-03, -1.354963208260506e-05, -7.996630734355088e-08, -2.459423026737161e-10,  1.157458910782770e-12,
  2.339209807354609e-14,  1.708345206869680e-16,  3.939525250310799e-19, -6.245257550330302e-21, -9.049400932254152e-23, -5.598963088179609e-25,  1.946152982214114e+00,
 -7.599305732958507e-04, -7.592589386507607e-06, -6.210344947557386e-08, -4.202458906482895e-10, -2.174224904972174e-12, -5.378800705809373e-15,  5.056772699323560e-17,
  9.460907447564281e-19,  9.106007804708177e-21,  5.951007702591901e-23,  1.976498251118466e-25,  1.989455420110751e+00, -1.575691417504954e-04, -1.746746010508014e-06,
 -1.696659904150292e-08, -1.517098718452580e-10, -1.272816456206829e-12, -1.008585048228254e-14, -7.540502391758078e-17, -5.273499416329291e-19, -3.379594098701271e-21,
 -1.890101992123779e-23, -7.921193582332797e-26,  6.229953541016653e-04, -3.499856844192533e-06,  1.474016312975901e-08, -5.519246596403486e-11,  1.935011398380528e-13,
 -6.524415550023958e-16,  2.126176661460859e-18, -6.880182851878371e-21,  2.107406471846890e-23, -7.097532781856150e-26,  1.674563139471288e-28, -1.013351077162754e-30,
  5.608264511149657e-03, -3.147775421441299e-05,  1.322640466024248e-07, -4.930969160712415e-10,  1.716770480085769e-12, -5.730149930537573e-15,  1.841004484165296e-17,
 -5.850570362593408e-20,  1.745466049075477e-22, -5.752384728349070e-25,  1.249447470996763e-27, -8.122035148373990e-30,  1.558576585364178e-02, -8.732077609023744e-05,
  3.651798826410165e-07, -1.349456311011276e-09,  4.631487766211165e-12, -1.513450146085008e-14,  4.716839475675448e-17, -1.440275938770705e-19,  4.041769845962030e-22,
 -1.264947483848993e-24,  2.149968473536642e-27, -1.758668673885041e-29,  3.056940489996425e-02, -1.707985183171447e-04,  7.091640847446569e-07, -2.585079195087920e-09,
  8.674677263469156e-12, -2.738970698701002e-14,  8.107619422304167e-17, -2.303512374785138e-19,  5.712242372133474e-22, -1.597051693765225e-24,  8.558003546333172e-28,
 -2.249834188782364e-29,  5.057998306940315e-02, -2.815529603609381e-04,  1.157579905782394e-06, -4.140457503259298e-09,  1.345388016010476e-11, -4.035146724480213e-14,
  1.099023235958810e-16, -2.738093319617290e-19,  5.069007000377719e-22, -9.851322615014412e-25, -4.452598365776893e-27, -1.832560998336728e-29,  7.564511335662100e-02,
 -4.190827965412642e-04,  1.701290020267646e-06, -5.934933659922181e-09,  1.845055320252529e-11, -5.130040862887463e-14,  1.214787136621156e-16, -2.274884405162172e-19,
  5.814057424123452e-23,  9.523727650917642e-25, -1.420776881603509e-26, -8.040612217026830e-30,  1.057990789927712e-01, -5.827211947947051e-04,  2.328396965339998e-06,
 -7.865654915342859e-09,  2.302640790603373e-11, -5.708447339197981e-14,  1.030929719544638e-16, -5.117195971730078e-20, -8.547228695265043e-22,  4.110866207011560e-24,
 -2.630918283298981e-26, -5.788232196054039e-30,  1.410826058429936e-01, -7.716056928584975e-04,  3.023903151195439e-06, -9.806395600649604e-09,  2.643456588734459e-11,
 -5.432718733599827e-14,  4.338406510843041e-17,  2.761564591814391e-19, -2.173384753904805e-21,  7.642073997878602e-24, -3.546297042744915e-26, -3.642668893410073e-29,
  1.815425056112087e-01, -9.846384379055412e-04,  3.769280287724084e-06, -1.160638573860769e-08,  2.783832917335997e-11, -3.972485911852259e-14, -6.517467863000047e-17,
  7.416504072864460e-19, -3.639445283459061e-21,  9.808978269120378e-24, -3.359786131787310e-26, -1.279937488573622e-28,  2.272311276373579e-01, -1.220434326888643e-03,
  4.541936766190871e-06, -1.308937846576658e-08,  2.634166484665705e-11, -1.046268838921204e-14, -2.231402178769178e-16,  1.282878376175204e-18, -4.751016016847671e-21,
  8.082891792145261e-24, -1.206136188039257e-26, -2.947962084219129e-28,  2.782055293669834e-01, -1.477253756175495e-03,  5.314571507506386e-06, -1.405334047820631e-08,
  2.103732908473345e-11,  3.521332671874066e-14, -4.203148040210441e-16,  1.773417698211843e-18, -4.764706305619334e-21, -3.431111671490071e-25,  3.374268475248369e-26,
 -5.114097551342619e-28,  3.345262352050635e-01, -1.752915569610853e-03,  6.054405434566823e-06, -1.427139294672159e-08,  1.108107957079330e-11,  9.722710973932009e-14,
 -6.314749779563863e-16,  2.014327327710913e-18, -2.783794441851257e-21, -1.742150975509251e-23,  9.705695693045982e-26, -6.840168252567262e-28,  3.962553939366667e-01,
 -2.044684315324238e-03,  6.722289656651659e-06, -1.349501781662989e-08, -4.196191964732012e-12,  1.726669985596368e-13, -8.121106114406528e-16,  1.739585871008176e-18,
  2.010173958424685e-21, -4.233109003277964e-23,  1.508816634907264e-25, -6.371392408455151e-28,  4.634540561273650e-01, -2.349123980185733e-03,  7.271707502189621e-06,
 -1.146115755964838e-08, -2.512230031936608e-11,  2.545263617932210e-13, -8.953050737042102e-16,  6.488513033319461e-19,  9.913007849721596e-21, -6.880833519230457e-23,
  1.413791085401570e-25, -1.517496495999770e-28,  5.361781591013850e-01, -2.661907865842385e-03,  7.647724584129291e-06, -7.905797780461789e-09, -5.144269943315876e-11,
  3.302349749183268e-13, -7.920300992711783e-16, -1.512128842800362e-18,  1.998238536135221e-20, -8.234001297304598e-23, -7.417242145507755e-27,  8.900559867694559e-28,
  6.144726032116378e-01, -2.977571154318904e-03,  7.786013374402625e-06, -2.588106561982139e-09, -8.197989103312374e-11,  3.801732461944255e-13, -3.990591958618671e-16,
 -4.796197101572078e-18,  2.907194616216437e-20, -5.909434381370268e-23, -3.611756262106963e-25,  2.200863806422637e-27,  6.983624892435175e-01, -3.289189123438079e-03,
  7.612215858005224e-06,  4.668564570573740e-09, -1.141703316056932e-10,  3.766759581811319e-13,  3.783131359146167e-16, -8.796996425334403e-18,  3.087634276586006e-20,
  2.920477620773263e-23, -8.928117765387056e-25,  2.658564837467823e-27,  7.878400989833476e-01, -3.587960561635743e-03,  7.042163023916642e-06,  1.390932913198195e-08,
 -1.434736233571645e-10,  2.846553703519369e-13,  1.577669440217629e-15, -1.228601428002853e-17,  1.581657735528877e-20,  1.969937765892698e-22, -1.338381230641931e-24,
  9.012929984052487e-29,  8.828454369674468e-01, -3.862674613640857e-03,  5.983937541315926e-06,  2.494050447697101e-08, -1.627073828681130e-10,  6.611646530191579e-14,
  3.090944090694231e-15, -1.283591949132048e-17, -2.630738942561406e-20,  4.040232692955990e-22, -1.047564719378078e-24, -7.716381246253503e-27,  9.832369497562494e-01,
 -4.099044981261185e-03,  4.343606502910905e-06,  3.716506196023689e-08, -1.615137094607970e-10, -3.072963954181191e-13,  4.526876571896471e-15, -6.772943834646586e-18,
 -9.742198142467933e-20,  4.926163690334414e-22,  9.143054161098449e-25, -1.894072629442337e-26,  1.088747153574795e+00, -4.278919930096940e-03,  2.037915272539875e-06,
  4.934425392927736e-08, -1.265134135140442e-10, -8.272216131669505e-13,  5.048283011834943e-15,  9.669389668824794e-18, -1.721979069737194e-19,  1.512304693928719e-22,
  4.787439195257189e-24, -1.997698934813046e-26,  1.198914987157582e+00, -4.379447156234716e-03, -9.803678871093937e-07,  5.928767743991920e-08, -4.342049705315670e-11,
 -1.399813708592983e-12,  3.315318270222061e-15,  3.635626782080054e-17, -1.726037729555428e-19, -9.222392317576076e-22,  7.559236959067317e-24,  1.638684683830782e-26,
  1.312982385553917e+00, -4.372449451709723e-03, -4.675351139790864e-06,  6.354545376181800e-08,  9.638824303747806e-11, -1.777687580879744e-12, -2.080281652811275e-15,
  6.086106985767730e-17,  2.834703703954478e-20, -2.330228214195883e-21,  5.772254191556888e-25,  9.088468209130393e-26,  1.429736795033530e+00, -4.224675019466629e-03,
 -8.846986918923429e-06,  5.737746915795300e-08,  2.810993942408433e-10, -1.518234584538391e-12, -1.093530632072087e-14,  4.959187582938377e-17,  4.682805049000547e-19,
 -1.838987891298105e-21, -2.182354353235887e-23,  6.846886418326943e-26,  1.547275724336633e+00, -3.900451026346586e-03, -1.300797956934325e-05,  3.572919804185155e-08,
  4.536988722226192e-10, -1.302653382963591e-13, -1.803616660114110e-14, -3.742697982101821e-17,  7.250453613862996e-19,  3.455659810142126e-21, -2.790046757198625e-23,
 -2.445208889904803e-25,  1.662671156195832e+00, -3.369863634827599e-03, -1.624385168857481e-05, -3.359016907271577e-09,  4.915499375908481e-10,  2.277341280977601e-12,
 -1.141848667910576e-14, -1.599490399366589e-16, -1.476906807510463e-19,  7.815689999744172e-21,  4.392805680717009e-23, -2.449083405888822e-25,  1.771543103893164e+00,
 -2.627662206441889e-03, -1.719486257558135e-05, -5.162033648518617e-08,  2.521659279747951e-10,  3.881785450716810e-12,  1.455394910046140e-14, -1.024378421327343e-16,
 -1.553793897189145e-18, -5.272639908862170e-21,  5.615299288059396e-23,  7.473165805543544e-25,  1.867664978743609e+00, -1.727609120026251e-03, -1.453197100155627e-05,
 -8.368403840623695e-08, -2.167851823958285e-10,  1.777460287505735e-12,  2.831289740688950e-14,  1.790972261972173e-16,  9.808439099477209e-20, -1.035018642495590e-20,
 -1.143536035476711e-22, -5.041183857069715e-25,  1.942986892842843e+00, -8.237699085820515e-04, -8.379630621877755e-06, -6.918172666962157e-08, -4.648875862938817e-10,
 -2.282584576994958e-12, -3.486406577100656e-15,  8.656275219312763e-17,  1.318634429112547e-18,  1.163530882391870e-20,  6.615874153943665e-23,  8.741878224814213e-26,
  1.988795845226585e+00, -1.724007955104786e-04, -1.965794055467339e-06, -1.961151322841893e-08, -1.797681753888514e-10, -1.542237657835038e-12, -1.245281411690650e-14,
 -9.437960277446393e-17, -6.634631282655474e-19, -4.205048178062433e-21, -2.233835614866055e-23, -7.443933733420709e-26,  6.092276477268035e-04, -3.384533119228615e-06,
  1.409600784142691e-08, -5.219812999920534e-11,  1.809473708568301e-13, -6.036511696511458e-16,  1.942597304926295e-18, -6.245491285261748e-21,  1.862841900505727e-23,
 -6.521015339187301e-26,  1.194989089355469e-28, -1.193711946945390e-30,  5.484432891621822e-03, -3.044285208857236e-05,  1.265079879456903e-07, -4.665219515410820e-10,
  1.606456383228753e-12, -5.307354417836184e-15,  1.684703343598730e-17, -5.324262647514493e-20,  1.546478031404684e-22, -5.328323103062614e-25,  8.578872091286666e-28,
 -9.915929130370432e-30,  1.524222481738041e-02, -8.446287377889941e-05,  3.494212365184595e-07, -1.277713864780775e-09,  4.339798873893641e-12, -1.404943327698951e-14,
  4.330995669805302e-17, -1.318075368109257e-19,  3.599877734714353e-22, -1.195857868430226e-24,  1.262436148794297e-27, -2.339943553251515e-29,  2.989736426307200e-02,
 -1.652469708845519e-04,  6.789581627762089e-07, -2.450563145093713e-09,  8.145829424036662e-12, -2.551926373417076e-14,  7.487365973698822e-17, -2.129874867330064e-19,
  5.140779954550581e-22, -1.586005612847643e-24, -3.997944031704357e-28, -3.579126439911408e-29,  4.947198291826457e-02, -2.724874640353784e-04,  1.109159813453801e-06,
 -3.931510916946815e-09,  1.267261570258882e-11, -3.780401250524997e-14,  1.024571662770777e-16, -2.581922662057649e-19,  4.679787040965464e-22, -1.185779025740000e-24,
 -5.758645463132960e-27, -4.300857559471578e-29,  7.399555873931181e-02, -4.057524116025170e-04,  1.631808718404897e-06, -5.647776627360337e-09,  1.745318518404001e-11,
 -4.846111765021703e-14,  1.151394496822395e-16, -2.251903391968564e-19,  8.202041121328441e-23,  3.667935576882004e-25, -1.535370176752295e-26, -4.700825258708354e-29,
  1.035048595041046e-01, -5.644653932226056e-04,  2.236182399765873e-06, -7.506232012435771e-09,  2.190932927414348e-11, -5.463039706588590e-14,  1.012980344329620e-16,
 -7.635963335486852e-20, -7.258586384065828e-22,  3.039566619620217e-24, -2.764242720424200e-26, -5.912198744499601e-29,  1.380438302783930e-01, -7.478780666331298e-04,
  2.908728456473400e-06, -9.392075832828474e-09,  2.535902106566480e-11, -5.320079583875184e-14,  5.018215399176675e-17,  2.107321511228916e-19, -1.924332611977441e-21,
  6.175325984041893e-24, -3.833767438363770e-26, -1.003607401480305e-28,  1.776633888685298e-01, -9.550337909935064e-04,  3.632649663487349e-06, -1.116740660924439e-08,
  2.702980546718591e-11, -4.105270037958230e-14, -4.598776999032986e-17,  6.305668184302535e-19, -3.312013539768591e-21,  8.335980731028593e-24, -4.054574376529135e-26,
 -1.962096021361107e-28,  2.224210766172222e-01, -1.184719975726975e-03,  4.387385209141958e-06, -1.266986492588086e-08,  2.608167933450987e-11, -1.540392126067316e-14,
 -1.893051487723908e-16,  1.135382276986051e-18, -4.471975925657664e-21,  7.325465309539990e-24, -2.630723369053594e-26, -3.636197213069153e-28,  2.723804875770421e-01,
 -1.435405972258978e-03,  5.147972516129745e-06, -1.371164059817974e-08,  2.164465311657876e-11,  2.570440738449470e-14, -3.727939560281597e-16,  1.620965005307611e-18,
 -4.758335196811353e-21,  5.392151137265073e-25,  9.810435941131089e-27, -5.894434554417224e-28,  3.276103632310630e-01, -1.705162196412322e-03,  5.884274057332111e-06,
 -1.407934379127853e-08,  1.287858187532882e-11,  8.273790384209680e-14, -5.764102447794919e-16,  1.915899886228876e-18, -3.348596809697103e-21, -1.417033426175779e-23,
  6.463594774103015e-26, -8.038115247531029e-28,  3.881831864146430e-01, -1.991554644634111e-03,  6.560057183813680e-06, -1.353557248653737e-08, -9.337814215781532e-13,
  1.537667456487193e-13, -7.627227750288756e-16,  1.780635221034620e-18,  5.875979156416182e-22, -3.691634785181982e-23,  1.182340894203156e-25, -8.608905158207931e-28,
  4.541730273322757e-01, -2.291506909668535e-03,  7.131926094640505e-06, -1.182355083165500e-08, -2.024499902413515e-11,  2.332906492347212e-13, -8.730609270571772e-16,
  9.275056988305233e-19,  7.535075498764863e-21, -6.339933572937145e-23,  1.261435507251239e-25, -5.549964578278794e-28,  5.256522712899909e-01, -2.601119044696288e-03,
  7.548131084885814e-06, -8.677089313230513e-09, -4.503115486068783e-11,  3.107876942554777e-13, -8.258632365704750e-16, -9.201111503453969e-19,  1.702069299649044e-20,
 -8.202509332036431e-23,  1.872231240543505e-26,  2.789462007162114e-28,  6.026866673893169e-01, -2.915429000705610e-03,  7.747335134573478e-06, -3.839521266921331e-09,
 -7.448254348477561e-11,  3.690873665163085e-13, -5.206671361625856e-16, -3.902542829542221e-18,  2.670618103133935e-20, -7.178986501143225e-23, -2.785636617092041e-25,
  1.518166409858481e-27,  6.853278399313921e-01, -3.228097784459908e-03,  7.657528261175412e-06,  2.902519009872677e-09, -1.065653886171835e-10,  3.829120621529766e-13,
  1.459400631142303e-16, -7.798798523891026e-18,  3.131254339516496e-20, -4.232999996834463e-24, -7.814177557681922e-25,  2.335936399657533e-27,  7.736019339469135e-01,
 -3.530994189005675e-03,  7.195495725347317e-06,  1.166123744487715e-08, -1.374294179216402e-10,  3.184547127558855e-13,  1.241739457938295e-15, -1.167672384369438e-17,
  2.194807351338757e-20,  1.437929055426131e-22, -1.316434451898488e-24,  8.056216741048626e-28,  8.674923146769863e-01, -3.813650099433108e-03,  6.267660041660946e-06,
  2.235167183636633e-08, -1.606727745518197e-10,  1.359042615681654e-13,  2.721877892183018e-15, -1.345375171067790e-17, -1.259285376089777e-20,  3.559580119190607e-22,
 -1.340946418365609e-24, -5.696451945523723e-27,  9.669130294907645e-01, -4.062556567076723e-03,  4.773898045258684e-06,  3.453750762835229e-08, -1.665902983245299e-10,
 -2.012627459075542e-13,  4.296296129773662e-15, -9.601248999976732e-18, -7.922680380874887e-20,  5.129178777243464e-22,  1.116495506283982e-25, -1.745620844629673e-26,
  1.071667780477542e+00, -4.260283709572512e-03,  2.617376614395322e-06,  4.719434774312409e-08, -1.418275196961177e-10, -7.034302660088976e-13,  5.242952797913323e-15,
  4.281311429959440e-18, -1.635325751763360e-19,  3.236297859217296e-22,  3.798536632965616e-24, -2.464799646531069e-26,  1.181385999068658e+00, -4.384458199147699e-03,
 -2.739930808382610e-07,  5.837363697932934e-08, -7.054198692764934e-11, -1.308683060562643e-12,  4.251398974213720e-15,  3.036122516464552e-17, -2.002305246742233e-19,
 -6.101220526264569e-22,  7.931275676681939e-24,  5.700880866387287e-28,  1.295422645015239e+00, -4.406778578274060e-03, -3.904732898833389e-06,  6.480110320213763e-08,
  6.047345875064988e-11, -1.807139680315281e-12, -3.760069989159612e-16,  6.043810502669562e-17, -5.418341582324462e-20, -2.229664568591392e-21,  4.372154754828335e-24,
  8.008773309327955e-26,  1.412701008638543e+00, -4.292622735158944e-03, -8.132518611246899e-06,  6.161838403066645e-08,  2.482311736279514e-10, -1.762392797712268e-12,
 -9.348059631449223e-15,  6.335584879558577e-17,  3.872168526173754e-19, -2.637888622638807e-21, -1.779884550067379e-23,  1.126573813850677e-25,  1.531468681742098e+00,
 -4.002676807680297e-03, -1.253583711794885e-05,  4.294371063821585e-08,  4.466940088357200e-10, -5.729802957882675e-13, -1.874225320250457e-14, -1.247067477668722e-17,
  8.268970493956221e-19,  2.139152341514718e-21, -3.749805954475012e-23, -1.860062773732636e-25,  1.648931737932079e+00, -3.499838622330324e-03, -1.623552046012165e-05,
  4.853738113478054e-09,  5.339919474769121e-10,  1.949292198719601e-12, -1.591864662787545e-14, -1.598584396615839e-16,  1.622213316851851e-19,  9.304167587669889e-21,
  2.918914061524358e-23, -4.237838577296554e-25,  1.760753518880348e+00, -2.767624275709953e-03, -1.778747814255991e-05, -4.694669598890620e-08,  3.330325358341343e-10,
  4.190884323403945e-12,  1.096452425575644e-14, -1.546971348614530e-16, -1.695059969015413e-18, -2.349063330595301e-21,  9.031694978959704e-23,  7.863786134510599e-25,
  1.860515591369569e+00, -1.847937737370840e-03, -1.555569345869837e-05, -8.682958100103795e-08, -1.740344350212736e-10,  2.517124288616706e-12,  3.330901391678249e-14,
  1.753507119974989e-16, -3.617787050286451e-19, -1.531884364968716e-20, -1.325310717001020e-22, -2.904575608221505e-25,  1.939552298184422e+00, -8.942576204685835e-04,
 -9.255959313239376e-06, -7.698877285734020e-08, -5.111533391290850e-10, -2.331999645268921e-12, -4.052624300120186e-16,  1.359758696534988e-16,  1.785537904382072e-18,
  1.429823892089174e-20,  6.519847571920054e-23, -1.595267455805813e-25,  1.988073226604476e+00, -1.891198518768440e-04, -2.219462999526471e-06, -2.275174403868234e-08,
 -2.138286721890093e-10, -1.875362021180333e-12, -1.541669728456538e-14, -1.182110693042759e-16, -8.316667938425698e-19, -5.158069445070149e-21, -2.510861594382946e-23,
 -4.605246860313844e-26,  5.959111526119225e-04, -3.274222250434742e-06,  1.348661086519738e-08, -4.939708137841773e-11,  1.693267450774858e-13, -5.590620978515500e-16,
  1.775722119025570e-18, -5.686128605889775e-21,  1.635338059525626e-23, -6.157807977419869e-26,  5.921739765824957e-29, -1.592426381017630e-30,  5.364650761826430e-03,
 -2.945275220947160e-05,  1.210605112867216e-07, -4.416463546185472e-10,  1.504234644257062e-12, -4.920373440826871e-15,  1.542268044590924e-17, -4.859509067137290e-20,
  1.359702781758449e-22, -5.081638773444336e-25,  3.484924307560347e-28, -1.364941947800902e-29,  1.490986859457781e-02, -8.172767472132053e-05,  3.344961977749719e-07,
 -1.210469747834075e-09,  4.068912218217041e-12, -1.305301941609140e-14,  3.977420526447018e-17, -1.209691675353332e-19,  3.175732488121831e-22, -1.168727423947129e-24,
  1.378139093102059e-29, -3.448314107731335e-29,  2.924705654498402e-02, -1.599307551125877e-04,  6.503168727508664e-07, -2.324217316128679e-09,  7.652940154620253e-12,
 -2.379205373963007e-14,  6.913169209629723e-17, -1.974570360962907e-19,  4.562618267633114e-22, -1.639438993656847e-24, -2.441421077372653e-27, -5.918477624824527e-29,
  4.839948561591250e-02, -2.637995077064536e-04,  1.063173729044761e-06, -3.734666531628505e-09,  1.194054816442115e-11, -3.543014204084989e-14,  9.543067850995067e-17,
 -2.439487203413468e-19,  4.205946246835355e-22, -1.464547131260394e-24, -8.478215712001628e-27, -8.417837672899913e-29,  7.239823540749539e-02, -3.929643605630798e-04,
  1.565679400821077e-06, -5.376131439759713e-09,  1.651108713603691e-11, -4.577313037999072e-14,  1.088719773308220e-16, -2.224779327289091e-19,  8.352590097043945e-23,
 -3.051689702264781e-25, -1.870673426602571e-26, -1.107721436530187e-28,  1.012822146807570e-01, -5.469303560073161e-04,  2.148175280950527e-06, -7.164292287889490e-09,
  2.084084651338729e-11, -5.222743245223984e-14,  9.884967288566245e-17, -9.805611815454684e-20, -6.371665972212133e-22,  1.858959735745843e-24, -3.203334434405492e-26,
 -1.481444820902634e-28,  1.350981535011975e-01, -7.250522413981945e-04,  2.798423117131654e-06, -8.994776302077625e-09,  2.430749167681080e-11, -5.193238193599393e-14,
  5.525180594794579e-17,  1.524042428043183e-19, -1.730943754311161e-21,  4.524605017915734e-24, -4.502306744507675e-26, -2.141333045399028e-28,  1.739005376729895e-01,
 -9.265013398565373e-04,  3.501208372357813e-06, -1.074155233091474e-08,  2.619908375990238e-11, -4.195624700471741e-14, -2.977290550791348e-17,  5.290520993209854e-19,
 -3.043488928968607e-21,  6.507732902097234e-24, -5.184892206803807e-26, -3.317790248925353e-28,  2.177514419504654e-01, -1.150221978318764e-03,  4.237839733874391e-06,
 -1.225525901689103e-08,  2.573066015329185e-11, -1.958169145087316e-14, -1.594798843078988e-16,  9.962619987116832e-19, -4.231388583789017e-21,  5.915243837569784e-24,
 -4.533247914742791e-26, -5.194790839931062e-28,  2.667201975227508e-01, -1.394874427545259e-03,  4.985526147297868e-06, -1.336168444417698e-08,  2.207285822148553e-11,
  1.728480988515888e-14, -3.295355176655508e-16,  1.469031388361501e-18, -4.738498648898370e-21,  3.685129145560642e-25, -1.967723546373243e-26, -7.734216763552569e-28,
  3.208827979053430e-01, -1.658760188513463e-03,  5.716610497255586e-06, -1.386078203997251e-08,  1.439928223484022e-11,  6.953523650798178e-14, -5.243387685127997e-16,
  1.801009136028341e-18, -3.821235940259770e-21, -1.235155383316909e-23,  2.456580953392980e-26, -1.043771352507133e-27,  3.803208999890780e-01, -1.939723921283575e-03,
  6.397638981646088e-06, -1.352688792602452e-08,  1.962544388800376e-12,  1.360606199551747e-13, -7.127954831996674e-16,  1.779007984290539e-18, -6.661992525620433e-22,
 -3.303558138488362e-23,  7.325495523376242e-26, -1.212684133621384e-27,  4.451202046054259e-01, -2.235024190740114e-03,  6.988250274021526e-06, -1.211127349023304e-08,
 -1.578648509017334e-11,  2.126740002974617e-13, -8.440515458187437e-16,  1.133027708862610e-18,  5.336337960195003e-21, -5.898716529601846e-23,  9.054743129333871e-26,
 -1.094997507567239e-27,  5.153678890717698e-01, -2.541162279416889e-03,  7.439884632347814e-06, -9.348946372629830e-09, -3.901538843999562e-11,  2.907166431081508e-13,
 -8.444438896099446e-16, -4.225393733954541e-19,  1.408231085739845e-20, -8.124420372718981e-23,  1.464665500364385e-26, -5.026811184288152e-28,  5.911485890776125e-01,
 -2.853654319477459e-03,  7.694351856161038e-06, -4.972902380104607e-09, -6.723411855310495e-11,  3.553742084671594e-13, -6.183771413325979e-16, -3.091330800297780e-18,
  2.393497918758418e-20, -8.185335239357134e-23, -2.315424746385523e-25,  5.639534821195080e-28,  6.725381496845405e-01, -3.166726640341338e-03,  7.682381352431794e-06,
  1.258856816408811e-09, -9.888922563274296e-11,  3.839071018177395e-13, -5.846308294273844e-17, -6.805077821227774e-18,  3.062059360409435e-20, -3.362924979955376e-23,
 -6.941595905914035e-25,  1.541824362436256e-27,  7.595939192544150e-01, -3.472907370581925e-03,  7.322452475612070e-06,  9.514829063570651e-09, -1.307883598609275e-10,
  3.444168663623017e-13,  9.253301040754848e-16, -1.090164959275276e-17,  2.618598405111742e-20,  9.190574879587900e-23, -1.277799122059020e-24,  8.192097279192882e-28,
  8.523396341692558e-01, -3.762479412850816e-03,  6.520556359757513e-06,  1.980607270311438e-08, -1.573321382103012e-10,  1.966747935230394e-13,  2.341381188190751e-15,
 -1.366250479235170e-17, -7.999354751700285e-22,  2.977703716266744e-22, -1.558414858184220e-24, -4.327008571487516e-27,  9.507417461130292e-01, -4.022753164904758e-03,
  5.172240520623988e-06,  3.184536684641290e-08, -1.696076259993263e-10, -1.016470867028051e-13,  3.994741053969810e-15, -1.184167609270987e-17, -6.086185897821512e-20,
  5.025296870666430e-22, -6.185879115818766e-25, -1.575514106178049e-26,  1.054672054620218e+00, -4.237118969687093e-03,  3.169651313754849e-06,  4.481942566291863e-08,
 -1.546311130991880e-10, -5.767404520166262e-13,  5.291514895352968e-15, -7.381769047987318e-19, -1.494173277341763e-19,  4.529148994714057e-22,  2.644628609817749e-24,
 -2.755432520139231e-26,  1.163848189115517e+00, -4.383869348438992e-03,  4.188735171325218e-07,  5.704139549728226e-08, -9.563027319505730e-11, -1.197190256914776e-12,
  5.008943509405852e-15,  2.366342528204472e-17, -2.165195329641495e-19, -2.968753305581645e-22,  7.621731542214858e-24, -1.442977579148151e-26,  1.277737999459354e+00,
 -4.434892286929120e-03, -3.122506947226326e-06,  6.547961678930240e-08,  2.437617470584499e-11, -1.796125367719703e-12,  1.280197959448996e-15,  5.746030015450028e-17,
 -1.304995918716679e-19, -1.989403007706561e-21,  7.500953824587639e-24,  6.090349304328927e-26,  1.395405172090254e+00, -4.354660437677320e-03, -7.370468769553437e-06,
  6.529653725978946e-08,  2.108903212983083e-10, -1.964150895087986e-12, -7.415819359997709e-15,  7.410027767478549e-17,  2.807260206759083e-19, -3.240642569110369e-21,
 -1.211973509445226e-23,  1.426607918869266e-25,  1.515260835021273e+00, -4.100781735825350e-03, -1.197808749282522e-05,  4.997463391457178e-08,  4.307236947721278e-10,
 -1.023934023180725e-12, -1.871155482173858e-14,  1.491810705173501e-17,  8.751535511250341e-19,  4.998761184600582e-22, -4.381602287247600e-23, -9.700586578892769e-26,
  1.634673192779753e+00, -3.629341740209458e-03, -1.612479720735140e-05,  1.368723084597749e-08,  5.687991285225880e-10,  1.514435428743487e-12, -2.027027281895729e-14,
 -1.491222295646126e-16,  5.132493726229114e-19,  1.005052924536103e-20,  7.005823312302803e-24, -5.774036310467846e-25,  1.749394990568921e+00, -2.912080502134704e-03,
 -1.831605936428964e-05, -4.093491991750209e-08,  4.190989423012488e-10,  4.395873781553583e-12,  5.866263436878653e-15, -2.095280785578500e-16, -1.706408009896244e-18,
  1.937000894279544e-21,  1.232284653858256e-22,  6.815911831097238e-25,  1.852868288857122e+00, -1.976594325903527e-03, -1.661254924757699e-05, -8.916631820727319e-08,
 -1.153091486487422e-10,  3.373603618477032e-12,  3.796644251928780e-14,  1.539082787399049e-16, -1.010784284907031e-18, -2.076511723570302e-20, -1.365992923056658e-22,
  1.474049966807890e-25,  1.935821120254686e+00, -9.721433309324897e-04, -1.023043230940128e-05, -8.553945777438646e-08, -5.575467512378444e-10, -2.289088395131221e-12,
  4.282841514595622e-15,  2.018317763243256e-16,  2.344487116419932e-18,  1.664822595885179e-20,  4.893618338671452e-23, -6.230817161007668e-25,  1.987279420616383e+00,
 -2.080287879610015e-04, -2.514317549670161e-06, -2.649434583068971e-08, -2.553203184525490e-10, -2.288267571276503e-12, -1.912850962994773e-14, -1.479922747105870e-16,
 -1.035769779473870e-18, -6.185203504052655e-21, -2.570079731414116e-23,  2.974961258217816e-26,  5.830263591255795e-04, -3.168655201539656e-06,  1.290973963044597e-08,
 -4.677504094534977e-11,  1.585590772572293e-13, -5.182982079606526e-16,  1.623505984809597e-18, -5.197980173537517e-21,  1.416063079453669e-23, -6.080216710546707e-26,
 -2.593184861052943e-29, -2.351968982497366e-30,  5.248743723973687e-03, -2.850506534294458e-05,  1.159019780128465e-07, -4.183462028810216e-10,  1.409420874615442e-12,
 -4.566082230336510e-15,  1.412019429993264e-17, -4.453532877300678e-20,  1.177669982321955e-22, -5.079971625037213e-25, -3.906725189261882e-28, -2.061243579466365e-29,
  1.458821937587773e-02, -7.910872045215119e-05,  3.203527262893372e-07, -1.147404901350399e-09,  3.817129050684659e-12, -1.213797473663371e-14,  3.652299839886768e-17,
 -1.114831619189920e-19,  2.750983659681800e-22, -1.203605240656754e-24, -1.902601392902306e-27, -5.445805631146534e-29,  2.861756484575793e-02, -1.548377365494854e-04,
  6.231455314026273e-07, -2.205488705341103e-09,  7.193251145685634e-12, -2.219764419572707e-14,  6.379826096967903e-17, -1.838255117831520e-19,  3.947643168441760e-22,
 -1.799599045279286e-24, -5.861735657533200e-27, -9.986017039457104e-29,  4.736101904526800e-02, -2.554701870952613e-04,  1.019481036213306e-06, -3.549164437797555e-09,
  1.125430305493747e-11, -3.322030291121391e-14,  8.878010100992802e-17, -2.314069956990654e-19,  3.607149358310183e-22, -1.895691215798207e-24, -1.358449305774749e-26,
 -1.538358810989175e-28,  7.085102649934398e-02, -3.806925573132072e-04,  1.502721131743796e-06, -5.119137890124293e-09,  1.562125072125342e-11, -4.323466905876412e-14,
  1.026772707404160e-16, -2.201364089063809e-19,  5.765216676071382e-23, -1.178443018242907e-24, -2.573081635369786e-26, -2.174010751652232e-28,  9.912832747427947e-02,
 -5.300832496323223e-04,  2.064170439547864e-06, -6.839067207137617e-09,  1.981978771625984e-11, -4.989023851394365e-14,  9.582686390048501e-17, -1.176369528834658e-19,
 -5.952220724976748e-22,  4.085710575340998e-25, -4.157521883243938e-26, -2.982165113505681e-28,  1.322420449330821e-01, -7.030900725482800e-04,  2.692785282416459e-06,
 -8.614092227921822e-09,  2.328241836826044e-11, -5.056125228923799e-14,  5.876555023328745e-17,  9.925131106853032e-20, -1.603193891604026e-21,  2.484595402150876e-24,
 -5.841088307055648e-26, -4.116667112094310e-28,  1.702497452656236e-01, -8.990002052402973e-04,  3.374797052834835e-06, -1.032911397294130e-08,  2.535395719994858e-11,
 -4.250383909660677e-14, -1.629074641978316e-17,  4.349765018840816e-19, -2.850614798786624e-21,  4.079048915652012e-24, -7.137689795634975e-26, -5.787023184990588e-28,
  2.132174379129330e-01, -1.116900545210325e-03,  4.093233196744358e-06, -1.184690027531485e-08,  2.530293238367828e-11, -2.308958227536333e-14, -1.334509719021228e-16,
  8.638657922880791e-19, -4.057251937725165e-21,  3.569513546663172e-24, -7.412344176455605e-26, -8.185287393972391e-28,  2.612194612500914e-01, -1.355625551853494e-03,
  4.827314981844071e-06, -1.300616918036558e-08,  2.234270913173622e-11,  9.852422683134819e-15, -2.905249852134416e-16,  1.317388091805421e-18, -4.748398549129476e-21,
 -1.189670183870349e-24, -6.085117303843808e-26, -1.134545140982915e-27,  3.143381751629900e-01, -1.613688604133112e-03,  5.551707168557628e-06, -1.361993473232886e-08,
  1.566815721171516e-11,  5.754202112186335e-14, -4.756884724834372e-16,  1.671708455163771e-18, -4.260274321705273e-21, -1.240092473501119e-23, -3.029744351524157e-26,
 -1.493669339056348e-27,  3.726633395029456e-01, -1.889191365381584e-03,  6.235591566097039e-06, -1.347463012300140e-08,  4.516703613796121e-12,  1.195477846461612e-13,
 -6.634571203113117e-16,  1.739113564141612e-18, -1.816943898532607e-21, -3.132459975948982e-23,  8.005263640054076e-27, -1.803863660403374e-27,  4.362909937453121e-01,
 -2.179703507430867e-03,  6.841536319390187e-06, -1.233091894616252e-08, -1.173291626643351e-11,  1.928148169915858e-13, -8.102509511679027e-16,  1.270406385156645e-18,
  3.264482712778780e-21, -5.654211146103740e-23,  2.582829898153110e-26, -1.904702693115925e-27,  5.053215531799505e-01, -2.482102129250849e-03,  7.324140095778314e-06,
 -9.927782220621412e-09, -3.340442871815156e-11,  2.703562383167424e-13, -8.504053382592010e-16, -1.864938546466418e-20,  1.116010121496240e-20, -8.139529744103292e-23,
 -3.019766394063706e-26, -1.603817826089818e-27,  5.798566783763186e-01, -2.792355956832664e-03,  7.628454410430588e-06, -5.992622675237055e-09, -6.028162052314122e-11,
  3.395782329460645e-13, -6.946670906214644e-16, -2.374319356017968e-18,  2.082423434687319e-20, -9.098747125052929e-23, -2.351969123535166e-25, -8.172051617901473e-28,
  6.599942196928128e-01, -3.105233479534172e-03,  7.688247228053823e-06, -2.620847017554677e-10, -9.123998185039289e-11,  3.803268984147114e-13, -2.355067774243643e-16,
 -5.849836489725507e-18,  2.892324282850052e-20, -6.040597941166963e-23, -6.550544073404725e-25,  1.131469457341498e-28,  7.458201226154424e-01, -3.413906082571036e-03,
  7.424305686160134e-06,  7.478426590422737e-09, -1.237021671925775e-10,  3.630592291573327e-13,  6.322426610154310e-16, -1.002056453614299e-17,  2.858165230514051e-20,
  4.132359237624147e-23, -1.257881144490025e-24, -8.782023825894567e-29,  8.373954906839295e-01, -3.709406746688260e-03,  6.743264687038389e-06,  1.732314962325223e-08,
 -1.528676719281540e-10,  2.482839137887519e-13,  1.959996348684329e-15, -1.352897765183569e-17,  8.753689893255826e-21,  2.318105006238533e-22, -1.737220433531519e-24,
 -4.010448798793609e-27,  9.347358442585225e-01, -3.979892917640563e-03,  5.538052060300184e-06,  2.912047395883872e-08, -1.707097539816855e-10, -9.955668729009004e-15,
  3.638585930094585e-15, -1.350590383243299e-17, -4.337932990760782e-20,  4.643407161554964e-22, -1.281911500915731e-24, -1.453892862408829e-26,  1.037777638961087e+00,
 -4.209653318297447e-03,  3.692281495346180e-06,  4.225993296813303e-08, -1.649003586619851e-10, -4.505166787175796e-13,  5.206489801667530e-15, -5.240643226186264e-18,
 -1.315058361941364e-19,  5.338717354901925e-22,  1.390212505736923e-24, -2.935500955299282e-26,  1.146323709777649e+00, -4.377808160984951e-03,  1.093421350470491e-06,
  5.532650343121549e-08, -1.183223439163904e-10, -1.069815443360673e-12,  5.573323066508534e-15,  1.662115070701156e-17, -2.219098843989838e-19, -8.796885638212161e-24,
  6.683831185632832e-24, -2.793435795380280e-26,  1.259953452429303e+00, -4.456725407167805e-03, -2.335589995756073e-06,  6.558446260999413e-08, -1.111147683425127e-11,
 -1.746629825421982e-12,  2.820297061195082e-15,  5.220114722473647e-17, -1.961357787681087e-19, -1.642897839427983e-21,  9.638172444163606e-24,  3.538399026466408e-26,
  1.377873642347000e+00, -4.410435636642509e-03, -6.567990547217168e-06,  6.834757031555200e-08,  1.700003437658591e-10, -2.116328593054523e-12, -5.233379084866992e-15,
  8.113592316553655e-17,  1.568948121243499e-19, -3.595199301244123e-21, -5.529209663672186e-24,  1.534534384203423e-25,  1.498670019897644e+00, -4.194092210462384e-03,
 -1.133779671988684e-05,  5.667818276689563e-08,  4.058044562354835e-10, -1.464829938695957e-12, -1.790152478071613e-14,  4.286615939573623e-17,  8.608506294892909e-19,
 -1.307455232500656e-21, -4.577154392209188e-23,  9.657842920433053e-27,  1.619899090522197e+00, -3.757526294110192e-03, -1.590503560433604e-05,  2.300251217200519e-08,
  5.938957756649034e-10,  9.800347067193999e-13, -2.416127857172575e-14, -1.269068201866984e-16,  8.736813857112669e-19,  9.789801182856301e-21, -2.072062034608227e-23,
 -6.700595488763520e-25,  1.737450670349963e+00, -3.060453137215709e-03, -1.876412456403199e-05, -3.352045197737015e-08,  5.079176238834309e-10,  4.460192123559588e-12,
 -7.474075774859940e-16, -2.620114449001175e-16, -1.541349987608068e-18,  7.394355585684312e-21,  1.475072898066594e-22,  3.886379752190902e-25,  1.844689297021044e+00,
 -2.113800610741947e-03, -1.769122397057324e-05, -9.042058952872799e-08, -3.839802248146669e-11,  4.332128502774791e-12,  4.170327011042751e-14,  1.085714836335068e-16,
 -1.853440090252063e-18, -2.591127081184824e-20, -1.155531677404740e-22,  8.550710291908614e-25,  1.931762140388033e+00, -1.058247769043464e-03, -1.131191736549430e-05,
 -9.481879393777183e-08, -6.017966746342249e-10, -2.109441301914298e-12,  1.107688793491873e-14,  2.867572601970533e-16,  2.970650037299382e-18,  1.785473425018539e-20,
  5.737585159035590e-24, -1.400607579090672e-24,  1.986404959971767e+00, -2.294881515860486e-04, -2.858355523305996e-06, -3.097201628715912e-08, -3.060324137256023e-10,
 -2.801035284496068e-12, -2.377118131608563e-14, -1.848931716850375e-16, -1.276273144356067e-18, -7.146741708643233e-21, -2.117510589020075e-23,  1.958080281291657e-25,
  };
  constexpr double w[11520] = {  1.029025267046880e-01, -4.544684831573169e-04,  2.135273977325504e-06, -1.046885617843379e-08,  5.261680290093145e-11,
 -2.676272340682671e-13,  1.366263779582665e-15, -6.967755845672489e-18,  3.540818716156698e-20, -1.790835151111668e-22,  9.010359355239102e-25, -4.509528399182888e-27,
  1.021038551219453e-01, -7.102696978595553e-04,  5.700708851765153e-06, -4.486623007420780e-08,  3.385185820574527e-10, -2.460087285404680e-12,  1.733467853145158e-14,
 -1.190466994087405e-16,  7.998089317359906e-19, -5.271567915327181e-21,  3.416009824751203e-23, -2.180010064118179e-25,  1.005325777609573e-01, -1.207507230264758e-03,
  1.449761427681115e-05, -1.562070648100816e-07,  1.554195905127391e-09, -1.456861846956456e-11,  1.302380058603871e-13, -1.119438300541729e-15,  9.305597664008126e-18,
 -7.514151867323474e-20,  5.914144217338707e-22, -4.549245893777353e-24,  9.823899250470960e-02, -1.918638764319370e-03,  3.157172893343605e-05, -4.436497675296677e-07,
  5.608235665977043e-09, -6.551820703700335e-11,  7.190466959606389e-13, -7.495400091986372e-15,  7.479903791486095e-17, -7.188122762231907e-19,  6.682300610530751e-21,
 -6.030580935187625e-23,  9.529416711214360e-02, -2.805174383905355e-03,  6.082434257432837e-05, -1.085007864668615e-06,  1.699708829280442e-08, -2.417777847919146e-10,
  3.187208897072438e-12, -3.947078325725829e-14,  4.636815867028301e-16, -5.204417025590767e-18,  5.612305159217636e-20, -5.839693480799811e-22,  9.178522662681086e-02,
 -3.820682680134247e-03,  1.063375679645528e-04, -2.356484247636611e-06,  4.486917058727724e-08, -7.635586218098215e-10,  1.189439059385015e-11, -1.723337458122891e-13,
  2.348745974404200e-15, -3.036574440874428e-17,  3.748140338991136e-19, -4.439062484058389e-21,  8.780988321364222e-02, -4.914229407928812e-03,  1.716578309060573e-04,
 -4.638804581190746e-06,  1.056463511961868e-07, -2.120003072684735e-09,  3.851043331652799e-11, -6.447387047808277e-13,  1.007590494464135e-14, -1.483832749249723e-16,
  2.074159916180046e-18, -2.767458435500314e-20,  8.347074385113432e-02, -6.033880468410436e-03,  2.591474304956787e-04, -8.400941556277702e-06,  2.256674226848367e-07,
 -5.273913436882358e-09,  1.104530465966294e-10, -2.114313989793257e-12,  3.751342842127648e-14, -6.233681629855202e-16,  9.779485157847071e-18, -1.457344880933822e-19,
  7.886990151654179e-02, -7.129929156555775e-03,  3.694958893210637e-04, -1.415785382985746e-05,  4.429761811675726e-07, -1.192343643934336e-08,  2.850113751962961e-10,
 -6.179895729694732e-12,  1.233990847979558e-13, -2.294722382276144e-15,  4.008581403357260e-17, -6.621602209676423e-19,  7.410422555983497e-02, -8.157578408285140e-03,
  5.014507172451246e-04, -2.240513713657077e-05,  8.072150170002067e-07, -2.477218101292906e-08,  6.696524474994534e-10, -1.630845836527684e-11,  3.635937975313582e-13,
 -7.510173076382647e-15,  1.450497366845221e-16, -2.637957887806682e-18,  6.926163781534463e-02, -9.078905836219543e-03,  6.517886862745161e-04, -3.353942889193431e-05,
  1.376729805079164e-06, -4.772017148341464e-08,  1.446501836446725e-09, -3.925769453919436e-11,  9.701256664196851e-13, -2.210495350055730e-14,  4.689543766512713e-16,
 -9.331607201697160e-18,  6.441851708428523e-02, -9.864044054960585e-03,  8.155116062415515e-04, -4.777731834702632e-05,  2.212467808306584e-06, -8.586178456381299e-08,
  2.895298152879914e-09, -8.692759417081467e-11,  2.364791524051340e-12, -5.905975876110794e-14,  1.367928498993844e-15, -2.961040299586873e-17,  5.963823871573957e-02,
 -1.049160431069398e-02,  9.862212859788012e-04, -6.508654868728263e-05,  3.368963377284637e-06, -1.451799660544716e-07,  5.405266016944925e-09, -1.782923619204761e-10,
  5.305125298065679e-12, -1.443426854784410e-13,  3.629119263785829e-15, -8.498836285971337e-17,  5.497074535065707e-02, -1.094844554823768e-02,  1.156610650095470e-03,
 -8.514142028579394e-05,  4.883473995097211e-06, -2.318683398890034e-07,  9.464035185313422e-09, -3.407087673673590e-10,  1.102055619224969e-11, -3.247809442404489e-13,
  8.815628761043225e-15, -2.221895543491974e-16,  5.045296917602424e-02, -1.122893758067618e-02,  1.319002736448961e-03, -1.073101860653289e-04,  6.764942108945604e-06,
 -3.512915591011323e-07,  1.561276827361954e-08, -6.095988012360752e-10,  2.130903224402665e-11, -6.764398865181929e-13,  1.971813689503036e-14, -5.321992654498212e-16,
  4.610988739913981e-02, -1.133388560293655e-02,  1.465874913705688e-03, -1.306769673246698e-04,  8.984747080665813e-06, -5.066930043170124e-07,  2.436214653578548e-08,
 -1.025445512468186e-09,  3.851858037875045e-11, -1.310061846208348e-12,  4.080374902731902e-14, -1.173674249545893e-15,  4.195598711710428e-02, -1.126927804020231e-02,
  1.590318915529943e-03, -1.540954933301813e-04,  1.147109682446283e-05, -6.978518760733211e-07,  3.607346820964062e-08, -1.627384510057545e-09,  6.532939417541360e-11,
 -2.368309995435445e-12,  7.843031317794508e-14, -2.392955604608996e-15,  3.799693549063959e-02, -1.104499739452167e-02,  1.686404385548785e-03, -1.762677532956720e-04,
  1.410841630998036e-05, -9.199515727574243e-07,  5.082082380846624e-08, -2.443473843364255e-09,  1.042758247293748e-10, -4.009030094139640e-12,  1.404900796653456e-13,
 -4.526027246463001e-15,  3.423128680605094e-02, -1.067360184326830e-02,  1.749431057412006e-03, -1.958380311031906e-04,  1.674233470699239e-05, -1.162927933286556e-06,
  6.826085487356482e-08, -3.478858844844996e-09,  1.570118946391749e-10, -6.370718906239875e-12,  2.351419404353208e-13, -7.963171795363951e-15,  3.065210074936763e-02,
 -1.016925061698638e-02,  1.776069819515338e-03, -2.114919278000055e-04,  1.919001818868895e-05, -1.411512789697012e-06,  8.754242445793696e-08, -4.704212387121289e-09,
  2.234205679234420e-10, -9.521470654071894e-12,  3.684677990545045e-13, -1.306001198345466e-14,  2.724838886793018e-02, -9.546813788274417e-03,  1.764404198380537e-03,
 -2.220506598637499e-04,  2.125480787779910e-05, -1.646083827809751e-06,  1.072869830781624e-07, -6.047617270594178e-09,  3.007693775095631e-10, -1.340012322861648e-11,
  5.412718228718343e-13, -1.999336146196650e-14,  2.400634388080545e-02, -8.821180253247823e-03,  1.713890746197891e-03, -2.265527183473440e-04,  2.274353337634289e-05,
 -1.844296891787395e-06,  1.256607171499791e-07, -7.393091659508169e-09,  3.831838569772521e-10, -1.776582162294091e-11,  7.457517621349336e-13, -2.858641481431687e-14,
  2.091033660471352e-02, -8.006757801307428e-03,  1.625259747720504e-03, -2.243173670754421e-04,  2.348455594763141e-05, -1.983338946574557e-06,  1.405431696166621e-07,
 -8.588046767542188e-09,  4.617073007620241e-10, -2.217639659611625e-11,  9.632151553453365e-13, -3.815740137374380e-14,  1.794368704961557e-02, -7.117146269796854e-03,
  1.500377372865246e-03, -2.149869658096332e-04,  2.334456525561792e-05, -2.042525831617119e-06,  1.497772993621848e-07, -9.460194150236605e-09,  5.251202096551466e-10,
 -2.601372693838342e-11,  1.164139624494691e-12, -4.746447012027679e-14,  1.508923033058670e-02, -6.164957999067652e-03,  1.342087898680783e-03, -1.985473601254168e-04,
  2.224237338789083e-05, -2.005899300631280e-06,  1.514673189515755e-07, -9.842161945019900e-09,  5.615152423520838e-10, -2.856436601247832e-11,  1.311494119144135e-12,
 -5.481200671626957e-14,  1.232970602633142e-02, -5.161757908409406e-03,  1.154050905436509e-03, -1.753273652683202e-04,  2.015835270468008e-05, -1.864463491634378e-06,
  1.442774504250160e-07, -9.599907253193297e-09,  5.604060052518153e-10, -2.914787004832172e-11,  1.367337819997901e-12, -5.834254539673274e-14,  9.648004474443837e-03,
 -4.118097657623200e-03,  9.405843626658419e-04, -1.459796252274391e-04,  1.713867386676775e-05, -1.617742404148124e-06,  1.276801593398377e-07, -8.659535792195933e-09,
  5.149550224733884e-10, -2.726808409385917e-11,  1.301530983843757e-12, -5.647191167561877e-14,  7.027315991319985e-03, -3.043627264924150e-03,  7.065217979655075e-04,
 -1.114460300146360e-04,  1.329406217909311e-05, -1.274430140478446e-06,  1.021079197066866e-07, -7.026836496150758e-09,  4.238042771546487e-10, -2.275029666632269e-11,
  1.100358100407313e-12, -4.835705008646258e-14,  4.451345358350404e-03, -1.947323936489663e-03,  4.571005302356651e-04, -7.291311107624038e-05,  8.793539063743852e-06,
 -8.520483762448533e-07,  6.897887367817027e-08, -4.794997791522851e-09,  2.920317294253338e-10, -1.582539867287510e-11,  7.724574547146944e-13, -3.424805848606259e-14,
  1.907226959583253e-03, -8.389729450790473e-04,  1.981531163432428e-04, -3.180427189969524e-05,  3.859097981678210e-06, -3.761504293844000e-07,  3.062775253282305e-08,
 -2.140986666953079e-09,  1.311013700419757e-10, -7.141836345831115e-12,  3.503773313948181e-13, -1.561088475006331e-14,  1.011180412053438e-01, -4.378748802035239e-04,
  2.014527877524741e-06, -9.668090184943710e-09,  4.757699596164696e-11, -2.370557509299218e-13,  1.186107718663816e-15, -5.931259903254030e-18,  2.956485001167602e-20,
 -1.467128374544801e-22,  7.244157602317884e-25, -3.558658966891240e-27,  9.935070307814821e-02, -6.667291269307792e-04,  5.193258462718771e-06, -3.982202575502218e-08,
  2.932213968995065e-10, -2.081328951585680e-12,  1.433293256035471e-14, -9.624318464130252e-17,  6.324815268555025e-19, -4.079102251878069e-21,  2.587281697968399e-23,
 -1.616612211747834e-25,  9.592320787530781e-02, -1.098622605355557e-03,  1.276323941486713e-05, -1.335111610722904e-07,  1.291705632152936e-09, -1.178773401548050e-11,
  1.026863935716717e-13, -8.607393411399692e-16,  6.982165417084855e-18, -5.504753503896494e-20,  4.232229158260732e-22, -3.181419182805129e-24,  9.103789725609804e-02,
 -1.685928513013535e-03,  2.674593369382382e-05, -3.635300522636672e-07,  4.454745870436318e-09, -5.053125436697830e-11,  5.391350442134119e-13, -5.469053951365159e-15,
  5.315596696748008e-17, -4.978738092900220e-19,  4.513851290198576e-21, -3.975011179252546e-23,  8.497027269577043e-02, -2.366379063294421e-03,  4.928889945980809e-05,
 -8.479304480220562e-07,  1.284492629958203e-08, -1.770290697622334e-10,  2.264410609512563e-12, -2.724313779747244e-14,  3.112233443336156e-16, -3.399907216711744e-18,
  3.571112070544907e-20, -3.621674435365266e-22,  7.804062147585221e-02, -3.071956372357762e-03,  8.190934935745076e-05, -1.746736419823395e-06,  3.210175444912686e-08,
 -5.284196822218449e-10,  7.975554942936520e-12, -1.121141106326889e-13,  1.484195028368131e-15, -1.865639927017739e-17,  2.240885895450855e-19, -2.584565169262391e-21,
  7.058363819884611e-02, -3.737817731622433e-03,  1.248823712809130e-04, -3.242986287005635e-06,  7.119578951090102e-08, -1.380367639233309e-09,  2.427041091885458e-11,
 -3.938786670563091e-13,  5.974230065767615e-15, -8.548049418232093e-17,  1.162028472937348e-18, -1.509090010421885e-20,  6.292026438813296e-02, -4.309736137328480e-03,
  1.769363222001980e-04, -5.507987283373402e-06,  1.425245960634470e-07, -3.216118851840473e-09,  6.515798860685935e-11, -1.208430498695347e-12,  2.080037944791778e-14,
 -3.357034274348925e-16,  5.120231677157531e-18, -7.424924692316531e-20,  5.533505119933861e-02, -4.749021085847000e-03,  2.353184170138434e-04, -8.658013808004857e-06,
  2.609125255120813e-07, -6.779929498204638e-09,  1.567528827065136e-10, -3.292679333068612e-12,  6.377962412808443e-14, -1.151897677994387e-15,  1.956328317222331e-17,
 -3.144802007765722e-19,  4.806096938437777e-02, -5.034521946526866e-03,  2.961871461893722e-04, -1.271446815259599e-05,  4.413646921979296e-07, -1.308017973007862e-08,
  3.420960587109545e-10, -8.073165121983618e-12,  1.746505210675723e-13, -3.504647692724652e-15,  6.582852611090199e-17, -1.165439619813531e-18,  4.127211540882093e-02,
 -5.161926691914466e-03,  3.552088145000399e-04, -1.757964898227600e-05,  6.958742796744239e-07, -2.331006386269155e-08,  6.840675330226673e-10, -1.800156724998271e-11,
  4.319174114456343e-13, -9.566746214247996e-15,  1.975005037115672e-16, -3.828081753626511e-18,  3.508351315754711e-02, -5.141013210958180e-03,  4.082025689515216e-04,
 -2.303585385901554e-05,  1.030004533193774e-06, -3.867305577234391e-08,  1.263821272922918e-09, -3.682757584874707e-11,  9.736308234510298e-13, -2.365816040620479e-14,
  5.336945194420431e-16, -1.126244783698839e-17,  2.955638496753496e-02, -4.991722598023818e-03,  4.516925795388802e-04, -2.876859507818297e-05,  1.440167272400785e-06,
 -6.013199840070072e-08,  2.172624324327933e-09, -6.964204025875885e-11,  2.016235360857296e-12, -5.343532083548479e-14,  1.309963448129937e-15, -2.993981625195382e-17,
  2.470691833726055e-02, -4.739912266604827e-03,  4.832735000199127e-04, -3.440800648281029e-05,  1.912399078028132e-06, -8.813267436080603e-08,  3.496606346739417e-09,
 -1.225145698804755e-10,  3.861390951081658e-12, -1.109994569159103e-13,  2.941629264110073e-15, -7.245238116673938e-17,  2.051662099472186e-02, -4.413473251200742e-03,
  5.017552485972026e-04, -3.957832064059434e-05,  2.423038138937101e-06, -1.223711122218387e-07,  5.296321984253491e-09, -2.016197326365968e-10,  6.878760225526577e-12,
 -2.133317197110742e-13,  6.080780788476598e-15, -1.606211857204322e-16,  1.694270332875890e-02, -4.039243967882315e-03,  5.071065201755063e-04, -4.394455380856069e-05,
  2.941185905933919e-06, -1.616698387423247e-07,  7.585308356391740e-09, -3.118921865833087e-10,  1.145558873991599e-11, -3.813123635208419e-13,  1.163290116028858e-14,
 -3.280017578467886e-16,  1.392740366617240e-02, -3.640898414835616e-03,  5.002514442875408e-04, -4.724782562288828e-05,  3.432387289110995e-06, -2.040024873084352e-07,
  1.031300940361477e-08, -4.554304334261022e-10,  1.791232619486895e-11, -6.367107905085343e-13,  2.069053457842598e-14, -6.198964970105313e-16,  1.140565233065548e-02,
 -3.237782434056088e-03,  4.827871770298399e-04, -4.932474679649639e-05,  3.862719773037887e-06, -2.466681582678379e-07,  1.335695910537850e-08, -6.300125236635217e-10,
  2.639571079065048e-11, -9.970271903305915e-13,  3.434949701287448e-14, -1.088630451149128e-15,  9.310872197382455e-03, -2.844540380826327e-03,  4.566854670144901e-04,
 -5.011051687877548e-05,  4.202488556603395e-06, -2.865802437785745e-07,  1.652706488232772e-08, -8.281317086100312e-10,  3.677243507634613e-11, -1.468844917578189e-12,
  5.340341063487102e-14, -1.782483872305442e-15,  7.578999283183246e-03, -2.471315384954208e-03,  4.240253385264603e-04, -4.962862877025993e-05,  4.428933350538548e-06,
 -3.206106088479902e-07,  1.958192329829855e-08, -1.036878733208577e-09,  4.855281990957090e-11, -2.041161922223414e-12,  7.796033243704671e-14, -2.728569124776583e-15,
  6.150975194196044e-03, -2.124303582555562e-03,  3.867842783484520e-04, -4.797183420153303e-05,  4.527662070101298e-06, -3.459244495464132e-07,  2.225431554801018e-08,
 -1.238812323868309e-09,  6.087154318257645e-11, -2.680672165196140e-12,  1.070752255859730e-13, -3.912751348892836e-15,  4.974034044321892e-03, -1.806475142784145e-03,
  3.466972458244176e-04, -4.527931926021969e-05,  4.492831974519213e-06, -3.602522965826569e-07,  2.428120381423859e-08, -1.413730801777626e-09,  7.254131933568090e-11,
 -3.330894639885405e-12,  1.385221347386338e-13, -5.262435436371957e-15,  4.002108450382400e-03, -1.518323033900924e-03,  3.051795088730744e-04, -4.171427387219809e-05,
  4.326324900916278e-06, -3.620671324611228e-07,  2.543307684019517e-08, -1.541057184660308e-09,  8.217871821791175e-11, -3.916329752978714e-12,  1.688219314772853e-13,
 -6.639340845483873e-15,  3.195640493303554e-03, -1.258549808946930e-03,  2.633015528820742e-04, -3.744473908409976e-05,  4.036279046348101e-06, -3.506585663833735e-07,
  2.553827337070862e-08, -1.602432055106892e-09,  8.838415411202109e-11, -4.351635197998581e-12,  1.935901374968908e-13, -7.848218030988061e-15,  2.521026624289911e-03,
 -1.024644722845671e-03,  2.218014144408258e-04, -3.262924196694182e-05,  3.635352567503701e-06, -3.261159670828253e-07,  2.449949128948414e-08, -1.584093472006420e-09,
  8.994539688549176e-11, -4.554507209320437e-12,  2.081862684607957e-13, -8.663668512957787e-15,  1.949865809146739e-03, -8.133347514108947e-04,  1.811203546797548e-04,
 -2.740758358207421e-05,  3.139034301116976e-06, -2.892448048910042e-07,  2.230149370623676e-08, -1.478697649783562e-09,  8.602879735141379e-11, -4.459917922505582e-12,
  2.085562826537216e-13, -8.871771567847884e-15,  1.458126788050262e-03, -6.209136156957295e-04,  1.414503373636967e-04, -2.189636783160794e-05,  2.564221015540942e-06,
 -2.414446376896781e-07,  1.901056661655306e-08, -1.286362471393645e-09,  7.632524578374320e-11, -4.032884918454288e-12,  1.920919052122705e-13, -8.317881783707349e-15,
  1.025308362374292e-03, -4.434651226693468e-04,  1.027852334815286e-04, -1.618847252743117e-05,  1.928182338292501e-06, -1.845749798795127e-07,  1.476730447758265e-08,
 -1.014858485172066e-09,  6.112704490717295e-11, -3.277145222824594e-12,  1.583072491245369e-13, -6.948693643630607e-15,  6.336500399560761e-04, -2.770093602038385e-04,
  6.497260582329114e-05, -1.035581707708506e-05,  1.247980761792484e-06, -1.208318667806744e-07,  9.774954426711591e-09, -6.790113639372695e-10,  4.132541209921671e-11,
 -2.237941363957011e-12,  1.091650595060637e-13, -4.836918827366030e-15,  2.677730461936634e-04, -1.177536767810767e-04,  2.780170925175328e-05, -4.460645673573396e-06,
  5.410543229176175e-07, -5.271833630033553e-08,  4.291044767125832e-09, -2.998558616055211e-10,  1.835521201454386e-11, -9.995823622092755e-13,  4.902347428305098e-14,
 -2.183525321063785e-15,  9.939805716254815e-02, -4.222101351180732e-04,  1.902926590454736e-06, -8.943295088059397e-09,  4.310762720110422e-11, -2.104798501442636e-13,
  1.032521651829816e-15, -5.064390994042356e-18,  2.476915776826779e-20, -1.206370001422888e-22,  5.847473339461772e-25, -2.820400385037247e-27,  9.676396080551118e-02,
 -6.270178068242680e-04,  4.742227864878057e-06, -3.544568265144253e-08,  2.548277111055631e-10, -1.767518102725138e-12,  1.190074641810189e-14, -7.816671534420186e-17,
  5.026683313687088e-19, -3.173429268768892e-21,  1.970926406491518e-23, -1.206184646512186e-25,  9.172325587699597e-02, -1.002590968147977e-03,  1.127774172051307e-05,
 -1.146037677046782e-07,  1.078766646490993e-09, -9.588942198389663e-12,  8.143758527159627e-14, -6.660053608730142e-16,  5.274235774936310e-18, -4.061633506696647e-20,
  3.051589670612419e-22, -2.242594791055386e-24,  8.469610467132328e-02, -1.488271280195061e-03,  2.278002097298619e-05, -2.996848947170572e-07,  3.562036759293128e-09,
 -3.925279855903614e-11,  4.073508699111160e-13, -4.023144549877958e-15,  3.810120570980915e-17, -3.479678051503482e-19,  3.077949803304698e-21, -2.645941212049376e-23,
  7.623353649345149e-02, -2.009525819406885e-03,  4.023890980769072e-05, -6.680239520400887e-07,  9.791385801226024e-09, -1.308154835729903e-10,  1.624429261611073e-12,
 -1.899504884003780e-14,  2.111132995717110e-16, -2.245598447859578e-18,  2.298293865298615e-20, -2.272637181682119e-22,  6.694194081946214e-02, -2.492533810129494e-03,
  6.371251242810277e-05, -1.308233525933309e-06,  2.321853109163922e-08, -3.698736830446395e-10,  5.411466260979572e-12, -7.383630047401004e-14,  9.498137463703313e-16,
 -1.161253036165381e-17,  1.357788485083968e-19, -1.525586935651392e-21,  5.740882923757792e-02, -2.876966543600597e-03,  9.198342367792220e-05, -2.296458429197791e-06,
  4.862067124377755e-08, -9.111703435902157e-10,  1.551279161746593e-11, -2.441246792495353e-13,  3.594980308472705e-15, -4.999224211789775e-17,  6.611089788076532e-19,
 -8.358936702138913e-21,  4.814261003388387e-02, -3.124250818362526e-03,  1.226469624367326e-04, -3.667488104596547e-06,  9.144542695382638e-08, -1.993042782470604e-09,
  3.907234813701907e-11, -7.022699133701959e-13,  1.172995389471816e-14, -1.839120605198218e-16,  2.727733979353813e-18, -3.849895883451877e-20,  3.953415725717135e-02,
 -3.220208017452729e-03,  1.525805905366544e-04, -5.391435969958035e-06,  1.565138523948063e-07, -3.927092764827265e-09,  8.783496165955654e-11, -1.787673827912087e-12,
  3.359615398365927e-14, -5.893822383681005e-16,  9.733044215843060e-18, -1.522756710598742e-19,  3.184208274828437e-02, -3.172591802055264e-03,  1.786110542311715e-04,
 -7.366195476198448e-06,  2.463823537810336e-07, -7.051540671384250e-09,  1.784380286181927e-10, -4.080706500307065e-12,  8.566476271584913e-14, -1.670065908818148e-15,
  3.050838228572665e-17, -5.258103929950004e-19,  2.519858263076252e-02, -3.005186787598785e-03,  1.981532769400539e-04, -9.430121101057220e-06,  3.599180281078753e-07,
 -1.165005823166640e-08,  3.309652652697589e-10, -8.444303085403508e-12,  1.967016305860396e-13, -4.234875589487539e-15,  8.506963618632874e-17, -1.605981657088374e-18,
  1.962963241534296e-02, -2.750542788548906e-03,  2.096420425839422e-04, -1.139150690910568e-05,  4.916594955410535e-07, -1.785534744455787e-08,  5.653661622834766e-10,
 -1.598634436668082e-11,  4.106488744138529e-13, -9.706511714025177e-15,  2.132237246079247e-16, -4.385877794180227e-18,  1.508240783594951e-02, -2.443171488031058e-03,
  2.126764072927456e-04, -1.306542056180481e-05,  6.322826498395068e-07, -2.556900034329176e-08,  8.962001779284471e-10, -2.790733881349054e-11,  7.858851358636692e-13,
 -2.028173061274957e-14,  4.846585132870440e-16, -1.080779248874420e-17,  1.145368242832731e-02, -2.114387584733127e-03,  2.078985592296730e-04, -1.430679211430909e-05,
  7.700873728404859e-07, -3.442846144293468e-08,  1.327072427077326e-09, -4.523519799557856e-11,  1.388630155943202e-12, -3.892074008545280e-14,  1.006670458614197e-15,
 -2.422072634519450e-17,  8.614822336251396e-03, -1.789241641299773e-03,  1.966969606702270e-04, -1.503135517953912e-05,  8.930625226596747e-07, -4.383727576258545e-08,
  1.846592751100768e-09, -6.849985241913989e-11,  2.279833686261811e-12, -6.904278177620484e-14,  1.923485616192022e-15, -4.970211472298421e-17,  6.431089676044810e-03,
 -1.485398875492996e-03,  1.808450895652050e-04, -1.522115190510390e-05,  9.909271084461452e-07, -5.305288101578399e-08,  2.427402379187488e-09, -9.744062286957859e-11,
  3.497485664213023e-12, -1.138732730771740e-13,  3.400942062515707e-15, -9.395260081148696e-17,  4.774728939173304e-03, -1.213473427760293e-03,  1.621699447892166e-04,
 -1.491635803378071e-05,  1.056624381512777e-06, -6.130712152396403e-08,  3.028852934697043e-09, -1.308457218590214e-10,  5.038798815458288e-12, -1.755162129269625e-13,
  5.593485377077954e-15, -1.644708633348088e-16,  3.532490706629955e-03, -9.782252929998248e-04,  1.423072393198730e-04, -1.419838845913201e-05,  1.086988736791233e-06,
 -6.792624834852932e-08,  3.602719677590548e-09, -1.665890214178727e-10,  6.847836404545967e-12, -2.539648117838098e-13,  8.596763798073420e-15, -2.678773081900570e-16,
  2.608832210748074e-03, -7.800955729941103e-04,  1.225612382393985e-04, -1.317007424170476e-05,  1.082586994561291e-06, -7.242130951381579e-08,  4.100408264735445e-09,
 -2.018679752687579e-10,  8.813148763049267e-12, -3.463455345181645e-13,  1.239634776973827e-14, -4.075699102635358e-16,  1.926157461294093e-03, -6.167070261971535e-04,
  1.038582588307825e-04, -1.193765999811619e-05,  1.046947752072130e-06, -7.453270355600929e-08,  4.479812101912716e-09, -2.335847769988850e-10,  1.077714241828277e-11,
 -4.466673458744114e-13,  1.682784783012338e-14, -5.812536263172672e-16,  1.423299220147219e-03, -4.841197255940822e-04,  8.676781668535245e-05, -1.059742284332374e-05,
  9.854848990657462e-07, -7.422779589818784e-08,  4.710316873215327e-09, -2.587751082598154e-10,  1.255541341905048e-11, -5.462191626992755e-13,  2.156325330731451e-14,
 -7.791198505833004e-16,  1.053160022707517e-03, -3.777640190040159e-04,  7.156240335395835e-05, -9.227758885445803e-06,  9.044027935889008e-07, -7.166224806714894e-08,
  4.775187360019772e-09, -2.749863464755967e-10,  1.396153821921077e-11, -6.345743786495372e-13,  2.613222955493237e-14, -9.834269820584060e-16,  7.801301588353663e-04,
 -2.930600745621206e-04,  5.829146444306439e-05, -7.886162997666985e-06,  8.097842796611164e-07, -6.712133388556262e-08,  4.671371163180922e-09, -2.805348614784866e-10,
  1.483176578592436e-11, -7.009945200951224e-13,  2.997755622028949e-14, -1.169919229433140e-15,  5.776469638212796e-04, -2.257781715881483e-04,  4.685282752727150e-05,
 -6.609798281129016e-06,  7.069577031622518e-07, -6.095725726418815e-08,  4.407345811572542e-09, -2.746145715049394e-10,  1.504480753793031e-11, -7.359333555853549e-13,
  3.253448839883914e-14, -1.311020208630548e-15,  4.260731329876325e-04, -1.722078530270271e-04,  3.705241785306271e-05, -5.418204257990063e-06,  6.001508356487297e-07,
 -5.353442067693175e-08,  3.999903610907735e-09, -2.572693059910499e-10,  1.453388631162800e-11, -7.323486065693806e-13,  3.331785925435477e-14, -1.380232248765389e-15,
  3.109497434542769e-04, -1.291995843013124e-04,  2.864896622895067e-05, -4.316908706118858e-06,  4.923841313794504e-07, -4.518920780927339e-08,  3.470739823394158e-09,
 -2.292682749614172e-10,  1.329049248116142e-11, -6.866114850776739e-13,  3.199976368762873e-14, -1.356835329614479e-15,  2.216091645700949e-04, -9.412972832448356e-05,
  2.138414809214447e-05, -3.301075665213997e-06,  3.855330937314408e-07, -3.620604212946211e-08,  2.843493825791592e-09, -1.919335449981055e-10,  1.136113927781379e-11,
 -5.989222569836930e-13,  2.846415162930034e-14, -1.229904539071654e-15,  1.500987107835272e-04, -6.482508349634954e-05,  1.500050472046804e-05, -2.358696086014711e-06,
  2.804914129925796e-07, -2.680825460772423e-08,  2.141615184707547e-09, -1.469638958887403e-10,  8.839418574122927e-12, -4.732501531102968e-13,  2.283072406178661e-14,
 -1.000842643971216e-15,  9.035595190578598e-05, -3.947122070246547e-05,  9.250336357351036e-06, -1.473162764184757e-06,  1.773859503899810e-07, -1.716113715827130e-08,
  1.387208256685882e-09, -9.628876415376871e-11,  5.855940360724841e-12, -3.168969690460908e-13,  1.544727119569568e-14, -6.839825592312410e-16,  3.762488928462043e-05,
 -1.654011029978526e-05,  3.903662593746861e-06, -6.260844941684607e-07,  7.591223828212820e-08, -7.393852568793671e-09,  6.016074664792386e-10, -4.202491902530615e-11,
  2.571585995043695e-12, -1.399943967639095e-13,  6.863563412736836e-15, -3.056051909667611e-16,  9.773899989935848e-02, -4.074045866989049e-04,  1.799610698314755e-06,
 -8.285950072103841e-09,  3.913479578228901e-11, -1.873152578800519e-13,  9.011932320196069e-16, -4.336982372140473e-18,  2.081899283128260e-20, -9.954921826948471e-23,
  4.738311181539249e-25, -2.244607795276639e-27,  9.432916578655832e-02, -5.907146529056793e-04,  4.340224882734958e-06, -3.163643634283626e-08,  2.221652110137141e-10,
 -1.506446923531751e-12,  9.921126763802120e-15, -6.376686516862063e-17,  4.014245633955851e-19, -2.481669692620750e-21,  1.509752242195205e-23, -9.052823118570603e-26,
  8.788502184805080e-02, -9.175905061009687e-04,  1.000005686232442e-05, -9.877755126362938e-08,  9.051154465598061e-10, -7.840417690997337e-12,  6.494821881055583e-14,
 -5.184491702611938e-16,  4.009912880288486e-18, -3.017490835579021e-20,  2.216335446937697e-22, -1.592932608898824e-24,  7.908601712042677e-02, -1.319503507109744e-03,
  1.950147257773718e-05, -2.484775307461404e-07,  2.866286344502044e-09, -3.070115866915760e-11,  3.100460466534075e-13, -2.982676410482947e-15,  2.753611864689520e-17,
 -2.453112181518686e-19,  2.117911047247434e-21, -1.777952220330261e-23,  6.879199999426742e-02, -1.717202356220278e-03,  3.308265578406577e-05, -5.303419974833003e-07,
  7.525508322922379e-09, -9.751693854981261e-11,  1.176153595923213e-12, -1.337332092386085e-14,  1.446642230341920e-16, -1.498910993788300e-18,  1.495388717112423e-20,
 -1.442304469913627e-22,  5.790000849477366e-02, -2.039833096515671e-03,  5.001964852345949e-05, -9.895059994054178e-07,  1.696858625902734e-08, -2.617247773791280e-10,
  3.713495600945566e-12, -4.920140174306077e-14,  6.152568345370060e-16, -7.319121434125565e-18,  8.333568890096490e-20, -9.124688752386675e-22,  4.721516388753720e-02,
 -2.239368548068058e-03,  6.855183029158737e-05, -1.646196092483873e-06,  3.362739731681572e-08, -6.093866102492697e-10,  1.004990019511884e-11, -1.534189453218671e-13,
  2.194209123071875e-15, -2.966501870801414e-17,  3.817391449125546e-19, -4.700533476623809e-21,  3.736072995321809e-02, -2.296970139895611e-03,  8.624891188415230e-05,
 -2.478291837476130e-06,  5.956493514546798e-08, -1.254293001059220e-09,  2.380137806021235e-11, -4.147071780609535e-13,  6.723455839636075e-15, -1.024339969443449e-16,
  1.477728971622944e-18, -2.030392641355234e-20,  2.873794091080097e-02, -2.221081909056454e-03,  1.006460836352787e-04, -3.416072465162831e-06,  9.555142622391974e-08,
 -2.315439586759062e-09,  5.010969956057817e-11, -9.883502191724470e-13,  1.802422669957697e-14, -3.071918889011484e-16,  4.933438374392661e-18, -7.513124354266730e-20,
  2.153183452556003e-02, -2.039643843035300e-03,  1.098749871561653e-04, -4.353553296383879e-06,  1.403141995879086e-07, -3.878513929752190e-09,  9.496650683128523e-11,
 -2.104758902697903e-12,  4.287849566163755e-14, -8.121839356624808e-16,  1.443041955207943e-17, -2.421266759523374e-19,  1.574956120009706e-02, -1.789965601345224e-03,
  1.130605466736112e-04, -5.173054375090396e-06,  1.903506874788598e-07, -5.953317237949913e-09,  1.637145128462017e-10, -4.049645056789550e-12,  9.157869034558414e-14,
 -1.916354370298343e-15,  3.745574351357605e-17, -6.886752964287362e-19,  1.127422102135277e-02, -1.509477601375582e-03,  1.103873386790304e-04, -5.773671259909909e-06,
  2.404751372310408e-07, -8.445265380181863e-09,  2.590450485992716e-10, -7.106405735118382e-12,  1.773372415606932e-13, -4.076895381820400e-15,  8.719578605951646e-17,
 -1.747958713306762e-18,  7.919300826461044e-03, -1.229329622386477e-03,  1.028811411729757e-04, -6.093332823004128e-06,  2.849426513805734e-07, -1.115612218088668e-08,
  3.792064561203591e-10, -1.146794223203332e-11,  3.140326685894464e-13, -7.889748983016193e-15,  1.837309118546958e-16, -3.996554981971935e-18,  5.473845209052921e-03,
 -9.713710180350522e-04,  9.203766007903584e-05, -6.117957317771999e-06,  3.187462898398867e-07, -1.381750062155090e-08,  5.172252580758892e-10, -1.714440375206876e-11,
  5.124095800384877e-13, -1.399807709362744e-14,  3.532318563088654e-16, -8.299391676529342e-18,  3.734083026960235e-03, -7.479697901925556e-04,  7.944226610477994e-05,
 -5.877094099375524e-06,  3.386409873442799e-07, -1.614669081470978e-08,  6.616115323451511e-10, -2.390328056855711e-11,  7.757049703042181e-13, -2.292880490877889e-14,
  6.240619212982200e-16, -1.576784307745025e-17,  2.521626869148428e-03, -5.636221743381905e-04,  6.648194456101774e-05, -5.430211647981490e-06,  3.436061825137279e-07,
 -1.790563459024916e-08,  7.984240933575406e-10, -3.127081672341862e-11,  1.096258834726486e-12, -3.489384377699818e-14,  1.019705206150596e-15, -2.758626163356346e-17,
  1.690905554901989e-03, -4.172965473601604e-04,  5.418920021451351e-05, -4.849718711629457e-06,  3.347065243120196e-07, -1.894432180518031e-08,  9.140274375962428e-10,
 -3.860107393072065e-11,  1.454568834993918e-12, -4.962127615296189e-14,  1.549973411778682e-15, -4.470492512591089e-17,  1.129339096883494e-03, -3.047343494069755e-04,
  4.320675162695055e-05, -4.205987160564533e-06,  3.145170433214383e-07, -1.921798316070321e-08,  9.976518440439558e-10, -4.519265057368831e-11,  1.821429306516000e-12,
 -6.628386826703910e-14,  2.203224346323324e-15, -6.746104511031724e-17,  7.534834944415909e-04, -2.202857238172228e-04,  3.383471695593315e-05, -3.557336735993671e-06,
  2.863705576091235e-07, -1.877809185485265e-08,  1.043036824774741e-09, -5.041627885975253e-11,  2.162644804965904e-12, -8.356276383321232e-14,  2.942557307549606e-15,
 -9.524309008582885e-17,  5.035619643410696e-04, -1.581525912649855e-04,  2.611735306417733e-05, -2.945537306542181e-06,  2.536605909575530e-07, -1.774528831070894e-08,
  1.048854863145038e-09, -5.381619683697096e-11,  2.444896697552861e-12, -9.983621731889158e-14,  3.707852392919684e-15, -1.263247988743687e-16,  3.379050208751415e-04,
 -1.130954257623233e-04,  1.993561743546178e-05, -2.395752535442481e-06,  2.193414370157249e-07, -1.627541868199804e-08,  1.018048940886523e-09, -5.516196109148130e-11,
  2.641066529524582e-12, -1.134398941113524e-13,  4.423549028466660e-15, -1.579516224832116e-16,  2.280845539396255e-04, -8.073956585064825e-05,  1.508564075448086e-05,
 -1.919199720517521e-06,  1.856654399738015e-07, -1.452837604234188e-08,  9.564968934493985e-10, -5.444672459046888e-11,  2.733712389754193e-12, -1.229257063831597e-13,
  5.010136440048529e-15, -1.866811601128416e-16,  1.550230888492106e-04, -5.762580382934566e-05,  1.133542916560533e-05, -1.516901207674723e-06,  1.541239564490994e-07,
 -1.264548454256056e-08,  8.714813155416785e-10, -5.184407819373473e-11,  2.716170387440428e-12, -1.272555597884746e-13,  5.396292886557311e-15, -2.088971968638597e-16,
  1.060690355233496e-04, -4.112331695731786e-05,  8.460193753052527e-06, -1.183376517924803e-06,  1.255243678697848e-07, -1.073701789515387e-08,  7.703435959554672e-10,
 -4.764340090921602e-11,  2.591528734149649e-12, -1.258958896384230e-13,  5.528777878000751e-15, -2.213689804231149e-16,  7.289425555166857e-05, -2.928616126012767e-05,
  6.260636521645788e-06, -9.096579733282508e-07,  1.001337159504554e-07, -8.878491931511018e-09,  6.595280067089202e-10, -4.218319688007304e-11,  2.370219313242236e-12,
 -1.188130275701535e-13,  5.378280309366189e-15, -2.217283368664260e-16,  5.003180355566384e-05, -2.070143777115841e-05,  4.569491442669269e-06, -6.854322873693118e-07,
  7.783566786463435e-08, -7.112997431386356e-09,  5.440591854929939e-10, -3.579617749884659e-11,  2.067108270053570e-12, -1.063950608150049e-13,  4.940853506745477e-15,
 -2.087783074910944e-16,  3.388282960847117e-05, -1.435297783795284e-05,  3.250973812821575e-06, -5.003659870049756e-07,  5.826865502619712e-08, -5.456738139092412e-09,
  4.273884762074730e-10, -2.877263287571597e-11,  1.698821409382152e-12, -8.933695535027391e-14,  4.235748718470663e-15, -1.826048573528828e-16,  2.205239237476772e-05,
 -9.509057259651114e-06,  2.196555655428256e-06, -3.447865450279853e-07,  4.093132431853212e-08, -3.905560183255782e-09,  3.114991646612323e-10, -2.134268324437768e-11,
  1.281760497059973e-12, -6.852358599962020e-14,  3.301077826421146e-15, -1.445140926995622e-16,  1.290803956024729e-05, -5.634326172868460e-06,  1.319280336976689e-06,
 -2.099165111917462e-07,  2.525444742878236e-08, -2.441161725722554e-09,  1.971668477739532e-10, -1.367475878040678e-11,  8.310029197571273e-13, -4.493612581797859e-14,
  2.188822115363230e-15, -9.684896668406347e-17,  5.291070932917316e-06, -2.325173438323954e-06,  5.485526813746194e-07, -8.794389958413080e-08,  1.065890733270103e-08,
 -1.037773228747634e-09,  8.440706917233541e-11, -5.893994533598566e-12,  3.605325592206223e-13, -1.961995573286523e-14,  9.615773647425434e-16, -4.280023695128975e-17,
  9.613756025328619e-02, -3.933950593353038e-04,  1.703816306771426e-06, -7.688628599706076e-09,  3.559531619907277e-11, -1.670717501580111e-13,  7.885708771949740e-16,
 -3.724641572290101e-18,  1.755387363113747e-20, -8.243049133090427e-23,  3.853871158913717e-25, -1.793555714489683e-27,  9.203342879874427e-02, -5.574531825097619e-04,
  3.980961560683318e-06, -2.831046928831713e-08,  1.942798858138296e-10, -1.288392564789150e-12,  8.302849915932393e-15, -5.224152907318491e-17,  3.220595543161477e-19,
 -1.950411190221407e-21,  1.162681828952509e-23, -6.833187266653780e-26,  8.436748615614319e-02, -8.420965729425159e-04,  8.896704110824962e-06, -8.547016551882442e-08,
  7.627897127567501e-10, -6.442305308889511e-12,  5.207622529559028e-14, -4.059298580315961e-16,  3.067644951517468e-18, -2.256614867687412e-20,  1.620975821478111e-22,
 -1.139818324632021e-24,  7.410218463490680e-02, -1.174683191172933e-03,  1.677587907760680e-05, -2.071515373153686e-07,  2.320391493196198e-09, -2.417027343019918e-11,
  2.376479396718951e-13, -2.227885076037527e-15,  2.005851260273688e-17, -1.743833303872773e-19,  1.470052081212639e-21, -1.205595253148675e-23,  6.241491326563015e-02,
 -1.476089444890680e-03,  2.738128097923298e-05, -4.241213732522300e-07,  5.829621727124752e-09, -7.330560221411503e-11,  8.591544702137533e-13, -9.503353925871411e-15,
  1.000988768546958e-16, -1.010685861719995e-18,  9.832518199301629e-21, -9.253448693811547e-23,  5.047181644636618e-02, -1.682925274837340e-03,  3.961631841476715e-05,
 -7.554734631657351e-07,  1.252428357359207e-08, -1.871300513966005e-10,  2.576049334405788e-12, -3.315671707554008e-14,  4.032115512632188e-16, -4.668869068354847e-18,
  5.178498432821333e-20, -5.527364999052252e-22,  3.924119883994664e-02, -1.761672503381776e-03,  5.166229020444768e-05, -1.193884001947184e-06,  2.354085877989410e-08,
 -4.126941394931757e-10,  6.595507996840921e-12, -9.770622773500320e-14,  1.357645566009370e-15, -1.785069557164174e-17,  2.235949322419077e-19, -2.682069402770168e-21,
  2.938507319534243e-02, -1.711458035230360e-03,  6.149052507806063e-05, -1.698453319270600e-06,  3.936339596823112e-08, -8.011284698068862e-10,  1.471953338785638e-11,
 -2.486955581499000e-13,  3.914703973128300e-15, -5.796973069260063e-17,  8.136103625668377e-19, -1.088525039158174e-20,  2.123686370498591e-02, -1.557032037171823e-03,
  6.748647715575299e-05, -2.200732101044746e-06,  5.932534754879775e-08, -1.388718257332904e-09,  2.908638861073634e-11, -5.560792630971298e-13,  9.842618209843283e-15,
 -1.629997816304626e-16,  2.546168117421233e-18, -3.774964222740513e-20,  1.484740139970910e-02, -1.336629069367598e-03,  6.889511296485655e-05, -2.622810418482014e-06,
  8.146196064534096e-08, -2.174963381976358e-09,  5.153513282313839e-11, -1.107037064707921e-12,  2.188818222671930e-14, -4.028510692496046e-16,  6.962108460266149e-18,
 -1.137330459095934e-19,  1.006821921568231e-02, -1.089844264184820e-03,  6.592730669872072e-05, -2.899810659619347e-06,  1.028655618525527e-07, -3.108409102224205e-09,
  8.274263364069949e-11, -1.984262224687047e-12,  4.356140537255085e-14, -8.859787674725799e-16,  1.684862811594831e-17, -3.017022260355136e-19,  6.641531613316122e-03,
 -8.490424542964347e-04,  5.954878471049476e-05, -2.997159823732182e-06,  1.204389047965656e-07, -4.089500263390038e-09,  1.214966216731023e-10, -3.233196766337529e-12,
  7.837044960941652e-14, -1.752116911838535e-15,  3.648109314570048e-17, -7.126291222894775e-19,  4.275521079055418e-03, -6.354701031818063e-04,  5.109880072270927e-05,
 -2.916412920846912e-06,  1.317359630312780e-07, -4.991984120702904e-09,  1.645057529866263e-10, -4.830271896380257e-12,  1.285881981909647e-13, -3.144333448923953e-15,
  7.134053324652943e-17, -1.513370643337306e-18,  2.695378952992629e-03, -4.593464221531668e-04,  4.190999503816656e-05, -2.689363821597552e-06,  1.355522226155757e-07,
 -5.695082987516407e-09,  2.069396352005557e-10, -6.667769202509064e-12,  1.939562226987327e-13, -5.162534154493584e-15,  1.270566423251166e-16, -2.914290266925444e-18,
  1.670193818202475e-03, -3.223138413169165e-04,  3.304586536043804e-05, -2.364971321774996e-06,  1.320749432167217e-07, -6.113616728005476e-09,  2.435462552347856e-10,
 -8.565630798912318e-12,  2.709093844710859e-13, -7.812480751307020e-15,  2.076489026226484e-16, -5.128125215741034e-18,  1.021226575037906e-03, -2.206408509427275e-04,
  2.519105648226913e-05, -1.995153799737976e-06,  1.226174217766813e-07, -6.215152645230226e-09,  2.699218415518927e-10, -1.030860017583294e-11,  3.527725585437259e-13,
 -1.097174465592839e-14,  3.135707666461851e-16, -8.303415809908696e-18,  6.186450917946051e-04, -1.480835033964113e-04,  1.866681583118724e-05, -1.624053858577007e-06,
  1.091159147720807e-07, -6.020124847532581e-09,  2.834646754920762e-10, -1.169544873302655e-11,  4.309767720160092e-13, -1.439060634693389e-14,  4.403381393429326e-16,
 -1.245122495917025e-17,  3.728349976889449e-04, -9.791557017243155e-05,  1.351702940797955e-05, -1.282628329852918e-06,  9.360499593570327e-08, -5.588201485019024e-09,
  2.837280192087716e-10, -1.258239877964689e-11,  4.968911705427664e-13, -1.773218348667426e-14,  5.784224487966704e-16, -1.739348782080456e-17,  2.244586199379472e-04,
 -6.408796714969868e-05,  9.613569828484897e-06, -9.880329216863527e-07,  7.782696537877706e-08, -4.998320412841689e-09,  2.721650989579332e-10, -1.290700922989152e-11,
  5.436235366527083e-13, -2.063939076247240e-14,  7.146144620681788e-16, -2.275763097138333e-17,  1.355303751644721e-04, -4.171038471895734e-05,  6.747868978709992e-06,
 -7.460497286284072e-07,  6.303378145645946e-08, -4.329807669456809e-09,  2.514763452627943e-10, -1.268825593294205e-11,  5.672151513099875e-13, -2.280586091297617e-14,
  8.344637767021697e-16, -2.802536263323521e-17,  8.238233743234422e-05, -2.710620608541993e-05,  4.695061407415651e-06, -5.546984786526547e-07,  4.995965798760202e-08,
 -3.649222750067645e-09,  2.248444205666733e-10, -1.200770971454720e-11,  5.669618301109394e-13, -2.402851482915497e-14,  9.249916151624992e-16, -3.262223968946557e-17,
  5.057462716170308e-05, -1.765342622613438e-05,  3.250642376709428e-06, -4.076979098369579e-07,  3.890276415818089e-08, -3.004184409551381e-09,  1.952889583127211e-10,
 -1.098159992866963e-11,  5.449426935750977e-13, -2.422916882114153e-14,  9.768467519274310e-16, -3.601979984833732e-17,  3.143335655895480e-05, -1.155421152055999e-05,
  2.246116413699683e-06, -2.971128504583273e-07,  2.985170264266724e-08, -2.422969012181384e-09,  1.652576338732835e-10, -9.733420515416013e-12,  5.050688434486579e-13,
 -2.344520719995157e-14,  9.853836092191677e-16, -3.782026008003341e-17,  1.980235596334054e-05, -7.611195164557797e-06,  1.551439836226556e-06, -2.150444371997980e-07,
  2.261019826371680e-08, -1.917633717216495e-09,  1.364607946130139e-10, -8.373366455590501e-12,  4.520170523637795e-13, -2.179886074866118e-14,  9.505857000101305e-16,
 -3.780390963027765e-17,  1.263366715369888e-05, -5.043274596517041e-06,  1.070699011109128e-06, -1.545111114029894e-07,  1.689579718369585e-08, -1.488508799104628e-09,
  1.098901049931765e-10, -6.986757225086766e-12,  3.903283198951632e-13, -1.945816195992414e-14,  8.761216545148208e-16, -3.593471123197451e-17,  8.126926419756452e-06,
 -3.347579387402483e-06,  7.353207731277862e-07, -1.097661840919165e-07,  1.240603649874246e-08, -1.128556906547754e-09,  8.594127546443077e-11, -5.630473930945680e-12,
  3.238099291115171e-13, -1.660086427793270e-14,  7.679883989326811e-16, -3.233287377467585e-17,  5.213735589207940e-06, -2.202153752074547e-06,  4.972010546860216e-07,
 -7.628258427882903e-08,  8.855745097652021e-09, -8.268314762410526e-10,  6.457193501290480e-11, -4.334918672898736e-12,  2.552535088370437e-13, -1.338809334736537e-14,
  6.331707031021781e-16, -2.722994606480730e-17,  3.252354405841215e-06, -1.400056761293292e-06,  3.228036566868974e-07, -5.057493251474891e-08,  5.993040331707945e-09,
 -5.708260495978644e-10,  4.544964404281324e-11, -3.108851749291355e-12,  1.864056587301869e-13, -9.949852850795442e-15,  4.786070360043137e-16, -2.092201879198577e-17,
  1.847613405838408e-06, -8.058012980094127e-07,  1.885021179227472e-07, -2.996520691394031e-08,  3.601697935698598e-09, -3.478360686553379e-10,  2.806928740877614e-11,
 -1.945125262839706e-12,  1.181059340240202e-13, -6.381410447394308e-15,  3.105944626251641e-16, -1.373255458731200e-17,  7.447134030404710e-07, -3.271463418707645e-07,
  7.714821410077350e-08, -1.236322163826053e-08,  1.497816518731572e-09, -1.457710503036317e-10,  1.185151623079816e-11, -8.272459674096674e-13,  5.058279869133880e-14,
 -2.751651248894199e-15,  1.348093795288672e-16, -5.998276139296952e-18,  9.459067008307574e-02, -3.801241485677221e-04,  1.614862883287462e-06, -7.144841074825814e-09,
  3.243500750602955e-11, -1.493366931610376e-13,  6.917192857059612e-16, -3.207570008045461e-18,  1.484585420738713e-20, -6.848272880368829e-23,  3.145829040125939e-25,
 -1.438720547749402e-27,  8.986523196524311e-02, -5.269134388229892e-04,  3.659070220185547e-06, -2.539778419730522e-08,  1.703919892821586e-10, -1.105574562281278e-12,
  6.974421610706942e-15, -4.297486343273860e-17,  2.595395094196213e-19, -1.540266615231534e-21,  9.000194403161712e-24, -5.186126780493172e-26,  8.113523193172816e-02,
 -7.748273987206771e-04,  7.940247886737468e-06, -7.423206564228539e-08,  6.455755499907329e-10, -5.318483942012560e-12,  4.197075088880178e-14, -3.196037633545706e-16,
  2.360829867679378e-18, -1.698341949843798e-20,  1.193533878918809e-22, -8.213849968343055e-25,  6.965696742553429e-02, -1.049823111564664e-03,  1.449781469272634e-05,
 -1.736025992968657e-07,  1.889320324087702e-09, -1.914817988879002e-11,  1.833848879417682e-13, -1.676070120146222e-15,  1.472275194972825e-17, -1.249568307775873e-19,
  1.028942488642256e-21, -8.246613457703052e-24,  5.691852307873203e-02, -1.275915935758614e-03,  2.280648314340199e-05, -3.415403498278171e-07,  4.549890417080026e-09,
 -5.554815469954324e-11,  6.329333605946719e-13, -6.813740635945066e-15,  6.991157981559454e-17, -6.881447675632212e-19,  6.530731633181152e-21, -5.999185810303761e-23,
  4.432102047471988e-02, -1.399114929094774e-03,  3.163954007782329e-05, -5.819578438847641e-07,  9.331659632725261e-09, -1.351296184073763e-10,  1.805628765673915e-12,
 -2.258659004593164e-14,  2.672179802024852e-16, -3.012881376142915e-18,  3.256469346173415e-20, -3.389481781950950e-22,  3.293864809085826e-02, -1.399853202152720e-03,
  3.934874154807952e-05, -8.755096624497781e-07,  1.667135978664992e-08, -2.828593335580846e-10,  4.382438667043010e-12, -6.302449755475460e-14,  8.511208050105995e-16,
 -1.088692719321457e-17,  1.327797026159286e-19, -1.552009166434834e-21,  2.340766097874370e-02, -1.291456561142375e-03,  4.441549601499880e-05, -1.179760834918316e-06,
  2.637519724459737e-08, -5.189907450022244e-10,  9.235995706820350e-12, -1.513653439436322e-13,  2.313996733143688e-15, -3.331449725129732e-17,  4.550119282219651e-19,
 -5.929034838602819e-21,  1.594154269236089e-02, -1.108527201784686e-03,  4.596617013111984e-05, -1.440509488647350e-06,  3.743378086971520e-08, -8.466887678237684e-10,
  1.716683303676903e-11, -3.181941310357556e-13,  5.467453778397567e-15, -8.799729262612591e-17,  1.337235369156530e-18, -1.930459985454738e-20,  1.043128853644356e-02,
 -8.921218342136380e-04,  4.399823655972227e-05, -1.609480913028974e-06,  4.817883691830037e-08, -1.242633279205167e-09,  2.849683179891733e-11, -5.933835854008294e-13,
  1.138788869873970e-14, -2.036778521615286e-16,  3.424154564980595e-18, -5.446512555926420e-20,  6.577345569734424e-03, -6.777445344364152e-04,  3.925709470371902e-05,
 -1.659803361166209e-06,  5.675939456220113e-08, -1.657172177073935e-09,  4.269966928626094e-11, -9.927464962276470e-13,  2.115779643853179e-14, -4.182485984409134e-16,
  7.738824752150714e-18, -1.349599577307560e-19,  4.009543598511659e-03, -4.890776145526322e-04,  3.288585476234353e-05, -1.592365711153072e-06,  6.172477723487671e-08,
 -2.026097717416131e-09,  5.829519532577241e-11, -1.504685885618180e-12,  3.542348770700628e-14, -7.700869642556900e-16,  1.560775783977436e-17, -2.970660543557973e-19,
  2.371669615377794e-03, -3.372279065661631e-04,  2.604057733990232e-05, -1.431627146921961e-06,  6.244436148632643e-08, -2.289555003327311e-09,  7.312973467779121e-11,
 -2.084318190189611e-12,  5.393106051203756e-14, -1.283261767206246e-15,  2.836119629930424e-17, -5.866155901520447e-19,  1.366677979008068e-03, -2.234596605204240e-04,
  1.961874635398005e-05, -1.214649785969196e-06,  5.919972805667290e-08, -2.409570931385915e-09,  8.495940021244723e-11, -2.660049988430798e-12,  7.528317831574941e-14,
 -1.951772346338566e-15,  4.683560238955436e-17, -1.048417638083778e-18,  7.705784807947717e-04, -1.431138487589096e-04,  1.415250166403761e-05, -9.791283294865696e-07,
  5.296506422118150e-08, -2.378841422869170e-09,  9.208667604254771e-11, -3.151358226276167e-12,  9.709565074287688e-14, -2.730650498820624e-15,  7.084847717144762e-17,
 -1.709541064967328e-18,  4.270994002949253e-04, -8.909608975743792e-05,  9.837014666883182e-06, -7.548551895459859e-07,  4.502586825234477e-08, -2.218460544963950e-09,
  9.378234901872143e-11, -3.490575477798548e-12,  1.165428575182438e-13, -3.539939222041915e-15,  9.889713372254015e-17, -2.562183250602387e-18,  2.338536161731328e-04,
 -5.423016159827255e-05,  6.629326370827289e-06, -5.602023081263148e-07,  3.661238121309347e-08, -1.967576054686697e-09,  9.035341363122639e-11, -3.639697082867706e-12,
  1.310825412442912e-13, -4.281692784937793e-15,  1.282740820213403e-16, -3.554140094603475e-18,  1.271441348957219e-04, -3.246080933147213e-05,  4.358546754071242e-06,
 -4.027749217554300e-07,  2.866253995577994e-08, -1.670539404794838e-09,  8.289498248626571e-11, -3.596362446693192e-12,  1.390697376004033e-13, -4.863750370471700e-15,
  1.556076962405370e-16, -4.592780594671482e-18,  6.900404902781972e-05, -1.921964553590962e-05,  2.812795362345970e-06, -2.823190465708761e-07,  2.174084035208879e-08,
 -1.366436258970248e-09,  7.288331246995005e-11, -3.388695911112473e-12,  1.400455600782486e-13, -5.221070462809414e-15,  1.776359690406698e-16, -5.562605671026148e-18,
  3.758116321010828e-05, -1.132119953019879e-05,  1.792464760949544e-06, -1.940956746801497e-07,  1.607549873497597e-08, -1.083364393828493e-09,  6.178309778314717e-11,
 -3.063164159644083e-12,  1.346540295824033e-13, -5.327314627877148e-15,  1.919236215511176e-16, -6.350298117925168e-18,  2.064452055726462e-05, -6.671052177251370e-06,
  1.134352476821649e-06, -1.316395343760329e-07,  1.165401018969500e-08, -8.373164879902850e-10,  5.078077735409084e-11, -2.671062154237597e-12,  1.242929183906795e-13,
 -5.194391184935474e-15,  1.972842575827738e-16, -6.868215715499184e-18,  1.149288004646442e-05, -3.952318206852917e-06,  7.166169725301786e-07, -8.853630462339569e-08,
  8.326570170047784e-09, -6.341064570043005e-10,  4.067280707242606e-11, -2.257943633507276e-12,  1.106719287086739e-13, -4.862622389144677e-15,  1.938200567166548e-16,
 -7.068831402344334e-18,  6.509933042663367e-06, -2.364466131257487e-06,  4.539169448425450e-07, -5.931033318413336e-08,  5.888753869661566e-09, -4.725426942898549e-10,
  3.187756693876814e-11, -1.857822643027516e-12,  9.542907910203976e-14, -4.386752551455893e-15,  1.826468950945085e-16, -6.947183049740771e-18,  3.762228997282257e-06,
 -1.432703391521522e-06,  2.891765250810969e-07, -3.969645300516104e-08,  4.134810127806308e-09, -3.475289243041636e-10,  2.451626472311649e-11, -1.491800098022977e-12,
  7.988529576674914e-14, -3.822773116405227e-15,  1.654602678801010e-16, -6.533157929750681e-18,  2.219914646833147e-06, -8.801006886580662e-07,  1.854717004934826e-07,
 -2.657056399943831e-08,  2.884982848803402e-09, -2.524325611139444e-10,  1.851355643640460e-11, -1.169634178507309e-12,  6.494561614681577e-14, -3.218585668445782e-15,
  1.441003293699803e-16, -5.878241938558234e-18,  1.333528450059580e-06, -5.466539655147020e-07,  1.194495899021915e-07, -1.773873939557563e-08,  1.994778849994554e-09,
 -1.805780274726651e-10,  1.368666158531285e-11, -8.926242581417148e-13,  5.111089496969199e-14, -2.609291378916065e-15,  1.202212585253825e-16, -5.041658512486632e-18,
  8.077697785544426e-07, -3.401166098015969e-07,  7.652860512981213e-08, -1.170137000549245e-08,  1.353920020047028e-09, -1.260046968148929e-10,  9.809856887950976e-12,
 -6.565927425637012e-13,  3.855041774448162e-14, -2.016335570883144e-15,  9.510304035769063e-17, -4.079378670194256e-18,  4.816367442424141e-07, -2.069566135755748e-07,
  4.762132427229680e-08, -7.446106260083065e-09,  8.806261265432409e-10, -8.371888561164973e-11,  6.653524690715829e-12, -4.543069342718716e-13,  2.719333334164585e-14,
 -1.449102763852233e-15,  6.959292311689869e-17, -3.037514322289136e-18,  2.650114677802841e-07, -1.154760473321814e-07,  2.698647646289761e-08, -4.285602186829628e-09,
  5.146055745739161e-10, -4.965069144111304e-11,  4.002923885778768e-12, -2.771409630458584e-13,  1.681294812161573e-14, -9.076519818467393e-16,  4.414058536557093e-17,
 -1.950065533260918e-18,  1.049132913445765e-07, -4.606981873375451e-08,  1.085955964159342e-08, -1.739512212500988e-09,  2.106520649727801e-10, -2.049239956185062e-11,
  1.665380705309684e-12, -1.161973391727196e-13,  7.102155124276902e-15, -3.861982403490932e-16,  1.891343322497535e-17, -8.412289809904165e-19,  9.309548044998965e-02,
 -3.675395968302791e-04,  1.532142829542583e-06, -6.648902422285953e-09,  2.960727958180580e-11, -1.337616853669653e-13,  6.082042633856119e-16, -2.769638647448451e-18,
  1.259252300719550e-20, -5.707819997709665e-23,  2.576830709138155e-25, -1.158432112420953e-27,  8.781425638886108e-02, -4.988152474327209e-04,  3.369953142934195e-06,
 -2.283970252168396e-08,  1.498615337931958e-10, -9.517383602637047e-13,  5.879533904665497e-15, -3.549153721208228e-17,  2.100559102340240e-19, -1.222018210986214e-21,
  7.001624526232760e-24, -3.956938906804140e-26,  7.815756233902146e-02, -7.147007012535545e-04,  7.108097477908898e-06, -6.470198038050750e-08,  5.485958264819684e-10,
 -4.410569686068456e-12,  3.399376469176019e-14, -2.529845175393244e-16,  1.827317234407482e-18, -1.286010938446321e-20,  8.845073063997114e-23, -5.959611933413818e-25,
  6.567713520778143e-02, -9.416872507621097e-04,  1.258405366828375e-05, -1.462130979602467e-07,  1.546826253235378e-09, -1.526075385427149e-11,  1.424272259762433e-13,
 -1.269632502661087e-15,  1.088536354487307e-17, -9.022937452905143e-20,  7.260133486661693e-22, -5.688539044779207e-24,  5.215544822167386e-02, -1.108699812732955e-03,
  1.911063325773633e-05, -2.768650578605229e-07,  3.576593313541530e-09, -4.241557851931619e-11,  4.700763978197934e-13, -4.927268031569391e-15,  4.926728848327909e-17,
 -4.729353083906513e-19,  4.380037983812612e-21, -3.928740411097195e-23,  3.918989520813648e-02, -1.171585474423917e-03,  2.546977839657528e-05, -4.521163296344894e-07,
  7.015790818097508e-09, -9.850926699436158e-11,  1.278248736182967e-12, -1.554615818990102e-14,  1.790035055948206e-16, -1.965965601868991e-18,  2.071407816097620e-20,
 -2.103139521656407e-22,  2.790815475207493e-02, -1.122948710857001e-03,  3.027338485607924e-05, -6.488596244508623e-07,  1.193751138114838e-08, -1.961079329193373e-10,
  2.946736122809619e-12, -4.115458340896950e-14,  5.403452100024122e-16, -6.726284268358093e-18,  7.990192464017546e-20, -9.103380216239653e-22,  1.887199938283819e-02,
 -9.863042665438739e-04,  3.248326029987832e-05, -8.300559704734518e-07,  1.790768593530472e-08, -3.408123486985731e-10,  5.876507695222988e-12, -9.344776122968814e-14,
  1.387841350519372e-15, -1.943119589780512e-17,  2.583311530344886e-19, -3.279317099280507e-21,  1.214625813983580e-02, -8.009155518139918e-04,  3.177990165878435e-05,
 -9.573613284792447e-07,  2.398935836229389e-08, -5.244230895535135e-10,  1.029555391795092e-11, -1.850592902251493e-13,  3.087594067745812e-15, -4.830620525061775e-17,
  7.142731853868598e-19, -1.004205524792808e-20,  7.460736052158242e-03, -6.059590715132168e-04,  2.859604270799433e-05, -1.005267468971453e-06,  2.900678573546279e-08,
 -7.228420546650985e-10,  1.604594641914589e-11, -3.239272112777077e-13,  6.034956487247883e-15, -1.049046934087791e-16,  1.715803694743034e-18, -2.657645334423157e-20,
  4.387215003040249e-03, -4.301188243883436e-04,  2.385212571323573e-05, -9.693540045073513e-07,  3.195562555921430e-08, -9.014693087524929e-10,  2.248480249900912e-11,
 -5.068310542792274e-13,  1.048672095429905e-14, -2.014928591573683e-16,  3.627523939597666e-18, -6.161180960412964e-20,  2.478574391311053e-03, -2.882837635784409e-04,
  1.857782777727513e-05, -8.652383539599751e-07,  3.234820152748335e-08, -1.026363259867019e-09,  2.859649904998224e-11, -7.158740931279209e-13,  1.636723162286418e-14,
 -3.459633680528740e-16,  6.824888139862178e-18, -1.265588686926754e-19,  1.350669234779575e-03, -1.835830452891826e-04,  1.360667794120013e-05, -7.202978199978130e-07,
  3.032883186833146e-08, -1.075708710160618e-09,  3.329487927894474e-11, -9.209587451523284e-13,  2.315684007352423e-14, -5.360766928788298e-16,  1.153885643813503e-17,
 -2.326688512912028e-19,  7.131038949277814e-04, -1.117617023205980e-04,  9.435682953829307e-06, -5.633446936721246e-07,  2.653772638152351e-08, -1.046028183933163e-09,
  3.577607837281997e-11, -1.088112745946045e-12,  2.995277436572254e-14, -7.561654513187533e-16,  1.768715052776921e-17, -3.862993905167271e-19,  3.665482893939788e-04,
 -6.544799401980172e-05,  6.237579972024164e-06, -4.169017865221223e-07,  2.183185217281293e-08, -9.509177234358941e-10,  3.575360994798785e-11, -1.190025517881519e-12,
  3.570420392509958e-14, -9.788587034239479e-16,  2.478268696612049e-17, -5.840681304210101e-19,  1.844134551928482e-04, -3.710223076845830e-05,  3.957821127419297e-06,
 -2.940289316470216e-07,  1.701033459061557e-08, -8.141836127670033e-10,  3.348315640571388e-11, -1.213905996156431e-12,  3.952295703562632e-14, -1.171877855167540e-15,
  3.198904482235201e-17, -8.104828952979200e-19,  9.133232086597168e-05, -2.049474461469825e-05,  2.427214763758554e-06, -1.990458996353724e-07,  1.264426334010425e-08,
 -6.614146589661703e-10,  2.960191776948265e-11, -1.163523736916346e-12,  4.093030050476774e-14, -1.307138165629917e-15,  3.832064347409978e-17, -1.039871127260167e-18,
  4.479939920028158e-05, -1.110568050498271e-05,  1.448877424693588e-06, -1.302721768929876e-07,  9.032163127504856e-09, -5.135290276581237e-10,  2.488646620428299e-11,
 -1.055546125428964e-12,  3.994284963571454e-14, -1.368204287818456e-15,  4.290773803001363e-17, -1.242345110168521e-18,  2.190306282373262e-05, -5.944240594920781e-06,
  8.478495987784164e-07, -8.302758207311934e-08,  6.245324908638125e-09, -3.838249689417633e-10,  2.003877637917196e-11, -9.127994712073609e-13,  3.698976338247503e-14,
 -1.353267123988744e-15,  4.521522313590909e-17, -1.391455538484205e-18,  1.074395502841587e-05, -3.164569067214620e-06,  4.898493836019638e-07, -5.190160572555034e-08,
  4.210082715021805e-09, -2.781370383657091e-10,  1.556271607719162e-11, -7.576446404387948e-13,  3.272791182891377e-14, -1.273247953500341e-15,  4.513577037151584e-17,
 -1.470447092294400e-18,  5.322182188649854e-06, -1.687271548104447e-06,  2.813827104684283e-07, -3.204529816345349e-08,  2.786193696930436e-09, -1.967490514097421e-10,
  1.173610283217780e-11, -6.075841227351934e-13,  2.784483813004264e-14, -1.146752217677432e-15,  4.294461882608954e-17, -1.474967036707014e-18,  2.679237304711407e-06,
 -9.069026461124131e-07,  1.617726541560816e-07, -1.967164985578627e-08,  1.821989622659531e-09, -1.367315674745497e-10,  8.647611319829377e-12, -4.736271468399254e-13,
  2.291527549105026e-14, -9.943555912131415e-16,  3.916160388003970e-17, -1.411904107382392e-18,  1.378450931077685e-06, -4.943244995510069e-07,  9.364153612344410e-08,
 -1.207717542537039e-08,  1.184128717452922e-09, -9.387862901455482e-11,  6.259901878722921e-12, -3.607794153183020e-13,  1.833421523783220e-14, -8.341575004553984e-16,
  3.438827374944917e-17, -1.295596359636219e-18,  7.280966444504511e-07, -2.745331066648547e-07,  5.483313773032832e-08, -7.449986097367897e-09,  7.682957606346790e-10,
 -6.395760316609012e-11,  4.470365814401763e-12, -2.696133093926603e-13,  1.431487129725268e-14, -6.794071344236632e-16,  2.917497618171685e-17, -1.143247697864248e-18,
  3.958015592737768e-07, -1.557647933506476e-07,  3.256726273822020e-08, -4.629335282533135e-09,  4.988587219823572e-10, -4.333230819301611e-11,  3.155772413556493e-12,
 -1.980295314197196e-13,  1.092457241818291e-14, -5.380223580886046e-16,  2.394319220786120e-17, -9.710665927664022e-19,  2.211895406408794e-07, -9.020353464910356e-08,
  1.960004661908917e-08, -2.894549730269149e-09,  3.237475296805974e-10, -2.915473779293446e-11,  2.198647356049631e-12, -1.426989284919978e-13,  8.132746077853175e-15,
 -4.133260390463819e-16,  1.896136323277537e-17, -7.918683809567473e-19,  1.260673362991415e-07, -5.290311287633094e-08,  1.185983188294170e-08, -1.806770672147228e-09,
  2.083108784476659e-10, -1.932003609910162e-11,  1.499124959511697e-12, -1.000176342415632e-13,  5.854165375570216e-15, -3.052828781007011e-16,  1.435767906832377e-17,
 -6.141604818127356e-19,  7.163860185926087e-08, -3.072271658089762e-08,  7.054189877508772e-09, -1.100633666402463e-09,  1.298956842069660e-10, -1.232376686305559e-11,
  9.775016756917702e-13, -6.661770474929475e-14,  3.980206235579769e-15, -2.117251961832654e-16,  1.015067889404373e-17, -4.423157506961270e-19,  3.809616535478374e-08,
 -1.658409810539801e-08,  3.871529220878190e-09, -6.141628596248865e-10,  7.366995767677826e-11, -7.100638388825831e-12,  5.718978322075485e-13, -3.955704881493128e-14,
  2.397518260175953e-15, -1.293137837496370e-16,  6.283231808449895e-18, -2.773489332092607e-19,  1.479406513695018e-08, -6.493785704504602e-09,  1.530015989897322e-09,
 -2.449690079481071e-10,  2.965181599127686e-11, -2.883259515808762e-12,  2.342144795865408e-13, -1.633464931757832e-14,  9.979789032701837e-16, -5.424543315502100e-17,
  2.655516318865146e-18, -1.180654907087236e-19,  9.164934213882908e-02, -3.555937466228764e-04,  1.455112515534028e-06, -6.195820291653150e-09,  2.707196088066506e-11,
 -1.200516769849079e-13,  5.360005505803463e-16, -2.397661126683977e-18,  1.071159214941094e-20, -4.772113853611486e-23,  2.117874968001246e-25, -9.361502092583560e-28,
  8.587123453233586e-02, -4.729125641277159e-04,  3.109659216343099e-06, -2.058685392271313e-08,  1.321611197243527e-10, -8.218339385991539e-13,  4.973628872158529e-15,
 -2.942280569778042e-17,  1.707116518468984e-19, -9.738674411179722e-22,  5.473003895408855e-24, -3.034534010570268e-26,  7.540777391391608e-02, -6.607988259870642e-04,
  6.381565220402886e-06, -5.658810522046009e-08,  4.680015860146836e-10, -3.673519129020693e-12,  2.766382423819904e-14, -2.012830934752788e-16,  1.422192144604224e-18,
 -9.795282725079718e-21,  6.595888448614977e-23, -4.352532628362059e-25,  6.210118371680075e-02, -8.476343603389998e-04,  1.096848992709450e-05, -1.237312887278212e-07,
  1.273105565744140e-09, -1.223254795922052e-11,  1.113031322251643e-13, -9.681232948969845e-16,  8.104694887453339e-18, -6.563583223301828e-20,  5.162520407249282e-22,
 -3.955869850158361e-24,  4.800667051689875e-02, -9.681921457895493e-04,  1.610547597301732e-05, -2.258569704742897e-07,  2.830783131995670e-09, -3.262575799380249e-11,
  3.518479383192214e-13, -3.592424149772272e-15,  3.501899232059739e-17, -3.279630636118053e-19,  2.965195006922300e-21, -2.597913798865405e-23,  3.487921837347605e-02,
 -9.877601309582749e-04,  2.065790349182086e-05, -3.540954618057883e-07,  5.320213664022109e-09, -7.246762643545888e-11,  9.135533141049868e-13, -1.080702317164840e-14,
  1.211536209950099e-16, -1.296605757678116e-18,  1.332211745872568e-20, -1.319882307480237e-22,  2.385564097383083e-02, -9.089348218886404e-04,  2.351509449845875e-05,
 -4.857534699320660e-07,  8.638453804897899e-09, -1.374638023162556e-10,  2.004062080347074e-12, -2.719167980066157e-14,  3.472279870320767e-16, -4.207785886343210e-18,
  4.869992286758766e-20, -5.409858238866855e-22,  1.538968152505627e-02, -7.618823059292874e-04,  2.403938255592201e-05, -5.912069697301793e-07,  1.231329328030480e-08,
 -2.267376486711394e-10,  3.789297281978069e-12, -5.848662306128905e-14,  8.441011798146853e-16, -1.149654958290178e-17,  1.488157779898121e-19, -1.840815431418806e-21,
  9.386575970935822e-03, -5.868224728448231e-04,  2.228754177832385e-05, -6.455935841676846e-07,  1.560365198432209e-08, -3.297741618189762e-10,  6.270518862037598e-12,
 -1.093286769565346e-13,  1.771588633445191e-15, -2.694886198275019e-17,  3.878059817134234e-19, -5.310818488994567e-21,  5.427880458088665e-03, -4.185303590224996e-04,
  1.890061703146136e-05, -6.386213401113009e-07,  1.776583677148292e-08, -4.278235354268916e-10,  9.194554433763777e-12, -1.799814650444688e-13,  3.255672894160155e-15,
 -5.501031022889598e-17,  8.754621206232628e-19, -1.320636921940544e-20,  2.985380958554745e-03, -2.783400776771619e-04,  1.477591309953936e-05, -5.771986626339185e-07,
  1.834389743378405e-08, -5.000278731399296e-10,  1.207372541818844e-11, -2.638780090235907e-13,  5.300903796189957e-15, -9.900316801587786e-17,  1.734324084926053e-18,
 -2.868961391847483e-20,  1.567559877920966e-03, -1.737416454770822e-04,  1.072744067052334e-05, -4.804765662130703e-07,  1.732361203798620e-08, -5.312602383554000e-10,
  1.433288146194333e-11, -3.479738923448309e-13,  7.726068635198453e-15, -1.587816492188972e-16,  3.048668595533200e-18, -5.507698680980558e-20,  7.891005198928932e-04,
 -1.024455950698191e-04,  7.284570366982548e-06, -3.711950346652851e-07,  1.508395994361020e-08, -5.174205686221546e-10,  1.551622819998775e-11, -4.164558142252449e-13,
  1.017429557693288e-14, -2.291176138045699e-16,  4.802395196918007e-18, -9.438816498376954e-20,  3.826354191785194e-04, -5.742989333056327e-05,  4.659677463649267e-06,
 -2.681437885615615e-07,  1.220404837020277e-08, -4.656848708932362e-10,  1.544484696759180e-11, -4.561871970177829e-13,  1.221081693489377e-14, -3.000974928125598e-16,
  6.840552423215814e-18, -1.457343536238803e-19,  1.796735747469996e-04, -3.081094553304384e-05,  2.827879461573113e-06, -1.824810678599129e-07,  9.245871552475404e-09,
 -3.903633897098176e-10,  1.424961313101782e-11, -4.611055390518850e-13,  1.346668832141826e-14, -3.597829475264674e-16,  8.885554437775810e-18, -2.044666946467772e-19,
  8.218186033862103e-05, -1.592856290945283e-05,  1.640213911526927e-06, -1.178805760532896e-07,  6.610019706528425e-09, -3.071664466393281e-10,  1.228217853918230e-11,
 -4.335072767665555e-13,  1.375717851204553e-14, -3.980052114550151e-16,  1.061087980000812e-17, -2.628028688156062e-19,  3.685099852614096e-05, -7.992390166397069e-06,
  9.161278698397410e-07, -7.284530043659656e-08,  4.494367428887484e-09, -2.286779615137104e-10,  9.968388721652806e-12, -3.820807678093012e-13,  1.312109968092989e-14,
 -4.094687496882671e-16,  1.174083171664289e-17, -3.118780488932975e-19,  1.631257328910023e-05, -3.921758082925990e-06,  4.966170654164662e-07, -4.340510396154756e-08,
  2.929581751270312e-09, -1.623588625766046e-10,  7.678750032975604e-12, -3.181943309815913e-13,  1.177531665499712e-14, -3.948186015675873e-16,  1.212995843760706e-17,
 -3.443426567607144e-19,  7.181526405497551e-06, -1.896737478894441e-06,  2.633892998679752e-07, -2.514119438537161e-08,  1.845577104925079e-09, -1.108206645083741e-10,
  5.658830147495010e-12, -2.523591970868861e-13,  1.002075718073205e-14, -3.595299669565848e-16,  1.178962765422772e-17, -3.563427134109327e-19,  3.168908492867469e-06,
 -9.115599577569465e-07,  1.378052757332353e-07, -1.427307283350326e-08,  1.132922183205318e-09, -7.331015859072920e-11,  4.021448125606324e-12, -1.920976504508574e-13,
  8.148458961799415e-15, -3.115215805448653e-16,  1.085949666196357e-17, -3.481283321615433e-19,  1.412739443049790e-06, -4.389286264883303e-07,  7.171786358916975e-08,
 -8.007853518762219e-09,  6.831900282580578e-10, -4.737772334248477e-11,  2.777487547803896e-12, -1.414217179934863e-13,  6.378674107616279e-15, -2.587062480123212e-16,
  9.546757676701024e-18, -3.232900815468171e-19,  6.413673327708334e-07, -2.134817633567708e-07,  3.742920877595410e-08, -4.475775597806412e-09,  4.079222009388246e-10,
 -3.014334372291204e-11,  1.878396196665923e-12, -1.014282568314107e-13,  4.840906539252735e-15, -2.073270314708060e-16,  8.063191804502390e-18, -2.872110891674341e-19,
  2.987326713948834e-07, -1.056825261514323e-07,  1.973854601479392e-08, -2.510820354954651e-09,  2.429232352484043e-10, -1.901445496142368e-11,  1.252432211269163e-12,
 -7.133640312816932e-14,  3.584404483832466e-15, -1.613168186642623e-16,  6.581125566190891e-18, -2.454699852900422e-19,  1.436748015215608e-07, -5.360190640945104e-08,
  1.058689087458734e-08, -1.422707206109901e-09,  1.451720673576895e-10, -1.196229846124855e-11,  8.279530532979456e-13, -4.946646171882709e-14,  2.602694598734690e-15,
 -1.224570453286375e-16,  5.214662109306217e-18, -2.027041659924060e-19,  7.166997963493989e-08, -2.798274374322731e-08,  5.801340314216972e-09, -8.178012461179846e-10,
  8.741813190921674e-11, -7.534542866204925e-12,  5.446272793542505e-13, -3.393100247964998e-14,  1.858933598674483e-15, -9.094250128581506e-17,  4.021285499808785e-18,
 -1.620908766205806e-19,  3.711281791918983e-08, -1.505085735697876e-08,  3.250707148746197e-09, -4.772151303875429e-10,  5.306729380847403e-11, -4.752296823156122e-12,
  3.564615016656531e-13, -2.301588334341391e-14,  1.305204182151580e-15, -6.601602977623509e-17,  3.014527053209756e-18, -1.253356691896801e-19,  1.982976290608941e-08,
 -8.291288153150401e-09,  1.851402284169942e-09, -2.809439069731323e-10,  3.226772743871174e-11, -2.981664196106545e-12,  2.305364303653364e-13, -1.532799355203938e-14,
  8.942012317252836e-16, -4.648222004703119e-17,  2.179381639702951e-18, -9.294956362366351e-20,  1.070575765069808e-08, -4.581609785085383e-09,  1.049545258631743e-09,
 -1.633789229812669e-10,  1.923850376027978e-11, -1.821266048358546e-12,  1.441558772418443e-13, -9.804399029238583e-15,  5.846341851958714e-16, -3.104047458438762e-17,
  1.485445893907183e-18, -6.461447889083770e-20,  5.489420842690716e-09, -2.387211707932637e-09,  5.566545206718386e-10, -8.820438318975590e-11,  1.056842748145944e-11,
 -1.017521948962291e-12,  8.186633607834458e-14, -5.656730835379190e-15,  3.425092311063053e-16, -1.845599771438992e-17,  8.959243152898919e-19, -3.951155347584212e-20,
  2.088246038457629e-09, -9.162356405933270e-10,  2.157730283237054e-10, -3.453042442070508e-11,  4.177667854315477e-12, -4.060335530805511e-13,  3.296793792787013e-14,
 -2.298222999821891e-15,  1.403500249621418e-16, -7.625485785791418e-18,  3.731391665374192e-19, -1.658315302665929e-20,  9.024978823087867e-02, -3.442430603473581e-04,
  1.383284549504572e-06, -5.781200389813421e-09,  2.479432322642370e-11, -1.079560756658260e-13,  4.734177721947125e-16, -2.080819772491108e-18,  9.136697432608758e-21,
 -4.001844301187525e-23,  1.746349930238627e-25, -7.591932836161378e-28,  8.402782337673814e-02, -4.489887199586303e-04,  2.874782295485334e-06, -1.859755322507564e-08,
  1.168544390509076e-10, -7.117665613510243e-13,  4.221285331903430e-15, -2.448120658939568e-17,  1.392914099519087e-19, -7.794608647592790e-22,  4.297941724185172e-24,
 -2.338649074489863e-26,  7.286255559243378e-02, -6.123405953758253e-04,  5.745123417574674e-06, -4.965359697210363e-08,  4.007392698960155e-10, -3.072384330449913e-12,
  2.261545219862789e-14, -1.609410307084118e-16,  1.112776459351296e-18, -7.503226011672889e-21,  4.948257057356759e-23, -3.199019768095505e-25,  5.887720402932126e-02,
 -7.654969522890486e-04,  9.598305287566872e-06, -1.051823839654983e-07,  1.053114343369219e-09, -9.859304447710486e-12,  8.749792100841808e-14, -7.429108197516046e-16,
  6.075088636209759e-18, -4.808589602665514e-20,  3.698431578483234e-22, -2.772496402999042e-24,  4.437544961662249e-02, -8.494662708742538e-04,  1.364681246204779e-05,
 -1.853578057062250e-07,  2.255174812111159e-09, -2.527197636013432e-11,  2.653247513102923e-13, -2.639893744839512e-15,  2.509790503842435e-17, -2.294034236068739e-19,
  2.025516719976544e-21, -1.734011432963370e-23,  3.123369994995889e-02, -8.381492788285626e-04,  1.687526540239332e-05, -2.794711093388258e-07,  4.067697236769638e-09,
 -5.377513122263445e-11,  6.588886089371081e-13, -7.584478504844088e-15,  8.281607429895075e-17, -8.639747273885853e-19,  8.659475664182806e-21, -8.374430463836873e-23,
  2.056228754600993e-02, -7.419737388789058e-04,  1.843242688001903e-05, -3.671570651207416e-07,  6.314422455969820e-09, -9.737473531675789e-11,  1.377913652340527e-12,
 -1.817019028268794e-14,  2.257451119380223e-16, -2.664022369060298e-18,  3.004987139998772e-20, -3.255684968835058e-22,  1.268616193063950e-02, -5.949110597011512e-04,
  1.799193512707952e-05, -4.260374594223103e-07,  8.569613624820755e-09, -1.527387037790464e-10,  2.474966281901397e-12, -3.709023387359435e-14,  5.203548522929350e-16,
 -6.896244157327016e-18,  8.693954542556568e-20, -1.048202304554432e-21,  7.352213702938663e-03, -4.357193063301961e-04,  1.584461557980860e-05, -4.414583305849842e-07,
  1.029479557104291e-08, -2.104097912010801e-10,  3.876100525356453e-12, -6.557084534385034e-14,  1.032208323369186e-15, -1.527006761546273e-17,  2.139056498314483e-19,
 -2.853947623499003e-21,  4.013687084047146e-03, -2.937270561600545e-04,  1.269493698634768e-05, -4.123529079038646e-07,  1.106173540127121e-08, -2.574691629803982e-10,
  5.358212090033839e-12, -1.017213272153818e-13,  1.786842192251649e-15, -2.935227484954764e-17,  4.545902206814297e-19, -6.679469505280700e-21,  2.070725314377766e-03,
 -1.835177270504296e-04,  9.325407091799355e-06, -3.501618059362124e-07,  1.072921216125600e-08, -2.826227479035295e-10,  6.606969193005355e-12, -1.400199967466357e-13,
  2.731132783298239e-15, -4.958542142234464e-17,  8.452694329191212e-19, -1.361934025417270e-20,  1.013438837566591e-03, -1.069736775238506e-04,  6.326724884975622e-06,
 -2.724806398060817e-07,  9.473790867588219e-09, -2.807973129544129e-10,  7.335371431652482e-12, -1.727093816083102e-13,  3.723858895628603e-15, -7.440694370328965e-17,
  1.390459500957165e-18, -2.447201773214992e-20,  4.725602061782131e-04, -5.855588084183699e-05,  3.992904135385072e-06, -1.957945863645911e-07,  7.676968082058907e-09,
 -2.546427545994726e-10,  7.397213358782935e-12, -1.926247809113363e-13,  4.571819492211105e-15, -1.001376127137185e-16,  2.043661634604304e-18, -3.914729459153671e-20,
  2.109867961535865e-04, -3.029959498382805e-05,  2.361227871352898e-06, -1.309085240494064e-07,  5.754310392053921e-09, -2.124979777413810e-10,  6.832316566628743e-12,
 -1.959275577363710e-13,  5.098383976493396e-15, -1.219523339494890e-16,  2.708397911365448e-18, -5.627247616081578e-20,  9.070461550410013e-05, -1.492345646885106e-05,
  1.318083856977927e-06, -8.206964213341365e-08,  4.021308257636671e-09, -1.644995843963317e-10,  5.827488924890867e-12, -1.832646331572231e-13,  5.208176801322768e-15,
 -1.355506611032893e-16,  3.264557951819363e-18, -7.332519391305670e-20,  3.778461279055508e-05, -7.047398524903934e-06,  6.999176545439502e-07, -4.862761299195964e-08,
  2.641236048669424e-09, -1.190951307266774e-10,  4.627735044731438e-12, -1.589436579844343e-13,  4.914156353278145e-15, -1.386593970055243e-16,  3.608931215742075e-18,
 -8.734201526186132e-20,  1.535868635778508e-05, -3.215725182725329e-06,  3.564135580435155e-07, -2.745610472001336e-08,  1.644035510281758e-09, -8.131120879479383e-11,
  3.450139173458673e-12, -1.288815718811962e-13,  4.318325187368431e-15, -1.316183150504404e-16,  3.689335945857462e-18, -9.588907553509193e-20,  6.138948496716079e-06,
 -1.429576946881757e-06,  1.755308336946164e-07, -1.489960011572517e-08,  9.781500124383475e-10, -5.280123941197262e-11,  2.435398148189184e-12, -9.853136160960270e-14,
  3.563724448804232e-15, -1.168927048660450e-16,  3.516279805018936e-18, -9.781547169230660e-20,  2.433164770382164e-06, -6.246376889722222e-07,  8.435702844501302e-08,
 -7.841040915872329e-09,  5.612420897045960e-10, -3.289991957327250e-11,  1.641868660835382e-12, -7.163235205400919e-14,  2.785308111610006e-15, -9.794062477717461e-17,
  3.150122578719375e-18, -9.346001499041814e-20,  9.648859635146283e-07, -2.707433099706297e-07,  3.993038038082031e-08, -4.038884890838545e-09,  3.134171594261695e-10,
 -1.984797285394973e-11,  1.066554404389746e-12, -4.995270148220969e-14,  2.079254598278923e-15, -7.806356920449672e-17,  2.674284493891112e-18, -8.430917935993732e-20,
  3.864401830915850e-07, -1.175335212102137e-07,  1.879592155759725e-08, -2.055679834559098e-09,  1.719370980950178e-10, -1.169954685904107e-11,  6.735518444941916e-13,
 -3.370491107842698e-14,  1.495124495281143e-15, -5.967805643647364e-17,  2.168685212801488e-18, -7.236552119102390e-20,  1.578123800655355e-07, -5.160065918904289e-08,
  8.883591109297493e-09, -1.043693990925751e-09,  9.352246208978546e-11, -6.799440653767802e-12,  4.171662659663034e-13, -2.219227808243971e-14,  1.044129858191937e-15,
 -4.410791658489773e-17,  1.692908110320505e-18, -5.954193427802126e-20,  6.632949493688781e-08, -2.312806967193838e-08,  4.255294126655121e-09, -5.334291693639060e-10,
  5.088776939906231e-11, -3.929682274971973e-12,  2.555034505709515e-13, -1.437313972140896e-14,  7.136285179283406e-16, -3.175078259861363e-17,  1.281114663791591e-18,
 -4.728151935907752e-20,  2.893801760065602e-08, -1.067431732341869e-08,  2.083275009999772e-09, -2.767078038798981e-10,  2.791851605914864e-11, -2.275704355662863e-12,
  1.558782422306729e-13, -9.220386554422984e-15,  4.804980292702951e-16, -2.239986026257201e-17,  9.454432093511435e-19, -3.643967492046916e-20,  1.319230911366898e-08,
 -5.107188021025444e-09,  1.049270647569096e-09, -1.466020666983565e-10,  1.553643846816060e-11, -1.328013547425012e-12,  9.523121365512721e-14, -5.887702472767676e-15,
  3.201929765147958e-16, -1.555382537879203e-17,  6.830859741381921e-19, -2.735444721546566e-20,  6.303943970317885e-09, -2.541223318338638e-09,  5.453175882944008e-10,
 -7.954466395562442e-11,  8.790870188443905e-12, -7.825490811078795e-13,  5.836071547879308e-14, -3.747404560013367e-15,  2.113820520186366e-16, -1.063686782751149e-17,
  4.833284348744770e-19, -2.000055692934096e-20,  3.145385374491233e-09, -1.310030095113665e-09,  2.912802653866593e-10, -4.401460143591590e-11,  5.034576870214046e-12,
 -4.633729939488181e-13,  3.569035694783791e-14, -2.364270855677097e-15,  1.374381359503278e-16, -7.119937742351459e-18,  3.327322345954583e-19, -1.414612183521221e-20,
  1.607976187120578e-09, -6.865903462212081e-10,  1.568917148684637e-10, -2.436234792889304e-11,  2.861841148054368e-12, -2.702911307193378e-13,  2.134565910867734e-14,
 -1.448610174524743e-15,  8.619891496110058e-17, -4.567363385538069e-18,  2.181448749752328e-19, -9.471119648701335e-21,  7.929978637060286e-10, -3.444751584781885e-10,
  8.022718462258389e-11, -1.269680821345668e-11,  1.519477945629197e-12, -1.461241099965636e-13,  1.174337518937302e-14, -8.105468561864401e-16,  4.902585763610590e-17,
 -2.639037752417678e-18,  1.279820032625923e-19, -5.638793630568655e-21,  2.950774862782126e-10, -1.294096235359634e-10,  3.046052146813604e-11, -4.872148812077500e-12,
  5.891603573250313e-13, -5.723301093487801e-14,  4.644790753753170e-15, -3.236391492709051e-16,  1.975516760707021e-17, -1.072852059496321e-18,  5.247493551149384e-20,
 -2.331105969170788e-21,  8.889451848066304e-02, -3.334476976925462e-04,  1.316221095831600e-06, -5.401166085116598e-09,  2.274426794742437e-11, -9.726145081970844e-14,
  4.190407258757721e-16, -1.810210560663986e-18,  7.814124264163718e-21, -3.365721724809976e-23,  1.444552714259853e-25, -6.177958519318471e-28,  8.227649508899193e-02,
 -4.268524069859683e-04,  2.662377132019182e-06, -1.683648461413533e-08,  1.035791901445457e-10, -6.182025107270404e-13,  3.594221059240288e-15, -2.044158213848196e-17,
  1.140926467877155e-19, -6.264643172055011e-22,  3.390270984317559e-24, -1.810948481904491e-26,  7.050148947147794e-02, -5.686584653579554e-04,  5.185814958988041e-06,
 -4.370532243028532e-08,  3.443740616304526e-10, -2.579902445412213e-12,  1.856959183191057e-14, -1.292979434800767e-16,  8.751403967559175e-19, -5.778943724748212e-21,
  3.733747659045904e-23, -2.365623207440310e-25,  5.596118077424195e-02, -6.934870957538329e-04,  8.431059691270550e-06, -8.980264271146232e-08,  8.753499309750360e-10,
 -7.988507914718389e-12,  6.917687087005483e-14, -5.735727623522413e-16,  4.583309151456234e-18, -3.547012040451260e-20,  2.668658753835158e-22, -1.957786946697176e-24,
  4.118266436829773e-02, -7.486118223397067e-04,  1.162339186177625e-05, -1.529961329891926e-07,  1.807864517421015e-09, -1.970753924133511e-11,  2.015134608661333e-13,
 -1.954638853603689e-15,  1.813095731820178e-17, -1.618021396779926e-19,  1.395662887564006e-21, -1.167851061943306e-23,  2.813132812635012e-02, -7.155318491061571e-04,
  1.387921750772005e-05, -2.221999462779680e-07,  3.134560155989424e-09, -4.023724260025587e-11,  4.793868923038659e-13, -5.371757431426086e-15,  5.715165083408625e-17,
 -5.814147805263734e-19,  5.686565691325070e-21, -5.369780197462204e-23,  1.786365080749549e-02, -6.105574788272059e-04,  1.457384002458577e-05, -2.800688168213241e-07,
  4.660287832469656e-09, -6.967466359091616e-11,  9.573691822851363e-13, -1.227422487196219e-14,  1.484183881208139e-16, -1.706214007769646e-18,  1.876316334338779e-20,
 -1.983253732683548e-22,  1.056501887806880e-02, -4.693072618224992e-04,  1.361092596826669e-05, -3.104564435551818e-07,  6.033542460959743e-09, -1.041276874025964e-10,
  1.636545200296517e-12, -2.382083885746476e-14,  3.249648134810199e-16, -4.191970344949178e-18,  5.148342298633195e-20, -6.051675948603894e-22,  5.832868921081698e-03,
 -3.276420290844033e-04,  1.141136108558692e-05, -3.059157861512612e-07,  6.885480600144864e-09, -1.361371802237213e-10,  2.430393234214802e-12, -3.990230068157456e-14,
  6.103727499627263e-16, -8.783556764473679e-18,  1.198002600101307e-19, -1.557580752564845e-21,  3.014342604235438e-03, -2.093020417731484e-04,  8.658940988769930e-06,
 -2.704366172884859e-07,  6.997283335069277e-09, -1.574530225305297e-10,  3.173708048115629e-12, -5.844422443638961e-14,  9.971464074614958e-16, -1.592733426615502e-17,
  2.400918207932565e-19, -3.436690570028645e-21,  1.462865484676376e-03, -1.231834668751763e-04,  5.991590252697396e-06, -2.162729200437268e-07,  6.389669393746523e-09,
 -1.626686156544714e-10,  3.682111061567945e-12, -7.567607709219008e-14,  1.433383954340955e-15, -2.530040164289693e-17,  4.197265810449104e-19, -6.587606505095451e-21,
  6.692077992394886e-04, -6.723402334216463e-05,  3.808127897588353e-06, -1.576924698651074e-07,  5.286963827053569e-09, -1.514510059705991e-10,  3.830943592705089e-12,
 -8.747492726876142e-14,  1.831595866228947e-15, -3.558203335420503e-17,  6.471594229863523e-19, -1.109615481205098e-20,  2.898495363715069e-04, -3.425506954624083e-05,
  2.239162020153889e-06, -1.056340506799095e-07,  3.995688761933469e-09, -1.281403578681954e-10,  3.605505662321526e-12, -9.108065837542350e-14,  2.099918816557320e-15,
 -4.473261341552226e-17,  8.888092628629929e-19, -1.659183022604100e-20,  1.194658623406942e-04, -1.640139589759453e-05,  1.226952218286943e-06, -6.550890376018170e-08,
  2.780188127412562e-09, -9.933212407308941e-11,  3.095417242459527e-12, -8.616258520502502e-14,  2.179221781857948e-15, -5.072402062839274e-17,  1.097355585615692e-18,
 -2.223122279268234e-20,  4.713042426626651e-05, -7.432463781226376e-06,  6.312776387338811e-07, -3.790544808531270e-08,  1.795306558792492e-09, -7.112706560953600e-11,
  2.444411968961383e-12, -7.468346283568425e-14,  2.064621420755772e-15, -5.233135881310739e-17,  1.228679438287908e-18, -2.693006076515562e-20,  1.791513375210639e-05,
 -3.211977720979292e-06,  3.074132386742308e-07, -2.063252225065451e-08,  1.084875640478735e-09, -4.744060103277590e-11,  1.790547138304286e-12, -5.981609931248570e-14,
  1.800995878445184e-15, -4.954271657808890e-17,  1.258373301661036e-18, -2.974815186340497e-20,  6.610654120841764e-06, -1.334614138279362e-06,  1.428946433601107e-07,
 -1.065584825242489e-08,  6.188055596576511e-10, -2.973003132072785e-11,  1.227180221900126e-12, -4.465249979324522e-14,  1.458994034961346e-15, -4.341009124707391e-17,
  1.188973417020824e-18, -3.022262563368056e-20,  2.387820136982789e-06, -5.379426581213529e-07,  6.397928643227806e-08, -5.269507541904418e-09,  3.362126526342631e-10,
 -1.766438596748015e-11,  7.940309477287037e-13, -3.134482905533825e-14,  1.107344379039117e-15, -3.551205302240760e-17,  1.045368622610490e-18, -2.848129302906341e-20,
  8.521190319635934e-07, -2.123638281004034e-07,  2.786158448191369e-08, -2.519431632622152e-09,  1.756817823997071e-10, -1.004557596526657e-11,  4.895850572779430e-13,
 -2.088189538691191e-14,  7.945600551124733e-16, -2.736507726880902e-17,  8.627784732892428e-19, -2.511182830124536e-20,  3.034644553845976e-07, -8.295864681011405e-08,
  1.192327908530336e-08, -1.176594618232200e-09,  8.918018914249218e-11, -5.522317188336434e-12,  2.904632614885589e-13, -1.332842232123684e-14,  5.440212556968484e-16,
 -2.004442701458683e-17,  6.743936343076129e-19, -2.089555144505194e-20,  1.090172613333061e-07, -3.242005843327767e-08,  5.068941779602549e-09, -5.424780209757488e-10,
  4.444121976157428e-11, -2.964693083661227e-12,  1.674774334655136e-13, -8.230140110702239e-15,  3.587976825859872e-16, -1.408484086504609e-17,  5.037152105509963e-19,
 -1.655199474597479e-20,  3.995162370995713e-08, -1.281864232442039e-08,  2.164804731887556e-09, -2.496433077810136e-10,  2.197418400360175e-11, -1.570555339467606e-12,
  9.479611239912849e-14, -4.964596798190722e-15,  2.301008051202550e-16, -9.581307855345296e-18,  3.626878858667323e-19, -1.258799067968615e-20,  1.510516851957565e-08,
 -5.186320937804903e-09,  9.391395371670647e-10, -1.159175143585845e-10,  1.089472162791641e-11, -8.293862932982113e-13,  5.319258646774790e-14, -2.953293240045389e-15,
  1.447970798200893e-16, -6.364928309096298e-18,  2.538544539959849e-19, -9.265100789428367e-21,  5.955497817838559e-09, -2.170281356629860e-09,  4.182140452878356e-10,
 -5.486246127792889e-11,  5.469419086644542e-12, -4.407221403971425e-13,  2.985635396048166e-14, -1.747418021225948e-15,  9.014060584176273e-17, -4.161314177711706e-18,
  1.739974262238279e-19, -6.646141932075752e-21,  2.470897362788595e-09, -9.478735580431102e-10,  1.928617681576496e-10, -2.669102198957197e-11,  2.802725263243720e-12,
 -2.374577765685710e-13,  1.688375082984958e-14, -1.035350831959778e-15,  5.586576401116252e-17, -2.693376103665189e-18,  1.174324180794222e-19, -4.670046374975611e-21,
  1.084886639633383e-09, -4.345169876239985e-10,  9.259650813197547e-11, -1.341464158250457e-11,  1.472701350141436e-12, -1.302607213112295e-13,  9.654891364102675e-15,
 -6.162909394760352e-16,  3.456619012997725e-17, -1.729899586473286e-18,  7.819236889532535e-20, -3.219373633161076e-21,  5.034221420555847e-10, -2.087893396065265e-10,
  4.621117213664894e-11, -6.951219665550947e-12,  7.916108318006132e-13, -7.254875685475513e-14,  5.565043459392258e-15, -3.671979862951156e-16,  2.126476723750185e-17,
 -1.097595458013444e-18,  5.111324790144080e-20, -2.165755824404935e-21,  2.428264502642051e-10, -1.034317423696684e-10,  2.357175594762868e-11, -3.650509484976690e-12,
  4.277127412624746e-13, -4.029463585301382e-14,  3.174474450333622e-15, -2.149307015249574e-16,  1.276057519899895e-17, -6.746695895637012e-19,  3.215599078740122e-20,
 -1.393300202852077e-21,  1.148671542370950e-10, -4.983882433217662e-11,  1.159208761866475e-11, -1.832167438159570e-12,  2.189817103592055e-13, -2.103265362081181e-14,
  1.688265743027605e-15, -1.163908108951775e-16,  7.031940123693206e-18, -3.781126180496545e-19,  1.831747957667521e-20, -8.062329980261019e-22,  4.174224148036623e-11,
 -1.829786004518541e-11,  4.304668946954443e-12, -6.881599379149454e-13,  8.317094099175849e-14, -8.075295302702414e-15,  6.550232733874257e-16, -4.561793257003216e-17,
  2.783200230393288e-18, -1.510768393212179e-19,  7.385999883119223e-21, -3.279624934674656e-22,  8.758138528206072e-02, -3.231711428279313e-04,  1.253528084109676e-06,
 -5.052289939787986e-09,  2.089564456820625e-11, -8.778552925326666e-14,  3.716810584258164e-16, -1.578480974477268e-18,  6.700244841536787e-21, -2.838747883421595e-23,
  1.198568290123730e-25, -5.044062673736987e-28,  8.061044249507521e-02, -4.063342778060546e-04,  2.469889572813050e-06, -1.527363054871147e-08,  9.203343849789087e-11,
 -5.384169580131664e-13,  3.069757795014326e-15, -1.712676939910364e-17,  9.380053785555056e-20, -5.055269605826994e-22,  2.685851478889909e-24, -1.408789736131028e-26,
  6.830663430538936e-02, -5.291799014362377e-04,  4.692783470663156e-06, -3.858508343550425e-08,  2.969550418890842e-10, -2.174694250219104e-12,  1.531197963756765e-14,
 -1.043530570833915e-16,  6.916506254382305e-19, -4.474384883899799e-21,  2.833104875130488e-23, -1.759687500809975e-25,  5.331562517742822e-02, -6.301226323068827e-04,
  7.432467126416412e-06, -7.699017510232475e-08,  7.309622601481087e-10, -6.505520400474312e-12,  5.499195937112824e-14, -4.454347908535143e-16,  3.479447014007938e-18,
 -2.633698575212918e-20,  1.938986914531666e-22, -1.392543482796095e-24,  3.836322041202882e-02, -6.625050987397442e-04,  9.948789328773540e-06, -1.269782274039963e-07,
  1.457961161119554e-09, -1.546743374868418e-11,  1.541019360969009e-13, -1.457801854506022e-15,  1.319838636214585e-17, -1.150382978772125e-19,  9.697259726832305e-22,
 -7.933967285822191e-24,  2.547550887326434e-02, -6.143684449521634e-04,  1.148907298665516e-05, -1.779074762953527e-07,  2.433676360722144e-09, -3.034808517781003e-11,
  3.517231348555420e-13, -3.838136401273616e-15,  3.980330296320516e-17, -3.950040293683260e-19,  3.771251971759862e-21, -3.478358962116686e-23,  1.563497657858689e-02,
 -5.062408014966966e-04,  1.161816298083207e-05, -2.155116225311324e-07,  3.471275608357000e-09, -5.033723174850984e-11,  6.718899495579141e-13, -8.378263626787239e-15,
  9.863626520268306e-17, -1.104979321417010e-18,  1.185037586240244e-20, -1.222382693821327e-22,  8.884094352818924e-03, -3.738260949013236e-04,  1.040228484565059e-05,
 -2.286534285234314e-07,  4.295263005501859e-09, -7.180575417883229e-11,  1.095017131586828e-12, -1.548591205341614e-14,  2.054916534922390e-16, -2.580925184296239e-18,
  3.088815971188351e-20, -3.540760937486657e-22,  4.684028003443086e-03, -2.493503223782479e-04,  8.320843324731254e-06, -2.147044156926710e-07,  4.665810294995863e-09,
 -8.926995861353548e-11,  1.544930149033526e-12, -2.462411168946573e-14,  3.661130572678690e-16, -5.126271646609319e-18,  6.809223531180735e-20, -8.628900220256251e-22,
  2.297526520850705e-03, -1.513231719380216e-04,  5.993549842937962e-06, -1.800317588770246e-07,  4.493967458543264e-09, -9.778580075202762e-11,  1.909470781285212e-12,
 -3.411649560468565e-14,  5.654747490069428e-16, -8.784325480432160e-18,  1.289066640752141e-19, -1.797838465570231e-21,  1.051723309438230e-03, -8.411314866500026e-05,
  3.916149997909504e-06, -1.359006439308114e-07,  3.871966936283500e-09, -9.528038631508445e-11,  2.088595944543763e-12, -4.163393343264000e-14,  7.658723608576324e-16,
 -1.314391877557161e-17,  2.122304118917632e-19, -3.244968298048503e-21,  4.509801735862910e-04, -4.310163256925046e-05,  2.337572607693242e-06, -9.306483875266011e-08,
  3.008765063691669e-09, -8.330297690053072e-11,  2.040385986771373e-12, -4.518444824807312e-14,  9.187936316933306e-16, -1.735451469197452e-17,  3.072125698721166e-19,
 -5.131656593028411e-21,  1.819390335556996e-04, -2.049341750791766e-05,  1.283719018732278e-06, -5.825128422475788e-08,  2.125352536258092e-09, -6.589196385174658e-11,
  1.795639831670476e-12, -4.400104812385351e-14,  9.853920673777049e-16, -2.041341564478344e-17,  3.948605992313725e-19, -7.182785509193266e-21,  6.941004397170314e-05,
 -9.102318316469094e-06,  6.533174999508780e-07, -3.358007655321983e-08,  1.375562001861960e-09, -4.753859186746570e-11,  1.435494726471923e-12, -3.877850491775526e-14,
  9.531099790218046e-16, -2.158426103954773e-17,  4.547910883527612e-19, -8.982376926066880e-21,  2.518940836159306e-05, -3.803837587078714e-06,  3.104809926095783e-07,
 -1.796939817780074e-08,  8.223112991206924e-10, -3.154057225382810e-11,  1.051203876298362e-12, -3.119297402129459e-14,  8.386047771600714e-16, -2.069506011171858e-17,
  4.735699372154339e-19, -1.012612433293388e-20,  8.755437089028688e-06, -1.507302311348737e-06,  1.389096014306242e-07, -9.000555563322095e-09,  4.578827741713314e-10,
 -1.940840039562848e-11,  7.111943096848483e-13, -2.309910271122367e-14,  6.770286969244841e-16, -1.815007939591360e-17,  4.497317045721324e-19, -1.038150963035327e-20,
  2.937626564290820e-06, -5.711961592453198e-07,  5.902387145503150e-08, -4.257412662320100e-09,  2.396104906540459e-10, -1.117580551965291e-11,  4.485089448886006e-13,
 -1.588773152647882e-14,  5.059843494393476e-16, -1.468947291299490e-17,  3.929547550462799e-19, -9.764609653501150e-21,  9.599047089731473e-07, -2.089516702217787e-07,
  2.404708844879875e-08, -1.920064970887433e-09,  1.189672591260342e-10, -6.079153214502707e-12,  2.661365875988346e-13, -1.024439176162612e-14,  3.532933221252227e-16,
 -1.107126132438081e-17,  3.187563086789217e-19, -8.501494585759488e-21,  3.085337861426929e-07, -7.455131785346339e-08,  9.491621765105457e-09, -8.341839085957305e-10,
  5.661783762142115e-11, -3.155408048922951e-12,  1.500701381244364e-13, -6.253217109025473e-15,  2.326843416691920e-16, -7.844161895756250e-18,  2.422866029284418e-19,
 -6.914211661094543e-21,  9.863321631653831e-08, -2.623618342840452e-08,  3.670609517120010e-09, -3.530239890165881e-10,  2.611105670072062e-11, -1.579666330401887e-12,
  8.126276397015677e-14, -3.650608691559638e-15,  1.460103817712874e-16, -5.276032248114589e-18,  1.742251567325740e-19, -5.302246701696670e-21,  3.174149855828893e-08,
 -9.218434397891133e-09,  1.407609001382540e-09, -1.472581769855194e-10,  1.180498942428017e-11, -7.713905650879146e-13,  4.272381996638716e-14, -2.060227914313124e-15,
  8.820631984630893e-17, -3.403040195126093e-18,  1.196922620180880e-19, -3.870697838895891e-21,  1.041597426752090e-08, -3.275753687133085e-09,  5.420924882885480e-10,
 -6.130075357492546e-11,  5.295563495261973e-12, -3.717616518972381e-13,  2.205738700559561e-14, -1.136367655012458e-15,  5.184689210876576e-17, -2.126561847974074e-18,
  7.934069844560879e-20, -2.715718652268301e-21,  3.531880044733515e-09, -1.192903172156191e-09,  2.123919515501810e-10, -2.578906770849019e-11,  2.385965192462108e-12,
 -1.789181228793800e-13,  1.131035012894597e-14, -6.193304686497981e-16,  2.996503959314999e-17, -1.300532604756307e-18,  5.123949855635735e-20, -1.848329793079620e-21,
  1.253740501649772e-09, -4.509859928170949e-10,  8.573494747168492e-11, -1.109918428599995e-11,  1.092510848239546e-12, -8.696438764037482e-14,  5.822696264553847e-15,
 -3.369802610323031e-16,  1.719678517555352e-17, -7.857141287794784e-19,  3.252834440795445e-20, -1.230696026156209e-21,  4.713973308853923e-10, -1.790698575278537e-10,
  3.605872317886078e-11, -4.939811931618775e-12,  5.136397123879753e-13, -4.310844039551520e-14,  3.037434407707045e-15, -1.846487378272844e-16,  9.880459262119407e-18,
 -4.725473149024659e-19,  2.044514582318951e-20, -8.070765510737913e-22,  1.893294535357312e-10, -7.530323731958672e-11,  1.592782780261880e-11, -2.290579961064935e-12,
  2.496821085675783e-13, -2.193345718962685e-14,  1.615018744526240e-15, -1.024390140910889e-16,  5.710696947626847e-18, -2.841320569669890e-19,  1.277098285249177e-20,
 -5.229881484124741e-22,  8.135315705847038e-11, -3.358706802340171e-11,  7.397154885072942e-12, -1.107277012510312e-12,  1.255009694169027e-13, -1.144927869957540e-14,
  8.743876810586946e-16, -5.745084100758907e-17,  3.313509995065568e-18, -1.703607646154870e-19,  7.903609754639810e-21, -3.336817802074739e-22,  3.688445101220646e-11,
 -1.566952079675563e-11,  3.560722865053582e-12, -5.498606116278959e-13,  6.424474023238818e-14, -6.036137729474583e-15,  4.742988897652747e-16, -3.203233556095795e-17,
  1.897189265240929e-18, -1.000738767728043e-19,  4.759025344192881e-21, -2.057622398625163e-22,  1.668720050797620e-11, -7.231069221573648e-12,  1.679516499531255e-12,
 -2.650797683558803e-13,  3.163893581158326e-14, -3.034787323833401e-15,  2.432841330124449e-16, -1.675132315526148e-17,  1.010837428493606e-18, -5.429011531637331e-20,
  2.627095311018284e-21, -1.155045133552873e-22,  5.911910089265788e-12, -2.590207230150565e-12,  6.090172024699528e-13, -9.730442229771944e-14,  1.175361295779518e-14,
 -1.140563975955780e-15,  9.246660610843808e-17, -6.436301618967900e-18,  3.924853816824911e-19, -2.129416995547317e-20,  1.040546093679420e-21, -4.618184318141882e-23,
  8.630838103794232e-02, -3.133798748148397e-04,  1.194850178206364e-06, -4.731535242301352e-09,  1.922567876653627e-11, -7.937223761563368e-14,  3.303380217806189e-16,
 -1.379540721887987e-18,  5.759504036894286e-21, -2.400879011307338e-23,  9.974165035853010e-26, -4.131610799895971e-28,  7.902349711474921e-02, -3.872840555668272e-04,
  2.295098396521599e-06, -1.388339643472644e-08,  8.196468188803192e-11, -4.701742861600532e-13,  2.629636079287501e-15, -1.439675439509214e-17,  7.739489738543728e-20,
 -4.095242587120755e-22,  2.136686901251633e-24, -1.100828428193539e-26,  6.626217659908848e-02, -4.934121264724011e-04,  4.256896922931270e-06, -3.416273730112769e-08,
  2.569116805621095e-10, -1.839909732694301e-12,  1.267721403302178e-14, -8.459305042214314e-17,  5.492349465704412e-19, -3.481944509641414e-21,  2.161328587683854e-23,
 -1.316433111986112e-25,  5.090847108361535e-02, -5.741690446359532e-04,  6.574684979526387e-06, -6.626797758598814e-08,  6.131011683361304e-10, -5.323623162833687e-12,
  4.394605828518012e-14, -3.478777579048723e-16,  2.657327390192532e-18, -1.967992726748091e-20,  1.418257940288203e-22, -9.974471854352044e-25,  3.586326072592101e-02,
 -5.886354441136527e-04,  8.555421336437765e-06, -1.059377554469197e-07,  1.182521992332525e-09, -1.221465829524201e-11,  1.186234400904312e-13, -1.094862193924134e-15,
  9.678579441440350e-18, -8.242240724844639e-20,  6.792183311761959e-22, -5.435335025121228e-24,  2.318921655147321e-02, -5.303767806857793e-04,  9.569178192288046e-06,
 -1.433998094084489e-07,  1.903114968539699e-09, -2.306458310140078e-11,  2.601408730557107e-13, -2.765588902441690e-15,  2.796619283367517e-17, -2.708277656943822e-19,
  2.524887964190305e-21, -2.275367067640257e-23,  1.378076390779469e-02, -4.227670603777590e-04,  9.334678004702595e-06, -1.672228101260609e-07,  2.608481124250953e-09,
 -3.670402875357631e-11,  4.761034761998098e-13, -5.776460418414450e-15,  6.623490913938501e-17, -7.233045353743967e-19,  7.567315723192434e-21, -7.619912086720091e-23,
  7.539365206456659e-03, -3.005154181393517e-04,  8.027649627393812e-06, -1.701253175553245e-07,  3.090334683642171e-09, -5.006357608972881e-11,  7.410424273115544e-13,
 -1.018579957370405e-14,  1.315136298505002e-16, -1.608730074741518e-18,  1.876685439389855e-20, -2.098503095213722e-22,  3.805070620988163e-03, -1.919439631819691e-04,
  6.139328131567319e-06, -1.525326719631794e-07,  3.201528154509397e-09, -5.929488594452079e-11,  9.950877901827851e-13, -1.540181048541699e-14,  2.226404796342941e-16,
 -3.033991967572400e-18,  3.925770102595850e-20, -4.850058465982973e-22,  1.775996513205823e-03, -1.109278709350288e-04,  4.207310192942583e-06, -1.215754801468106e-07,
  2.928594088872605e-09, -6.163699916980234e-11,  1.166289967448039e-12, -2.022251148022117e-14,  3.256937675616782e-16, -4.921569440597405e-18,  7.032103789835770e-20,
 -9.557603299377215e-22,  7.689166693496771e-04, -5.838291944687279e-05,  2.602014075900832e-06, -8.682211060309038e-08,  2.385846777492348e-09, -5.675857769692023e-11,
  1.205061974762642e-12, -2.330234446701702e-14,  4.163662435743006e-16, -6.948725100761409e-18,  1.092155992164027e-19, -1.626962784059511e-21,  3.099097365478739e-04,
 -2.816103043663040e-05,  1.462228562404889e-06, -5.596943311114459e-08,  1.744917496133556e-09, -4.669560793526275e-11,  1.107570858235235e-12, -2.378880599509021e-14,
  4.697955455158869e-16, -8.628174851685669e-18,  1.486657586406794e-19, -2.419375583370309e-21,  1.167787633989509e-04, -1.252842078366854e-05,  7.518262754122126e-07,
 -3.280936362357382e-08,  1.154558643474376e-09, -3.460141002518545e-11,  9.131955198729304e-13, -2.170560438808172e-14,  4.721389040874407e-16, -9.511384560163783e-18,
  1.791008485745363e-19, -3.174612493413977e-21,  4.134806446850831e-05, -5.175175824080315e-06,  3.562213120224717e-07, -1.762063850760562e-08,  6.965265191132906e-10,
 -2.327912779634027e-11,  6.810391001536542e-13, -1.785184984670363e-14,  4.263251991252081e-16, -9.391969707175735e-18,  1.927142740703061e-19, -3.710211221672030e-21,
  1.383829263165947e-05, -1.999167809777779e-06,  1.567166071976248e-07, -8.738224885359541e-09,  3.862084665822208e-10, -1.433659860048620e-11,  4.632456650442925e-13,
 -1.334695104252216e-14,  3.488640351473204e-16, -8.380079173871000e-18,  1.868553103060975e-19, -3.896968243109858e-21,  4.408115780057402e-06, -7.279200175916639e-07,
  6.454468647186769e-08, -4.034904439858051e-09,  1.984927504362779e-10, -8.151579846781291e-12,  2.898806674969013e-13, -9.150207803337867e-15,  2.609765791715652e-16,
 -6.815960841154531e-18,  1.647038737632570e-19, -3.711324303223748e-21,  1.347282506745813e-06, -2.520105085060890e-07,  2.511018362441386e-08, -1.750589000965514e-09,
  9.542244954846138e-11, -4.318150287195733e-12,  1.683968525184170e-13, -5.804434937092382e-15,  1.800934961566551e-16, -5.099240959104709e-18,  1.331717912479714e-19,
 -3.233699675103428e-21,  3.987717363289460e-07, -8.376952300643534e-08,  9.319149938010584e-09, -7.207310102151459e-10,  4.333263823678944e-11, -2.152069006801697e-12,
  9.169780042267219e-14, -3.439787868779783e-15,  1.157356723513140e-16, -3.542130659537175e-18,  9.969479706754669e-20, -2.601613917204616e-21,  1.155170738911512e-07,
 -2.702789736318334e-08,  3.335676757161226e-09, -2.846508012704960e-10,  1.878860862626766e-11, -1.019779324235264e-12,  4.729454666895246e-14, -1.923930400262325e-15,
  6.996470156764369e-17, -2.307288431726923e-18,  6.977694343898097e-20, -1.951270955405909e-21,  3.314446992607668e-08, -8.567425733223251e-09,  1.165466218919174e-09,
 -1.091336789621258e-10,  7.869633489260552e-12, -4.647412756941076e-13,  2.336401156943532e-14, -1.026792068981224e-15,  4.021389056931994e-17, -1.424149698961043e-18,
  4.612822478675524e-20, -1.378037728640263e-21,  9.545170536299541e-09, -2.703821660177121e-09,  4.027461721691210e-10, -4.114448123573313e-11,  3.224523695617054e-12,
 -2.062073243764746e-13,  1.118816559936452e-14, -5.290049768006194e-16,  2.222626530093604e-17, -8.421623645354668e-19,  2.911202502651109e-20, -9.259310393878131e-22,
  2.799237563729274e-09, -8.618708610418882e-10,  1.396092970384630e-10, -1.546529560572942e-11,  1.309933754624333e-12, -9.024677519249515e-14,  5.259140873070920e-15,
 -2.663256734093577e-16,  1.195272784414966e-17, -4.825783154296770e-19,  1.773402084962749e-20, -5.982554518573364e-22,  8.488208781845749e-10, -2.817213205125437e-10,
  4.926917345693166e-11, -5.879497100703507e-12,  5.349889803000302e-13, -3.948415862547423e-14,  2.458280372036815e-15, -1.326621370419015e-16,  6.329565206446950e-18,
 -2.710589300667747e-19,  1.054300929528235e-20, -3.756526917911630e-22,  2.702899898993767e-10, -9.588443721211827e-11,  1.796672464922739e-11, -2.293469916679419e-12,
  2.227163029275075e-13, -1.749987012885874e-14,  1.157234645151874e-15, -6.618073987357381e-17,  3.339013742748715e-18, -1.508972187572111e-19,  6.181799381098763e-21,
 -2.315416252808767e-22,  9.170390015407722e-11, -3.447026006910944e-11,  6.864437354044037e-12, -9.302092088597866e-13,  9.571328327786294e-14, -7.952429023932094e-15,
  5.549412490044895e-16, -3.342422291410249e-17,  1.772683658717885e-18, -8.406098217739683e-20,  3.607299386455943e-21, -1.412854014277351e-22,  3.353642697773421e-11,
 -1.323875977441042e-11,  2.777796912692260e-12, -3.963308548745207e-13,  4.287276205085388e-14, -3.738596502226661e-15,  2.733462317093128e-16, -1.722098730704786e-17,
  9.537994369337227e-19, -4.716026059931618e-20,  2.107053452995298e-21, -8.579192626640520e-23,  1.328324416841865e-11, -5.457109613250281e-12,  1.195474397996968e-12,
 -1.780103526698481e-13,  2.007331670008178e-14, -1.822273160731887e-15,  1.385110845845953e-16, -9.059460843458819e-18,  5.202322274372310e-19, -2.663519407044853e-20,
  1.230722265945278e-21, -5.175917878889483e-23,  5.637860755097908e-12, -2.388292814236372e-12,  5.410210372410730e-13, -8.328819915794023e-14,  9.701984916750986e-15,
 -9.089057131879123e-16,  7.121878648998583e-17, -4.796886480322892e-18,  2.833701838539016e-19, -1.491006360778827e-20,  7.073476464705168e-22, -3.051254890462854e-23,
  2.431803196734794e-12, -1.052329485626427e-12,  2.440478014575513e-13, -3.846008907771973e-14,  4.583677961156888e-15, -4.390342974631443e-16,  3.514652832125861e-17,
 -2.416777803027758e-18,  1.456491399149875e-19, -7.812783209255925e-21,  3.776051498521149e-22, -1.658278435881092e-23,  8.383427511897952e-13, -3.671111193489234e-13,
  8.626486578000575e-14, -1.377451219881634e-14,  1.662868379713618e-15, -1.612702819542160e-16,  1.306693686680540e-17, -9.090454263195701e-19,  5.540374537548956e-20,
 -3.004338050671110e-21,  1.467329658320786e-22, -6.509119231886770e-24,  8.507362677190217e-02, -3.040430756070878e-04,  1.139866395126896e-06, -4.436205947776518e-09,
  1.771449068321957e-11, -7.188759636236923e-14,  2.941664944900734e-16, -1.208329819675573e-18,  4.962830344157614e-21, -2.035987978135900e-23,  8.324002723010544e-26,
 -3.394898009154794e-28,  7.751005788816324e-02, -3.695680700772735e-04,  2.136066678582960e-06, -1.264389255580315e-08,  7.316104760861597e-11, -4.116335250712308e-13,
  2.259095864858340e-15, -1.214041051183599e-17,  6.408054909156020e-20, -3.330016919123937e-22,  1.706677925145585e-24, -8.639008557640180e-27,  6.435413717342027e-02,
 -4.609295756217950e-04,  3.870444687237324e-06, -3.033077590396224e-08,  2.229739536994943e-10, -1.562203953966670e-12,  1.053694869647696e-14, -6.886697475246474e-17,
  4.381459198926584e-19, -2.722933764346085e-21,  1.657444127957741e-23, -9.902648890560861e-26,  4.871217871050276e-02, -5.245933995702523e-04,  5.834990347128540e-06,
 -5.725597987531495e-08,  5.164337905214983e-10, -4.376813306237504e-12,  3.529679191935026e-14, -2.731644015148281e-16,  2.041210703764473e-18, -1.479569979757842e-20,
  1.044074065532976e-22, -7.192881771600458e-25,  3.363798523746631e-02, -5.249730503113967e-04,  7.390102736382477e-06, -8.882689072837654e-08,  9.643851907369243e-10,
 -9.703136871952704e-12,  9.189207294120242e-14, -8.278136810376087e-16,  7.147810239725462e-18, -5.949352865624115e-20,  4.794416849362879e-22, -3.753762396332187e-24,
  2.121060509420967e-02, -4.602218766849372e-04,  8.016887929125619e-06, -1.163256974426352e-07,  1.498471554026482e-09, -1.765767175380671e-11,  1.938959199608546e-13,
 -2.008977583483094e-15,  1.981646854072485e-17, -1.873327808180174e-19,  1.705967029910035e-21, -1.502577771787308e-23,  1.222727445039840e-02, -3.554588374646013e-04,
  7.556064355474631e-06, -1.307898895666097e-07,  1.976707185697138e-09, -2.700105349917920e-11,  3.405026862537997e-13, -4.021127851604181e-15,  4.492295168512781e-17,
 -4.783695141230014e-19,  4.883863937135120e-21, -4.802136283165786e-23,  6.453910125065123e-03, -2.436899327607831e-04,  6.252660393103735e-06, -1.278128663158873e-07,
  2.246060115596745e-09, -3.527418058493141e-11,  5.069886874486477e-13, -6.775427946971522e-15,  8.514744718797092e-17, -1.014724145328798e-18,  1.154179254816050e-20,
 -1.259282817194460e-22,  3.125051892255970e-03, -1.493624618796860e-04,  4.580983011815540e-06, -1.096311436347024e-07,  2.223289013226586e-09, -3.987375723182685e-11,
  6.491009355167450e-13, -9.759165352221454e-15,  1.371974185803504e-16, -1.820102177494783e-18,  2.294717943116358e-20, -2.764506970310126e-22,  1.391374691415765e-03,
 -8.239311876096464e-05,  2.993316211946321e-06, -8.323230342827526e-08,  1.935355544220921e-09, -3.940925590682861e-11,  7.227758905221916e-13, -1.216508748475001e-14,
  1.904208068600222e-16, -2.799628473517470e-18,  3.895682454615728e-20, -5.160794331507519e-22,  5.712327947442928e-04, -4.116238237683204e-05,  1.756272714512156e-06,
 -5.635597444882220e-08,  1.493940155351431e-09, -3.436523440572626e-11,  7.068086881223158e-13, -1.326060090034284e-14,  2.301841385763153e-16, -3.736205651044794e-18,
  5.716983744845346e-20, -8.298602478837168e-22,  2.169946483780574e-04, -1.873772301717284e-05,  9.314142225412623e-07, -3.427699451182417e-08,  1.030565329532386e-09,
 -2.665876812243071e-11,  6.123725625664952e-13, -1.275784140189562e-14,  2.447116355115868e-16, -4.370301801741466e-18,  7.329883897863501e-20, -1.162218575823837e-21,
  7.658342664578049e-05, -7.820391506263123e-06,  4.494733277979152e-07, -1.886138096878044e-08,  6.401102274777610e-10, -1.854351898663837e-11,  4.739527497981577e-13,
 -1.092698006758346e-14,  2.308572440850183e-16, -4.522494759182790e-18,  8.289912780199833e-20, -1.431783686976157e-21,  2.523490718637783e-05, -3.012098839224365e-06,
  1.987472991558501e-07, -9.458549366464208e-09,  3.607177796275739e-10, -1.165701305600046e-11,  3.303553720755102e-13, -8.401553490276963e-15,  1.949272336533575e-16,
 -4.176969815060466e-18,  8.345527395629193e-20, -1.566018564411019e-21,  7.808826911834805e-06, -1.078237726313777e-06,  8.112908912375391e-08, -4.356162399334163e-09,
  1.858854109956096e-10, -6.676218593777949e-12,  2.090877658321465e-13, -5.847839456082735e-15,  1.485749320650171e-16, -3.473181315669532e-18,  7.544590977748747e-20,
 -1.534379255158509e-21,  2.285021365201579e-06, -3.615548395369910e-07,  3.082286461920117e-08, -1.857913426597511e-09,  8.833809077762538e-11, -3.513326687471731e-12,
  1.212007909718515e-13, -3.716774440932087e-15,  1.031216316300308e-16, -2.622959651663550e-18,  6.179286646142682e-20, -1.358796105692274e-21,  6.374588506534434e-07,
 -1.145726679886059e-07,  1.099811527237849e-08, -7.405457107849257e-10,  3.907061831142199e-11, -1.714459793815907e-12,  6.493592664929640e-14, -2.176909977436207e-15,
  6.577316388289687e-17, -1.815567197550024e-18,  4.627171625289779e-20, -1.097516689908673e-21,  1.711629373433729e-07, -3.465573595731713e-08,  3.723105711467529e-09,
 -2.786603678650164e-10,  1.624502006029150e-11, -7.835942185975673e-13,  3.247610566765138e-14, -1.186521918512946e-15,  3.892791057729282e-17, -1.162974790584629e-18,
  3.198242409926283e-20, -8.162279358735965e-22,  4.472647831876409e-08, -1.011996719691075e-08,  1.209385512823913e-09, -1.001120639834198e-10,  6.420783247314053e-12,
 -3.391330342215971e-13,  1.532597200878933e-14, -6.082516896963255e-16,  2.160350956449357e-17, -6.965155992892012e-19,  2.061203512188808e-20, -5.645241389317623e-22,
  1.151939162617950e-08, -2.889724656688895e-09,  3.817864678854103e-10, -3.477193112644965e-11,  2.442286385043103e-12, -1.406688532198531e-13,  6.905564817354119e-15,
 -2.966694935720749e-16,  1.136940001464122e-17, -3.943529140162625e-19,  1.252074209525142e-20, -3.669512824469464e-22,  2.966502114926542e-09, -8.185380555086756e-10,
  1.187999908282824e-10, -1.183917692227116e-11,  9.061973206880344e-13, -5.666323807761911e-14,  3.009203199636195e-15, -1.394012268256707e-16,  5.743458276058080e-18,
 -2.135794965225440e-19,  7.251428442913412e-21, -2.266919861488913e-22,  7.761441683991100e-10, -2.336685903517051e-10,  3.700752154590483e-11, -4.011731831636530e-12,
  3.328491924470191e-13, -2.248371281713817e-14,  1.285812459844709e-15, -6.395340972741450e-17,  2.821248301072709e-18, -1.120412733776949e-19,  4.052701327146695e-21,
 -1.346587147677960e-22,  2.099051057810912e-10, -6.838235282013876e-11,  1.173442217075885e-11, -1.374878931116623e-12,  1.229261258524612e-13, -8.921423678746846e-15,
  5.466080193214715e-16, -2.904873729318103e-17,  1.365755965687169e-18, -5.766962413689175e-20,  2.212996438800768e-21, -7.783576177533339e-23,  5.974326373433726e-11,
 -2.088086370010732e-11,  3.852881104435536e-12, -4.845230247294610e-13,  4.638039233203641e-14, -3.594532662426995e-15,  2.345904946956714e-16, -1.324785541142693e-17,
  6.603697176595089e-19, -2.949998653277204e-20,  1.195174102522853e-21, -4.429175151867712e-23,  1.821158812972403e-11, -6.768348757221918e-12,  1.331904518096096e-12,
 -1.784012971674850e-13,  1.815199025869352e-14, -1.492051921598792e-15,  1.030523275246342e-16, -6.145902810777984e-18,  3.228843218343815e-19, -1.517294681057395e-20,
  6.454710301914878e-22, -2.507089333828049e-23,  6.035440820669980e-12, -2.363282450227173e-12,  4.916025993811583e-13, -6.954810206873715e-14,  7.461879565838071e-15,
 -6.455845522648680e-16,  4.684615015111876e-17, -2.930012599222258e-18,  1.611564826337463e-19, -7.915324033605724e-21,  3.513874324231850e-22, -1.421975739316459e-23,
  2.193056013960948e-12, -8.961751042551619e-13,  1.951960662236587e-13, -2.890085485432893e-14,  3.241133429170689e-15, -2.926794145973384e-16,  2.213370665938178e-17,
 -1.440625032944157e-18,  8.233977867862250e-20, -4.196752204146692e-21,  1.930811837861995e-22, -8.086639040908642e-24,  8.675995938225911e-13, -3.663955862182382e-13,
  8.272006896155722e-14, -1.269192995229585e-14,  1.473648630834007e-15, -1.376228796252053e-16,  1.075116855730497e-17, -7.220379198847105e-19,  4.253464432373455e-20,
 -2.232045089403036e-21,  1.056175067569356e-22, -4.544714871642718e-24,  3.555766758671953e-13, -1.536433104941997e-13,  3.557354040987955e-14, -5.597000307613857e-15,
  6.659924658171657e-16, -6.369207106389244e-17,  5.091241255529711e-18, -3.495866536397917e-19,  2.103899231738913e-20, -1.127049375949326e-21,  5.440210221237334e-23,
 -2.386145668039624e-24,  1.190389454710125e-13, -5.209789192025596e-14,  1.223439341797803e-14, -1.952309282662042e-15,  2.355364871191520e-16, -2.282908410297518e-17,
  1.848622717827378e-18, -1.285307718188554e-19,  7.829144969854253e-21, -4.243109093611019e-22,  2.071236140705465e-23, -9.183272277857632e-25,  8.387536184151673e-02,
 -2.951323708228967e-04,  1.088286280932500e-06, -4.163903708045500e-09,  1.634468817547621e-11, -6.521630869817212e-14,  2.624508377153181e-16, -1.060632020367280e-18,
  4.286377427369759e-21, -1.731055447453569e-23,  6.966053597463243e-26, -2.798164347769660e-28,  7.606502903123497e-02, -3.530671507875888e-04,  1.991100986716777e-06,
 -1.153634284232829e-08,  6.544417785397681e-11, -3.612733106505821e-13,  1.946160053443975e-15, -1.026917488277002e-17,  5.323496950508019e-20, -2.717637762311264e-22,
  1.368538979981593e-24, -6.807997676739324e-27,  6.257012344691652e-02, -4.313635348759193e-04,  3.526892604212083e-06, -2.700003332255390e-08,  1.941103717273351e-10,
 -1.330958356418315e-12,  8.791091464058788e-15, -5.629481573881262e-17,  3.510742838741186e-19, -2.139467986463492e-21,  1.277439160471094e-23, -7.488817549583871e-26,
  4.670300340430950e-02, -4.805276599505978e-04,  5.194749830292581e-06, -4.964977610311386e-08,  4.367853754619368e-10, -3.614557328593186e-12,  2.848798392403330e-14,
 -2.156199938931809e-16,  1.576693907290431e-18, -1.118941717460849e-20,  7.734017954687994e-23, -5.220916375969309e-25,  3.164993565025000e-02, -4.698676139832528e-04,
  6.410724641244039e-06, -7.483684219688903e-08,  7.906247071888086e-10, -7.751880274337316e-12,  7.161815951894245e-14, -6.299511242882217e-16,  5.314846431317605e-18,
 -4.325122797502111e-20,  3.409636805161408e-22, -2.612697468943206e-24,  1.948968902783818e-02, -4.012881094214957e-04,  6.753948462610226e-06, -9.494045148762921e-08,
  1.187642282813969e-09, -1.361332049786258e-11,  1.455953874450600e-13, -1.470776438904804e-15,  1.415661295231158e-17, -1.306840751662012e-19,  1.162862973602026e-21,
 -1.001351512451195e-23,  1.091710445952358e-02, -3.007889086827136e-04,  6.159869176769402e-06, -1.030742775993652e-07,  1.510063436974509e-09, -2.003230674279784e-11,
  2.456942902265619e-13, -2.825207666755173e-15,  3.076221980133960e-17, -3.195340752685163e-19,  3.184436320890475e-21, -3.058408385137361e-23,  5.570276025344961e-03,
 -1.992423595418199e-04,  4.913224537716573e-06, -9.691802582730672e-08,  1.648345913033043e-09, -2.510591996466391e-11,  3.505086492570858e-13, -4.555901858165148e-15,
  5.574553579461141e-17, -6.474165120754764e-19,  7.182108731579772e-21, -7.648089823353014e-23,  2.593346046976011e-03, -1.174276945184103e-04,  3.455036211915509e-06,
 -7.967659223898529e-08,  1.561792637028409e-09, -2.713306166130378e-11,  4.285957638625533e-13, -6.261413478747589e-15,  8.563124024773579e-17, -1.106215247661254e-18,
  1.359274977341099e-20, -1.597226024786525e-22,  1.104040888867731e-03, -6.196963013423083e-05,  2.157076577548756e-06, -5.773411468286581e-08,  1.296245512560393e-09,
 -2.554492262698664e-11,  4.542220728208446e-13, -7.422900037610483e-15,  1.129539553148065e-16, -1.616130948905422e-18,  2.190545293720816e-20, -2.829042851189459e-22,
  4.309122249922457e-04, -2.945775380643354e-05,  1.203411709706908e-06, -3.714240661892271e-08,  9.500210527609805e-10, -2.113514850095795e-11,  4.211901323449815e-13,
 -7.668170375620464e-15,  1.293351052496851e-16, -2.042060717067383e-18,  3.042478613267984e-20, -4.303992909259021e-22,  1.546895152535742e-04, -1.268726875017776e-05,
  6.037192052384786e-07, -2.136203409082676e-08,  6.194473024937663e-10, -1.549095562979133e-11,  3.446520471810550e-13, -6.965433627874620e-15,  1.297805615493224e-16,
 -2.253994977235767e-18,  3.680175302072701e-20, -5.685779418073054e-22,  5.127310383165016e-05, -4.980473532421644e-06,  2.740987203891791e-07, -1.105927608989636e-08,
  3.619564659398231e-10, -1.013561617895928e-11,  2.508812469858655e-13, -5.610410005231600e-15,  1.151298406790176e-16, -2.193242527670810e-18,  3.913618860117379e-20,
 -6.586278522154262e-22,  1.576587000711791e-05, -1.793286612270592e-06,  1.133839197305086e-07, -5.190282262158123e-09,  1.909355537482721e-10, -5.965408289508518e-12,
  1.637479308991889e-13, -4.039983684461273e-15,  9.105617521566746e-17, -1.897731215053183e-18,  3.691699359754942e-20, -6.751361250965619e-22,  4.522809683462376e-06,
 -5.963581524378438e-07,  4.304531572299740e-08, -2.224844398072645e-09,  9.163200809815630e-11, -3.183311488278750e-12,  9.660730997366889e-14, -2.622299201714046e-15,
  6.474764333556971e-17, -1.472705326408788e-18,  3.116003617030203e-20, -6.178672638117027e-22,  1.218755216192640e-06, -1.845890988970485e-07,  1.511884628068824e-08,
 -8.782357111911499e-10,  4.034090838734966e-11, -1.553162396032792e-12,  5.195873921961387e-14, -1.547485749575333e-15,  4.175331230459946e-17, -1.034007904458950e-18,
  2.374219271763267e-20, -5.093446882515698e-22,  3.110093639163709e-07, -5.365043306445215e-08,  4.957300875115306e-09, -3.221625229257798e-10,  1.644165462346682e-11,
 -6.992333000823199e-13,  2.570943641017925e-14, -8.378855913053131e-16,  2.464239256808689e-17, -6.628756474348116e-19,  1.648045971981625e-20, -3.816950546729669e-22,
  7.588796515916354e-08, -1.479115179755617e-08,  1.533013509125772e-09, -1.109502496141844e-10,  6.267008517333074e-12, -2.934113985521638e-13,  1.182114814649665e-14,
 -4.204064232214910e-16,  1.344244514522013e-17, -3.918190188251202e-19,  1.052340198513588e-20, -2.625371749432391e-22,  1.790848395965584e-08, -3.913372882575120e-09,
  4.523559491634540e-10, -3.628996304448163e-11,  2.259658791230005e-12, -1.160550396805142e-13,  5.107043478255382e-15, -1.976138395058903e-16,  6.850818382750844e-18,
 -2.158141239138527e-19,  6.246107298756716e-21, -1.674546339503446e-22,  4.141942428643469e-09, -1.007008778214370e-09,  1.290657481487623e-10, -1.142152321335957e-11,
  7.806597882726097e-13, -4.381663224839930e-14,  2.098763468852109e-15, -8.807572985731323e-17,  3.300587919645022e-18, -1.120526827429616e-19,  3.485224169166503e-21,
 -1.001462799850143e-22,  9.533751386831664e-10, -2.559032388515261e-10,  3.614621129452834e-11, -3.510170546795154e-12,  2.621510909366054e-13, -1.601317758164774e-14,
  8.316814357987101e-16, -3.771752544170680e-17,  1.522743706733845e-18, -5.553457804090136e-20,  1.850648419413521e-21, -5.682840733523130e-23,  2.222178566996346e-10,
 -6.533321156058369e-11,  1.010490851896679e-11, -1.070794263239776e-12,  8.693916371593766e-14, -5.752724160456139e-15,  3.225781090956818e-16, -1.574550272466700e-17,
  6.822212047177131e-19, -2.663071833746175e-20,  9.474957305892085e-22, -3.098792454932226e-23,  5.346746800275870e-11, -1.707711142868183e-11,  2.872185150306960e-12,
 -3.300697026954748e-13,  2.896968867874492e-14, -2.065646765921677e-15,  1.244415306321045e-16, -6.507400852722735e-18,  3.012635033033251e-19, -1.253417817026579e-20,
  4.742078388280197e-22, -1.645373711845009e-23,  1.355495197217714e-11, -4.662828422107907e-12,  8.463876770355061e-13, -1.047599635463622e-13,  9.876297008224985e-15,
 -7.543418377321265e-16,  4.854888434670536e-17, -2.705328373466246e-18,  1.331417508123207e-19, -5.875352286810339e-21,  2.352591840550295e-22, -8.620984528565451e-24,
  3.696399908628018e-12, -1.357132045293254e-12,  2.636790476591878e-13, -3.488199445944334e-14,  3.506980083532457e-15, -2.849802462189025e-16,  1.946803818440587e-17,
 -1.148911048804459e-18,  5.975529286109735e-20, -2.781057186152653e-21,  1.172192808876535e-22, -4.512790158782440e-24,  1.104715275017122e-12, -4.287966965572675e-13,
  8.837076745733593e-14, -1.238849268433562e-14,  1.317527860369415e-15, -1.130304236418103e-16,  8.135766301837302e-18, -5.049205414716129e-19,  2.756578975030191e-20,
 -1.344292070964581e-21,  5.927065863705321e-23, -2.382872642372460e-24,  3.664082704316780e-13, -1.488674841911509e-13,  3.222383873317158e-14, -4.741947906656666e-15,
  5.286516822874490e-16, -4.746674179933536e-17,  3.570055537958484e-18, -2.311489910506145e-19,  1.314509981985029e-20, -6.667598153713167e-22,  3.053391173372863e-23,
 -1.273157809145611e-24,  1.344893509169549e-13, -5.660603257811246e-14,  1.273316849493418e-14, -1.946627514407503e-15,  2.252295842070650e-16, -2.096298431479329e-17,
  1.632319849988380e-18, -1.092828429481250e-19,  6.418456879264696e-21, -3.358442503086281e-22,  1.584772808213788e-23, -6.801171880478554e-25,  5.218079296862906e-14,
 -2.251106382806811e-14,  5.202874934218198e-15, -8.171639950078698e-16,  9.706893168644788e-17, -9.267812616870555e-18,  7.396418656161613e-19, -5.070881319656402e-20,
  3.047253244956562e-21, -1.630065015260819e-22,  7.857392735017691e-24, -3.441784066324152e-25,  1.692641405168183e-14, -7.403478447083490e-15,  1.737429149305773e-15,
 -2.770642271200067e-16,  3.340425087422581e-17, -3.235565767403337e-18,  2.618396255121990e-19, -1.819394319271090e-20,  1.107576971948282e-21, -5.999163729218153e-23,
  2.926779018139677e-24, -1.296937113313947e-25,  8.271193463044610e-02, -2.866215991525671e-04,  1.039846565395797e-06, -3.912490896289614e-09,  1.510102241762622e-11,
 -5.925891858181324e-14,  2.345834526487607e-16, -9.329242125700401e-19,  3.710523790469228e-21, -1.475537137989709e-23,  5.845148389722546e-26, -2.313331733530129e-28,
  7.468376570858254e-02, -3.376748196531619e-04,  1.858717034847715e-06, -1.054459634512428e-08,  5.866345738957094e-11, -3.178320907040570e-13,  1.681073702256761e-15,
 -8.712185476019578e-18,  4.436872395888496e-20, -2.225688475842885e-22,  1.101547573299211e-24, -5.386782466909217e-27,  6.089911954837107e-02, -4.043935487701911e-04,
  3.220684089801143e-06, -2.409627109385029e-08,  1.694796611313226e-10, -1.137685529297826e-12,  7.361206591149402e-15, -4.620025188570146e-17,  2.825092368601768e-19,
 -1.688722157276967e-21,  9.893537894939638e-24, -5.692565302165730e-26,  4.486039615289429e-02, -4.412393075064311e-04,  4.638613266726465e-06, -4.320434563179204e-08,
  3.708702789964460e-10, -2.997944626576310e-12,  2.310043602657762e-14, -1.710560053121753e-16,  1.224438463041711e-18, -8.510384075318801e-21,  5.763461850386731e-23,
 -3.813510063184078e-25,  2.986763798329479e-02, -4.219701398983852e-04,  5.583753188529011e-06, -6.333942656106889e-08,  6.514402751623172e-10, -6.226839417298441e-12,
  5.614404450583531e-14, -4.823658920128617e-16,  3.977918544447573e-18, -3.166063297660244e-20,  2.442371784048649e-22, -1.832213843889828e-24,  1.798581453805443e-02,
 -3.515101494126586e-04,  5.720270751056099e-06, -7.793958335725152e-08,  9.472302605962959e-10, -1.056606798998483e-11,  1.101078867140038e-13, -1.084857449399718e-15,
  1.019296520891596e-17, -9.191482036898353e-20,  7.994282931835628e-22, -6.732279101532495e-24,  9.805215274526274e-03, -2.560752767731743e-04,  5.055691473482708e-06,
 -8.182306902310254e-08,  1.162509144210048e-09, -1.498348842750944e-11,  1.788017590358718e-13, -2.002694593564501e-15,  2.126078412280299e-17, -2.154890977917279e-19,
  2.096964150840158e-21, -1.967769689596205e-23,  4.845138556936564e-03, -1.641756713835864e-04,  3.893249733942676e-06, -7.414437829087182e-08,  1.220973917866641e-09,
 -1.804262443621703e-11,  2.447737809939107e-13, -3.095484350759323e-15,  3.688985842445868e-17, -4.176492079107914e-19,  4.520111729489596e-21, -4.699165870959181e-23,
  2.173410019270982e-03, -9.322495968917791e-05,  2.632601345758558e-06, -5.852478580291844e-08,  1.109250272384819e-09, -1.867431539858659e-11,  2.863275647677686e-13,
 -4.065817470000638e-15,  5.410806905375409e-17, -6.808431450710385e-19,  8.155712800675148e-21, -9.349708969341094e-23,  8.867388197099624e-04, -4.716697956606155e-05,
  1.573588969521786e-06, -4.055301974732493e-08,  8.794282016891897e-10, -1.677751125528543e-11,  2.893156732931842e-13, -4.591834604398745e-15,  6.794393117911404e-17,
 -9.462721415185196e-19,  1.249623329232642e-20, -1.573654632439512e-22,  3.298395179043514e-04, -2.138377806721598e-05,  8.365538060441672e-07, -2.483984274329072e-08,
  6.131689408691593e-10, -1.319577865744793e-11,  2.548537748585260e-13, -4.503443107452423e-15,  7.381833458617344e-17, -1.133940679760502e-18,  1.645294519985959e-20,
 -2.268611449108162e-22,  1.121865707846858e-04, -8.735327417690076e-06,  3.979107455132115e-07, -1.353874108762603e-08,  3.786876891872274e-10, -9.156318159738987e-12,
  1.973363422027535e-13, -3.869319743159387e-15,  7.003763410047522e-17, -1.183065795581924e-18,  1.880607495650357e-20, -2.831327595595639e-22,  3.501735058599794e-05,
 -3.233595234057020e-06,  1.703756917255437e-07, -6.609281690734283e-09,  2.086084410239960e-10, -5.646664255617898e-12,  1.353627970865886e-13, -2.936313319315378e-15,
  5.852757302042034e-17, -1.084268478752886e-18,  1.883475542987655e-20, -3.088618789704022e-22,  1.007530976349040e-05, -1.091263898660484e-06,  6.609243756796012e-08,
 -2.909507019816913e-09,  1.032309426108888e-10, -3.117845830048566e-12,  8.288927949687496e-14, -1.983805273472442e-15,  4.343296140339054e-17, -8.803510811068210e-19,
  1.667329307842742e-20, -2.971543507726244e-22,  2.686719238751657e-06, -3.379932078843495e-07,  2.339165159461410e-08, -1.163390530750467e-09,  4.623383106372854e-11,
 -1.553245520135483e-12,  4.566868554748384e-14, -1.202872061665052e-15,  2.885901800824531e-17, -6.385806930045724e-19,  1.315850048065366e-20, -2.543546190938920e-22,
  6.684096850702910e-07, -9.680499116777205e-08,  7.612571144290070e-09, -4.259325255499503e-10,  1.889317314439520e-11, -7.039145136155393e-13,  2.282847462779468e-14,
 -6.601228086723045e-16,  1.731613207570349e-17, -4.174096172285934e-19,  9.339034030711279e-21, -1.954175321137067e-22,  1.563852517989738e-07, -2.586267240732635e-08,
  2.298379264999483e-09, -1.440652172882928e-10,  7.108154445629503e-12, -2.928313061568698e-13,  1.044734839011929e-14, -3.308688047295843e-16,  9.468396655273263e-18,
 -2.481149689577085e-19,  6.015520375631231e-21, -1.359961766636273e-22,  3.474345504484319e-08, -6.510687692465378e-09,  6.503798109799002e-10, -4.547919099130097e-11,
  2.487297901922730e-12, -1.129583776013309e-13,  4.421434513537108e-15, -1.529823282838808e-16,  4.764955922097543e-18, -1.354443943525103e-19,  3.551140410781380e-21,
 -8.656683824616660e-23,  7.414731974238652e-09, -1.562757440706379e-09,  1.745408697761072e-10, -1.355770129069723e-11,  8.189185239928258e-13, -4.086751082372523e-14,
  1.749986801811997e-15, -6.597802611403297e-17,  2.231257855559467e-18, -6.863939075389975e-20,  1.941824122727431e-21, -5.093322159345941e-23,  1.541083355069773e-09,
 -3.626287120440835e-10,  4.503499762874515e-11, -3.868339452665112e-12,  2.570592605985082e-13, -1.404822373642122e-14,  6.560421611504834e-16, -2.687377632633916e-17,
  9.840975394103040e-19, -3.267928960155825e-20,  9.951268548735841e-22, -2.801910686238652e-23,  3.170041425958862e-10, -8.266012321444416e-11,  1.134929365730405e-11,
 -1.072814709562138e-12,  7.809840989330464e-14, -4.656082948465436e-15,  2.362994758010414e-16, -1.048278434555714e-17,  4.143942030564867e-19, -1.481136089372639e-20,
  4.841290943197077e-22, -1.459333697630210e-23,  6.575062755175004e-11, -1.885259870468346e-11,  2.844160101356335e-12, -2.942940327219758e-13,  2.335848529133794e-14,
 -1.512627884068538e-15,  8.309291272165763e-17, -3.977070778487891e-18,  1.691163496757417e-19, -6.484025574255251e-21,  2.267584431777921e-22, -7.294829190376933e-24,
  1.404336047777276e-11, -4.391966036742450e-12,  7.231603165928671e-13, -8.142419446343155e-14,  7.008392722710245e-15, -4.905125562086993e-16,  2.903015186115924e-17,
 -1.492544091285191e-18,  6.798666290550312e-20, -2.785034643973514e-21,  1.038104190167353e-22, -3.550970696522623e-24,  3.160657158121773e-12, -1.068912510167682e-12,
  1.906718406725152e-13, -2.320495600567651e-14,  2.152568403376520e-15, -1.618902190030635e-16,  1.026645996286905e-17, -5.640701824083893e-19,  2.738826167812311e-20,
 -1.193081138372554e-21,  4.718478081317308e-23, -1.708680767023461e-24,  7.677376209992554e-13, -2.782055895235175e-13,  5.331999786715567e-14, -6.960573695845065e-15,
  6.909280845272390e-16, -5.546339990735248e-17,  3.744868986173253e-18, -2.185463147390280e-19,  1.124564072479876e-20, -5.180417895636648e-22,  2.162151080108092e-23,
 -8.246081223920301e-25,  2.058846500143884e-13, -7.916132143810345e-14,  1.615171862309958e-14, -2.242180854000369e-15,  2.362160178467651e-16, -2.008213484066593e-17,
  1.432993224035732e-18, -8.819825802923347e-20,  4.776957079372831e-21, -2.311869168361567e-22,  1.011894372429808e-23, -4.039791831858510e-25,  6.200586469005895e-14,
 -2.503495437818948e-14,  5.382741595025296e-15, -7.868838431805054e-16,  8.716617789537010e-17, -7.778586581730855e-18,  5.816051206088681e-19, -3.744496088136594e-20,
  2.117947734587892e-21, -1.068729579592971e-22,  4.869902013246641e-24, -2.020934622918079e-25,  2.101216698732474e-14, -8.811787637223670e-15,  1.974321155089387e-15,
 -3.006521394602913e-16,  3.465448089059571e-17, -3.213662940257737e-18,  2.493605930277545e-19, -1.663837261625764e-20,  9.740575924461324e-22, -5.080932609893995e-23,
  2.390439865715726e-24, -1.022950022332397e-25,  7.687490473084033e-15, -3.310680157087333e-15,  7.637238201782079e-16, -1.197233512687499e-16,  1.419542676732731e-17,
 -1.352915225175014e-18,  1.077873098757724e-19, -7.377510726080229e-21,  4.426310669557428e-22, -2.364127589483622e-23,  1.137893773378173e-24, -4.977249861556706e-26,
  2.410389480445387e-15, -1.053612766893771e-15,  2.470829950208179e-16, -3.937360064199288e-17,  4.743735217987463e-18, -4.591664289372313e-19,  3.713336356012920e-20,
 -2.578533297374104e-21,  1.568717356163366e-22, -8.491688770344926e-24,  4.140314370009733e-25, -1.833623966059490e-26,  8.158179411206264e-02, -2.784866068436249e-04,
  9.943082290871212e-07, -3.680058713936310e-09,  1.397009551917848e-11, -5.392943616839766e-14,  2.100471388063477e-16, -8.222544664949668e-19,  3.219074716813932e-21,
 -1.260867089442278e-23,  4.917106726700121e-26, -1.918281747101265e-28,  7.336202642048928e-02, -3.232957368016277e-04,  1.737610682417139e-06, -9.654722186767774e-09,
  5.269131284459819e-11, -2.802602894442605e-13,  1.455863202951484e-15, -7.412524513974661e-18,  3.709542597419260e-20, -1.829012468174886e-22,  8.898926195712279e-25,
 -4.278979770256004e-27,  5.933130785837443e-02, -3.797402676257050e-04,  2.947077946395445e-06, -2.155744932803412e-08,  1.483929086836142e-10, -9.755718617736935e-13,
  6.185541758574967e-15, -3.806092207236619e-17,  2.282740563727143e-19, -1.338837189290079e-21,  7.698449856813057e-24, -4.348733279213159e-26,  4.316650984821527e-02,
 -4.061077021894003e-04,  4.153879333356243e-06, -3.772152161106324e-08,  3.160892725294674e-10, -2.496849367812775e-12,  1.881634999909145e-14, -1.363618618881673e-16,
  9.558152383809604e-19, -6.508405785652852e-21,  4.319932370206503e-23, -2.802497929380230e-25,  2.826452192534806e-02, -3.801722260462177e-04,  4.882333822157234e-06,
 -5.384381082223350e-08,  5.393541554182819e-10, -5.028062588740640e-12,  4.426114188732007e-14, -3.715705587410234e-16,  2.996158717868077e-18, -2.333063252985865e-20,
  1.761721817174726e-22, -1.294243195286074e-24,  1.666571854171135e-02, -3.092466130750235e-04,  4.869394642327585e-06, -6.434059120887965e-08,  7.600526084620616e-10,
 -8.253983388997173e-12,  8.384174337381433e-14, -8.059899029816492e-16,  7.394755279297004e-18, -6.515895622439889e-20,  5.541064311384936e-22, -4.564901051500926e-24,
  8.856004853455534e-03, -2.192623992453439e-04,  4.176232725364899e-06, -6.540489231206052e-08,  9.015785708949001e-10, -1.129490115889038e-11,  1.311912165935817e-13,
 -1.431836326353779e-15,  1.482532151324085e-17, -1.466687586757298e-19,  1.394079397496249e-21, -1.278552441964780e-23,  4.245528035715524e-03, -1.362819869706706e-04,
  3.109781375410052e-06, -5.720366602623473e-08,  9.124812631838863e-10, -1.308748106635271e-11,  1.725937381683349e-13, -2.124357841349647e-15,  2.466553030236757e-17,
 -2.723076553674950e-19,  2.876028420322219e-21, -2.919814358128913e-23,  1.838575284391202e-03, -7.469776057434243e-05,  2.025578464268585e-06, -4.342675670941313e-08,
  7.961839724232786e-10, -1.299349456252409e-11,  1.934465981492139e-13, -2.670815423083298e-15,  3.459726019469256e-17, -4.241564221516502e-19,  4.954533247753373e-21,
 -5.542735328817345e-23,  7.204732165483741e-04, -3.630885940171085e-05,  1.161417133542433e-06, -2.882896851175922e-08,  6.040471824852480e-10, -1.115944199520045e-11,
  1.866785309530563e-13, -2.878302554739392e-15,  4.142371021588014e-17, -5.617062639707223e-19,  7.228661543234983e-21, -8.878165053059603e-23,  2.560129326840358e-04,
 -1.573497147914322e-05,  5.896006458759777e-07, -1.684664742343887e-08,  4.014390255762212e-10, -8.359136795313358e-12,  1.564948563970401e-13, -2.684649362260906e-15,
  4.277500912626562e-17, -6.393997469333836e-19,  9.036434573277486e-21, -1.214667717296884e-22,  8.271185866158183e-05, -6.111309725871130e-06,  2.664995636527639e-07,
 -8.720159350594356e-09,  2.353054266262743e-10, -5.501789858356047e-12,  1.148786481632692e-13, -2.185696572337778e-15,  3.843980331693974e-17, -6.316081825758373e-19,
  9.776008094855095e-21, -1.434400436968233e-22,  2.437675710319777e-05, -2.138654641057511e-06,  1.078675682315880e-07, -4.023061580397001e-09,  1.224603921428044e-10,
 -3.204381638862595e-12,  7.439887848656211e-14, -1.565568265690822e-15,  3.031235225499104e-17, -5.461301629862532e-19,  9.235719084980085e-21, -1.475825047124984e-22,
  6.580785704404642e-06, -6.782222704019215e-07,  3.933533316736476e-08, -1.664974295827240e-09,  5.697051697909486e-11, -1.663253235966504e-12,  4.282427038267116e-14,
 -9.941941445275257e-16,  2.114304477786556e-17, -4.167741368978827e-19,  7.684668663234779e-21, -1.334643312863763e-22,  1.635662378825452e-06, -1.961512407937232e-07,
  1.300987686054445e-08, -6.224306803600536e-10,  2.386213912310902e-11, -7.750953936922935e-13,  2.207549724949425e-14, -5.641271760585720e-16,  1.314925532322345e-17,
 -2.830233426573620e-19,  5.678943937275514e-21, -1.069999419277231e-22,  3.766747066509800e-07, -5.211396066114418e-08,  3.932167491973412e-09, -2.118130495768586e-10,
  9.069443954392619e-12, -3.268877948962351e-13,  1.027416412935063e-14, -2.883772034405857e-16,  7.352645357377510e-18, -1.724781657751393e-19,  3.759417586654320e-21,
 -7.671138702004440e-23,  8.099739685395608e-08, -1.282740378211266e-08,  1.095515045994138e-09, -6.618973464794366e-11,  3.155632903616581e-12, -1.258725559101478e-13,
  4.355698818221881e-15, -1.339985135105002e-16,  3.729828894375805e-18, -9.518029692289537e-20,  2.249630431102455e-21, -4.962915179366464e-23,  1.641877975632191e-08,
 -2.954489821682296e-09,  2.841916376555028e-10, -1.918597490964839e-11,  1.015293303927774e-12, -4.469899091058625e-14,  1.698907352418719e-15, -5.716091953875946e-17,
  1.733494918007282e-18, -4.803169193442069e-20,  1.228819945696480e-21, -2.925807557963830e-23,  3.174009719498532e-09, -6.443634411289612e-10,  6.946261315762312e-11,
 -5.219503435059284e-12,  3.055872941768489e-13, -1.480732196856910e-14,  6.165916718101265e-16, -2.263669679399348e-17,  7.463449566437137e-19, -2.240856280078801e-20,
  6.193460863808886e-22, -1.588597357768974e-23,  5.934064908208767e-10, -1.349556082625209e-10,  1.622126811495644e-11, -1.351076928796850e-12,  8.720976616465215e-14,
 -4.636656266719600e-15,  2.109451559636315e-16, -8.428723868714894e-18,  3.014085733328630e-19, -9.784066653668215e-21,  2.915157988268072e-22, -8.038238437716272e-24,
  1.091037475275817e-10, -2.759788813799631e-11,  3.678774649598648e-12, -3.381239693281328e-13,  2.396943598139620e-14, -1.393459301926027e-15,  6.904508337457849e-17,
 -2.993864163710084e-18,  1.157978621226421e-19, -4.053423758881382e-21,  1.298688057785458e-22, -3.840382412604188e-24,  2.012017105184042e-11, -5.618448989263803e-12,
  8.257431306614155e-13, -8.333696230295061e-14,  6.459615531562684e-15, -4.089863948117696e-16,  2.198998382298608e-17, -1.031192447643343e-18,  4.300058244018087e-20,
 -1.618125024471994e-21,  5.558385669581745e-23, -1.757700846542417e-24,  3.807247366055963e-12, -1.164378716892545e-12,  1.874666658822537e-13, -2.065793570936669e-14,
  1.741938443559054e-15, -1.195553064502102e-16,  6.944955758023929e-18, -3.507663425462026e-19,  1.570824445203247e-20, -6.330909221465711e-22,  2.323295734964615e-23,
 -7.829368726387746e-25,  7.583182390796527e-13, -2.518376443862604e-13,  4.409671021668379e-14, -5.271301345124352e-15,  4.806742988575405e-16, -3.556399420893074e-17,
  2.220394193762336e-18, -1.201893743871302e-19,  5.753149236016859e-21, -2.472211777994036e-22,  9.650314337736321e-24, -3.451187186606881e-25,  1.633802613054880e-13,
 -5.837593422150180e-14,  1.102578801583986e-14, -1.419051553432522e-15,  1.389536925703142e-16, -1.100997796606450e-17,  7.341928827075700e-19, -4.233982779138191e-20,
  2.154005912227629e-21, -9.815137073283090e-23,  4.054019064197801e-24, -1.530778624276359e-25,  3.911479059646037e-14, -1.488623045018764e-14,  3.004717133513406e-15,
 -4.127410693416618e-16,  4.304387694437644e-17, -3.624027767537173e-18,  2.562049163204915e-19, -1.562931454024154e-20,  8.393327300064406e-22, -4.029084621135302e-23,
  1.749796046821519e-24, -6.933755222043464e-26,  1.063809681518353e-14, -4.266037829964872e-15,  9.105847865205154e-16, -1.321671913841506e-16,  1.454004198516240e-17,
 -1.288970504736068e-18,  9.576689841056182e-20, -6.128330402518312e-21,  3.446174861514722e-22, -1.729296508867836e-23,  7.837946611391923e-25, -3.236055783167660e-26,
  3.310871726992265e-15, -1.382977394758954e-15,  3.085334276645427e-16, -4.678498549976828e-17,  5.370543422041277e-18, -4.960704356188734e-19,  3.834632911855905e-20,
 -2.549336100104111e-21,  1.487256991724462e-22, -7.732002152933221e-24,  3.626040013362433e-25, -1.546946110469889e-26,  1.137343269341368e-15, -4.888859632931027e-16,
  1.125458923223246e-16, -1.760684855905595e-17,  2.083460659620529e-18, -1.981851585176336e-19,  1.576023038186040e-20, -1.076786303375590e-21,  6.449347344092166e-23,
 -3.438961463735925e-24,  1.652600005862090e-25, -7.217600508597602e-27,  3.437932578612494e-16, -1.501743066610324e-16,  3.519069193116593e-17, -5.603495677997067e-18,
  6.746042394190661e-19, -6.525013188481528e-20,  5.273109599365683e-21, -3.659107942697972e-22,  2.224619606899807e-23, -1.203433512072198e-24,  5.863898564301927e-26,
 -2.595357074842569e-27,  8.048348219052859e-02, -2.707050641944700e-04,  9.514539266051601e-07, -3.464899617631005e-09,  1.294011166241548e-11, -4.915334840434582e-14,
  1.884005348367747e-16, -7.261429725709849e-19,  2.798623254637946e-21, -1.080066424038126e-23,  4.146416891740167e-26, -1.595541074473470e-28,  7.209593117225892e-02,
 -3.098443599725362e-04,  1.626633372813686e-06, -8.854672611476686e-09,  4.741937090657628e-11, -2.476818909705952e-13,  1.263988334090616e-15, -6.324303792721394e-18,
  3.110882158109482e-20, -1.508004451686031e-22,  7.214561057882144e-25, -3.411937015379261e-27,  5.785791676058417e-02, -3.571594709569614e-04,  2.702015568497156e-06,
 -1.933153638010154e-08,  1.302837637501309e-10, -8.391243896836865e-13,  5.215259938816072e-15, -3.147143843573853e-17,  1.851870306841704e-19, -1.065984811458602e-21,
  6.017673045774396e-24, -3.338165359260122e-26,  4.160579084098290e-02, -3.746049662784227e-04,  3.729993800686257e-06, -3.304029127252626e-08,  2.703759256225716e-10,
 -2.087823468381599e-12,  1.539344464457290e-14, -1.092138115271939e-16,  7.498590783641966e-19, -5.003822136141099e-21,  3.256122401860087e-23, -2.071667089825601e-25,
  2.681805572029870e-02, -3.435586385362846e-04,  4.284845312127640e-06, -4.596426973672893e-08,  4.486257232303506e-10, -4.080538846665913e-12,  3.508226783958042e-14,
 -2.878758895580927e-16,  2.270485298912494e-18, -1.730284176287389e-20,  1.279323287818268e-22, -9.206641975798345e-25,  1.550202868850419e-02, -2.731849419849350e-04,
  4.165159251701707e-06, -5.339827546271653e-08,  6.133964968288441e-10, -6.487878417624363e-12,  6.426260169160808e-14, -6.029756108982738e-16,  5.403920273478666e-18,
 -4.654423034053948e-20,  3.871193704552972e-22, -3.120812714133371e-24,  8.041129101432181e-03, -1.887628636631366e-04,  3.470990025074859e-06, -5.262847153039246e-08,
  7.041767057789331e-10, -8.578320193159282e-12,  9.701857050270150e-14, -1.032156307244851e-15,  1.042676941232610e-17, -1.007187393595973e-19,  9.353561299380575e-22,
 -8.386526928458813e-24,  3.746135003521743e-03, -1.139198420591170e-04,  2.502975248511192e-06, -4.449162847192120e-08,  6.877613097678994e-10, -9.578147303307618e-12,
  1.228329942643673e-13, -1.471997423402835e-15,  1.665695874925918e-17, -1.793755927615570e-19,  1.849349118563120e-21, -1.833966148300197e-23,  1.569174680430658e-03,
 -6.037928405514837e-05,  1.573068033174065e-06, -3.253786146290865e-08,  5.772751618608331e-10, -9.135917597146659e-12,  1.321151612662103e-13, -1.774077844067206e-15,
  2.237612219897104e-17, -2.673569191966302e-19,  3.046112597284145e-21, -3.326304785593876e-23,  5.918408805462701e-04, -2.825251867002082e-05,  8.668124708537208e-07,
 -2.073122318297522e-08,  4.198347388457787e-10, -7.513342307176359e-12,  1.219615210991175e-13, -1.827321168663866e-15,  2.558528007997371e-17, -3.378725693907273e-19,
  4.238265928366962e-21, -5.077891824567574e-23,  2.013652405975047e-04, -1.172911049894600e-05,  4.210593444035182e-07, -1.158004049801617e-08,  2.664437098135612e-10,
 -5.369639328870508e-12,  9.747016734476472e-14, -1.623650010637883e-15,  2.515191958664308e-17, -3.659291443612737e-19,  5.038190218528729e-21, -6.603206153773296e-23,
  6.194832346948459e-05, -4.341361266245338e-06,  1.812496661631075e-07, -5.704309040678478e-09,  1.485214787811678e-10, -3.358686693593907e-12,  6.795601116373897e-14,
 -1.254792501173679e-15,  2.144489525771029e-17, -3.428005607153228e-19,  5.166985212558403e-21, -7.389510687576974e-23,  1.728358259102967e-05, -1.439818901122894e-06,
  6.950995792519059e-08, -2.492522343995551e-09,  7.317553254412448e-11, -1.851130193883986e-12,  4.163035558421691e-14, -8.498730528061954e-16,  1.598546044051390e-17,
 -2.801130011000340e-19,  4.611982406076274e-21, -7.181855743020446e-23,  4.389673146579738e-06, -4.301696903249586e-07,  2.388505467932615e-08, -9.719717079802355e-10,
  3.207163467430990e-11, -9.050628829763809e-13,  2.256788043060923e-14, -5.082157054874353e-16,  1.049824648892311e-17, -2.012532278294774e-19,  3.612610427523918e-21,
 -6.114116514863506e-23,  1.019727257829154e-06, -1.164730830394661e-07,  7.400308026258740e-09, -3.404871291888454e-10,  1.258974473422921e-11, -3.953310532914608e-13,
  1.090528264730183e-14, -2.703456428211627e-16,  6.121526711992649e-18, -1.281516182917010e-19,  2.503695787960231e-21, -4.597668832908273e-23,  2.179584083286547e-07,
 -2.877849954152446e-08,  2.082237858071061e-09, -1.079379473390152e-10,  4.459819988284484e-12, -1.554582397394817e-13,  4.734162090935998e-15, -1.289511437590333e-16,
  3.195012444692665e-18, -7.292140393857881e-20,  1.548120768728054e-21, -3.079926301661805e-23,  4.318490619517149e-08, -6.541955423352573e-09,  5.365225238924425e-10,
 -3.122759781200568e-11,  1.437870636175819e-12, -5.550907607910922e-14,  1.862362361602370e-15, -5.563496573571310e-17,  1.505790058878284e-18, -3.740858611865598e-20,
  8.616925681643109e-22, -1.854503247725186e-23,  8.005357407481299e-09, -1.381578796396144e-09,  1.278487934936916e-10, -8.326709032744903e-12,  4.260862568712030e-13,
 -1.817503112016785e-14,  6.704298468773326e-16, -2.192454449455527e-17,  6.470969351755605e-19, -1.747020657584123e-20,  4.359540445998039e-22, -1.013462050025188e-23,
  1.404423986007853e-09, -2.742637025715215e-10,  2.850676912011462e-11, -2.070291250429848e-12,  1.173959789611333e-13, -5.519464237006219e-15,  2.233610150771882e-16,
 -7.980290033549831e-18,  2.563790875109173e-19, -7.509002855001004e-21,  2.026609861718261e-22, -5.080827586644040e-24,  2.364849252531279e-10, -5.190781605394702e-11,
  6.031551352537282e-12, -4.866413987268187e-13,  3.048471698035922e-14, -1.575510312221168e-15,  6.977760481022798e-17, -2.717703871659692e-18,  9.484127185035242e-20,
 -3.007622254140751e-21,  8.762922101323210e-23, -2.364983827356375e-24,  3.888171975892710e-11, -9.527045553830037e-12,  1.231410644153635e-12, -1.099301991743227e-13,
  7.581128340773803e-15, -4.293733334985234e-16,  2.075420164577194e-17, -8.789236140474795e-19,  3.323776443082599e-20, -1.138654020359349e-21,  3.573590765601861e-23,
 -1.036042464318612e-24,  6.371963812924707e-12, -1.730403491509017e-12,  2.474398540927626e-13, -2.432932471382643e-14,  1.839713924023578e-15, -1.137752553257856e-16,
  5.982158442445143e-18, -2.746141963696993e-19,  1.122086144640941e-20, -4.141117645048177e-22,  1.396251343681603e-23, -4.337214576686620e-25,  1.066444873076338e-12,
 -3.185088633528628e-13,  5.007973123779251e-14, -5.394747688407380e-15,  4.451832175405223e-16, -2.993317209018445e-17,  1.705126037634412e-18, -8.452819940873876e-20,
  3.718537608643915e-21, -1.473360108210368e-22,  5.319357877907369e-24, -1.764806083210312e-25,  1.874327041393855e-13, -6.104900867486627e-14,  1.048084998058139e-14,
 -1.229286722421028e-15,  1.100787631150290e-16, -8.004766000848839e-18,  4.915897319737722e-19, -2.619391117865563e-20,  1.235112645655986e-21, -5.231640904474882e-23,
  2.014239063137241e-24, -7.109107547049219e-26,  3.567025186988784e-14, -1.255338705200124e-14,  2.334215562102591e-15, -2.958983750085384e-16,  2.855646534842021e-17,
 -2.231483367472317e-18,  1.468463445559648e-19, -8.361925631573122e-21,  4.202924174511174e-22, -1.893114429255631e-23,  7.733152699455925e-25, -2.889246981735642e-26,
  7.584746517717100e-15, -2.854808428659096e-15,  5.695693037227897e-16, -7.735675737437216e-17,  7.979981581279745e-18, -6.648984986805168e-19,  4.653976693190843e-20,
 -2.812164086198840e-21,  1.496511467168029e-22, -7.121452692997913e-24,  3.067096466656630e-25, -1.205720372278204e-26,  1.852260804315388e-15, -7.373165335964695e-16,
  1.561442220493985e-16, -2.248915054417080e-17,  2.455728545345783e-18, -2.161503941780866e-19,  1.594995804174394e-20, -1.014018109533483e-21,  5.666603666298017e-23,
 -2.826528659622287e-24,  1.273781504984564e-25, -5.230313112336329e-27,  5.265047272732837e-16, -2.189782033649651e-16,  4.862500525717906e-17, -7.339475607925055e-18,
  8.387722972781380e-19, -7.714570544405079e-20,  5.938968664384585e-21, -3.932852124631670e-22,  2.285764040957558e-23, -1.184051283237661e-24,  5.533619566054745e-26,
 -2.352965625857136e-27,  1.690371905185577e-16, -7.251212739858041e-17,  1.665557013249913e-17, -2.599839657229298e-18,  3.069821487882894e-19, -2.914035745486324e-20,
  2.312684244652087e-21, -1.577055508529690e-22,  9.428214977940885e-24, -5.018437676684301e-25,  2.407500423320405e-26, -1.049734165897720e-27,  4.911801891664379e-17,
 -2.143992649734989e-17,  5.019998841828034e-18, -7.986967727337479e-19,  9.607834933684726e-20, -9.285819086463817e-21,  7.498552784351481e-22, -5.199568252486825e-23,
  3.158920235877360e-24, -1.707674166649189e-25,  8.315305874373618e-27, -3.677961047286065e-28,  7.941562673667464e-02, -2.632563014034597e-04,  9.110857180471284e-07,
 -3.265483427784846e-09,  1.200066474713172e-11, -4.486594794499778e-14,  1.692660667303558e-16, -6.425013433935085e-19,  2.438036646931724e-21, -9.274343216605306e-24,
  3.504422883595156e-26, -1.331276318773054e-28,  7.088192463703359e-02, -2.972437852653658e-04,  1.524771270349420e-06, -8.134001784637715e-09,  4.275530754410174e-11,
 -2.193634716559838e-13,  1.100066520102956e-15, -5.410393610179684e-18,  2.616522985697498e-20, -1.247322712014305e-22,  5.869099054259866e-25, -2.730639093592541e-27,
  5.647109033034745e-02, -3.364370556969441e-04,  2.482011789824283e-06, -1.737474336240334e-08,  1.146848772522663e-10, -7.238967845533668e-13,  4.411569641660359e-15,
 -2.611573029084282e-17,  1.508124888210321e-19, -8.522507016672305e-22,  4.724587469164521e-24, -2.574403840653249e-26,  4.016463961311313e-02, -3.462804556515516e-04,
  3.358150724780647e-06, -2.902924814510649e-08,  2.320795244567260e-10, -1.752523029298600e-12,  1.264600812343242e-14, -8.786594497270834e-17,  5.911246568380261e-19,
 -3.866808405470924e-21,  2.467593254165597e-23, -1.540156333786064e-25,  2.550904986001877e-02, -3.113700530228272e-04,  3.773790028510989e-06, -3.939599701226821e-08,
  3.748218990483861e-10, -3.327622759695098e-12,  2.795188530842748e-14, -2.242732494173023e-16,  1.730706089481505e-18, -1.291205110313428e-20,  9.350630173292897e-23,
 -6.593710587670859e-25,  1.447209639488707e-02, -2.422692856258558e-04,  3.579240575763630e-06, -4.454360122715465e-08,  4.977891914268651e-10, -5.130082894292856e-12,
  4.956819070902093e-14, -4.541203283606926e-16,  3.976868270615107e-18, -3.349219919826311e-20,  2.725306870582096e-22, -2.150551711593194e-24,  7.337867915259245e-03,
 -1.633418373079426e-04,  2.901772141266727e-06, -4.261685156303815e-08,  5.537353525240198e-10, -6.562084763998439e-12,  7.229188194536852e-14, -7.499573056906615e-16,
  7.394010513872037e-18, -6.975986141847299e-20,  6.331701305266089e-22, -5.551684891222595e-24,  3.327368012221946e-03, -9.585815072653435e-05,  2.029262223742317e-06,
 -3.487277833513625e-08,  5.226274980517935e-10, -7.070007838772715e-12,  8.820192899592127e-14, -1.029459578594816e-15,  1.135703032744122e-17, -1.193338846664857e-19,
  1.201344825125463e-21, -1.164045977319412e-23,  1.350558434849118e-03, -4.921238392074615e-05,  1.232517584046466e-06, -2.460646720578198e-08,  4.226241144915261e-10,
 -6.488450231090485e-12,  9.117096980278141e-14, -1.191115726999416e-15,  1.463228066136947e-17, -1.704373637775291e-19,  1.894585186635082e-21, -2.019925954957883e-23,
  4.912715960053951e-04, -2.220938966281352e-05,  6.538544692474258e-07, -1.507282917838833e-08,  2.951286747430119e-10, -5.117898308347985e-12,  8.064035822097812e-14,
 -1.174409357824242e-15,  1.600202043861878e-17, -2.058497000179789e-19,  2.517536426225874e-21, -2.943054618251019e-23,  1.603981726150159e-04, -8.851411680314701e-06,
  3.045065965880998e-07, -8.062946468814719e-09,  1.791843570638672e-10, -3.495862882994548e-12,  6.154314322120627e-14, -9.957213107447724e-16,  1.499997336414521e-17,
 -2.124474380838893e-19,  2.850150280863160e-21, -3.642906917678134e-23,  4.710030612598502e-05, -3.129356517164533e-06,  1.250967587579487e-07, -3.787424300906778e-09,
  9.516842075045797e-11, -2.081927842660947e-12,  4.082524565659395e-14, -7.317182711153543e-16,  1.215428941514897e-17, -1.890454795391764e-19,  2.775282735191179e-21,
 -3.869134261664764e-23,  1.247182423922209e-05, -9.859739150470047e-07,  4.555880085595529e-08, -1.570767454062843e-09,  4.448008568671479e-11, -1.087938293875314e-12,
  2.370143854311904e-14, -4.694637230232716e-16,  8.579050707387843e-18, -1.462239564386060e-19,  2.344169208837752e-21, -3.557585775849975e-23,  2.988001713048515e-06,
 -2.782264277177876e-07,  1.478651160299492e-08, -5.784392220395836e-10,  1.840507037012110e-11, -5.020464431318187e-13,  1.212386592584443e-14, -2.648386630674449e-16,
  5.314096835123292e-18, -9.907281466884424e-20,  1.731375013609719e-21, -2.855475573294648e-23,  6.505075771548040e-07, -7.070943515243207e-08,  4.302043053351534e-09,
 -1.903076513275792e-10,  6.785791089794226e-12, -2.059635993761294e-13,  5.502307194241473e-15, -1.323142315835146e-16,  2.910245380295017e-18, -5.925228647805954e-20,
  1.127049695083043e-21, -2.017005989883723e-23,  1.294019479371823e-07, -1.629008276058085e-08,  1.129605742512409e-09, -5.632789429619769e-11,  2.245176218284703e-12,
 -7.566877196470869e-14,  2.232202119037766e-15, -5.899272760540522e-17,  1.420142568550332e-18, -3.153058096281690e-20,  6.518887831021553e-22, -1.264256087218461e-23,
  2.368613465720139e-08, -3.428475641448513e-09,  2.698156050925138e-10, -1.512016294233417e-11,  6.720897320723279e-13, -2.510168783494858e-14,  8.162572295437558e-16,
 -2.367095609887463e-17,  6.227778348817337e-19, -1.505805226348680e-20,  3.379497292990137e-22, -7.093588145015520e-24,  4.025055671916259e-09, -6.654091123041968e-10,
  5.918583489210721e-11, -3.716129313406098e-12,  1.837683349711358e-13, -7.590855161327763e-15,  2.716242614869676e-16, -8.629857886118935e-18,  2.477881855793719e-19,
 -6.515764153044254e-21,  1.585370902377415e-22, -3.597108998258423e-24,  6.421475351991004e-10, -1.204681758921159e-10,  1.206047067632856e-11, -8.458250751570161e-13,
  4.641886857216347e-14, -2.116177178005662e-15,  8.317425226323931e-17, -2.890367611683676e-18,  9.043302615293731e-20, -2.582482623764715e-21,  6.802830772410595e-23,
 -1.666258173428067e-24,  9.753594039046509e-11, -2.063318063877449e-11,  2.315068319704122e-12, -1.807584765626380e-13,  1.097942105526790e-14, -5.511554324870974e-16,
  2.374562755096134e-17, -9.008877722502840e-19,  3.066146839130359e-20, -9.493401714385620e-22,  2.703238177079227e-23, -7.136885854156386e-25,  1.435171483738359e-11,
 -3.401350935740258e-12,  4.257668812069477e-13, -3.687666019335415e-14,  2.471587496750541e-15, -1.362548409587586e-16,  6.419412639265000e-18, -2.653081505477953e-19,
  9.802310561730127e-21, -3.284198527529892e-22,  1.008997716485675e-23, -2.866135439633240e-25,  2.089744911975847e-12, -5.510766168385656e-13,  7.657097079409441e-14,
 -7.326341940766067e-15,  5.398824496038648e-16, -3.258137181378962e-17,  1.673713691456232e-18, -7.515013341537704e-20,  3.006469069882477e-21, -1.087366462725040e-22,
  3.596021702910710e-24, -1.096544824527204e-25,  3.089316909879205e-13, -8.997522035050154e-14,  1.379784288224958e-14, -1.451289106543602e-15,  1.170771251366120e-16,
 -7.704195919711287e-18,  4.299590942649982e-19, -2.090198130502376e-20,  9.025258080720672e-22, -3.512813912375112e-23,  1.246795977833466e-24, -4.069515355142773e-26,
  4.778383983172630e-14, -1.524424406144525e-14,  2.562841547226172e-15, -2.945978219360004e-16,  2.587849484264426e-17, -1.847747647643956e-18,  1.115146407087296e-19,
 -5.844073111103288e-21,  2.712281048736368e-22, -1.131573739891535e-23,  4.293941865602118e-25, -1.494638841054629e-26,  8.000443715462185e-15, -2.770094922298967e-15,
  5.065268848521589e-16, -6.317874178785909e-17,  6.003515747796708e-18, -4.622501369393070e-19,  2.999338738191364e-20, -1.685107704757562e-21,  8.361700183922392e-23,
 -3.720383067434130e-24,  1.501985581391134e-25, -5.549049298823313e-27,  1.503114702796632e-15, -5.590184603383475e-16,  1.101425637238495e-16, -1.477792829723949e-17,
  1.506739103625175e-18, -1.241470903151755e-19,  8.597441149799890e-21, -5.142309423199921e-22,  2.709988993750117e-23, -1.277650452108197e-24,  5.453836213739613e-26,
 -2.125816737817758e-27,  3.276606283345015e-16, -1.293856726737088e-16,  2.716734513825321e-17, -3.880280350837203e-18,  4.203154067707443e-19, -3.671161712978120e-20,
  2.689094800562494e-21, -1.697589334829066e-22,  9.422902868149395e-24, -4.670009763979330e-25,  2.091618745209061e-26, -8.538052230258758e-28,  8.456265901377893e-17,
 -3.500521955303285e-17,  7.733652159653024e-18, -1.161498045083556e-18,  1.320993312123975e-19, -1.209359258792774e-20,  9.268860598226333e-22, -6.111912368512991e-23,
  3.537807217461712e-24, -1.825500208967483e-25,  8.499645996490585e-27, -3.601299365641339e-28,  2.524778211501256e-17, -1.080649781303820e-17,  2.476144730476407e-18,
 -3.855811214781558e-19,  4.542201819117865e-20, -4.301988530141244e-21,  3.406824441066007e-22, -2.318338157263734e-23,  1.383221592902973e-24, -7.348486037880508e-26,
  3.518809505545542e-27, -1.531589214249890e-28,  7.030199648458309e-18, -3.066280537755342e-18,  7.173249756810345e-19, -1.140295205401800e-19,  1.370538651905897e-20,
 -1.323506589565327e-21,  1.067908229066393e-22, -7.399202064112753e-24,  4.491875758612737e-25, -2.426473760984766e-26,  1.180701261375405e-27, -5.218795936323819e-29,
  7.837693524592308e-02, -2.561211614747603e-04,  8.730230678442933e-07, -3.080436582412904e-09,  1.114255673843445e-11, -4.101092595973305e-14,  1.523199412683628e-16,
 -5.695667016953659e-19,  2.128041954531709e-21, -7.983034098162027e-24,  2.967899371004920e-26, -1.114525889927876e-28,  6.971674364203193e-02, -2.854247421062777e-04,
  1.431127488497376e-06, -7.483630388987189e-09,  3.862025524397550e-11, -1.946891466868406e-13,  9.596534637040872e-16, -4.640645903708248e-18,  2.207002882482146e-20,
 -1.034914211682562e-22,  4.790429607896053e-25, -2.193242690498624e-27,  5.516377644962628e-02, -3.173848189171364e-04,  2.284064823812790e-06, -1.565009528625498e-08,
  1.012091904608675e-10, -6.262757585986294e-13,  3.743528566960181e-15, -2.174625744599702e-17,  1.232769880521701e-19, -6.840990138930488e-22,  3.725189728751520e-24,
 -1.994369413967325e-26,  3.883112771579966e-02, -3.207480888338767e-04,  3.030973936467301e-06, -2.558068865438443e-08,  1.998753507596281e-10, -1.476526413954972e-12,
  1.043094347046227e-14, -7.099923911423781e-17,  4.681669029188329e-19, -3.002979053361242e-21,  1.879827477574697e-23, -1.151328871037253e-25,  2.432109374156465e-02,
 -2.829736204341360e-04,  3.334937230147980e-06, -3.389684475695582e-08,  3.144998550840044e-10, -2.726280126387232e-12,  2.238254644165808e-14, -1.756592586640959e-16,
  1.326749309056339e-18, -9.693200180711976e-21,  6.877390583531020e-23, -4.753394323881649e-25,  1.355708316228248e-02, -2.156454534630477e-04,  3.089317425260382e-06,
 -3.733922857696582e-08,  4.061238063943263e-10, -4.079693594102607e-12,  3.846719154254941e-14, -3.442201311493389e-16,  2.946531813138103e-18, -2.427144723900003e-20,
  1.932816620283153e-22, -1.493350725377948e-24,  6.727890254016524e-03, -1.420320485395421e-04,  2.439484489827247e-06, -3.471943753067567e-08,  4.382717383692265e-10,
 -5.054485377361489e-12,  5.426031999018909e-14, -5.490832701305918e-16,  5.285241519480730e-18, -4.871826352894538e-20,  4.322992814460908e-22, -3.707762919632707e-24,
  2.973940679745989e-03, -8.116583660517596e-05,  1.656642378879668e-06, -2.753603368403635e-08,  4.002575177491677e-10, -5.261654090048343e-12,  6.387991720332662e-14,
 -7.264132621697304e-16,  7.815311702989089e-18, -8.015103733204926e-20,  7.881103362125188e-22, -7.463436558588524e-24,  1.171709282466364e-03, -4.042754262718834e-05,
  9.738857811182463e-07, -1.877420176356850e-08,  3.122858565675355e-10, -4.652838043567853e-12,  6.354759192968649e-14, -8.080060768834335e-16,  9.670542296057156e-18,
 -1.098435052931616e-19,  1.191615705463869e-21, -1.240720838391526e-23,  4.118540445998248e-04, -1.762892229448859e-05,  4.982474626861589e-07, -1.107469976922860e-08,
  2.097331655533079e-10, -3.525478405651795e-12,  5.393690113815386e-14, -7.637574387428965e-16,  1.013002100270661e-17, -1.269728244363023e-19,  1.514371143245063e-21,
 -1.727753380329352e-23,  1.293142523722043e-04, -6.758477901927653e-06,  2.228818913750747e-07, -5.683669338326098e-09,  1.220321227875359e-10, -2.305501304903939e-12,
  3.937357543612121e-14, -6.188836277050073e-16,  9.068543466105402e-18, -1.250631115895491e-19,  1.635210806643567e-21, -2.038627428548518e-23,  3.632935347912940e-05,
 -2.287343292924542e-06,  8.756491727779779e-08, -2.550850768735240e-09,  6.187138593979526e-11, -1.309626873969528e-12,  2.489454795786976e-14, -4.331860737221933e-16,
  6.994760248361267e-18, -1.058772299508323e-19,  1.514110628457317e-21, -2.058050808005767e-23,  9.152619543202188e-06, -6.862747507948689e-07,  3.035076291949720e-08,
 -1.006217201059218e-09,  2.748673976702781e-11, -6.501072327221149e-13,  1.372171723422440e-14, -2.637381590283264e-16,  4.683031076882084e-18, -7.764701554655036e-20,
  1.212145537996418e-21, -1.792990913210196e-23,  2.073895891186803e-06, -1.833648823528419e-07,  9.325848022009646e-09, -3.506895091994129e-10,  1.076010319083044e-11,
 -2.837159127521288e-13,  6.635636748436103e-15, -1.406123564159952e-16,  2.740741570388864e-18, -4.969442530126712e-20,  8.455050080846865e-22, -1.358904831614003e-23,
  4.242840545191432e-07, -4.385413589898332e-08,  2.554057451846046e-09, -1.086069595992516e-10,  3.734015469437974e-12, -1.095404587996617e-13,  2.833861135650558e-15,
 -6.609910083429634e-17,  1.412145799561345e-18, -2.796052087869496e-20,  5.177768184623544e-22, -9.030100798022550e-24,  7.876571626135901e-08, -9.444847928429394e-09,
  6.273571329083654e-10, -3.008236611876071e-11,  1.156400591509771e-12, -3.767487973741880e-14,  1.076408137574483e-15, -2.759650222625174e-17,  6.453691594677473e-19,
 -1.393682287529067e-20,  2.805673363443322e-22, -5.303538023304238e-24,  1.335544769931072e-08, -1.845123463615142e-09,  1.392444690864128e-10, -7.509035657347867e-12,
  3.220815947960475e-13, -1.163379394520737e-14,  3.665519012712488e-16, -1.031591155070651e-17,  2.637622123366817e-19, -6.205404688245234e-21,  1.356604697306978e-22,
 -2.776556638621433e-24,  2.085791153052445e-09, -3.298994413696999e-10,  2.818045253574612e-11, -1.704610682063250e-12,  8.141720198543320e-14, -3.255107047758778e-15,
  1.129409292783140e-16, -3.484726802387140e-18,  9.730165863032027e-20, -2.491188556788992e-21,  5.908098255999470e-23, -1.307930144878040e-24,  3.032892905631865e-10,
 -5.458606159159699e-11,  5.258334678061419e-12, -3.558258330522115e-13,  1.888573295301846e-14, -8.343150307059076e-16,  3.183052688772171e-17, -1.075302565370747e-18,
  3.274912117721248e-20, -9.114182071695226e-22,  2.342293195129311e-23, -5.602696341666325e-25,  4.162796925829387e-11, -8.474909905211506e-12,  9.171431971587567e-13,
 -6.923167519572915e-14,  4.074012339244878e-15, -1.984901261781667e-16,  8.313003577377324e-18, -3.070174643189711e-19,  1.018468315257963e-20, -3.077014035285110e-22,
  8.558374476897677e-24, -2.209194588322991e-25,  5.487805832806572e-12, -1.256109408507136e-12,  1.520826004859773e-13, -1.276587983778489e-14,  8.307285995670424e-16,
 -4.453739044618410e-17,  2.043552766433635e-18, -8.236096286257918e-20,  2.970893257023122e-21, -9.728298022918546e-23,  2.923938131208247e-24, -8.132875039881503e-26,
  7.101114603504011e-13, -1.815622488387782e-13,  2.448124227203647e-14, -2.276712857322177e-15,  1.633238023115304e-16, -9.608775195788595e-18,  4.818242503096950e-19,
 -2.114238845409098e-20,  8.274854250659484e-22, -2.930772631410358e-23,  9.499929114215473e-25, -2.841761229784905e-26,  9.263379914487419e-14, -2.626985145597508e-14,
  3.923850632107874e-15, -4.024967466791369e-16,  3.170654248595171e-17, -2.039858798404269e-18,  1.114247354330282e-19, -5.307246438398741e-21,  2.247388895511137e-22,
 -8.585942228889011e-24,  2.993584682298912e-25, -9.605897795462589e-27,  1.257979240656047e-14, -3.925405088119483e-15,  6.454140899422291e-16, -7.262435311713904e-17,
  6.251363070586561e-18, -4.378186570361646e-19,  2.594209517800107e-20, -1.335940275511902e-21,  6.097524974311065e-23, -2.503648923408741e-24,  9.356640843191894e-26,
 -3.209710107746188e-27,  1.845935617720304e-15, -6.280476950971721e-16,  1.128032700541060e-16, -1.382879920529553e-17,  1.292562236662567e-18, -9.797006182668160e-20,
  6.262315656015169e-21, -3.468433164977795e-22,  1.697774446387709e-23, -7.456203056642790e-25,  2.972954564155567e-26, -1.085365263805753e-27,  3.048527309427731e-16,
 -1.119165044503929e-16,  2.175506765936758e-17, -2.880890582045746e-18,  2.900666335611148e-19, -2.361510279214334e-20,  1.616798693348969e-21, -9.565471385737944e-23,
  4.988754576870191e-24, -2.328709420494504e-25,  9.846321722564567e-27, -3.803241347506854e-28,  5.895797605886944e-17, -2.307839786608947e-17,  4.801111159464279e-18,
 -6.795580317573686e-19,  7.297269093914828e-20, -6.320830325265665e-21,  4.593293948483993e-22, -2.877755347400972e-23,  1.585831031454255e-24, -7.805141985898434e-26,
  3.472709240470473e-27, -1.408636271762157e-28,  1.372873019979613e-17, -5.653938278513241e-18,  1.242220166259581e-18, -1.855541006656700e-19,  2.099302473788424e-20,
 -1.912255205248778e-21,  1.458569685143667e-22, -9.573697087380097e-24,  5.517291633974479e-25, -2.834954304057219e-26,  1.314668598365276e-27, -5.548875743047893e-29,
  3.791393033935376e-18, -1.618846850500208e-18,  3.699516392147444e-19, -5.745739001829276e-20,  6.751392604013830e-21, -6.378732825521151e-22,  5.039593479979433e-23,
 -3.421721594082374e-24,  2.037144516313898e-25, -1.080011673643237e-26,  5.161350117412873e-28, -2.242248905590187e-29,  1.008167861572346e-18, -4.393535093507349e-19,
  1.026868830526123e-19, -1.630845675501325e-20,  1.958356415469866e-21, -1.889479938351173e-22,  1.523271818957243e-23, -1.054550235030323e-24,  6.396765228245680e-26,
 -3.452785433868156e-27,  1.678827034216799e-28, -7.415138885538484e-30,  7.736618905407856e-02, -2.492818681850512e-04,  8.371010760009631e-07, -2.908524084703388e-09,
  1.035764189894590e-11, -3.753918436866048e-14,  1.372838118588280e-16, -5.058477231789831e-19,  1.860890239984717e-21, -6.888459717103598e-24,  2.517922404667316e-26,
 -9.366165108093575e-29,  6.859738840751493e-02, -2.743247197585159e-04,  1.344906909722566e-06, -6.895647966423285e-09,  3.494666245979671e-11, -1.731402301998988e-13,
  8.390679688408637e-16, -3.990498517702246e-18,  1.866721044597756e-20, -8.612732641429821e-23,  3.922576907532179e-25, -1.767787631394485e-27,  5.392963045190485e-02,
 -2.998368972207732e-04,  2.105581686352226e-06, -1.412627008512662e-08,  8.953501248101063e-11, -5.433138145098304e-13,  3.186354617831448e-15, -1.816830793076376e-17,
  1.011328879783186e-19, -5.512524425059244e-22,  2.949334053331097e-24, -1.551792831904823e-26,  3.759476071165530e-02, -2.976759634876405e-04,  2.742261482953474e-06,
 -2.260597200407267e-08,  1.726955659895437e-10, -1.248441561100414e-12,  8.637431435463641e-15, -5.761184539877793e-17,  3.724571842880287e-19, -2.343308428302526e-21,
  1.439328598594087e-23, -8.652602511565358e-26,  2.324009762893254e-02, -2.578395894671634e-04,  2.956657908025968e-06, -2.927345496906061e-08,  2.649711605492337e-10,
 -2.243627414789282e-12,  1.800957232790788e-14, -1.382939797668436e-16,  1.022656192579436e-18, -7.318881181999923e-21,  5.089060223378198e-23, -3.448493632833824e-25,
  1.274124081326957e-02, -1.926186221226081e-04,  2.677695941438130e-06, -3.144693255800366e-08,  3.330331924722780e-10, -3.262241336078991e-12,  3.002765495567414e-14,
 -2.625389560341195e-16,  2.197425687247288e-18, -1.770985209064122e-20,  1.380579737019767e-22, -1.044701663497651e-24,  6.196313850606918e-03, -1.240707434579901e-04,
  2.061805063499967e-06, -2.844995499804346e-08,  3.490514909041941e-10, -3.919126935533078e-12,  4.101217930495319e-14, -4.049747265184159e-16,  3.806971728384392e-18,
 -3.429593832664126e-20,  2.976059220284905e-22, -2.497551626177034e-24,  2.673834669549641e-03, -6.913304605035684e-05,  1.361414091491604e-06, -2.189691779180690e-08,
  3.088435934467069e-10, -3.946814287465270e-12,  4.664775049425628e-14, -5.169949566613200e-16,  5.426192852185725e-18, -5.433174198113821e-20,  5.219518529221341e-22,
 -4.832261480185365e-24,  1.024265673080116e-03, -3.345924603621969e-05,  7.757527547561050e-07, -1.444632293828008e-08,  2.328142959517304e-10, -3.367566760116409e-12,
  4.472123367294439e-14, -5.535904108923814e-16,  6.457069824890424e-18, -7.154096517860426e-20,  7.576127988552171e-22, -7.705726137028263e-24,  3.485426446987509e-04,
 -1.412241613244373e-05,  3.833680723709677e-07, -8.219374158494683e-09,  1.506090503750513e-10, -2.454824838100657e-12,  3.647822966041906e-14, -5.023830865164356e-16,
  6.488000916395672e-18, -7.925935579721638e-20,  9.220950223724375e-22, -1.026959560935965e-23,  1.054571194464201e-04, -5.218243978074596e-06,  1.650228400917930e-07,
 -4.054043415616638e-09,  8.412146029940059e-11, -1.539437240718746e-12,  2.551146644612641e-14, -3.896709552559968e-16,  5.555305627788485e-18, -7.461554611021808e-20,
  9.510317139064502e-22, -1.156724598177490e-23,  2.840853118576347e-05, -1.694234271855695e-06,  6.212489857081898e-08, -1.741696605899107e-09,  4.078823874206653e-11,
 -8.355592130556628e-13,  1.540007055979809e-14, -2.602184802596516e-16,  4.085391843764210e-18, -6.019156085530448e-20,  8.386459048075974e-22, -1.111572286092724e-23,
  6.826044920797209e-06, -4.851739260914284e-07,  2.053758023837818e-08, -6.547896023361349e-10,  1.725731114347035e-11, -3.947511025010207e-13,  8.073547540484030e-15,
 -1.506010392068018e-16,  2.598706541160022e-18, -4.192062855294764e-20,  6.373348565336055e-22, -9.189543202338728e-24,  1.466624335803655e-06, -1.230454664882204e-07,
  5.988049882632971e-09, -2.164489502566898e-10,  6.404398452146349e-12, -1.632415575594965e-13,  3.697931606182641e-15, -7.602007305248623e-17,  1.439448366940568e-18,
 -2.538486307651456e-20,  4.205108894452349e-22, -6.586499363988326e-24,  2.827194780112201e-07, -2.776443962749356e-08,  1.547391305263591e-09, -6.324187197747701e-11,
  2.096328206821068e-12, -5.943508985379517e-14,  1.488953006932418e-15, -3.368537577355355e-17,  6.989980574772922e-19, -1.345927535561515e-20,  2.426428385108446e-22,
 -4.123736440307719e-24,  4.911641453618394e-08, -5.604702291726220e-09,  3.564361771160967e-10, -1.643029225467408e-11,  6.089949612682387e-13, -1.917599445049155e-14,
  5.305505685497634e-16, -1.319346614173181e-17,  2.996961973648082e-19, -6.294227938435811e-21,  1.233670385801323e-22, -2.272723658300913e-24,  7.735934563520504e-09,
 -1.018999223512829e-09,  7.369374825466387e-11, -3.822519451711106e-12,  1.581544176202540e-13, -5.523082041361901e-15,  1.685649450284122e-16, -4.602731975651494e-18,
  1.143428320853442e-19, -2.616944259276642e-21,  5.571697831174044e-23, -1.111712655050768e-24,  1.113302460687999e-09, -1.682648266643540e-10,  1.379243083809342e-11,
 -8.032428725193969e-13,  3.703575369514697e-14, -1.432525513606133e-15,  4.817489366611873e-17, -1.442977643998268e-18,  3.916841081465157e-20, -9.760736670777008e-22,
  2.255612359385242e-23, -4.870633059068203e-25,  1.479024352599377e-10, -2.550394334905465e-11,  2.361682186307224e-12, -1.540769612558809e-13,  7.903534924896689e-15,
 -3.381395856754874e-16,  1.251559064166973e-17, -4.108131281743492e-19,  1.217323939082690e-20, -3.300207538755931e-22,  8.270936312779755e-24, -1.931254950566510e-25,
  1.838142498998536e-11, -3.596243953431196e-12,  3.749423319966775e-13, -2.733710893763450e-14,  1.557209252732310e-15, -7.358060145894632e-17,  2.993629925569636e-18,
 -1.075596947995587e-19,  3.475698290303046e-21, -1.024088169525939e-22,  2.780806543725091e-24, -7.014777564590504e-26,  2.174082287628579e-12, -4.798672810510781e-13,
  5.612545824375438e-14, -4.560916787904146e-15,  2.878900693109041e-16, -1.499697119247028e-17,  6.696298812669724e-19, -2.629831132901499e-20,  9.255051967539984e-22,
 -2.960003637051988e-23,  8.698078933208065e-25, -2.367611120249277e-26,  2.501334116974839e-13, -6.191105126873389e-14,  8.090008653245776e-15, -7.304001157477506e-16,
  5.095272614352367e-17, -2.919513111505970e-18,  1.427736846235421e-19, -6.117378399922712e-21,  2.340498967882967e-22, -8.111657027544413e-24,  2.575331930774922e-25,
 -7.552170675941616e-27,  2.877520085637029e-14, -7.933373624167741e-15,  1.152606107196729e-15, -1.151593781930194e-16,  8.848363358149391e-18, -5.559779567749011e-19,
  2.969617760354231e-20, -1.384595110939002e-21,  5.745125909459473e-23, -2.152658738850227e-24,  7.367363246214603e-26, -2.322437231417406e-27,  3.423939303730610e-15,
 -1.043480379031508e-15,  1.675680722611559e-16, -1.843468502898478e-17,  1.553165761630518e-18, -1.065849291919338e-19,  6.194433459018566e-21, -3.131714772104625e-22,
  1.404495333248933e-23, -5.670964310141876e-25,  2.085646109709759e-26, -7.045850097379978e-28,  4.387481839180613e-16, -1.464937817503164e-16,  2.581260698068379e-17,
 -3.106631081425129e-18,  2.853152233862227e-19, -2.126692394439158e-20,  1.337933237915488e-21, -7.298756937883547e-23,  3.521416117731203e-24, -1.525322952939371e-25,
  6.002124343985318e-27, -2.163836997428121e-28,  6.336624147724715e-17, -2.293861698679396e-17,  4.394565045444331e-18, -5.738020273698488e-19,  5.700050374083690e-20,
 -4.581299942534336e-21,  3.098387604031076e-22, -1.811824250271828e-23,  9.344710429867922e-25, -4.315912953062571e-26,  1.806429880162332e-27, -6.910241865432215e-29,
  1.080454228285494e-17, -4.189197828509392e-18,  8.627775792633435e-19, -1.209276742294861e-19,  1.286391200769142e-20, -1.104288643671537e-21,  7.956234080193962e-23,
 -4.944057111027135e-24,  2.703306708588506e-25, -1.320630715704263e-26,  5.834125078373787e-28, -2.350477836017995e-29,  2.255019551051870e-18, -9.234798708936893e-19,
  2.016750934033655e-19, -2.994693019168143e-20,  3.368836875970789e-21, -3.051960963159592e-22,  2.315759010995894e-23, -1.512447847668156e-24,  8.674772685282365e-26,
 -4.437124459161049e-27,  2.048718340491532e-28, -8.611292317191501e-30,  5.726817834461503e-19, -2.438748595512849e-19,  5.557116987290706e-20, -8.606170567671025e-21,
  1.008456797200418e-21, -9.502650247277325e-23,  7.488582007405057e-24, -5.072111775093635e-25,  3.012663236541250e-26, -1.593618332289837e-27,  7.599530082673160e-29,
 -3.294698032932042e-30,  1.448762489350179e-19, -6.307946833990434e-20,  1.472841138160763e-20, -2.336797623776785e-21,  2.803346151993720e-22, -2.702191608645969e-23,
  2.176471357250422e-24, -1.505418849097844e-25,  9.123837935170566e-27, -4.920689309375511e-28,  2.390634454139681e-29, -1.055090049548303e-30,  7.638223805426642e-02,
 -2.427219073744312e-04,  8.031689117590091e-07, -2.748633763204626e-09,  9.638692892434018e-12, -3.440783112248629e-14,  1.239178146215877e-16, -4.500803916609119e-19,
  1.630082962309323e-21, -5.959206485526233e-24,  2.138963224805993e-26, -7.907278017201438e-29,  6.752109705106664e-02, -2.638872063392997e-04,  1.265403184437400e-06,
 -6.363146470055358e-09,  3.167652079563115e-11, -1.542786661377804e-13,  7.352515398247008e-16, -3.439874632405239e-18,  1.583127416243858e-20, -7.188754213929044e-23,
  3.221912925244868e-25, -1.429764023612933e-27,  5.276293189910947e-02, -2.836467508456259e-04,  1.944316221320555e-06, -1.277665169941612e-08,  7.939407059719769e-11,
 -4.725977133029160e-13,  2.720121068533398e-15, -1.522807861371176e-17,  8.325657556589482e-20, -4.458709777428875e-22,  2.344417737845387e-24, -1.212558756842088e-26,
  3.644627888975192e-02, -2.767778121690207e-04,  2.486779663947573e-06, -2.003185558227441e-08,  1.496756982509304e-10, -1.059228133415738e-12,  7.179229699522057e-15,
 -4.693888196197375e-17,  2.976055061025267e-19, -1.837028439198766e-21,  1.107461844047540e-23, -6.536316881022587e-26,  2.225391845224883e-02, -2.355226438989200e-04,
  2.629405514466188e-06, -2.537066531862575e-08,  2.241253860482028e-10, -1.854396641199276e-12,  1.455851922513863e-14, -1.094196377880468e-16,  7.924354767596562e-19,
 -5.557034992430432e-21,  3.787873496599296e-23, -2.517195250901527e-25,  1.201134114616901e-02, -1.726206383912217e-04,  2.330271193981398e-06, -2.660356763245948e-08,
  2.744382621647307e-10, -2.622397922519071e-12,  2.357227337675362e-14, -2.014402043572705e-16,  1.649113671574176e-18, -1.300766081583048e-20,  9.929411731684994e-23,
 -7.360965144870647e-25,  5.730984158537563e-03, -1.088525865853773e-04,  1.751491189984200e-06, -2.344233310827628e-08,  2.796599790425160e-10, -3.058203830941210e-12,
  3.120801543177984e-14, -3.008074836041732e-16,  2.762520638492031e-18, -2.432974170737529e-20,  2.065233650433838e-22, -1.696322713571591e-24,  2.417532101232027e-03,
 -5.921440695082594e-05,  1.125879559536954e-06, -1.753067250987939e-08,  2.400244520459144e-10, -2.983030357632410e-12,  3.433527034658771e-14, -3.710043789317934e-16,
  3.799903809697471e-18, -3.715842836173956e-20,  3.488648779725901e-22, -3.158373568956380e-24,  9.018259118296881e-04, -2.788808639264297e-05,  6.226999089710361e-07,
 -1.120666705174109e-08,  1.750517969459040e-10, -2.459100713480574e-12,  3.176443959054332e-14, -3.829273706026690e-16,  4.354183664575959e-18, -4.707029931177389e-20,
  4.867304769183284e-22, -4.837215066458563e-24,  2.976154735525056e-04, -1.141248028205967e-05,  2.977158300842489e-07, -6.159225747215401e-09,  1.092388447833124e-10,
 -1.727089696248934e-12,  2.493523112160249e-14, -3.341007422056420e-16,  4.202398993912654e-18, -5.004858423931414e-20,  5.681062879380369e-22, -6.177864636060925e-24,
  8.694587071290781e-05, -4.071915168189003e-06,  1.235323805175777e-07, -2.924520710013098e-09,  5.866586109645206e-11, -1.040245722576846e-12,  1.673273045452123e-14,
 -2.484298401961418e-16,  3.446702146919168e-18, -4.509795287645008e-20,  5.604534086139646e-22, -6.651740494214025e-24,  2.250736229787552e-05, -1.270893002179588e-06,
  4.464761033397709e-08, -1.204927611968418e-09,  2.725151992400074e-11, -5.404105570807440e-13,  9.659603512835277e-15, -1.585314159283674e-16,  2.420459090451385e-18,
 -3.471807912590864e-20,  4.713734926591148e-22, -6.093375411849300e-24,  5.170100448938820e-06, -3.481473075804577e-07,  1.410682760112042e-08, -4.325858291097097e-10,
  1.100160746731134e-11, -2.434273078443115e-13,  4.825037596459027e-15, -8.736404259064943e-17,  1.465218951964600e-18, -2.299889058875738e-20,  3.405753940734039e-22,
 -4.787342914765746e-24,  1.055968796459989e-06, -8.400866599974097e-08,  3.911591866690073e-09, -1.359149640991237e-10,  3.878356099773169e-12, -9.556988300360423e-14,
  2.097087179190247e-15, -4.182654426754144e-17,  7.694469705336899e-19, -1.319865449905110e-20,  2.128904041374405e-22, -3.249860650485120e-24,  1.923136277118673e-07,
 -1.792987019527365e-08,  9.560204656417816e-10, -3.754899057315747e-11,  1.199958052807553e-12, -3.287951866923842e-14,  7.976173853776870e-16, -1.750242712093023e-17,
  3.527637879018974e-19, -6.605561571785412e-21,  1.159318564139778e-22, -1.919978943516926e-24,  3.135229349258779e-08, -3.401425739959210e-09,  2.070195789549029e-10,
 -9.171180507990911e-12,  3.277067092365237e-13, -9.971695951107507e-15,  2.671355169945559e-16, -6.442807616818558e-18,  1.421430590733811e-19, -2.903049799994949e-21,
  5.539329973261795e-23, -9.944573339340404e-25,  4.599754784106784e-09, -5.770699618118904e-10,  3.996914355086686e-11, -1.993293188052179e-12,  7.952603365357326e-14,
 -2.684329082370181e-15,  7.933967806312387e-17, -2.101467410683751e-18,  5.071291763002106e-20, -1.128888794974650e-21,  2.340325786224604e-23, -4.551526761372599e-25,
  6.116683227156405e-10, -8.823574363162150e-11,  6.934773964748953e-12, -3.886058355908368e-13,  1.728847358949938e-14, -6.466803508982667e-16,  2.107076788320539e-17,
 -6.124841124281915e-19,  1.615699002114411e-20, -3.917774619706019e-22,  8.819417387903269e-24, -1.857064126388465e-25,  7.443427194724292e-11, -1.228098668800216e-11,
  1.092145025793577e-12, -6.864245393933985e-14,  3.400827029783267e-15, -1.408292531552830e-16,  5.054398825646878e-18, -1.611262651188999e-19,  4.643362157502880e-21,
 -1.225764084014525e-22,  2.994614594508707e-24, -6.823267446106380e-26,  8.395107552844725e-12, -1.576102828189506e-12,  1.581355156117781e-13, -1.112594161178830e-14,
  6.130004985605702e-16, -2.807163800926103e-17,  1.108759061636860e-18, -3.873249915284632e-20,  1.218523006140025e-21, -3.499562827461930e-23,  9.272603799316224e-25,
 -2.284743618612837e-26,  8.923644523618866e-13, -1.896397981717835e-13,  2.139986752563484e-14, -1.681742152830013e-15,  1.028702435924159e-16, -5.202450681005787e-18,
  2.258762551284177e-19, -8.637876156308786e-21,  2.963803179145368e-22, -9.252286637199683e-24,  2.656543377440147e-25, -7.072354186874290e-27,  9.136689972250464e-14,
 -2.185659221494782e-14,  2.764053998216771e-15, -2.419796226163838e-16,  1.639787977104131e-17, -9.141836312839237e-19,  4.356117662080437e-20, -1.820987374861382e-21,
  6.805309185715581e-23, -2.306261900438211e-24,  7.166623356539747e-26, -2.058903300237696e-27,  9.266947907320135e-15, -2.479849875966721e-15,  3.499470849597462e-16,
 -3.401261538724131e-17,  2.546138935959753e-18, -1.560853545641185e-19,  8.144084641769842e-21, -3.713668563205465e-22,  1.508606527654971e-23, -5.539453344166037e-25,
  1.859537866585700e-26, -5.754489973763420e-28,  9.645525943738245e-16, -2.866543841819253e-16,  4.489612827416660e-17, -4.822797545094603e-18,  3.972476963305035e-19,
 -2.668251490277330e-20,  1.519459617372420e-21, -7.534565904285549e-23,  3.317282439305916e-24, -1.316049517871983e-25,  4.759364635718521e-27, -1.582203237739840e-28,
  1.075763250967800e-16, -3.519991771691681e-17,  6.076712505140548e-18, -7.171257543255224e-19,  6.464148299723465e-20, -4.733422799780309e-21,  2.927989971948253e-22,
 -1.571820371403034e-23,  7.468261521311017e-25, -3.187999491479160e-26,  1.237088393865399e-27, -4.400850119000452e-29,  1.351899022254958e-17, -4.820084056989048e-18,
  9.090674490501218e-19, -1.169131217723212e-19,  1.144713752872277e-20, -9.074531022224608e-22,  6.057266120144059e-23, -3.498116249287388e-24,  1.782855330806978e-25,
 -8.141295213837921e-27,  3.370821453186531e-28, -1.276205063158279e-29,  2.019312567756145e-18, -7.748466212447512e-19,  1.578485202360895e-19, -2.189038557512425e-20,
  2.305045632623670e-21, -1.959613830095324e-22,  1.398862302684254e-23, -8.616272574139661e-25,  4.671737816705763e-26, -2.264018437620380e-27,  9.925399088143464e-29,
 -3.969706586027409e-30,  3.751183446659010e-19, -1.526750572810724e-19,  3.312290678591501e-20, -4.886799662116324e-21,  5.463311327632777e-22, -4.920126629798120e-23,
  3.712179625261706e-24, -2.411388316902574e-25,  1.375952379696186e-26, -7.003372207081204e-28,  3.218431562347632e-29, -1.346736124034160e-30,  8.705502907579756e-20,
 -3.696441832808642e-20,  8.396391122667262e-21, -1.296281109113471e-21,  1.514393086926237e-22, -1.422887291301472e-23,  1.118208589357626e-24, -7.553726298548206e-26,
  4.475296779978021e-27, -2.361574605736838e-28,  1.123556902597448e-29, -4.860266634398811e-31,  2.086546091641200e-20, -9.076071002704065e-21,  2.116896983357480e-21,
 -3.355056491196413e-22,  4.020695002480139e-23, -3.871682699440753e-24,  3.115372999156139e-25, -2.152792369471076e-26,  1.303538686021049e-27, -7.024044428100101e-29,
  3.409590810966444e-30, -1.503556369963529e-31,  7.542399586479263e-02, -2.364259200474483e-04,  7.710884239209024e-07, -2.599762522275632e-09,  8.979285405947991e-12,
 -3.157932869084610e-14,  1.120147285724014e-16, -4.011916930307867e-19,  1.430147461095143e-21, -5.169519393805382e-24,  1.818145437206735e-26, -6.715825989695797e-29,
  6.648532293979148e-02, -2.540610243137312e-04,  1.191987567512138e-06, -5.880079703361033e-09,  2.875989222858868e-11, -1.377334864628496e-13,  6.456554514541277e-16,
 -2.972311717622657e-18,  1.346090974650525e-20, -6.017434154843317e-23,  2.654296204757557e-25, -1.160305121029201e-27,  5.165851249815322e-02, -2.686846011714722e-04,
  1.798317423529289e-06, -1.157855490487137e-08,  7.056190334289215e-11, -4.121445955779732e-13,  2.328743998794183e-15, -1.280358458673128e-17,  6.877216260177040e-20,
 -3.619465516655607e-22,  1.870804022594369e-24, -9.513863722153547e-27,  3.537748912145193e-02, -2.578059434823094e-04,  2.260096322474429e-06, -1.779758744684036e-08,
  1.301130063703675e-10, -9.016801272998760e-13,  5.988904743079395e-15, -3.839345921473080e-17,  2.387989786395352e-19, -1.446592680140903e-21,  8.561640632719019e-24,
 -4.962351932824697e-26,  2.135205269156051e-02, -2.156469299267526e-04,  2.345308434016461e-06, -2.206337068638708e-08,  1.902973951439816e-10, -1.539066637795078e-12,
  1.182167162312686e-14, -8.699048800147049e-17,  6.171825220836207e-19, -4.242106198044802e-21,  2.835398174141842e-23, -1.848333228089498e-25,  1.135622143002656e-02,
 -1.551845883225629e-04,  2.035738249042590e-06, -2.260321657104911e-08,  2.272198604559253e-10, -2.118790845618741e-12,  1.860547225256689e-14, -1.554535571537061e-16,
  1.245159563602181e-18, -9.615031116861636e-21,  7.189137627745021e-23, -5.222604555679194e-25,  5.321917631256341e-03, -9.589421913773965e-05,  1.495136545288543e-06,
 -1.941908460526634e-08,  2.253519829874336e-10, -2.401049217741806e-12,  2.390191697756538e-14, -2.249617040635973e-16,  2.018964683436403e-18, -1.738843887280617e-20,
  1.444275650665448e-22, -1.161382026303658e-24,  2.197442752846600e-03, -5.098781600516316e-05,  9.367209807557516e-07, -1.412609263172727e-08,  1.878289694988381e-10,
 -2.271046960333370e-12,  2.546613806666167e-14, -2.683675811521215e-16,  2.683152442099986e-18, -2.563221257926474e-20,  2.352514624448660e-22, -2.083253526317064e-24,
  7.994476681735526e-04, -2.340027878940041e-05,  5.035267233262149e-07, -8.761254598479581e-09,  1.326999536694865e-10, -1.811114065955070e-12,  2.276296090658836e-14,
 -2.673285752844527e-16,  2.964228595978072e-18, -3.127504146698219e-20,  3.158689749691576e-22, -3.068080179223960e-24,  2.562996392724231e-04, -9.299112186744935e-06,
  2.332494213249108e-07, -4.658150167761982e-09,  7.999576701992907e-11, -1.227226362574423e-12,  1.722065975057194e-14, -2.245478290222513e-16,  2.751672892521538e-18,
 -3.195678311435717e-20,  3.540167232427746e-22, -3.759826616674261e-24,  7.243307285850562e-05, -3.209526311207357e-06,  9.344821010134978e-08, -2.132645388984239e-09,
  4.137193011076250e-11, -7.110278706827942e-13,  1.110456838145300e-14, -1.602993529623147e-16,  2.164877376251968e-18, -2.760086964306470e-20,  3.345190741380638e-22,
 -3.874984541262984e-24,  1.805605381344121e-05, -9.648827203846572e-07,  3.248498156342172e-08, -8.441382212297167e-10,  1.844283241586069e-11, -3.541309090348945e-13,
  6.140388291943429e-15, -9.790227397514887e-17,  1.453972337290470e-18, -2.030758798953039e-20,  2.687304238920327e-22, -3.388600936526181e-24,  3.974127608239657e-06,
 -2.533972745835405e-07,  9.829608194338637e-09, -2.899619635819464e-10,  7.117376434767357e-12, -1.523628100998168e-13,  2.927393335959216e-15, -5.145859204615303e-17,
  8.389576411487918e-19, -1.281578754228345e-20,  1.848760254179075e-22, -2.533812998565774e-24,  7.735080224414532e-07, -5.831422767905376e-08,  2.597737763698478e-09,
 -8.677107377458381e-11,  2.388106767213522e-12, -5.689772546035546e-14,  1.209499123689546e-15, -2.340743331889709e-17,  4.183921776276856e-19, -6.981484885718659e-21,
  1.096568807561811e-22, -1.631585058141728e-24,  1.334392484730323e-07, -1.180163180591918e-08,  6.018916144317261e-10, -2.271649472935682e-11,  6.998649834082139e-13,
 -1.853331869631294e-14,  4.353740862192924e-16, -9.266601990612518e-18,  1.814129776900033e-19, -3.303573567464830e-21,  5.644589240586447e-23, -9.109655329682401e-25,
  2.047026990840960e-08, -2.109514188881589e-09,  1.228245635130452e-10, -5.228189864716062e-12,  1.800691610421505e-13, -5.294398603279986e-15,  1.373209862075728e-16,
 -3.211894181485553e-18,  6.881958988108670e-20, -1.366727376400910e-21,  2.538658545597467e-23, -4.441068266101812e-25,  2.805389355770952e-09, -3.348592400359566e-10,
  2.219994212531619e-11, -1.064041546240840e-12,  4.092396089764051e-14, -1.334837878318140e-15,  3.820012858479839e-17, -9.813023010607830e-19,  2.300008145961230e-20,
 -4.978984588029307e-22,  1.004921804132493e-23, -1.904689994162290e-25,  3.456845631202334e-10, -4.753780372022945e-11,  3.579668346128632e-12, -1.929083653988366e-13,
  8.277116137792176e-15, -2.992958945607059e-16,  9.445389435901721e-18, -2.663663193705235e-19,  6.826733550778989e-21, -1.610311262508126e-22,  3.530363442985529e-24,
 -7.247137403498039e-26,  3.863744329124048e-11, -6.091426933850422e-12,  5.197538967084593e-13, -3.144793001382743e-14,  1.503936324263296e-15, -6.024807273960490e-17,
  2.095735741100409e-18, -6.485596039427248e-20,  1.816962991907865e-21, -4.668691842135015e-23,  1.111458475151913e-24, -2.470361835170920e-26,  3.964360527787065e-12,
 -7.131569874382100e-13,  6.878359391223801e-14, -4.665768225691113e-15,  2.484526854522732e-16, -1.101910104208771e-17,  4.222630078996805e-19, -1.433382638592489e-20,
  4.387896707744723e-22, -1.227735320700942e-23,  3.172790596702879e-25, -7.632605002909713e-27,  3.794593582945411e-13, -7.751960623259283e-14,  8.429369574664405e-15,
 -6.399441231862571e-16,  3.789896742167493e-17, -1.859204452040270e-18,  7.843186896001579e-20, -2.918557926449167e-21,  9.757035483752564e-23, -2.971228476865476e-24,
  8.330794507331435e-26, -2.167958087887003e-27,  3.461764816716991e-14, -7.990455910984477e-15,  9.766172164240270e-16, -8.280579025150176e-17,  5.445173524586848e-18,
 -2.950819934944764e-19,  1.368842503618960e-20, -5.578205171872642e-22,  2.034695413103958e-23, -6.737598561846860e-25,  2.047835963589257e-26, -5.759904380961057e-28,
  3.096114468867087e-15, -8.028368777194370e-16,  1.098828660671046e-16, -1.037597717429759e-17,  7.558669768573051e-19, -4.515952883857854e-20,  2.299535301859832e-21,
 -1.024571083662017e-22,  4.071348728421322e-24, -1.463838488709750e-25,  4.816147808019814e-27, -1.462026896371811e-28,  2.815392313556499e-16, -8.145903983195455e-17,
  1.242508573770810e-17, -1.301553596921748e-18,  1.046840815676608e-19, -6.874642735283369e-21,  3.831954214693202e-22, -1.861909416639830e-23,  8.040355302484257e-25,
 -3.131461763943681e-26,  1.112668665101377e-27, -3.637196178982933e-29,  2.724752196526019e-17, -8.724205924403786e-18,  1.473553774563576e-18, -1.702975235550077e-19,
  1.504853869089393e-20, -1.081355780444065e-21,  6.570304596989137e-23, -3.467559881843403e-24,  1.621063326621446e-25, -6.813755478139308e-27,  2.605325526955155e-28,
 -9.138739592010442e-30,  2.964974936253524e-18, -1.039887081196635e-18,  1.928388426530115e-19, -2.440010154248461e-20,  2.352258533144152e-21, -1.837397015023722e-22,
  1.209377503634837e-23, -6.891638445631417e-25,  3.468043659383364e-26, -1.564591313972293e-27,  6.403594444760914e-29, -2.397867859692708e-30,  3.854443730856773e-19,
 -1.462347387975061e-19,  2.943895451477363e-20, -4.035838391692772e-21,  4.203151851060713e-22, -3.535955419044238e-23,  2.499028679871161e-24, -1.524698998282924e-25,
  8.192340634505369e-27, -3.936034623835951e-28,  1.711392379327653e-29, -6.791305684788883e-31,  6.326369937260313e-20, -2.557505812389711e-20,  5.508641600803533e-21,
 -8.070124712444817e-22,  8.961348563103054e-23, -8.018393571688100e-24,  6.012628210784431e-25, -3.882865437396578e-26,  2.203218962481520e-27, -1.115432321207389e-28,
  5.099978279802949e-30, -2.123733790194750e-31,  1.332578154956178e-20, -5.640208305428986e-21,  1.276730573804999e-21, -1.964379427210010e-22,  2.287371836066424e-23,
 -2.142395621601229e-24,  1.678581998395006e-25, -1.130653214995857e-26,  6.680267632062095e-28, -3.515848911114272e-29,  1.668514660160117e-30, -7.200315442632961e-32,
  3.012311813292302e-21, -1.308925339192470e-21,  3.049396529010481e-22, -4.827396514455621e-23,  5.778637838644468e-24, -5.558409127920559e-25,  4.467896598779486e-26,
 -3.084276590542273e-27,  1.865729037885336e-28, -1.004384866683453e-29,  4.870994123215532e-31, -2.146110718342970e-32,  7.449043540336724e-02, -2.303796059617023e-04,
  7.407329056293088e-07, -2.461004309624244e-09,  8.373698478940536e-12, -2.902077128114252e-14,  1.013950579201263e-16, -3.582698545276248e-19,  1.256450768979324e-21,
 -4.498370370274156e-24,  1.544612412876082e-26, -5.752559049673446e-29,  6.548771453206327e-02, -2.447997489306293e-04,  1.124099308611097e-06, -5.441144296457678e-09,
  2.615368192728231e-11, -1.231897084908231e-13,  5.681495983710094e-16, -2.574269695731745e-18,  1.147405457079219e-20, -5.051131030566646e-23,  2.192899439234436e-25,
 -9.448406381852098e-28,  5.061169349603967e-02, -2.548352468991268e-04,  1.665886205970182e-06, -1.051258846986219e-08,  6.285010740176236e-11, -3.603196068766444e-13,
  1.999193121718020e-15, -1.079769421029144e-17,  5.699400452789771e-20, -2.948545653896120e-22,  1.498486829469335e-24, -7.494499408637721e-27,  3.438112249023750e-02,
 -2.405453879316270e-04,  2.058445347381075e-06, -1.585258919778072e-08,  1.134339313551370e-10, -7.700289765446395e-13,  5.013488487467518e-15, -3.152307708201479e-17,
  1.923940682911831e-19, -1.144084155144742e-21,  6.649368024627407e-24, -3.785661621552608e-26,  2.052538320187053e-02, -1.978939865386732e-04,  2.097848516538254e-06,
 -1.925023729766103e-08,  1.621669315429735e-10, -1.282477250583408e-12,  9.640950581913098e-15, -6.948017262953461e-17,  4.830636008342621e-19, -3.255235629255982e-21,
  2.134095314154685e-23, -1.365013628375236e-25,  1.076642024060575e-02, -1.399249028921306e-04,  1.784989087132505e-06, -1.928384662564359e-08,  1.889787693795343e-10,
 -1.720290459539643e-12,  1.476227871545454e-14, -1.206337145682497e-16,  9.456848038283975e-19, -7.151149190914103e-21,  5.238726245067834e-23, -3.730366764160855e-25,
  4.960869055181966e-03, -8.480740431860934e-05,  1.282252038676217e-06, -1.616846997704342e-08,  1.825926590897762e-10, -1.896230653068769e-12,  1.842078512100988e-14,
 -1.693483743644181e-16,  1.485731909485481e-18, -1.251702869393327e-20,  1.017587697171788e-22, -8.013094737599729e-25,  2.007473273734686e-03, -4.412425937925434e-05,
  7.838415450387406e-07, -1.145337940882550e-08,  1.479579933084638e-10, -1.741120749717415e-12,  1.902715595068901e-14, -1.956199698750469e-16,  1.909791635992034e-18,
 -1.782835302269403e-20,  1.600022052307557e-22, -1.386294950101901e-24,  7.132846809506855e-04, -1.975908277730816e-05,  4.100251621890876e-07, -6.900515332693833e-09,
  1.013857602852418e-10, -1.344866021987959e-12,  1.645244223000298e-14, -1.882907591186122e-16,  2.036589611776679e-18, -2.097782837953441e-20,  2.069928568818700e-22,
 -1.965532270354818e-24,  2.225095925184382e-04, -7.636678596718888e-06,  1.842885457214013e-07, -3.554089769654682e-09,  5.912216768906867e-11, -8.804013008124957e-13,
  1.201087885357980e-14, -1.524621612902851e-16,  1.820720035240335e-18, -2.062523544282797e-20,  2.230456470421402e-22, -2.314078736265451e-24,  6.094262975313725e-05,
 -2.554048171168674e-06,  7.140194340924960e-08, -1.571374733670004e-09,  2.948978286085259e-11, -4.913840339515092e-13,  7.453320957474150e-15, -1.046391956497594e-16,
  1.375977404077843e-18, -1.709795287930539e-20,  2.021428200035870e-22, -2.285890447231138e-24,  1.465856081410676e-05, -7.409955807512834e-07,  2.391570897896903e-08,
 -5.985521978083917e-10,  1.263641895594482e-11, -2.350071616731955e-13,  3.953856924825799e-15, -6.125809074788706e-17,  8.851277840481089e-19, -1.204049915945619e-20,
  1.553239051841799e-22, -1.910880016800745e-24,  3.098231388182079e-06, -1.869516754998160e-07,  6.943920491403615e-09, -1.970849740487413e-10,  4.670025795358562e-12,
 -9.674198803200649e-14,  1.802084502235221e-15, -3.075951527255015e-17,  4.875865053809096e-19, -7.249875321489767e-21,  1.018972613818009e-22, -1.361858530874611e-24,
  5.760350035764535e-07, -4.112501501139693e-08,  1.752750263778419e-09, -5.628613686651756e-11,  1.494277413542883e-12, -3.442685201347296e-14,  7.090557714497114e-16,
 -1.331669691800778e-17,  2.313030644294515e-19, -3.754978041325464e-21,  5.743833895318078e-23, -8.330701758106063e-25,  9.437230497622773e-08, -7.911404021290936e-09,
  3.858723243838037e-10, -1.399394264840272e-11,  4.156467273700084e-13, -1.063798418919926e-14,  2.420079357657056e-16, -4.996471759358845e-18,  9.501545915659577e-20,
 -1.682747418901248e-21,  2.799235859152771e-23, -4.402497336940258e-25,  1.365990021060770e-08, -1.335911539619147e-09,  7.438475051158052e-11, -3.041740842334275e-12,
  1.009696009262278e-13, -2.868338896326920e-15,  7.202544903876573e-17, -1.633702779078305e-18,  3.399446450700726e-20, -6.564527158288677e-22,  1.186942060009323e-23,
 -2.023250584471339e-25,  1.753681676122920e-09, -1.989486667911361e-10,  1.261817106892762e-11, -5.810527395408914e-13,  2.153811791472674e-14, -6.787309638595290e-16,
  1.880371146589998e-17, -4.684071625636038e-19,  1.066158962255046e-20, -2.244174107159341e-22,  4.409206771624993e-24, -8.143487578090165e-26,  2.008129787417358e-10,
 -2.629458919512978e-11,  1.895741059842595e-12, -9.819687599722485e-14,  4.061928383213398e-15, -1.419374033604999e-16,  4.337272959556450e-18, -1.186330725939269e-19,
  2.953251995722321e-21, -6.775078256157543e-23,  1.446226648383315e-24, -2.893674051972153e-26,  2.067365776189134e-11, -3.110293901082966e-12,  2.544047707236480e-13,
 -1.480827180786414e-14,  6.831917727596963e-16, -2.646369534556693e-17,  8.918098743283168e-19, -2.678121356501254e-20,  7.291158425896091e-22, -1.822928835330455e-23,
  4.227543217255380e-25, -9.162897835237795e-27,  1.934795004876879e-12, -3.330149933917278e-13,  3.084283701239832e-14, -2.015346124267387e-15,  1.036451309528398e-16,
 -4.449049884994566e-18,  1.653176779830765e-19, -5.450135513181085e-21,  1.622637406788856e-22, -4.421142046164518e-24,  1.113848887254618e-25, -2.614975789511434e-27,
  1.671375180852150e-13, -3.277092229949546e-14,  3.429557576496426e-15, -2.512671577038520e-16,  1.439416373833780e-17, -6.844155650556846e-19,  2.803311784542212e-20,
 -1.014364496750318e-21,  3.302004357256376e-23, -9.802952323995153e-25,  2.682536161590254e-26, -6.820152917545106e-28,  1.360740009810658e-14, -3.025504630864816e-15,
  3.568962836586869e-16, -2.927308601865946e-17,  1.865977790453540e-18, -9.819999291076671e-20,  4.430878194207684e-21, -1.758793709152391e-22,  6.256865264615183e-24,
 -2.023016305972235e-25,  6.010097347366557e-27, -1.653949248549832e-28,  1.073774257434497e-15, -2.693352268051216e-16,  3.570104337628897e-17, -3.270972784181076e-18,
  2.316115232887227e-19, -1.347179037235091e-20,  6.688052841654677e-22, -2.909013775581092e-23,  1.129778693244722e-24, -3.974309809147291e-26,  1.280575356630066e-27,
 -3.810650648483072e-29,  8.523238144079090e-17, -2.396801356379320e-17,  3.555050455024554e-18, -3.626528140057507e-19,  2.844650014205178e-20, -1.824352115686687e-21,
  9.943264637797143e-23, -4.729437926872943e-24,  2.001328473378381e-25, -7.645311959218008e-27,  2.666854487028526e-28, -8.565437838901061e-30,  7.139167835735734e-18,
 -2.233220441986326e-18,  3.685116083549185e-19, -4.165139942676324e-20,  3.603730435271008e-21, -2.538301663054937e-22,  1.513294250964396e-23, -7.843999090260411e-25,
  3.604706103699115e-26, -1.490611996851972e-27,  5.611440759601556e-29, -1.939312414671615e-30,  6.695467349658219e-19, -2.306798662873815e-19,  4.200690792591396e-20,
 -5.223042115130106e-21,  4.952106488282020e-22, -3.807549217949572e-23,  2.468810643367587e-24, -1.386932083490589e-25,  6.885339635541781e-27, -3.066410799464902e-28,
  1.239661990766669e-29, -4.587850209625543e-31,  7.525736898480629e-20, -2.820086794277570e-20,  5.604463772800420e-21, -7.587914182104799e-22,  7.808804097253342e-23,
 -6.495134309835476e-24,  4.541164661614095e-25, -2.742361141260397e-26,  1.459180674199934e-27, -6.945811023180543e-29,  2.993410581961584e-30, -1.177900867607670e-31,
  1.082987172304888e-20, -4.345674603245527e-21,  9.286571928151317e-22, -1.350041946458414e-22,  1.488110126662886e-23, -1.322184425328535e-24,  9.848225859598753e-26,
 -6.319385338859285e-27,  3.564031285025940e-28, -1.793962466267062e-29,  8.157222767655642e-31, -3.379047347262754e-32,  2.055374439553186e-21, -8.668948317976400e-22,
  1.954875278842108e-22, -2.996561811205171e-23,  3.476742526562626e-24, -3.245189702633181e-25,  2.534280154058341e-26, -1.701680516168328e-27,  1.002399824774430e-28,
 -5.260592091383359e-30,  2.489701938427061e-31, -1.071611405277730e-32,  4.360097451699308e-22, -1.892422639860221e-22,  4.403249745986016e-23, -6.961956482305078e-24,
  8.323705788520492e-25, -7.997085834201322e-26,  6.420844431041761e-27, -4.427593492561513e-28,  2.675503063921152e-29, -1.438851245219592e-30,  6.971205299200776e-32,
 -3.068548822395891e-33,  7.358058482808739e-02, -2.245696365467047e-04,  7.119859944248306e-07, -2.331539569075408e-09,  7.816828171907854e-12, -2.670327072662091e-14,
  9.190286895445160e-17, -3.205400528032951e-19,  1.105042577588267e-21, -3.928766574499077e-24,  1.308950608341683e-26, -4.991163549439845e-29,  6.452609740037216e-02,
 -2.360611981401914e-04,  1.061237359964158e-06, -5.041678653433963e-09,  2.382061272868310e-11, -1.103792042015266e-13,  5.009486709818836e-16, -2.234579598271958e-18,
  9.804010347583462e-21, -4.251755351540394e-23,  1.816550770054563e-25, -7.720919225843163e-28,  4.961823116410629e-02, -2.419961975130512e-04,  1.545539116083543e-06,
 -9.562130148620745e-09,  5.610005738289182e-11, -3.157703167511638e-13,  1.720874133639825e-15, -9.132769066558138e-18,  4.738319557482989e-20, -2.410200114289307e-22,
  1.204647955321128e-24, -5.926640252892547e-27,  3.345071333452753e-02, -2.248090248152251e-04,  1.878616101392357e-06, -1.415460139664280e-08,  9.916853512174515e-11,
 -6.596376088256586e-13,  4.211191041316726e-15, -2.597721394239118e-17,  1.556188527120279e-19, -9.086377356192933e-22,  5.187259055492052e-24, -2.901545233476417e-26,
  1.976596961499378e-02, -1.819929712394851e-04,  1.881606248203800e-06, -1.684882230968632e-08,  1.386822221880713e-10, -1.072795686641245e-12,  7.895410853041364e-15,
 -5.574346488393178e-17,  3.798962010175735e-19, -2.510565451679523e-21,  1.614800368656613e-23, -1.013695683188112e-25,  1.023388415334974e-02, -1.265217078452319e-04,
  1.570648857451446e-06, -1.651727259861707e-08,  1.578590235570998e-10, -1.403333275136438e-12,  1.177220713359007e-14, -9.411647597740758e-17,  7.223170102576818e-19,
 -5.350385268888342e-21,  3.841304677291019e-23, -2.681846839024073e-25,  4.640993169616731e-03, -7.527854320376446e-05,  1.104581407872119e-06, -1.352788424248180e-08,
  1.487310479008625e-10, -1.506050354319264e-12,  1.428212179429792e-14, -1.282932929572437e-16,  1.100618230092974e-18, -9.073052246035198e-21,  7.221488800030161e-23,
 -5.570247823915304e-25,  1.842700763122311e-03, -3.836553872816012e-05,  6.595313853821048e-07, -9.341564666760750e-09,  1.172917550763861e-10, -1.343843173276555e-12,
  1.431705728961436e-14, -1.436507030181160e-16,  1.369848188368666e-18, -1.249997977213805e-20,  1.097270287632374e-22, -9.304187062233868e-25,  6.403207156271409e-04,
 -1.678444249091464e-05,  3.361292974218728e-07, -5.473736189700079e-09,  7.804527652853082e-11, -1.006553394301959e-12,  1.198964419107650e-14, -1.337601947162442e-16,
  1.411696522124265e-18, -1.420016910614060e-20,  1.369279246243203e-22, -1.271434185588134e-24,  1.946624425615523e-04, -6.318128517770467e-06,  1.467811669456164e-07,
 -2.734678318505383e-09,  4.408229196284854e-11, -6.374128800427127e-13,  8.457209286874563e-15, -1.045385296545273e-16,  1.216960053732885e-18, -1.345054718107371e-20,
  1.420302249018222e-22, -1.439830317344245e-24,  5.175985694279081e-05, -2.050925755204965e-06,  5.508111388025802e-08, -1.169353944503502e-09,  2.123706685920783e-11,
 -3.432050304176564e-13,  5.057408946092890e-15, -6.907336355326918e-17,  8.846240481497105e-19, -1.071627370168771e-20,  1.236165544987036e-22, -1.364954963440060e-24,
  1.203616022247460e-05, -5.752897003180204e-07,  1.780630996083642e-08, -4.293451435461550e-10,  8.761253679135231e-12, -1.578580834129918e-13,  2.577686776623009e-15,
 -3.881742766507913e-17,  5.458209931103261e-19, -7.233035021102084e-21,  9.097860897568842e-23, -1.092219393283355e-24,  2.448165975873708e-06, -1.397232588004594e-07,
  4.970255591967882e-09, -1.357573050233902e-10,  3.106106196660950e-12, -6.227973231090701e-14,  1.125015904694239e-15, -1.865000961328990e-17,  2.874911314361938e-19,
 -4.161546129192471e-21,  5.699752662142011e-23, -7.429653370240856e-25,  4.358128788260088e-07, -2.944519911154297e-08,  1.200727210787549e-09, -3.707457008810003e-11,
  9.495565428273221e-13, -2.115819507037967e-14,  4.222795050139192e-16, -7.697453419933266e-18,  1.299410791931908e-19, -2.052530742160786e-21,  3.058030642299088e-23,
 -4.323888108595810e-25,  6.797771824249247e-08, -5.397411533815675e-09,  2.517317580315150e-10, -8.772127022670790e-12,  2.512004580384115e-13, -6.214126140896981e-15,
  1.369124156489862e-16, -2.742106055509477e-18,  5.065569824569517e-20, -8.725492397625371e-22,  1.413213967312513e-23, -2.166105345416438e-25,  9.308946096314841e-09,
 -8.631921551193243e-10,  4.595035054210890e-11, -1.804832164471540e-12,  5.773699617449102e-14, -1.584673665295564e-15,  3.852310443716600e-17, -8.473546317195413e-19,
  1.712300246801369e-20, -3.215108699538513e-22,  5.658736479936597e-24, -9.398724813007642e-26,  1.122704880137651e-09, -1.209274485108330e-10,  7.333960547866789e-12,
 -3.243702985304239e-13,  1.158553916982347e-14, -3.526761400296061e-16,  9.457461729123663e-18, -2.284265688224265e-19,  5.048602824303362e-21, -1.033202719111715e-22,
  1.975875372295900e-24, -3.555700114467097e-26,  1.198191288257623e-10, -1.492118198339447e-11,  1.029286334708314e-12, -5.122284313978235e-14,  2.041970237869013e-15,
 -6.893321190166985e-17,  2.039096952634828e-18, -5.408244610542180e-20,  1.307433165857306e-21, -2.916505037504945e-23,  6.060566815548067e-25, -1.181709661529127e-26,
  1.139501758380534e-11, -1.633791020247775e-12,  1.279955400512456e-13, -7.162755963774220e-15,  3.186345616195890e-16, -1.192892505220846e-17,  3.892959871168063e-19,
 -1.134034601192660e-20,  2.999284306159743e-22, -7.294207302095525e-24,  1.647351465111195e-25, -3.480828116874764e-27,  9.754324528547239e-13, -1.603998698573879e-13,
  1.425061264939608e-14, -8.962472697141764e-16,  4.448409463617556e-17, -1.847038059755468e-18,  6.651300395416324e-20, -2.128563852580844e-21,  6.160542506085323e-23,
 -1.633828277450179e-24,  4.011183284886473e-26, -9.186505959530036e-28,  7.623586051977589e-14, -1.432336252727060e-14,  1.440890752723497e-15, -1.017753971638361e-16,
  5.634850578261250e-18, -2.594866833790290e-19,  1.031215205694030e-20, -3.626095154467311e-22,  1.148671788854653e-23, -3.322695713157721e-25,  8.869198588800953e-27,
 -2.201881982430199e-28,  5.549528111374391e-15, -1.186537977234029e-15,  1.349022453084343e-16, -1.069120490395165e-17,  6.599387191585095e-19, -3.369610229659019e-20,
  1.477601267439938e-21, -5.708546210779967e-23,  1.979182352389389e-24, -6.244033400506085e-26,  1.811987120497590e-27, -4.875794162703093e-29,  3.867555210644873e-16,
 -9.367238011163559e-17,  1.200697346077009e-17, -1.066001880337621e-18,  7.328239923658574e-20, -4.145376185515806e-21,  2.004458255581077e-22, -8.503396878591317e-24,
  3.224943149093753e-25, -1.109062603718557e-26,  3.497092054473779e-28, -1.019357606278389e-29,  2.678743371038091e-17, -7.308215956639767e-18,  1.052449527901748e-18,
 -1.044057393184139e-19,  7.976883991134498e-21, -4.990236158047745e-22,  2.656605497044535e-23, -1.235711970029021e-24,  5.119327691665506e-26, -1.916519069239934e-27,
  6.557554303255018e-29, -2.067756760168157e-30,  1.937622549568718e-18, -5.911622061045509e-19,  9.515686835061069e-20, -1.050386608103148e-20,  8.886968545787278e-22,
 -6.128426683481816e-23,  3.581101800418182e-24, -1.821219993022611e-25,  8.219296756090853e-27, -3.340763377468980e-28,  1.237142705200368e-29, -4.209128943629314e-31,
  1.559313538076268e-19, -5.269714667414997e-20,  9.410159208883521e-21, -1.148277874501517e-21,  1.069472565765380e-22, -8.085053440075249e-24,  5.158949345153277e-25,
 -2.854415627537496e-26,  1.396699869219707e-27, -6.135183349191525e-29,  2.447949506508325e-30, -8.947142850744454e-32,  1.505478354526103e-20, -5.565646267162844e-21,
  1.090684327178041e-21, -1.456821726213356e-22,  1.480001089016769e-23, -1.216014694492395e-24,  8.403494408080982e-26, -5.018949384268698e-27,  2.642592836740999e-28,
 -1.245372287276228e-29,  5.316246748903969e-31, -2.073066315373332e-32,  1.884240046130116e-21, -7.499248960390331e-22,  1.588753515440901e-22, -2.290291891090875e-23,
  2.504255652140806e-24, -2.208017379394284e-25,  1.632671235327006e-26, -1.040403627916344e-27,  5.829108878252049e-29, -2.915723070874438e-30,  1.317885597127829e-31,
 -5.428258532098440e-33,  3.196702266020189e-22, -1.343053724206819e-22,  3.015988165204224e-23, -4.604190731880795e-24,  5.320967171704841e-25, -4.947909707196919e-26,
  3.850130508786465e-27, -2.576386025832604e-28,  1.512709136439720e-29, -7.914005715655760e-31,  3.734379347751926e-32, -1.602800784236982e-33,  6.328629614953506e-23,
 -2.743442677181606e-23,  6.374722796779702e-24, -1.006545653982225e-24,  1.201846804840601e-25, -1.153223940703181e-26,  9.247907612549765e-28, -6.369541687422107e-29,
  3.844625344637837e-30, -2.065336510415357e-31,  9.996006757105663e-33, -4.395550220401593e-34,  7.269352380991544e-02, -2.189835761385931e-04,  6.847406909710558e-07,
 -2.210625981590691e-09,  7.304112570372448e-12, -2.460143467345923e-14,  8.340224018426074e-17, -2.873447929489311e-19,  9.725189717384093e-22, -3.447289044450874e-24,
  1.102601261165339e-26, -4.419501801904842e-29,  6.359845816912887e-02, -2.278069842646202e-04,  1.002953204048260e-06, -4.677576938401338e-09,  2.172836569233823e-11,
 -9.907316930377651e-14,  4.425521602327303e-16, -1.944002829086499e-18,  8.396378898592787e-21, -3.588773425383340e-23,  1.508457964506967e-25, -6.333249744090998e-28,
  4.867426920549180e-02, -2.300760734270229e-04,  1.435977790013463e-06, -8.712892422212099e-09,  5.017780036692734e-11, -2.773743073080442e-13,  1.485143335695497e-15,
 -7.746521229996834e-18,  3.951449255690558e-20, -1.976677263009571e-22,  9.718590112005259e-25, -4.704412897306996e-27,  3.258049614547870e-02, -2.104335111894992e-04,
  1.717862839088042e-06, -1.266819301162300e-08,  8.693033744140402e-11, -5.667635025847845e-13,  3.548900427784679e-15, -2.148310907162156e-17,  1.263544196681299e-19,
 -7.245801733942664e-22,  4.064174535197671e-24, -2.234007186173371e-26,  1.906687410476501e-02, -1.677127094576763e-04,  1.692057786126763e-06, -1.479176543943851e-08,
  1.190015415636993e-10, -9.007411868798152e-13,  6.492040878878132e-15, -4.491643469582210e-17,  3.001427080949604e-19, -1.945707454726516e-21,  1.228165625993572e-23,
 -7.568593145482013e-26,  9.751730316983129e-03, -1.147084460134679e-04,  1.386717238561287e-06, -1.420156176493857e-08,  1.324170118713276e-10, -1.149979458757461e-12,
  9.433575317584171e-15, -7.380923014520618e-17,  5.547358869020638e-19, -4.026173579265010e-21,  2.833664934210500e-23, -1.940189335575453e-25,  4.356578420079180e-03,
 -6.705294952350286e-05,  9.555881391525604e-07, -1.137168507469348e-08,  1.217661374417443e-10, -1.202689141364762e-12,  1.113759664544599e-14, -9.778671702351277e-17,
  8.205744881377064e-19, -6.620876271312007e-21,  5.160735000849236e-23, -3.900251992712569e-25,  1.699123643356708e-03, -3.350770718443779e-05,  5.578626234614913e-07,
 -7.662525531016217e-09,  9.354912508183476e-11, -1.043934447112565e-12,  1.084648516176189e-14, -1.062425047144316e-16,  9.898919535861382e-19, -8.832059487109110e-21,
  7.585352038016974e-23, -6.296362928682381e-25,  5.781730833906451e-04, -1.433835348730382e-05,  2.773198579301220e-07, -4.371613068605066e-09,  6.051286187385066e-11,
 -7.590777675241742e-13,  8.806894540096359e-15, -9.580860471842884e-17,  9.869382113044670e-19, -9.697528032458158e-21,  9.140725823190605e-23, -8.301777908186608e-25,
  1.715463264256993e-04, -5.264055214337216e-06,  1.178094174608378e-07, -2.121240911242430e-09,  3.314764861540791e-11, -4.655753557131250e-13,  6.009688188352835e-15,
 -7.235981440903424e-17,  8.213765136601047e-19, -8.859976663481542e-21,  9.137590950538409e-23, -9.053463063472389e-25,  4.435609834786420e-05, -1.661111222434426e-06,
  4.288080461489881e-08, -8.784830984710011e-10,  1.544522070256774e-11, -2.421621103336549e-13,  3.467848983549813e-15, -4.608991685121175e-17,  5.750462987103456e-19,
 -6.792827934057133e-21,  7.647266561839286e-23, -8.246899452506362e-25,  9.990345555485651e-06, -4.512845330938357e-07,  1.340101990664300e-08, -3.113979594146013e-10,
  6.143962713458915e-12, -1.072802023571248e-13,  1.700692436571854e-15, -2.489937567025818e-17,  3.407986907678792e-19, -4.400465255075804e-21,  5.398023449548670e-23,
 -6.325103607072979e-25,  1.959558426258154e-06, -1.057186491108229e-07,  3.602557890357555e-09, -9.471781739516086e-11,  2.093054936140059e-12, -4.063033393864224e-14,
  7.118912955345781e-16, -1.146420625460236e-17,  1.718900183035743e-19, -2.422784434992839e-21,  3.234167334936254e-23, -4.112348603792778e-25,  3.347523796662223e-07,
 -2.138959659674041e-08,  8.346274675618923e-10, -2.478194870319819e-11,  6.124485251637609e-13, -1.320063746045571e-14,  2.553456858080593e-16, -4.518319618294706e-18,
  7.414077470804080e-20, -1.139670597471922e-21,  1.654042287495838e-23, -2.280263292750522e-25,  4.983442409729323e-08, -3.744695994009917e-09,  1.669943376408964e-10,
 -5.591792246492177e-12,  1.543941565536951e-13, -3.691945473208504e-15,  7.878662990466746e-17, -1.530885478830936e-18,  2.747508448423669e-20, -4.603348791113274e-22,
  7.259761338199278e-24, -1.084515032483254e-25,  6.473578324501483e-09, -5.686351260217334e-10,  2.893232267165554e-11, -1.091429822337963e-12,  3.364698326269918e-14,
 -8.922258397947789e-16,  2.099836431357901e-17, -4.479112475107699e-19,  8.790069299318431e-21, -1.604847444179194e-22,  2.749533216648263e-24, -4.449786709514270e-26,
  7.355175882093354e-10, -7.513981637501369e-11,  4.355673326177377e-12, -1.849827067967090e-13,  6.365266640429370e-15, -1.871514322295313e-16,  4.857377991316275e-18,
 -1.137443117000196e-19,  2.440885290012514e-21, -4.856349298794549e-23,  9.039052319446300e-25, -1.584792494470087e-26,  7.337503099699427e-11, -8.679924464941389e-12,
  5.725324059442450e-13, -2.736242057001497e-14,  1.050883711347280e-15, -3.426394493794501e-17,  9.809369237833641e-19, -2.522341730869601e-20,  5.920481862360875e-22,
 -1.283971868158667e-23,  2.596946829184703e-25, -4.933724625385471e-27,  6.465446931349557e-12, -8.822705540027475e-13,  6.614868800281733e-14, -3.556750259833950e-15,
  1.524871271314338e-16, -5.515268703878027e-18,  1.742398717414944e-19, -4.922005658093830e-21,  1.264236881841745e-22, -2.989878793727901e-24,  6.574071515687977e-26,
 -1.353844955619432e-27,  5.077124562213337e-13, -7.964561418092456e-14,  6.780978307839786e-15, -4.101520250259775e-16,  1.963433402951734e-17, -7.881233801297164e-19,
  2.749057474982559e-20, -8.536012600986662e-22,  2.400592707122051e-23, -6.194471935437908e-25,  1.481416197158908e-26, -3.308494004388401e-28,  3.599776963731166e-14,
 -6.470362040313078e-15,  6.249290701037809e-16, -4.251413830125570e-17,  2.273003758294831e-18, -1.013007392300689e-19,  3.903379702313091e-21, -1.333006805225271e-22,
  4.106906182378172e-24, -1.156889062645983e-25,  3.010713211333782e-27, -7.295053803636475e-29,  2.348178601169555e-15, -4.819488749048362e-16,  5.273941200898951e-17,
 -4.033867798028831e-18,  2.408790889812792e-19, -1.192212455737567e-20,  5.076596881064440e-22, -1.907451859177878e-23,  6.440560938542414e-25, -1.981296407458111e-26,
  5.612699886306139e-28, -1.475873586504714e-29,  1.447287516943715e-16, -3.378528487372802e-17,  4.181431250816187e-18, -3.592588355010177e-19,  2.394973688079240e-20,
 -1.316149759026468e-21,  6.192643728985256e-23, -2.559944658353731e-24,  9.472777135951567e-26, -3.182244683808859e-27,  9.812217708897865e-29, -2.799646375359105e-30,
  8.747621335753626e-18, -2.311084542356186e-18,  3.226152873047919e-19, -3.107908772260053e-20,  2.309890376052868e-21, -1.407921659481042e-22,  7.313087693326705e-24,
 -3.323259154676541e-25,  1.346598978660586e-26, -4.936027685869550e-28,  1.655266062202783e-29, -5.120215678353920e-31,  5.454636751445353e-19, -1.620248257177223e-19,
  2.539988834559132e-20, -2.734268799037408e-21,  2.259186963871603e-22, -1.523429893339833e-23,  8.715393056189508e-25, -4.344171204590091e-26,  1.923493486395301e-27,
 -7.677418247524144e-29,  2.794302250499369e-30, -9.351584387008352e-32,  3.751463264703691e-20, -1.241624114594333e-20,  2.170970911311084e-21, -2.596318021381582e-22,
  2.372408950174128e-23, -1.761382556877799e-24,  1.104833286174080e-25, -6.014520449957558e-27,  2.897944674552158e-28, -1.254429685839243e-29,  4.935803081699018e-31,
 -1.780209013648880e-32,  3.090918903810095e-21, -1.125927201506673e-21,  2.173071906843325e-22, -2.860247146000605e-23,  2.865434403884076e-24, -2.323325721820295e-25,
  1.585519873369533e-26, -9.357173128483980e-28,  4.871281818857877e-29, -2.271102724291224e-30,  9.596090487069397e-32, -3.705743316965626e-33,  3.336617204579065e-22,
 -1.316052892454565e-22,  2.761763491982775e-23, -3.944720767931678e-24,  4.275421283549667e-25, -3.738225758052061e-26,  2.742254063141094e-27, -1.734326447800366e-28,
  9.647509700231188e-30, -4.792888442214384e-31,  2.152340735820645e-32, -8.810851496590887e-34,  5.017375273096883e-23, -2.098967440747015e-23,  4.691804517125746e-24,
 -7.130254654243384e-25,  8.204693739101718e-26, -7.598004195625944e-27,  5.889040253183871e-28, -3.926028414115437e-29,  2.296938523408805e-30, -1.197609975151459e-31,
  5.632899134179172e-33, -2.410218642857064e-34,  9.213919588518578e-24, -3.988841615534442e-24,  9.254881440645950e-25, -1.459174078703300e-25,  1.739823615297984e-26,
 -1.667147628556323e-27,  1.335151738136187e-28, -9.184258524932020e-30,  5.536814397994240e-31, -2.970893650916046e-32,  1.436258162245511e-33, -6.308826856544894e-35,
  7.182838010519377e-02, -2.136098106402479e-04,  6.588984820176468e-07, -2.097590327184923e-09,  6.831466415170297e-12, -2.269292385093902e-14,  7.577420298090403e-17,
 -2.581284292108482e-19,  8.558983370638301e-22, -3.043885260939641e-24,  9.171572085942445e-27, -4.043879864028203e-29,  6.270293013725110e-02, -2.200021191414392e-04,
  9.488446356574718e-07, -4.345215681957541e-09,  1.984885781945860e-11, -8.907589454803497e-14,  3.916954316035191e-16, -1.694877909479894e-18,  7.206632024226577e-21,
 -3.037662053279842e-23,  1.255215395211766e-25, -5.218046754122536e-28,  4.777629710443219e-02, -2.189932309642700e-04,  1.336063160491941e-06, -7.952562136478173e-09,
  4.496989100164001e-11, -2.441971306440014e-13,  1.284924692208123e-15, -6.588798000079138e-18,  3.305105673658113e-20, -1.626347108818312e-22,  7.867515375484021e-25,
 -3.747881060443527e-27,  3.176531740560709e-02, -1.972758690868400e-04,  1.573830222304013e-06, -1.136355860392472e-08,  7.640034277079129e-11, -4.883743458673352e-13,
  3.000271763083024e-15, -1.782757575341717e-17,  1.029735270993277e-19, -5.800804679909622e-22,  3.197648243481166e-24, -1.727588739092227e-26,  1.842201597563128e-02,
 -1.548551996628912e-04,  1.525412558935301e-06, -1.302380261821134e-08,  1.024482834276707e-10, -7.590002984403028e-13,  5.358954538389475e-15, -3.634392865604534e-17,
  2.381926748409780e-19, -1.515066106084989e-21,  9.387714904213472e-24, -5.680469178906201e-26,  9.314053330215158e-03, -1.042620370376720e-04,  1.228289554857279e-06,
 -1.225525312266815e-08,  1.115239072325852e-10, -9.464941271244548e-13,  7.595116953865676e-15, -5.817366249991345e-17,  4.282944149493451e-19, -3.046602129049530e-21,
  2.102575002673082e-23, -1.412195221756148e-25,  4.102836245625843e-03, -5.992270304862680e-05,  8.300683168208656e-07, -9.602213945420065e-09,  1.001780471772313e-10,
 -9.654827428164326e-13,  8.734011076754833e-15, -7.497484090978857e-17,  6.155867717928779e-19, -4.862840281502031e-21,  3.713021499093828e-23, -2.750132494535168e-25,
  1.573470205401148e-03, -2.938866172151643e-05,  4.742472355447811e-07, -6.319575821869141e-09,  7.504995912468567e-11, -8.160109558090730e-13,  8.271248462779946e-15,
 -7.911782782328034e-17,  7.204769655787207e-19, -6.287177275813560e-21,  5.284423471923162e-23, -4.295102137988277e-25,  5.249463490824649e-04, -1.231425602008252e-05,
  2.302035986905613e-07, -3.514227319364789e-09,  4.724482883140087e-11, -5.766342324660535e-13,  6.518564509417261e-15, -6.917242105195380e-17,  6.956962965593757e-19,
 -6.679325784185632e-21,  6.155881610326815e-23, -5.469910211063892e-25,  1.522256978316955e-04, -4.415043253814458e-06,  9.525304462696226e-08, -1.658172928055418e-09,
  2.512853985884582e-11, -3.429569397995219e-13,  4.308251387795255e-15, -5.054486144596297e-17,  5.596196742503481e-19, -5.892897473101896e-21,  5.937435640900675e-23,
 -5.750969069318953e-25,  3.833646181090220e-05, -1.356371616912686e-06,  3.367545506597062e-08, -6.659874952160979e-10,  1.133958951061886e-11, -1.725470617685338e-13,
  2.402020156652785e-15, -3.107508270499321e-17,  3.778129316729756e-19, -4.353105356250148e-21,  4.783910335834705e-23, -5.039759326220196e-25,  8.378118603761330e-06,
 -3.575020685669874e-07,  1.018984547981301e-08, -2.282582948091230e-10,  4.355850981112517e-12, -7.373016902916452e-14,  1.135055393367087e-15, -1.616072230042057e-17,
  2.153594900452609e-19, -2.710168101433198e-21,  3.242985104952339e-23, -3.709620266017206e-25,  1.587855498627609e-06, -8.093155700785548e-08,  2.642794988467046e-09,
 -6.690039329197064e-11,  1.428201536346897e-12, -2.684783106364529e-14,  4.563822536061605e-16, -7.141141029962293e-18,  1.041665015026295e-19, -1.429923198652779e-21,
  1.860749685936062e-23, -2.308373166034450e-25,  2.608758169670777e-07, -1.575362159931873e-08,  5.882984056342690e-10, -1.680053886121476e-11,  4.007110499681272e-13,
 -8.356191041986681e-15,  1.566879536985018e-16, -2.691922735014442e-18,  4.294336483299817e-20, -6.424880857008698e-22,  9.084697922161833e-24, -1.221273518206149e-25,
  3.715522250496721e-08, -2.640162109018414e-09,  1.125748703765284e-10, -3.622423976781532e-12,  9.644708263932271e-14, -2.229611973963929e-15,  4.609064043795451e-17,
 -8.689639939345637e-19,  1.515296826909708e-20, -2.469731648307832e-22,  3.792880371568862e-24, -5.522815451724832e-26,  4.590339530027700e-09, -3.816105460032286e-10,
  1.855469328957834e-11, -6.722062280569018e-13,  1.997031330133393e-14, -5.116430238454355e-16,  1.165795392101187e-17, -2.411616285175125e-19,  4.596322827649330e-21,
 -8.160045490979943e-23,  1.360918160733174e-24, -2.146115780377166e-26,  4.927055954870377e-10, -4.769036177164503e-11,  2.641326938466756e-12, -1.076911818526991e-13,
  3.569607486328193e-15, -1.013622219473096e-16,  2.546050289685871e-18, -5.779993732685716e-20,  1.204251887454536e-21, -2.329206823896035e-23,  4.219293688780778e-25,
 -7.206955165263707e-27,  4.608036322689950e-11, -5.172044520811774e-12,  3.260234176042360e-13, -1.495782229307343e-14,  5.533055478047605e-16, -1.742038585505040e-17,
  4.825883146026542e-19, -1.202856793038185e-20,  2.740895444173971e-22, -5.778099683818993e-24,  1.137340572771147e-25, -2.105030513994180e-27,  3.773544144298522e-12,
 -4.894387788486070e-13,  3.509166966672202e-14, -1.811939263309709e-15,  7.483463256677798e-17, -2.613990906062654e-18,  7.991896039728541e-20, -2.188610480541643e-21,
  5.458017414748800e-23, -1.254920690079130e-24,  2.685752827407178e-26, -5.389370900820548e-28,  2.726650736136305e-13, -4.074440292519483e-14,  3.321060168755975e-15,
 -1.930479539085015e-16,  8.907719561392631e-18, -3.454808532275752e-19,  1.166729015287733e-20, -3.513562420638390e-22,  9.597778703476153e-24, -2.408758685096641e-25,
  5.609431849780081e-27, -1.221235440424337e-28,  1.758903034371070e-14, -3.019623245025407e-15,  2.796797663203290e-16, -1.830823838387236e-17,  9.444853168976534e-19,
 -4.070843684138679e-20,  1.519965379047563e-21, -5.038213159525601e-23,  1.508868833041879e-24, -4.137054754829595e-26,  1.049166382742522e-27, -2.480009273572911e-29,
  1.030736795789128e-15, -2.027174944595881e-16,  2.132207805322117e-17, -1.572179544099142e-18,  9.073047500936269e-20, -4.349166327552073e-21,  1.796888201436128e-22,
 -6.561394005760404e-24,  2.156150226093906e-25, -6.463557387985504e-27,  1.786329296282479e-28, -4.587469074311927e-30,  5.628441810174707e-17, -1.263981082466693e-17,
  1.508164865174180e-18, -1.252333425727361e-19,  8.086526449162927e-21, -4.312743775477943e-22,  1.972638436095799e-23, -7.939208829163155e-25,  2.864063598477017e-26,
 -9.391262189687510e-28,  2.829574251011576e-29, -7.897144531559413e-31,  2.970376490983056e-18, -7.584786876029647e-19,  1.024653932214060e-19, -9.571782211961859e-21,
  6.911413590734025e-22, -4.099592307697684e-23,  2.075427160300307e-24, -9.204626245151789e-26,  3.644593611161203e-27, -1.306900199874647e-28,  4.291709148938008e-30,
 -1.301273294486386e-31,  1.594734869217615e-19, -4.603234253786330e-20,  7.016205555949556e-21, -7.354590703468546e-22,  5.926278618630086e-23, -3.902854623307321e-24,
  2.183432571274215e-25, -1.065528221018511e-26,  4.624038856588713e-28, -1.810702034108852e-29,  6.471429643358766e-31, -2.128548133192572e-32,  9.339242306017124e-21,
 -3.022003640542002e-21,  5.165661731230462e-22, -6.045819271150109e-23,  5.412754721151638e-24, -3.941848632248529e-25,  2.427797695450355e-26, -1.298982599982921e-27,
  6.156919236495441e-29, -2.623890050677158e-30,  1.017212085016191e-31, -3.617390963677540e-33,  6.524947107288256e-22, -2.338739466452608e-22,  4.439638138760667e-23,
 -5.751233441667596e-24,  5.675186237651666e-25, -4.536062789829531e-26,  3.053862774548367e-27, -1.779260649197525e-28,  9.150442582414636e-30, -4.217026090819193e-31,
  1.762311663016006e-32, -6.734784272940596e-34,  6.022847154319467e-23, -2.352064231702575e-23,  4.884612485243159e-24, -6.906713409552568e-25,  7.413957099059282e-26,
 -6.423395672680129e-27,  4.671326514786167e-28, -2.930159901868251e-29,  1.617284188617425e-30, -7.975356392883772e-32,  3.556357530388273e-33, -1.446140602590477e-34,
  7.954369118514080e-24, -3.311854615550079e-24,  7.365360819867647e-25, -1.113782490446768e-25,  1.275526135441483e-26, -1.175860912374759e-27,  9.074590404614406e-29,
 -6.024967447412860e-30,  3.511213006810970e-31, -1.823947972708818e-32,  8.548619535722678e-34, -3.645560263252059e-35,  1.345914074360443e-24, -5.818104184355885e-25,
  1.347739924032924e-25, -2.121534383866477e-26,  2.525673005950601e-27, -2.416571601146586e-28,  1.932570101386506e-29, -1.327555018036631e-30,  7.992746018117973e-32,
 -4.283250625557043e-33,  2.068191762512903e-34, -9.074040226631468e-36,  7.098432640008072e-02, -2.084374828242103e-04,  6.343685550245987e-07, -1.991821325771505e-09,
  6.395223885898841e-12, -2.095807800900216e-14,  6.891406075853611e-17, -2.324255959314761e-19,  7.524990965645293e-22, -2.711994539683658e-24,  7.433611992950658e-27,
 -3.898948472334477e-29,  6.183778038600207e-02, -2.126146656747490e-04,  8.985503592696318e-07, -4.041391008143027e-09,  1.815763336136477e-11, -8.021960086919361e-14,
  3.473096799627725e-16, -1.480836809355137e-18,  6.198171501845729e-21, -2.578717537461422e-23,  1.046013198928340e-25, -4.324184049717922e-28,  4.692111358883084e-02,
 -2.086745774492040e-04,  1.244793615447267e-06, -7.270500521955713e-09,  4.037998238819739e-11, -2.154584619899134e-13,  1.114406547712544e-15, -5.619076326631474e-18,
  2.772508339749423e-20, -1.342284601603821e-22,  6.390287731534528e-25, -2.996428705791133e-27,  3.100055997241506e-02, -1.852106149550935e-04,  1.444491849915795e-06,
 -1.021554391875898e-08,  6.731433372191367e-11, -4.220039853871548e-13,  2.544260139643515e-15, -1.484327615541394e-17,  8.422091953824277e-20, -4.661652410666701e-22,
  2.526191452614377e-24, -1.341601135895807e-26,  1.782604984319662e-02, -1.432502857203724e-04,  1.378482749318455e-06, -1.149941317364408e-08,  8.847624506320156e-11,
 -6.417835669170520e-13,  4.440325037448673e-15, -2.952658649880545e-17,  1.898478447614912e-19, -1.185132023342142e-21,  7.210481458540917e-24, -4.284879114116024e-26,
  8.915767421943237e-03, -9.499501521187368e-05,  1.091338759268934e-06, -1.061293282809385e-08,  9.429250901825757e-11, -7.823047842503108e-13,  6.142732613593343e-15,
 -4.607217957635194e-17,  3.323691840599084e-19, -2.317797183164787e-21,  1.568948009888222e-23, -1.033953150682603e-25,  3.875733380857490e-03, -5.371721128169670e-05,
  7.238566576912564e-07, -8.143128967265198e-09,  8.280536522796537e-11, -7.789841276385158e-13,  6.886095072090102e-15, -5.781250859868161e-17,  4.645790566283860e-19,
 -3.594044863517532e-21,  2.688932825380039e-23, -1.952359900092379e-25,  1.463050494347159e-03, -2.587878370830818e-05,  4.051115415311898e-07, -5.239261393237876e-09,
  6.054802752361963e-11, -6.416747545529290e-13,  6.347404470954816e-15, -5.931030990791542e-17,  5.280343587549979e-19, -4.507975112207283e-21,  3.709105573038846e-23,
 -2.952690584715656e-25,  4.791225535317552e-04, -1.062928390214783e-05,  1.922136339978769e-07, -2.842687276721198e-09,  3.713183328510833e-11, -4.411212666501019e-13,
  4.860394008892224e-15, -5.032557767051862e-17,  4.943176776154066e-19, -4.638557107067977e-21,  4.181140362138238e-23, -3.635752792704546e-25,  1.359725576926753e-04,
 -3.726263278890810e-06,  7.755792348696500e-08, -1.305818580001468e-09,  1.919842797022970e-11, -2.546991754805120e-13,  3.114814647759748e-15, -3.561826673170792e-17,
  3.847565954299277e-19, -3.956275133359677e-21,  3.895292563812249e-23, -3.689334114573032e-25,  3.340320014797596e-05, -1.116094304402710e-06,  2.666771783157378e-08,
 -5.093023472340226e-10,  8.401145772475738e-12, -1.241062313999795e-13,  1.680020570308573e-15, -2.116254681705081e-17,  2.507956855297751e-19, -2.819225520505098e-21,
  3.025160563897070e-23, -3.113996119744541e-25,  7.095336363593587e-06, -2.858580757566792e-07,  7.824651199585287e-09, -1.690223060938043e-10,  3.120680683216214e-12,
 -5.122203391486020e-14,  7.659844259777335e-16, -1.060870175283500e-17,  1.376795727815538e-19, -1.689027634192575e-21,  1.971947673741212e-23, -2.202536206560016e-25,
  1.301828676281384e-06, -6.264919936115070e-08,  1.961135129995648e-09, -4.781146858602136e-11,  9.863426048203004e-13, -1.796029579096348e-14,  2.962776873681663e-16,
 -4.505565545542995e-18,  6.395288063296185e-20, -8.551763869884348e-22,  1.085033667310462e-23, -1.313503244801586e-25,  2.061359208569635e-07, -1.175615752945370e-08,
  4.202431156341865e-10, -1.154491591129656e-11,  2.658072512265971e-13, -5.363985020851713e-15,  9.752067713897933e-17, -1.626992999579281e-18,  2.523775943760881e-20,
 -3.675697721173123e-22,  5.064441684559045e-24, -6.639897201017049e-26,  2.815348148298067e-08, -1.890241824170412e-09,  7.706740463354187e-11, -2.383288912865642e-12,
  6.119756892062471e-14, -1.367890593476238e-15,  2.739566886670860e-17, -5.012198216616298e-19,  8.493346133025660e-21, -1.346788316800679e-22,  2.014359336362285e-24,
 -2.859233609185663e-26,  3.316439864890971e-09, -2.606961988572706e-10,  1.211130510375396e-11, -4.213703732391042e-13,  1.206401889488973e-14, -2.986420475281325e-16,
  6.588365898398458e-18, -1.321813803134625e-19,  2.446812680148068e-21, -4.224228736946540e-23,  6.858395765982207e-25, -1.053908740388097e-26,  3.372126315361900e-10,
 -3.089293514652480e-11,  1.634236070655430e-12, -6.395616934084307e-14,  2.041921562591277e-15, -5.599526870800811e-17,  1.361162442356019e-18, -2.995659731519208e-20,
  6.059624711638875e-22, -1.139346031308994e-23,  2.008612920940618e-25, -3.342407735288835e-27,  2.965385837247085e-11, -3.154227835477973e-12,  1.899131075859177e-13,
 -8.361766261093875e-15,  2.978461885836433e-16, -9.053540722837992e-18,  2.426551801069791e-19, -5.861995799728727e-21,  1.296577770392877e-22, -2.656665872523765e-24,
  5.088542264944784e-26, -9.174246804581315e-28,  2.263788410840246e-12, -2.787103574177380e-13,  1.909544914296999e-14, -9.463641345543245e-16,  3.763816271674145e-17,
 -1.269285332535863e-18,  3.754480352134496e-20, -9.965167286893506e-22,  2.412299907295460e-23, -5.391065959023156e-25,  1.122801349311641e-26, -2.194949010398098e-28,
  1.509879148946365e-13, -2.145999491182925e-14,  1.673057927875449e-15, -9.339699308599159e-17,  4.151639330508816e-18, -1.555062540762878e-19,  5.082362748205308e-21,
 -1.483822360632713e-22,  3.935580802282570e-24, -9.603319579683955e-26,  2.177006902816568e-27, -4.618836858794130e-29,  8.888819508163289e-15, -1.455116369730351e-15,
  1.290965960655971e-16, -8.124414474412235e-18,  4.041059501647084e-19, -1.683355641887133e-20,  6.086818746667614e-22, -1.957267701207331e-23,  5.695080227658936e-25,
 -1.519138556113074e-26,  3.752589117760801e-28, -8.649736993420890e-30,  4.692568180072870e-16, -8.827662863380990e-17,  8.912536119683823e-18, -6.328186287520744e-19,
  3.526069066744857e-20, -1.635595848228806e-21,  6.551726376782589e-23, -2.323379204619285e-24,  7.425603261212299e-26, -2.167823601708699e-27,  5.841549197557645e-29,
 -1.464306620190493e-30,  2.275141331282260e-17, -4.905715993885743e-18,  5.634480622374056e-19, -4.515937530824182e-20,  2.821256708935834e-21, -1.458734347737924e-22,
  6.480178976560842e-24, -2.536978610783711e-25,  8.915195514627982e-27, -2.851202504467902e-28,  8.388362940403123e-30, -2.288456946185341e-31,  1.049494483273434e-18,
 -2.584919700763473e-19,  3.373773467739689e-20, -3.051604153966049e-21,  2.137895227614286e-22, -1.232630623516084e-23,  6.075367436238106e-25, -2.627055089173951e-26,
  1.015482858629986e-27, -3.559066231891597e-29,  1.143559961507659e-30, -3.396025504637116e-32,  4.847951375020137e-20, -1.357150073754298e-20,  2.007700669053091e-21,
 -2.046100636408645e-22,  1.605656635081625e-23, -1.031394248931076e-24,  5.635856418883865e-26, -2.689748465421037e-27,  1.142861366790413e-28, -4.386316204470816e-30,
  1.537984702601650e-31, -4.967431846480684e-33,  2.409882724559709e-21, -7.609849738212643e-22,  1.269534789846955e-22, -1.451895895250710e-23,  1.271811849492740e-24,
 -9.073242805809221e-26,  5.480578051985825e-27, -2.878865328744965e-28,  1.340915683631782e-29, -5.620647766124422e-31,  2.144905997060048e-32, -7.514279744437178e-34,
  1.418954201439720e-22, -4.996868361359124e-23,  9.316168339095759e-24, -1.186186483823161e-24,  1.151507137491830e-25, -9.062473784984992e-27,  6.012611975238226e-28,
 -3.454926287124470e-29,  1.753645622334271e-30, -7.981758594257168e-32,  3.296390802249881e-33, -1.245677954147035e-34,  1.110067124569863e-23, -4.287693903806247e-24,
  8.802802921715761e-25, -1.230974726964145e-25,  1.307518826980705e-26, -1.121559004071077e-27,  8.079561905895585e-29, -5.022807840604917e-30,  2.748861539540044e-31,
 -1.344677097383573e-32,  5.950481400734524e-34, -2.402199629167836e-35,  1.275052484881468e-24, -5.280816508555608e-25,  1.167819510136664e-25, -1.756295976548616e-26,
  2.000813271974405e-27, -1.835289686472899e-28,  1.409668091823002e-29, -9.317309251797384e-31,  5.406770400017388e-32, -2.797249184973367e-33,  1.305990137114853e-34,
 -5.549058683942446e-36,  1.973150750697053e-25, -8.515781558166214e-26,  1.969173192272692e-26, -3.094368844280487e-27,  3.677628004318621e-28, -3.513073509393838e-29,
  2.805100237627096e-30, -1.924062427547453e-31,  1.156759111915965e-32, -6.190506228175861e-34,  2.985199690089729e-35, -1.308089811471087e-36,  7.016057740173179e-02,
 -2.034564335899828e-04,  6.110670934394045e-07, -1.892763337016252e-09,  5.992088246142358e-12, -1.937960275755477e-14,  6.272897602739250e-17, -2.098537105230389e-19,
  6.598044338662234e-22, -2.449188164823818e-24,  5.694553731092049e-27, -4.068448056650970e-29,  6.100139819872896e-02, -2.056154297524842e-04,  8.517452845018613e-07,
 -3.763264823724794e-09,  1.663334942295264e-11, -7.236014694006312e-14,  3.084890183068415e-16, -1.296577079277900e-18,  5.340764457776107e-21, -2.196152678621272e-23,
  8.719762271349922e-26, -3.614641114347289e-28,  4.610579450455361e-02, -1.990545475095281e-04,  1.161286450218575e-06, -6.657492716947216e-09,  3.632602645633899e-11,
 -1.905047553633506e-13,  9.688005375751804e-16, -4.804502580647466e-18,  2.332288503403895e-20, -1.111195566917013e-22,  5.207279602987416e-25, -2.403895557661410e-27,
  3.028207803018633e-02, -1.741273373361504e-04,  1.328099349918841e-06, -9.202853522521509e-09,  5.945272246619177e-11, -3.656393767845407e-13,  2.163989126862026e-15,
 -1.239831371079122e-17,  6.912411224205945e-20, -3.759965366597308e-22,  2.003745806371619e-24, -1.046027855169199e-26,  1.727426320339015e-02, -1.327512692591694e-04,
  1.248577950162000e-06, -1.018095766787873e-08,  7.664267298842677e-11, -5.444877289261470e-13,  3.692595012869863e-15, -2.408191379097812e-17,  1.519505073870783e-19,
 -9.311440831996007e-22,  5.564335456890390e-24, -3.247854058811489e-26,  8.552476901934605e-03, -8.674921750610062e-05,  9.725441234924132e-07, -9.221829257039515e-09,
  8.002207669181874e-11, -6.492305860752272e-13,  4.989883703096238e-15, -3.665866060813057e-17,  2.592086631401305e-19, -1.772534321706916e-21,  1.177186715171501e-23,
 -7.613385964807320e-26,  3.671857670925179e-03, -4.829583348293395e-05,  6.336019482247986e-07, -6.934422728850899e-09,  6.875542720418389e-11, -6.315754570921747e-13,
  5.457413381520480e-15, -4.482426792021477e-17,  3.526487178060199e-19, -2.672427633121608e-21,  1.959652162728475e-23, -1.395136860631036e-25,  1.365640989319012e-03,
 -2.287383109996637e-05,  3.476548574704520e-07, -4.365416005153754e-09,  4.911266065668422e-11, -5.074962504213611e-13,  4.900781277376705e-15, -4.474706751586771e-17,
  3.895933000361809e-19, -3.254878224108234e-21,  2.622316229343214e-23, -2.045103853956981e-25,  4.394782155687868e-04, -9.218555542375076e-06,  1.613941971911847e-07,
 -2.313268202767098e-09,  2.937038681742025e-11, -3.397372381450581e-13,  3.649760289359682e-15, -3.688531888365030e-17,  3.539403300041815e-19, -3.247068378234680e-21,
  2.863340978579884e-23, -2.437201256766290e-25,  1.222160822231801e-04, -3.163619551814301e-06,  6.357533541062894e-08, -1.035649523145526e-09,  1.477788639392988e-11,
 -1.906416686028428e-13,  2.270435933569028e-15, -2.531326550973418e-17,  2.668608182589088e-19, -2.680207013439820e-21,  2.579396663910089e-23, -2.389452342352402e-25,
  2.932979355223691e-05, -9.250893090014643e-07,  2.128727228452471e-08, -3.927365407271934e-10,  6.278546747373636e-12, -9.007552377874599e-14,  1.186089820022352e-15,
 -1.455181576574682e-17,  1.681425821872733e-19, -1.844541634060563e-21,  1.933077171149080e-23, -1.944746889868543e-25,  6.065356080691419e-06, -2.305969471561094e-07,
  6.065141986977812e-09, -1.263808044348426e-10,  2.258368681514940e-12, -3.595625824443206e-14,  5.224648498177130e-16, -7.040730623324509e-18,  8.901052044602516e-20,
 -1.064753498193432e-21,  1.213156709275295e-23, -1.323369693549225e-25,  1.079322053384327e-06, -4.901177044472079e-08,  1.471376155864594e-09, -3.455635756982648e-11,
  6.891092189758811e-13, -1.215795739322314e-14,  1.946820704178219e-16, -2.878025391718365e-18,  3.976086793111639e-20, -5.180315518166820e-22,  6.409792649958392e-24,
 -7.573282986805746e-26,  1.650500418626346e-07, -8.883466792631941e-09,  3.040546331244336e-10, -8.037061539815031e-12,  1.786669217414830e-13, -3.489857231589559e-15,
  6.153090586481973e-17, -9.970878471241318e-19,  1.504228377199399e-20, -2.133049473603671e-22,  2.864257454804063e-24, -3.663000678966332e-26,  2.166548725417287e-08,
 -1.373323443174623e-09,  5.354399316302780e-11, -1.591537782851342e-12,  3.941950869482015e-14, -8.520718417130355e-16,  1.653572634979078e-17, -2.936250417774897e-19,
  4.835713648592460e-21, -7.461180726319884e-23,  1.086968861534634e-24, -1.504182000158805e-26,  2.439509303271899e-09, -1.811539002902131e-10,  8.040641000939692e-12,
 -2.686530562958720e-13,  7.412985135576555e-15, -1.773226585463808e-16,  3.787915153593749e-18, -7.371176268688784e-20,  1.325350441900652e-21, -2.225229348437351e-23,
  3.517347151161337e-25, -5.267217259215722e-27,  2.356128551200100e-10, -2.040839218612842e-11,  1.030885257066686e-12, -3.871983758097273e-14,  1.190650724311899e-15,
 -3.153155848923990e-17,  7.417725565088550e-19, -1.582621771464563e-20,  3.108107050452266e-22, -5.681025111492153e-24,  9.747122317912961e-26, -1.580115244929387e-27,
  1.953858056860428e-11, -1.967225551391643e-12,  1.130803900759950e-13, -4.776750457211348e-15,  1.638111453725874e-16, -4.806667212188117e-18,  1.246291064189444e-19,
 -2.917783439366024e-21,  6.263874722282842e-23, -1.247358808734070e-24,  2.324681940787536e-26, -4.082385729050286e-28,  1.394809899316527e-12, -1.627873362306206e-13,
  1.065061440258898e-14, -5.064008156716911e-16,  1.938776595854238e-17, -6.310563131836171e-19,  1.805513378546604e-20, -4.643651829999353e-22,  1.090942273864153e-23,
 -2.369337331197727e-25,  4.801274410030161e-27, -9.142226623285018e-29,  8.614806344390316e-14, -1.162875227698078e-14,  8.663630849904898e-16, -4.641663447938073e-17,
  1.986651373289497e-18, -7.183424748137344e-20,  2.271196828996766e-21, -6.426268031192773e-23,  1.654435684818097e-24, -3.923925103884190e-26,  8.656577165454179e-28,
 -1.789327001308260e-29,  4.643410180190861e-15, -7.236232682684960e-16,  6.142646692015502e-17, -3.713232614772420e-18,  1.779515728726599e-19, -7.159907281469606e-21,
  2.505816258958734e-22, -7.812838247194231e-24,  2.207655229743028e-25, -5.726595610543647e-27,  1.377304449001722e-28, -3.094505371009403e-30,  2.215044320429972e-16,
 -3.978474580537011e-17,  3.850446760864987e-18, -2.629829669618230e-19,  1.413521722135799e-20, -6.339722321399132e-22,  2.460362779436281e-23, -8.467652042709869e-25,
  2.630471876813282e-26, -7.474321079635785e-28,  1.962679542543786e-29, -4.799718169154840e-31,  9.559553823430988e-18, -1.975224151932656e-18,  2.180434442403280e-19,
 -1.684615013311196e-20,  1.017094472257084e-21, -5.093335715334929e-23,  2.195506963270318e-24, -8.354110332985201e-26,  2.857479709711553e-27, -8.906700477569606e-29,
  2.556911736486394e-30, -6.814123007944177e-32,  3.860385080715162e-19, -9.152317261193979e-20,  1.152106603498742e-20, -1.007537806102701e-21,  6.839687816771025e-23,
 -3.828628145681862e-24,  1.835212916226570e-25, -7.729421578436302e-27,  2.914109399951257e-28, -9.973761741609939e-30,  3.132978753309029e-31, -9.105464597220546e-33,
  1.534120924116523e-20, -4.156387176479504e-21,  5.957090778232376e-22, -5.893048160252740e-23,  4.497211368900737e-24, -2.813959821188347e-25,  1.500054493647750e-26,
 -6.993576648510330e-28,  2.906382631405523e-29, -1.092229972082937e-30,  3.753733401276516e-32, -1.189488174562307e-33,  6.456192460339580e-22, -1.985633639661990e-22,
  3.227250707982197e-23, -3.600701222034739e-24,  3.081502243852585e-25, -2.150681030468033e-26,  1.272480333768825e-27, -6.554630663645720e-29,  2.996950420231340e-30,
 -1.234319671775682e-31,  4.632250688605090e-33, -1.597263244015112e-34,  3.185085721183526e-23, -1.100158310225076e-23,  2.011347920754326e-24, -2.513493163774740e-25,
  2.397221426227348e-26, -1.855391788749392e-27,  1.211721748975393e-28, -6.859670918072098e-30,  3.433022425881094e-31, -1.541782621324554e-32,  6.287077625959899e-34,
 -2.347398458316835e-35,  2.092844941625655e-24, -7.986040993639010e-25,  1.618988128079528e-25, -2.236603950525148e-26,  2.348398506503408e-27, -1.992509578661301e-28,
  1.420625377830401e-29, -8.745710770958515e-31,  4.742258700385440e-32, -2.299564490619634e-33,  1.009187073857914e-34, -4.042146150444051e-36,  2.068877757217399e-25,
 -8.518334277932273e-26,  1.872031728025747e-26, -2.798312238289509e-27,  3.169469141912612e-28, -2.891303890417282e-29,  2.209224847312914e-30, -1.453002140424489e-31,
  8.392245629295494e-33, -4.322557123975796e-34,  2.009633613353514e-35, -8.504718652817701e-37,  2.904172368556014e-26, -1.251170334144473e-26,  2.887593328315935e-27,
 -4.528938621341238e-28,  5.372702234054040e-29, -5.123244693991819e-30,  4.083868083116569e-31, -2.796659288892431e-32,  1.678767792301012e-33, -8.970772115032543e-35,
  4.319764852518899e-36, -1.890316685238395e-37,  6.935638715363598e-02, -1.986571485699454e-04,  5.889166429385826e-07, -1.799910818846150e-09,  5.619087187170724e-12,
 -1.794231231299535e-14,  5.713570226954042e-17, -1.901103221808046e-19,  5.752894392516904e-22, -2.258703105518185e-24,  3.782182901624887e-27, -4.726008595820208e-29,
  6.019228464156001e-02, -1.989776873507715e-04,  8.081364206122914e-07, -3.508318591878406e-09,  1.525734000516100e-11, -6.537345540666491e-14,  2.744632911704580e-16,
 -1.137679344560584e-18,  4.609257993093768e-21, -1.877444855434598e-23,  7.255558371969363e-26, -3.066289741248664e-28,  4.532766450576444e-02, -1.900742164596247e-04,
  1.084762073807242e-06, -6.105538006139242e-09,  3.273796754653591e-11, -1.687870772893424e-13,  8.441492452838901e-16, -4.118353097969250e-18,  1.967335788899157e-20,
 -9.225989474093835e-23,  4.256672692646660e-25, -1.934982794374268e-27,  2.960614097307753e-02, -1.639286463721768e-04,  1.223140075688254e-06, -8.307404111450829e-09,
  5.263241360741308e-11, -3.176314939358839e-13,  1.845874338969405e-15, -1.038830394728184e-17,  5.692658056291610e-20, -3.043391781512346e-22,  1.595668018695409e-24,
 -8.185906287483391e-27,  1.676248999847212e-02, -1.232312822559542e-04,  1.133419786916251e-06, -9.037197549441378e-09,  6.658723702546304e-11, -4.634370228143723e-13,
  3.081626712976071e-15, -1.971552554834243e-17,  1.221137935505292e-19, -7.347079177813797e-22,  4.313813894564953e-24, -2.473199677473800e-26,  8.220369357499906e-03,
 -7.939069254051090e-05,  8.691559622954814e-07, -8.039178967201699e-09,  6.815650043584048e-11, -5.409092561433811e-13,  4.070585609158512e-15, -2.930025164351974e-17,
  2.031238693902312e-19, -1.362378884818273e-21,  8.879616827146689e-24, -5.636857421482039e-26,  3.488310144209283e-03, -4.354208450060555e-05,  5.565944956797114e-07,
 -5.928676372396108e-09,  5.733826768700320e-11, -5.144670819336410e-13,  4.346870189280145e-15, -3.493877875604672e-17,  2.691874011107582e-19, -1.998804726412065e-21,
  1.436943138574165e-23, -1.003300398756315e-25,  1.279394263101033e-03, -2.028950545622897e-05,  2.996693283702800e-07, -3.654824181448227e-09,  4.004428310232332e-11,
 -4.036051903924667e-13,  3.806133243132476e-15, -3.396882258923367e-17,  2.893143300300873e-19, -2.365999864248328e-21,  1.867000820633076e-23, -1.426794371002940e-25,
  4.050211264965795e-04, -8.030937227605489e-06,  1.362448190020665e-07, -1.893270116245573e-09,  2.337411191026439e-11, -2.633572072521384e-13,  2.759425837535797e-15,
 -2.722788174472043e-17,  2.553154661821253e-19, -2.290563854868654e-21,  1.976555463486125e-23, -1.647227074029450e-25,  1.105054155320395e-04, -2.700980130403777e-06,
  5.244936603269457e-08, -8.269700564484552e-10,  1.145718030701725e-11, -1.437740075215241e-13,  1.668021769082033e-15, -1.813727782617854e-17,  1.866628256991100e-19,
 -1.831650262895837e-21,  1.723459579238398e-23, -1.561923490793977e-25,  2.594242701549378e-05, -7.720622321367058e-07,  1.712238067685433e-08, -3.052735465424124e-10,
  4.731594367771497e-12, -6.594718285195526e-14,  8.449585113702145e-16, -1.009974392359190e-17,  1.138153106464083e-19, -1.218783343772717e-21,  1.247778138142966e-23,
 -1.227149432883276e-25,  5.231205976206599e-06, -1.875783515179306e-07,  4.743681357000427e-09, -9.538027258297764e-11,  1.650191181037936e-12, -2.549325665980398e-14,
  3.600457509999910e-16, -4.722351280589025e-18,  5.817177713136270e-20, -6.786840749990255e-22,  7.548238871446828e-24, -8.043435243614753e-26,  9.044328837713763e-07,
 -3.872898564057667e-08,  1.115583350076406e-09, -2.524703445579491e-11,  4.868222938414194e-13, -8.324440547368270e-15,  1.294249662551189e-16, -1.860438063552290e-18,
  2.502246929613429e-20, -3.177108761527169e-22,  3.834519734652922e-24, -4.422711838363290e-26,  1.338324501524970e-07, -6.793038017424315e-09,  2.226947556615358e-10,
 -5.665129014871306e-12,  1.216294467860817e-13, -2.300120533836283e-15,  3.933807526752029e-17, -6.192965946741416e-19,  9.088301178882417e-21, -1.255020196641850e-22,
  1.642700758643400e-24, -2.049512467936325e-26,  1.692153098909146e-08, -1.011810965877091e-09,  3.773034776423170e-11, -1.078104343541543e-12,  2.576154019030485e-14,
 -5.385975691356636e-16,  1.012990440340204e-17, -1.746111767703611e-19,  2.795280065478473e-21, -4.197232517410349e-23,  5.956678348965392e-25, -8.037351960859544e-27,
  1.825654115593618e-09, -1.279483902252139e-10,  5.425689347619142e-12, -1.741016002340601e-13,  4.630400962341911e-15, -1.070406553210992e-16,  2.214328720189294e-18,
 -4.179932688921388e-20,  7.300805138282496e-22, -1.192210623506205e-23,  1.834831234147588e-25, -2.677818906341893e-27,  1.679318563757570e-10, -1.373832256381229e-11,
  6.625043032187489e-13, -2.387982978990661e-14,  7.072457641117433e-16, -1.808782927256458e-17,  4.118035938962803e-19, -8.517923200611583e-21,  1.624169107385983e-22,
 -2.885988180187312e-24,  4.819068381303793e-26, -7.610825035663148e-28,  1.317038212224321e-11, -1.253683124010433e-12,  6.877215544253426e-14, -2.786499436107222e-15,
  9.198661904984011e-17, -2.605292791735768e-18,  6.534368233473073e-20, -1.482475489401106e-21,  3.088799946576897e-23, -5.977565261638688e-25,  1.083897688970615e-26,
 -1.853904363979405e-28,  8.819331736405104e-13, -9.744181031100265e-14,  6.084230635542410e-15, -2.774220221297373e-16,  1.022138802260519e-17, -3.210394587895283e-19,
  8.882748356802410e-21, -2.213372025676447e-22,  5.045705339370676e-24, -1.064786262354301e-25,  2.099081446275978e-27, -3.892561498482760e-29,  5.060711235658993e-14,
 -6.478075178362185e-15,  4.608201719071042e-16, -2.368084110533835e-17,  9.754465784826531e-19, -3.403499829082541e-20,  1.040654493042120e-21, -2.852758155654945e-23,
  7.126832830095392e-25, -1.642514108955423e-26,  3.525414316012944e-28, -7.097676822587350e-30,  2.505804491796638e-15, -3.711223994184375e-16,  3.011063175491398e-17,
 -1.746962812079093e-18,  8.061064863820853e-20, -3.130951134013018e-21,  1.060050027093640e-22, -3.203215381747300e-24,  8.786099200691329e-26, -2.215412806425459e-27,
  5.185872638546110e-29, -1.135305640749726e-30,  1.083642497037549e-16, -1.854880540152351e-17,  1.718628449419949e-18, -1.127941646176178e-19,  5.843128935480241e-21,
 -2.532000924324829e-22,  9.513572736861322e-24, -3.175657526157686e-25,  9.583168664979182e-27, -2.648829527518957e-28,  6.774516456560074e-30, -1.615436454824468e-31,
  4.174920519256367e-18, -8.249673529495604e-19,  8.739222679149357e-20, -6.500460794073490e-21,  3.788751784586745e-22, -1.835790191384483e-23,  7.671762297448892e-25,
 -2.834943096183153e-26,  9.431235413895573e-28, -2.863062962980396e-29,  8.014714579550601e-31, -2.085130493533491e-32,  1.478918871548714e-19, -3.367808751285463e-20,
  4.081781071772322e-21, -3.446141119103821e-22,  2.263913317861215e-23, -1.228907554874388e-24,  5.722719926975166e-26, -2.345301246095029e-27,  8.616157975781627e-29,
 -2.877275882528407e-30,  8.828793454392364e-32, -2.509241003079172e-33,  5.058637673524932e-21, -1.323501250747420e-21,  1.834338812276047e-22, -1.758541725965129e-23,
  1.303160655948208e-24, -7.932278496566341e-26,  4.120131640279204e-27, -1.874360402255952e-28,  7.610624013018275e-30, -2.797737448627280e-31,  9.415614575223767e-33,
 -2.924685249161796e-34,  1.798711611818884e-22, -5.376667968579037e-23,  8.497608667538552e-24, -9.233855035864456e-25,  7.708731000551137e-26, -5.256090417902049e-27,
  3.042208025294844e-28, -1.534858323735540e-29,  6.881226039946788e-31, -2.781779424329848e-32,  1.025657309540361e-33, -3.477677278292322e-35,  7.394750980216461e-24,
 -2.500774610273050e-24,  4.475715780260356e-25, -5.480916217908121e-26,  5.128394111682764e-27, -3.898395447266601e-28,  2.503088506290170e-29, -1.394475600943106e-30,
  6.873805922992599e-32, -3.043026588938997e-33,  1.224096781867435e-34, -4.511779895200601e-36,  4.044066809911113e-25, -1.522526556335633e-25,  3.043936105437496e-26,
 -4.149344059760354e-27,  4.301952499003506e-28, -3.606647550110141e-29,  2.542631730429126e-30, -1.548716446496022e-31,  8.313581195495824e-33, -3.993095120165267e-34,
  1.736661581368718e-35, -6.896781769914591e-37,  3.402334352604346e-26, -1.391701735522984e-26,  3.037277755075143e-27, -4.509626763980411e-28,  5.075089889610245e-29,
 -4.601612969202072e-30,  3.495889265458126e-31, -2.286758284475371e-32,  1.313998976129879e-33, -6.735017562050476e-35,  3.116782369693431e-36, -1.313255148505862e-37,
  4.293120749900690e-27, -1.845935671245584e-27,  4.251197818997730e-28, -6.653684620132785e-29,  7.877384516558278e-30, -7.497127560552794e-31,  5.965119938160172e-32,
 -4.077750267228281e-33,  2.443652730659092e-34, -1.303703508396358e-35,  6.268155758647718e-37, -2.738895203601326e-38,  6.857104655479306e-02, -1.940307095511242e-04,
  5.678455400403414e-07, -1.712803462242756e-09,  5.273532774891274e-12, -1.663292647408857e-14,  5.205830245302792e-17, -1.729771442107231e-19,  4.961666086066567e-22,
 -2.152606784451156e-24,  1.415342557612124e-27, -6.208620114971053e-29,  5.940904317334882e-02, -1.926769423767817e-04,  7.674592861140837e-07, -3.274313543183067e-09,
  1.401324538871302e-11, -5.915253472755374e-14,  2.445754542810285e-16, -1.000462647897876e-18,  3.982484332324336e-21, -1.612932218198162e-23,  5.998799519465382e-26,
 -2.672091055309648e-28,  4.458427205412609e-02, -1.816805305605987e-04,  1.014530524704338e-06, -5.607673652177677e-09,  2.955583644244525e-11, -1.498430786190031e-13,
  7.371722113560277e-16, -3.538820669245958e-18,  1.663902961388106e-20, -7.682015744442705e-23,  3.490295206146451e-25, -1.562580402602417e-27,  2.896938485951858e-02,
 -1.545284327855318e-04,  1.128301836664489e-06, -7.513794831320508e-09,  4.670025533092606e-11, -2.766248333510817e-13,  1.578941764022003e-15, -8.730305087154708e-18,
  4.703752046225634e-20, -2.471655222696028e-22,  1.275816307756646e-24, -6.426274090576054e-27,  1.628703743158454e-02, -1.145802769318819e-04,  1.031072445057091e-06,
 -8.042113288718512e-09,  5.801555469504804e-11, -3.956841340996246e-13,  2.580548396260689e-15, -1.619978967078087e-17,  9.852490936321131e-20, -5.820864517951612e-22,
  3.359575742676735e-24, -1.891401611548371e-26,  7.916127235061460e-03, -7.280557589364499e-05,  7.788883012083552e-07, -7.030178678774429e-09,  5.825241511344875e-11,
 -4.523685723788048e-13,  3.334266884528680e-15, -2.352103839173375e-17,  1.599160663609381e-19, -1.052225951039533e-21,  6.732841854846035e-24, -4.195420796211437e-26,
  3.322617770093842e-03, -3.935905573857744e-05,  4.906327973611106e-07, -5.088226422883678e-09,  4.801769595948336e-11, -4.209709712063887e-13,  3.479106383967294e-15,
 -2.737325195506668e-17,  2.065944728063665e-19, -1.503459245609564e-21,  1.059945088788628e-23, -7.259494096043690e-26,  1.202767790820693e-03, -1.805727311171388e-05,
  2.594045466618695e-07, -3.074034805711110e-09,  3.281370054782384e-11, -3.226991942063277e-13,  2.972774876886970e-15, -2.594088653554790e-17,  2.161942105347833e-19,
 -1.731107863957889e-21,  1.338295605404416e-23, -1.002428671838246e-25,  3.749418820084751e-04, -7.025876030501037e-06,  1.156066621147677e-07, -1.558066712050495e-09,
  1.871194393397987e-11, -2.054274039220432e-13,  2.100040934655377e-15, -2.023768833050305e-17,  1.854974432028780e-19, -1.627887246656906e-21,  1.374963880478625e-23,
 -1.122190026530094e-25,  1.004819633883695e-04, -2.318168627314341e-06,  4.353732537641214e-08, -6.646451717844776e-10,  8.944136152314306e-12, -1.092171214771282e-13,
  1.234766104375986e-15, -1.309841544035644e-17,  1.316373242720669e-19, -1.262356884004105e-21,  1.161614631816887e-23, -1.030158887335286e-25,  2.310662863147795e-05,
 -6.485428535050856e-07,  1.387312918298801e-08, -2.391069925564453e-10,  3.594501226250961e-12, -4.868747847687857e-14,  6.071889985342883e-16, -7.072997869605638e-18,
  7.775807717352849e-20, -8.130189624472568e-22,  8.133364596653935e-24, -7.821294450784905e-26,  4.550128743508844e-06, -1.537942099596714e-07,  3.742117403485782e-09,
 -7.262807739667708e-11,  1.217025119681809e-12, -1.824917128058367e-14,  2.505863695098665e-16, -3.199786979691044e-18,  3.841679421214856e-20, -4.372526638224188e-22,
  4.748133979726372e-24, -4.943640588892960e-26,  7.656190391351560e-07, -3.089539925190961e-08,  8.543616863818892e-10, -1.863722724784238e-11,  3.476023459926682e-13,
 -5.762464423062342e-15,  8.701419631784065e-17, -1.216547079125678e-18,  1.593322404809155e-20, -1.971998333631396e-22,  2.322041595485028e-24, -2.615006512157611e-26,
  1.098353474162353e-07, -5.253512908501863e-09,  1.650229247015553e-10, -4.041134091503274e-12,  8.381725718810521e-14, -1.534988531044552e-15,  2.547124260033996e-17,
 -3.896549616125664e-19,  5.563661170458755e-21, -7.483354324450378e-23,  9.549527126247667e-25, -1.162564067159043e-26,  1.340494869695538e-08, -7.554504728606274e-10,
  2.694937759477159e-11, -7.403827567046445e-13,  1.707160920358819e-14, -3.452888868139035e-16,  6.295093661571404e-18, -1.053527305399789e-19,  1.639683163447521e-21,
 -2.396394774927177e-23,  3.313570172846203e-25, -4.360042971665550e-27,  1.389024860168770e-09, -9.178602413781407e-11,  3.718712021813809e-12, -1.146092617807173e-13,
  2.938354352427841e-15, -6.565247866902599e-17,  1.315405177385953e-18, -2.408977992462878e-20,  4.087841207182627e-22, -6.493261114701029e-24,  9.730904983493719e-26,
 -1.384196706487834e-27,  1.220030526628441e-10, -9.416517402359789e-12,  4.334448557928742e-13, -1.499259340440476e-14,  4.276749547267090e-16, -1.056342431607840e-17,
  2.327611905624733e-19, -4.667838456953838e-21,  8.642022732193801e-23, -1.492906491004328e-24,  2.426268030454835e-26, -3.733184681368265e-28,  9.074952698466966e-12,
 -8.157066556133294e-13,  4.268716939223666e-14, -1.658684052344788e-15,  5.270359717384303e-17, -1.440710123744849e-18,  3.495242034678934e-20, -7.684181799758191e-22,
  1.553817087173115e-23, -2.922190510304986e-25,  5.155269820179652e-27, -8.587850065293299e-29,  5.717946606442417e-13, -5.972600001970947e-14,  3.556998438273795e-15,
 -1.554821650983826e-16,  5.511600436267869e-18, -1.670135030856782e-19,  4.468153687098267e-21, -1.078506608732905e-22,  2.385393654050943e-24, -4.890612574124833e-26,
  9.378123979409174e-28, -1.693486629536256e-29,  3.058421638319941e-14, -3.706971186370113e-15,  2.515815815937593e-16, -1.239364945674501e-17,  4.911143763834030e-19,
 -1.652981900684767e-20,  4.886269057908232e-22, -1.297400216698351e-23,  3.144407032106095e-25, -7.040307243600203e-27,  1.469843058648052e-28, -2.881674106457355e-30,
  1.395966815456280e-15, -1.961575135505799e-16,  1.519566689505343e-17, -8.455130669045162e-19,  3.754243720716086e-20, -1.406885394461962e-21,  4.605930960376870e-23,
 -1.348329475399958e-24,  3.588602496517480e-26, -8.792629870289953e-28,  2.002482447402660e-29, -4.270155970895342e-31,  5.491691545399589e-17, -8.941651676266548e-18,
  7.921386219030790e-19, -4.990708041439029e-20,  2.489690673552844e-21, -1.041602346691644e-22,  3.786630603597588e-24, -1.225218091569227e-25,  3.589682812818041e-27,
 -9.646821330160993e-29,  2.401833590825113e-30, -5.582083602150216e-32,  1.894797825253928e-18, -3.573293971478445e-19,  3.627050843562833e-20, -2.594186091268301e-21,
  1.458091465817987e-22, -6.829539992487479e-24,  2.764624869668887e-25, -9.913617091074667e-27,  3.205413103704114e-28, -9.470658837689868e-30,  2.583547674187728e-31,
 -6.557621552921661e-33,  5.902647339903093e-20, -1.288229312378686e-20,  1.500643210149555e-21, -1.221337456278476e-22,  7.754524361513374e-24, -4.077245168439206e-25,
  1.842615456130543e-26, -7.340852783499689e-28,  2.625587911061126e-29, -8.547555725531384e-31,  2.559978198746907e-32, -7.109581949010047e-34,  1.739688012727281e-21,
 -4.385311746591321e-22,  5.866238200653923e-23, -5.440974283776221e-24,  3.909493009185241e-25, -2.311872374264707e-26,  1.168605715986842e-27, -5.181635449383778e-29,
  2.053470390858710e-30, -7.376831130542784e-32,  2.428835021843344e-33, -7.388871003071604e-35,  5.219582155948727e-23, -1.513012130622526e-23,  2.320699525100583e-24,
 -2.451737323832674e-25,  1.993468236909973e-26, -1.325950151591448e-27,  7.497664201538862e-29, -3.700426496822218e-30,  1.624860900482295e-31, -6.440421833517360e-33,
  2.330609977699718e-34, -7.763273830384876e-36,  1.779453877274850e-24, -5.880238148970410e-25,  1.028357567300380e-25, -1.232002574551015e-26,  1.129215242997127e-27,
 -8.418817681203420e-29,  5.307668740774907e-30, -2.906382532064958e-31,  1.409508635736383e-32, -6.144485784100394e-34,  2.435878399692711e-35, -8.854900434159614e-37,
  8.026249092842312e-26, -2.976977435970943e-26,  5.861215748828811e-27, -7.873315144981729e-28,  8.050426970464870e-29, -6.661598547371271e-30,  4.638814609584133e-31,
 -2.792859114872973e-32,  1.482863546481315e-33, -7.048877978507269e-35,  3.035742506178165e-36, -1.194453722313510e-37,  5.679010896337126e-27, -2.305955259407500e-27,
  4.993711564185766e-28, -7.359134679568526e-29,  8.223171552763918e-30, -7.405994065633474e-31,  5.590763756574701e-32, -3.635192208899105e-33,  2.077013543966733e-34,
 -1.058897723729023e-35,  4.875479429674843e-37, -2.044451640723710e-38,  6.376839873925476e-28, -2.735936508622779e-28,  6.286061630921613e-29, -9.815824284472265e-30,
  1.159531039146325e-30, -1.101218928733811e-31,  8.744176362572356e-33, -5.965986353797301e-34,  3.568632959555405e-35, -1.900547124700872e-36,  9.122449638111767e-38,
 -3.979727166725312e-39,  6.780388106441602e-02, -1.895687502451323e-04,  5.477873953788412e-07, -1.631021937432021e-09,  4.952984895318415e-12, -1.543992475059349e-14,
  4.742562010712699e-17, -1.583345427600916e-19,  4.189694546913463e-22, -2.157897709739036e-24, -1.891432804067273e-27, -9.129063771064910e-29,  5.865037116968846e-02,
 -1.866907114212627e-04,  7.294747621519808e-07, -3.059256368160577e-09,  1.288669596031375e-11, -5.360499913971709e-14,  2.182625322698043e-16, -8.818730266931656e-19,
  3.442261500726603e-21, -1.395697040519771e-23,  4.879482376530604e-26, -2.445864511639831e-28,  4.387336729390533e-02, -1.738256371898860e-04,  9.499799290446548e-07,
 -5.157826528023323e-09,  2.672817060249399e-11, -1.332822847963329e-13,  6.451422266091000e-16, -3.048054488253112e-18,  1.410908441386062e-20, -6.414180496630795e-23,
  2.870480809437416e-25, -1.265758953691605e-27,  2.836877030425951e-02, -1.458503852681776e-04,  1.042443400311155e-06, -6.808871933673661e-09,  4.152774974336969e-11,
 -2.415014086363256e-13,  1.354295517536117e-15, -7.358149427262443e-18,  3.899394830719189e-20, -2.013598998245983e-22,  1.024438356735605e-24, -5.055383052578956e-27,
  1.584462379402603e-02, -1.067025188963534e-04,  9.398859210685952e-07, -7.173956891480055e-09,  5.068622482549347e-11, -3.388563098298604e-13,  2.168119093822874e-15,
 -1.335788170442365e-17,  7.980088261147924e-20, -4.629649288353170e-22,  2.628471509901268e-24, -1.451854320189353e-26,  7.636854347383752e-03, -6.689673382691796e-05,
  6.998333218716588e-07, -6.166385071994818e-09,  4.995476847754223e-11, -3.797042080531919e-13,  2.741976238180080e-15, -1.896123435104818e-17,  1.264696350803358e-19,
 -8.164822241388590e-22,  5.131237617707857e-24, -3.137998078723279e-26,  3.172662597472597e-03, -3.566577905689627e-05,  4.339199529822699e-07, -4.383009654277736e-09,
  4.037483832459218e-11, -3.459700180400773e-13,  2.797622053720064e-15, -2.155225441273879e-17,  1.593900263263055e-19, -1.137063232702633e-21,  7.863983716014748e-24,
 -5.283668935478472e-26,  1.134467528542646e-03, -1.612113157137316e-05,  2.254651773229366e-07, -2.597004564895903e-09,  2.701815738067064e-11, -2.593410693162694e-13,
  2.334605804734225e-15, -1.992452101710759e-17,  1.625343191704823e-19, -1.274582876021684e-21,  9.656481541559991e-24, -7.090677902584694e-26,  3.485764664211507e-04,
 -6.171015654920611e-06,  9.857899786009541e-08, -1.288986793455199e-09,  1.506475648201684e-11, -1.612061070478163e-13,  1.608382708979699e-15, -1.514224224106432e-17,
  1.357087698133388e-19, -1.165277762608009e-21,  9.636383565040493e-24, -7.704038575059091e-26,  9.185860119114525e-05, -1.999496322680298e-06,  3.635303152372250e-08,
 -5.375202388400609e-10,  7.028723238054246e-12, -8.354679339656104e-14,  9.207435632225761e-16, -9.531633385420843e-18,  9.356803858273337e-20, -8.771316056547934e-22,
  7.895493565265509e-24, -6.853427096540312e-26,  2.071754396714674e-05, -5.481264271046640e-07,  1.131917590152582e-08, -1.886557969047216e-10,  2.751781507475359e-12,
 -3.623525200758202e-14,  4.399921055839269e-16, -4.996412811306429e-18,  5.360116272447964e-20, -5.473596502867073e-22,  5.351927912098171e-24, -5.033484673927337e-26,
  3.989739315775120e-06, -1.270381450810927e-07,  2.976351311472550e-09, -5.577691517943620e-11,  9.055859726921658e-13, -1.318464407610924e-14,  1.760752524511650e-16,
 -2.189521178895133e-18,  2.562784433025230e-20, -2.846353485268627e-22,  3.018530085461144e-24, -3.071458701601819e-26,  6.544135943582422e-07, -2.486862015505257e-08,
  6.606197850924311e-10, -1.389474061294615e-11,  2.507494266395362e-13, -4.031239363087027e-15,  5.913757212606719e-17, -8.043770222729725e-19,  1.026130843713200e-20,
 -1.238249677046597e-22,  1.422826466747010e-24, -1.564838727179964e-26,  9.118389709855956e-08, -4.106640093493766e-09,  1.236609413024849e-10, -2.915818681343901e-12,
  5.844114367868260e-14, -1.036733080382295e-15,  1.669570751489874e-17, -2.482462086270662e-19,  3.449500733493862e-21, -4.520119808214618e-23,  5.624683027446126e-25,
 -6.682749026592280e-27,  1.076399288349557e-08, -5.712264328593257e-10,  1.949985456343199e-11, -5.151800950402339e-13,  1.146527915311027e-14, -2.243902450463815e-16,
  3.966374781138446e-18, -6.446149557122371e-20,  9.755646702081892e-22, -1.388003309638392e-23,  1.870230502031511e-25, -2.400161788736844e-27,  1.073679380481787e-09,
 -6.682802723353524e-11,  2.587140383702138e-12, -7.658996523778468e-14,  1.893178293908953e-15, -4.089057244069872e-17,  7.936217034873669e-19, -1.410251481299909e-20,
  2.325290546634865e-22, -3.593256592518458e-24,  5.244173890586015e-26, -7.271566784479022e-28,  9.027796155806084e-11, -6.566559715092732e-12,  2.884927018350696e-13,
 -9.575813108864438e-15,  2.631088383360753e-16, -6.276735286537637e-18,  1.338681226396055e-19, -2.603029123922392e-21,  4.679654080709085e-23, -7.859868260181819e-25,
  1.243330041203184e-26, -1.863902006742313e-28,  6.386744951120053e-12, -5.414171254789820e-13,  2.702147574613813e-14, -1.006778488169091e-15,  3.078898064181573e-17,
 -8.123158791734681e-19,  1.906229606638074e-20, -4.060981950351525e-22,  7.969535619943910e-24, -1.456514379137198e-25,  2.499966368466254e-27, -4.055988215469667e-29,
  3.798098929673219e-13, -3.745453995629961e-14,  2.126497996826101e-15, -8.908235177574805e-17,  3.037595113672478e-18, -8.879006453921887e-20,  2.296551854956089e-21,
 -5.369247060723988e-23,  1.152070344378314e-24, -2.294591008139724e-26,  4.279617319534524e-28, -7.524731153869128e-30,  1.899973665707710e-14, -2.177155719072231e-15,
  1.408649872470079e-16, -6.649121787297113e-18,  2.533760407081722e-19, -8.224041838682816e-21,  2.349700764807326e-22, -6.041551750621780e-24,  1.420218528684500e-25,
 -3.088602352701507e-27,  6.270996136516713e-29, -1.197007616340459e-30,  8.022291122997782e-16, -1.067689127693422e-16,  7.889421361923074e-18, -4.207026092743687e-19,
  1.796502077829939e-20, -6.492498149008025e-22,  2.054468709920907e-23, -5.824172779557533e-25,  1.503599485923494e-26, -3.578642896897047e-28,  7.927117998661078e-30,
 -1.646050759021550e-31,  2.881322500543057e-17, -4.454097493742356e-18,  3.768099360164383e-19, -2.276819579126123e-20,  1.092944613734003e-21, -4.411652353359697e-23,
  1.550828033867475e-24, -4.861356712748452e-26,  1.382124835918731e-27, -3.609538053596858e-29,  8.744758712150880e-31, -1.979949673955970e-32,  8.934202107596234e-19,
 -1.604608916399373e-19,  1.558298483595695e-20, -1.070414533623459e-21,  5.795954297992941e-23, -2.621941974739103e-24,  1.027284792132135e-25, -3.572011924080383e-27,
  1.121745437754209e-28, -3.223623093337635e-30,  8.564346763884931e-32, -2.119607041242267e-33,  2.454741356180908e-20, -5.122811548874801e-21,  5.725489493273013e-22,
 -4.485506544663723e-23,  2.748994895207836e-24, -1.398454339397271e-25,  6.127121523483693e-27, -2.370691199750478e-28,  8.247825675328363e-30, -2.615442322264735e-31,
  7.639700869830568e-33, -2.071714821835314e-34,  6.244651601963530e-22, -1.512991828053100e-22,  1.949607326377241e-23, -1.746525959705461e-24,  1.214981439761776e-25,
 -6.970648443370869e-27,  3.424802922938217e-28, -1.478425439168773e-29,  5.712385566404361e-31, -2.003384817924848e-32,  6.447248951846139e-34, -1.919203729285200e-35,
  1.579976749059912e-23, -4.430743799229862e-24,  6.581863592845955e-25, -6.748077612345303e-26,  5.335062003339982e-27, -3.456594901355650e-28,  1.906892725209698e-29,
 -9.194947051781536e-31,  3.949746497112540e-32, -1.533310691099368e-33,  5.440157921862058e-35, -1.778489271032759e-36,  4.447712341910620e-25, -1.433063734028940e-25,
  2.444113972330103e-26, -2.859519078265915e-27,  2.563256678757295e-28, -1.871512043212830e-29,  1.156950151000743e-30, -6.219115390474351e-32,  2.963884632574013e-33,
 -1.270900001966997e-34,  4.960147904661720e-36, -1.776639609412185e-37,  1.639860844382630e-26, -5.982391616625810e-27,  1.158097294703151e-27, -1.530770940978270e-28,
  1.541581960337851e-29, -1.257515662431125e-30,  8.639673235849724e-32, -5.136126940408159e-33,  2.694629999516303e-34, -1.266542225836919e-35,  5.396780250359397e-37,
 -2.102167799072977e-38,  9.636418862732227e-28, -3.880722965828856e-28,  8.331554785371655e-29, -1.217606816479685e-29,  1.349852642423565e-30, -1.206676388591572e-31,
  9.045345126351355e-33, -5.842555502194596e-34,  3.317411361431375e-35, -1.681318890242129e-36,  7.698218488073011e-38, -3.211168394130565e-39,  9.522272061143777e-29,
 -4.075599772491821e-29,  9.339641719890988e-30, -1.454684469325258e-30,  1.714194123409906e-31, -1.624187798217649e-32,  1.286812640757453e-33, -8.761114443493868e-35,
  5.230027610885957e-36, -2.780016727236932e-37,  1.331944069578474e-38, -5.800591192280025e-40,  6.705424857559603e-02, -1.852634159974786e-04,  5.286806246000876e-07,
 -1.554184205072795e-09,  4.655216968921832e-12, -1.435346779170120e-14,  4.316811932136810e-17, -1.461937015480492e-19,  3.388352543657949e-22, -2.327473751026976e-24,
 -6.976310246441994e-27, -1.449155841124274e-28,  5.791505226006023e-02, -1.809983321196874e-04,  6.939663287748359e-07, -2.861369595624834e-09,  1.186504130349167e-11,
 -4.865101179942628e-14,  1.950392501515034e-16, -7.794040621956956e-19,  2.972372560130909e-21, -1.221817190605217e-23,  3.815930454836910e-26, -2.427396538822375e-28,
  4.319288243242781e-02, -1.664663006323259e-04,  8.905665967245137e-07, -4.750687824652850e-09,  2.421070095003771e-11, -1.187740562157578e-13,  5.657856256503765e-16,
 -2.631397902065350e-18,  1.199391036504298e-20, -5.370001018561833e-23,  2.367701768035595e-25, -1.028230852964724e-27,  2.780154586005282e-02, -1.378267243168863e-04,
  9.645697452218234e-07, -6.181369757685062e-09,  3.700676550386986e-11, -2.113360779803160e-13,  1.164700828864073e-15, -6.218832330293100e-18,  3.243207295925291e-20,
 -1.644951585699957e-22,  8.266483275545370e-25, -3.976438454740420e-27,  1.543232547928894e-02, -9.951449210965497e-05,  8.584494935403905e-07, -6.414489242391821e-09,
  4.440058005028269e-11, -2.910358441682906e-13,  1.827481386448165e-15, -1.105181480227868e-17,  6.488237414281524e-20, -3.695521357388900e-22,  2.066496740687143e-24,
 -1.117389481491025e-26,  7.380014549872485e-03, -6.158102082268321e-05,  6.303928619664174e-07, -5.424458530398388e-09,  4.297800769803659e-11, -3.198362461296204e-13,
  2.263568800090388e-15, -1.534743609694034e-17,  1.004608100099045e-19, -6.363781657913685e-22,  3.930727689204103e-24, -2.357450084647170e-26,  3.036623931035427e-03,
 -3.239432509154415e-05,  3.849827618825096e-07, -3.788914616933907e-09,  3.408081247843615e-11, -2.855280520703539e-13,  2.259819741840119e-15, -1.705028245986466e-17,
  1.235992477206832e-19, -8.644888973213353e-22,  5.867720484188823e-24, -3.867069791086821e-26,  1.073402951816004e-03, -1.443509275331924e-05,  1.967330679650877e-07,
 -2.203343917486077e-09,  2.234931934205680e-11, -2.094573209970444e-13,  1.843134690385842e-15, -1.538873423968085e-17,  1.229107241471221e-19, -9.441738038530988e-22,
  7.012399831208984e-24, -5.048381589619604e-26,  3.253771829131576e-04, -5.440389512901051e-06,  8.445739707887569e-08, -1.071782132831960e-09,  1.219468440881032e-11,
 -1.272382499189964e-13,  1.239385297935640e-15, -1.140252631979628e-17,  9.995112323568642e-20, -8.399488329367271e-22,  6.802652880837492e-24, -5.328410962080132e-26,
  8.440395377345840e-05, -1.732680846836875e-06,  3.052606036794071e-08, -4.373125117191171e-10,  5.558780358764707e-12, -6.434036991215739e-14,  6.914319251979778e-16,
 -6.987175907158980e-18,  6.701739888752080e-20, -6.142880312863157e-22,  5.410489541815022e-24, -4.597794127057203e-26,  1.869279572485717e-05, -4.659315862996841e-07,
  9.297298570256524e-09, -1.498954816510149e-10,  2.122272197665390e-12, -2.717724512272264e-14,  3.214148116857563e-16, -3.559112073732674e-18,  3.726955823401862e-20,
 -3.718000608977783e-22,  3.554063336739134e-24, -3.269897330063225e-26,  3.525292394356777e-06, -1.056769531945405e-07,  2.385953270127722e-09, -4.318677110018038e-11,
  6.796269091314641e-13, -9.610542872575673e-15,  1.248614798277898e-16, -1.512486146663600e-18,  1.726375358680572e-20, -1.871489228674076e-22,  1.938720141266547e-24,
 -1.928355810856442e-26,  5.645418269752419e-07, -2.018806752899608e-08,  5.155245975571837e-10, -1.045767194231852e-11,  1.826689441347336e-13, -2.848860563216556e-15,
  4.061308867562106e-17, -5.375729008740752e-19,  6.681277988337742e-21, -7.862688996696003e-23,  8.818461858571149e-25, -9.473638904135183e-27,  7.653483823371481e-08,
 -3.242861141155426e-09,  9.366178944615055e-11, -2.127023202930465e-12,  4.120903606393788e-14, -7.083348975163453e-16,  1.107347913637895e-17, -1.600724352767302e-19,
  2.165128002962008e-21, -2.764579118668472e-23,  3.355271111835400e-25, -3.891248163065813e-27,  8.755923025724577e-09, -4.371479630706501e-10,  1.428548068271460e-11,
 -3.630215659704909e-13,  7.799650390817043e-15, -1.477434471391171e-16,  2.532596400450293e-18, -3.997857559676734e-20,  5.884511402396743e-22, -8.151939534399945e-24,
  1.070550493256339e-25, -1.340209654098937e-27,  8.425934402724522e-10, -4.934831812369158e-11,  1.825836903183363e-12, -5.192724993072686e-14,  1.237737969535415e-15,
 -2.584773509152675e-17,  4.860378427596008e-19, -8.381738867304035e-21,  1.343077492544345e-22, -2.019372064932758e-24,  2.870524032348280e-26, -3.880352890923770e-28,
  6.798959144303563e-11, -4.655209765725152e-12,  1.952031571510697e-13, -6.217825782868694e-15,  1.645737282645380e-16, -3.792374580616078e-18,  7.829578568639673e-20,
 -1.476324049174274e-21,  2.577470949997733e-23, -4.209384190035224e-25,  6.481718208218349e-27, -9.467914394840290e-29,  4.587282289336841e-12, -3.662865932631077e-13,
  1.743082842473261e-14, -6.226715918694554e-16,  1.832721892692667e-17, -4.666844716151270e-19,  1.059333782681326e-20, -2.186933090929651e-22,  4.165318846219048e-24,
 -7.397974583356015e-26,  1.235424991234263e-27, -1.952150695486441e-29,  2.582556844447207e-13, -2.401005155991177e-14,  1.298982662124482e-15, -5.213747040344700e-17,
  1.709866368774019e-18, -4.820703390714799e-20,  1.205373451132732e-21, -2.729422514084153e-23,  5.681160334909201e-25, -1.099156895392232e-26,  1.993790001649150e-28,
 -3.413168759730511e-30,  1.212263502964937e-14, -1.311237385590308e-15,  8.082679746283164e-17, -3.653991053341652e-18,  1.338596126405002e-19, -4.188851856236669e-21,
  1.156507081747398e-22, -2.879001332038071e-24,  6.563190740963829e-26, -1.386131164005197e-27,  2.736559410084533e-29, -5.084913279052324e-31,  4.751981416567386e-16,
 -5.979761196733266e-17,  4.210818767389080e-18, -2.150518555535174e-19,  8.827273719999500e-21, -3.075218188546423e-22,  9.402283006206892e-24, -2.580360143069983e-25,
  6.459719430087646e-27, -1.493024514996116e-28,  3.215812036185840e-30, -6.500619834280646e-32,  1.564082081149357e-17, -2.291108448447603e-18,  1.848706386913836e-19,
 -1.070363413584487e-20,  4.940513697604531e-22, -1.922880692957972e-23,  6.532615269273652e-25, -1.982881612346503e-26,  5.468042033876347e-28, -1.387146728380549e-29,
  3.268701769079725e-31, -7.207100834518138e-33,  4.374758720188943e-19, -7.467028776740317e-20,  6.927633900487811e-21, -4.564950463433207e-22,  2.378898891447837e-23,
 -1.038477519302182e-24,  3.935115000621724e-26, -1.325876676496475e-27,  4.041411651821349e-29, -1.128944795164671e-30,  2.919348539684342e-32, -7.041072939446610e-34,
  1.063726041568860e-20, -2.117750323891079e-21,  2.266925363719716e-22, -1.707071809532311e-23,  1.008602640903305e-24, -4.958855649337379e-26,  2.104261223916288e-27,
 -7.900041900742835e-29,  2.671225804455239e-30, -8.244445694236575e-32,  2.346946945543569e-33, -6.210009035626216e-35,  2.341089343702453e-22, -5.438314530416946e-23,
  6.736857361059985e-24, -5.819127006157601e-25,  3.913410824162341e-26, -2.175395610232756e-27,  1.037599753000781e-28, -4.355831531213123e-30,  1.639200406045582e-31,
 -5.606854906175399e-33,  1.762018932200386e-34, -5.127954897054658e-36,  4.995918243343869e-24, -1.351955455902538e-24,  1.940863224361397e-25, -1.927451920840821e-26,
  1.479231550258380e-27, -9.321257118762921e-29,  5.009856253236606e-30, -2.357141893890136e-31,  9.893291059572087e-33, -3.757315924446507e-34,  1.305652647399982e-35,
 -4.185048583446401e-37,  1.157190615423296e-25, -3.626908574232185e-26,  6.019819109790136e-27, -6.864943055211802e-28,  6.007941847598626e-29, -4.289167638082268e-30,
  2.596210406652472e-31, -1.368174523176177e-32,  6.399638881303232e-34, -2.696108541075781e-35,  1.034821010657079e-36, -3.648438410163825e-38,  3.457444794241628e-27,
 -1.238318667553222e-27,  2.352907005201310e-28, -3.055424302847366e-29,  3.026131655017970e-30, -2.430180200540522e-31,  1.645281273295488e-32, -9.646680466905368e-34,
  4.995642919702565e-35, -2.319448272585023e-36,  9.769443642266807e-38, -3.764067668670199e-39,  1.665268265389285e-28, -6.644337072789645e-29,  1.412724304105780e-29,
 -2.045487363470209e-30,  2.247786663546663e-31, -1.992793203601952e-32,  1.482220273344347e-33, -9.503999532751200e-35,  5.359254571332189e-36, -2.698538148498688e-37,
  1.228008405942729e-38, -5.092847050155732e-40,  1.430316718209970e-29, -6.105341610335709e-30,  1.395036850330896e-30, -2.166665564599304e-31,  2.546266367057709e-32,
 -2.406346547554554e-33,  1.901830318347396e-34, -1.291826398407065e-35,  7.694632193557529e-37, -4.081482303854467e-38,  1.951585516448672e-39, -8.482986065990789e-41,
  };
  int offset = -30;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 30;
    if (std::isnan(t)) {
      fill_n(rr+offset, 30, 0.5);
      fill_n(ww+offset, 30, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 30; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=30; ++j) {
        const int boxof = it*360+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
